/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business.task;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.dao.repository.impl.PsCompensateTaskServiceImpl;
import com.xinqiyi.ps.dao.repository.impl.SpuServiceImpl;
import com.xinqiyi.ps.model.dto.mall4j.Mall4jServerResponseEntity;
import com.xinqiyi.ps.model.dto.mall4j.SpuForMallFourJDTO;
import com.xinqiyi.ps.model.entity.task.PsCompensateTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PsCompensateTaskBiz {
    private static final Logger log = LoggerFactory.getLogger(PsCompensateTaskBiz.class);
    @Autowired
    private IdSequenceGenerator idSequence;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private PsCompensateTaskServiceImpl taskService;
    @Autowired
    private SpuServiceImpl spuService;

    public void saveTask(Integer type, String url, String param, String sourceId, String reason, Integer methodType) {
        PsCompensateTask task = new PsCompensateTask();
        task.setType(type);
        task.setUrl(url);
        task.setSourceId(sourceId);
        task.setParam(param);
        task.setFailReason(reason);
        task.setMethodType(methodType);
        task.setId(this.idSequence.generateId(PsCompensateTask.class));
        this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)task);
        this.taskService.saveTask(task);
    }

    public void retryProdTask() {
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(1);
        List taskList = this.taskService.selectTaskByTypes(types);
        if (CollUtil.isNotEmpty((Collection)taskList)) {
            for (PsCompensateTask task : taskList) {
                try {
                    Mall4jServerResponseEntity response;
                    String res = this.sendHttpRequest(task.getUrl(), task.getParam());
                    if (log.isInfoEnabled()) {
                        log.info("\u63a8\u9001\u5546\u57ce\u8865\u507f\u4efb\u52a1\u51fa\u53c2:{}", (Object)res);
                    }
                    if ((response = (Mall4jServerResponseEntity)JSON.parseObject((String)res, Mall4jServerResponseEntity.class)).isSuccess()) {
                        this.updateTask(true, task);
                        List spuForMallFourJDTOS = JSON.parseArray((String)task.getParam(), SpuForMallFourJDTO.class);
                        List codeList = spuForMallFourJDTOS.stream().map(SpuForMallFourJDTO::getPsProdCode).collect(Collectors.toList());
                        List spuList = this.spuService.selectSpuByCodes(codeList);
                        if (!CollUtil.isNotEmpty((Collection)spuList)) continue;
                        List ids = spuList.stream().map(BaseDo::getId).collect(Collectors.toList());
                        this.spuService.updateSpuPushMall4JStatus(ids);
                        continue;
                    }
                    task.setFailReason(null != response.getMsg() ? response.getMsg() : res);
                    this.updateTask(false, task);
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error("\u63a8\u9001\u5546\u57ce\u5931\u8d25\u4efb\u52a1id={}\u9519\u8bef\u539f\u56e0={}", (Object)task.getId(), (Object)e.getMessage());
                    }
                    task.setFailReason(null != e.getMessage() ? e.getMessage() : e.toString());
                    this.updateTask(false, task);
                }
            }
        }
    }

    public void retryTask() {
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(2);
        types.add(3);
        types.add(4);
        List taskList = this.taskService.selectTaskByTypes(types);
        if (CollUtil.isNotEmpty((Collection)taskList)) {
            for (PsCompensateTask task : taskList) {
                try {
                    Mall4jServerResponseEntity response;
                    String res = task.getMethodType() == 1 ? this.sendHttpRequest(task.getUrl(), task.getParam()) : this.sendGetHttpRequest(task.getUrl());
                    if (log.isInfoEnabled()) {
                        log.info("\u63a8\u9001\u5546\u57ce\u8865\u507f\u4efb\u52a1\u51fa\u53c2:{}", (Object)res);
                    }
                    if ((response = (Mall4jServerResponseEntity)JSON.parseObject((String)res, Mall4jServerResponseEntity.class)).isSuccess()) {
                        this.updateTask(true, task);
                        continue;
                    }
                    task.setFailReason(null != response.getMsg() ? response.getMsg() : res);
                    this.updateTask(false, task);
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error("\u63a8\u9001\u5546\u57ce\u5931\u8d25\u4efb\u52a1id={}\u9519\u8bef\u539f\u56e0={}", (Object)task.getId(), (Object)e.getMessage());
                    }
                    task.setFailReason(null != e.getMessage() ? e.getMessage() : e.toString());
                    this.updateTask(false, task);
                }
            }
        }
    }

    private void updateTask(boolean isSuccess, PsCompensateTask task) {
        if (isSuccess) {
            this.taskService.removeById((Serializable)task.getId());
        } else {
            task.setTimes(Integer.valueOf(task.getTimes() + 1));
            this.taskService.updateById((Object)task);
        }
    }

    private String sendHttpRequest(String url, String param) {
        return ((HttpRequest)HttpRequest.post((String)url).header("Content-Type", "application/json")).body(param).execute().body();
    }

    private String sendGetHttpRequest(String url) {
        return HttpRequest.get((String)url).execute().body();
    }
}

