/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business.task;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.auth.GateWayWebAuthService;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.api.model.vo.category.CategoryVO;
import com.xinqiyi.ps.api.model.vo.category.PsTagCategoryVO;
import com.xinqiyi.ps.dao.repository.PsTagCategoryService;
import com.xinqiyi.ps.dao.repository.PsTagService;
import com.xinqiyi.ps.model.dto.category.CategoryMoveDTO;
import com.xinqiyi.ps.model.dto.category.CategoryOprDTO;
import com.xinqiyi.ps.model.dto.category.PsTagCategoryAddDTO;
import com.xinqiyi.ps.model.dto.category.PsTagCategoryQueryDTO;
import com.xinqiyi.ps.model.dto.category.PsTagCategoryUpdateDTO;
import com.xinqiyi.ps.model.entity.PsTagCategory;
import com.xinqiyi.ps.service.util.BeanConvertUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PsTagCategoryBiz {
    private static final Logger log = LoggerFactory.getLogger(PsTagCategoryBiz.class);
    @Autowired
    private PsTagCategoryService psTagCategoryService;
    @Autowired
    private IdSequenceGenerator idSequenceGenerator;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private GateWayWebAuthService gateWayWebAuthService;
    @Autowired
    private PsTagService psTagService;

    public void saveCategory(PsTagCategoryAddDTO dto) {
        int sort;
        Long pid = ObjectUtil.isNotNull((Object)dto.getPid()) ? dto.getPid() : Long.valueOf(0L);
        PsTagCategory category = this.psTagCategoryService.selectCategoryByPidAndName(pid, dto.getName());
        Assert.isTrue((null == category ? 1 : 0) != 0, (String)"\u7c7b\u76ee\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        int level = 1;
        Object wholeName = "";
        if (0L != pid) {
            PsTagCategory parentCategory = (PsTagCategory)this.psTagCategoryService.getById((Serializable)pid);
            Assert.isTrue((null != parentCategory ? 1 : 0) != 0, (String)"\u7236\u7ea7\u7c7b\u76ee\u4e0d\u5b58\u5728");
            level = parentCategory.getLevel() + 1;
            wholeName = parentCategory.getWholeName() + "-" + dto.getName();
        } else {
            wholeName = dto.getName();
        }
        int n = sort = ObjectUtil.isNotNull((Object)this.psTagCategoryService.getCategoryForMaxSort(pid)) ? this.psTagCategoryService.getCategoryForMaxSort(pid) : 1;
        if (level > 3) {
            throw new IllegalArgumentException("\u7c7b\u76ee\u7ea7\u522b\u6700\u591a\u4e3a3\u7ea7");
        }
        category = new PsTagCategory();
        BeanUtils.copyProperties((Object)dto, (Object)category);
        Long id = this.idSequenceGenerator.generateId(PsTagCategory.class);
        category.setId(id);
        category.setLevel(Integer.valueOf(level));
        category.setPid(pid);
        category.setStatus(Integer.valueOf(1));
        category.setWholeName((String)wholeName);
        category.setSort(Integer.valueOf(sort + 1));
        category.setIsDelete(Integer.valueOf(0));
        this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)category);
        this.psTagCategoryService.save((Object)category);
    }

    public void updateCategory(PsTagCategoryUpdateDTO dto) {
        LoginUserInfo userInfo;
        PsTagCategory category = (PsTagCategory)this.psTagCategoryService.getById((Serializable)dto.getId());
        Assert.isTrue((null != category ? 1 : 0) != 0, (String)"\u7c7b\u76ee\u6570\u636e\u4e0d\u5b58\u5728");
        if (!category.getStatus().equals(1)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getName())) {
            PsTagCategory oldCategory = this.psTagCategoryService.selectCategoryByPidAndName(category.getPid(), dto.getName());
            if (null != oldCategory && !dto.getId().equals(oldCategory.getId())) {
                throw new IllegalArgumentException("\u7c7b\u76ee\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
            }
            category.setWholeName(category.getWholeName().replace(category.getName(), dto.getName()));
            category.setName(dto.getName());
        }
        Assert.isTrue((null != (userInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u83b7\u53d6\u5931\u8d25");
        category.setUpdateTime(new Date());
        category.setUpdateUserName(userInfo.getName());
        this.psTagCategoryService.updateById((Object)category);
    }

    public List<PsTagCategoryVO> selectAllCategory(PsTagCategoryQueryDTO dto) {
        Integer level = ObjectUtil.isNotNull((Object)dto.getLevel()) ? dto.getLevel() : 4;
        Long parentId = ObjectUtil.isNotNull((Object)dto.getParentId()) ? dto.getParentId() : 0L;
        List list = this.psTagCategoryService.getAllCategory(dto);
        ArrayList<PsTagCategoryVO> result = new ArrayList<PsTagCategoryVO>();
        if (CollUtil.isNotEmpty((Collection)list)) {
            List<PsTagCategoryVO> res = BeanConvertUtil.convertList(list, PsTagCategoryVO.class);
            Long finalParentId = parentId;
            List levelFistList = res.stream().filter(category -> finalParentId.equals(category.getPid())).sorted(Comparator.comparing(PsTagCategoryVO::getSort)).collect(Collectors.toList());
            for (PsTagCategoryVO vo : levelFistList) {
                vo.setChildren(this.getChild(res, vo, level));
                result.add(vo);
            }
        }
        return result;
    }

    public List<PsTagCategoryVO> getChild(List<PsTagCategoryVO> list, PsTagCategoryVO categoryVO, Integer level) {
        if (categoryVO.getLevel() >= level) {
            return Collections.emptyList();
        }
        return list.stream().filter(vo -> vo.getPid().equals(categoryVO.getId())).peek(vo -> vo.setChildren(this.getChild(list, (PsTagCategoryVO)vo, level))).sorted(Comparator.comparing(PsTagCategoryVO::getSort)).collect(Collectors.toList());
    }

    public void sortCategory(List<CategoryMoveDTO> list) {
        ArrayList res = new ArrayList();
        LoginUserInfo userInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        Assert.isTrue((null != userInfo ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u83b7\u53d6\u5931\u8d25");
        list.stream().forEach(categoryMoveDTO -> {
            PsTagCategory category = (PsTagCategory)this.psTagCategoryService.getById((Serializable)categoryMoveDTO.getId());
            Assert.isTrue((null != category ? 1 : 0) != 0, (String)"\u7c7b\u76ee\u6570\u636e\u4e0d\u5b58\u5728");
            category.setSort(categoryMoveDTO.getSort());
            category.setUpdateTime(new Date());
            category.setUpdateUserName(userInfo.getName());
            res.add(category);
        });
        this.psTagCategoryService.updateBatchById(res);
    }

    public ApiResponse<Void> updateCategoryStatus(CategoryOprDTO dto) {
        LoginUserInfo userInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        Assert.isTrue((null != userInfo ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u83b7\u53d6\u5931\u8d25");
        PsTagCategory category = (PsTagCategory)this.psTagCategoryService.getById((Serializable)dto.getId());
        Assert.isTrue((null != category ? 1 : 0) != 0, (String)"\u7c7b\u76ee\u6570\u636e\u4e0d\u5b58\u5728");
        if (Integer.valueOf(3).equals(dto.getType())) {
            List categoryList = this.psTagCategoryService.getByPid(dto.getId());
            Assert.isTrue((boolean)CollUtil.isEmpty((Collection)categoryList), (String)"\u53ea\u80fd\u5220\u9664\u6700\u672b\u7ea7\u7c7b\u76ee");
            List psTagList = this.psTagService.selectPsTagListByTagCategory(dto.getId());
            if (CollUtil.isNotEmpty((Collection)psTagList)) {
                return ApiResponse.failed((String)"\u5f53\u524d\u7c7b\u76ee\u5df2\u5173\u8054\u5bf9\u5e94\u6807\u7b7e\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5230\u3010\u57fa\u7840\u6863\u6848\u2014\u2014\u6807\u7b7e\u7ba1\u7406\u3011\u4e2d\uff0c\u79fb\u9664\u4e0e\u6807\u7b7e\u7684\u5173\u8054\u5173\u7cfb\u540e\uff0c\u518d\u5220\u9664\u8be5\u7c7b\u76ee");
            }
            category.setIsDelete(Integer.valueOf(1));
            category.setSort(Integer.valueOf(9999));
            category.setUpdateTime(new Date());
            category.setUpdateUserName(userInfo.getName());
            this.psTagCategoryService.updateById((Object)category);
        } else if (Integer.valueOf(1).equals(dto.getType())) {
            ArrayList<Long> childIds = new ArrayList<Long>();
            childIds.add(category.getId());
            Set<Long> categoryIdList = this.selectParentCategoryId(null, childIds);
            category.setStatus(Integer.valueOf(2));
            category.setUpdateTime(new Date());
            category.setUpdateUserName(userInfo.getName());
            this.psTagCategoryService.enableCategory(category, categoryIdList);
            List psTagList = this.psTagService.selectPsTagListByTagCategory(category.getPid());
            if (CollectionUtil.isNotEmpty((Collection)psTagList)) {
                this.psTagService.updateTagCategory(psTagList, category.getId());
            }
        } else if (Integer.valueOf(2).equals(dto.getType())) {
            ArrayList<PsTagCategory> list = new ArrayList<PsTagCategory>();
            List<PsTagCategory> categoryList = this.getChildList(dto.getId(), list);
            categoryList.add(category);
            categoryList.stream().forEach(a -> {
                List psTagList = this.psTagService.selectPsTagListByTagCategory(a.getId());
                if (CollUtil.isNotEmpty((Collection)psTagList)) {
                    throw new IllegalArgumentException("\u5f53\u524d\u7c7b\u76ee\u5df2\u5173\u8054\u5bf9\u5e94\u6807\u7b7e\uff0c\u65e0\u6cd5\u505c\u7528\uff0c\u8bf7\u5230\u3010\u57fa\u7840\u6863\u6848\u2014\u2014\u6807\u7b7e\u7ba1\u7406\u3011\u4e2d\uff0c\u79fb\u9664\u4e0e\u6807\u7b7e\u7684\u5173\u8054\u5173\u7cfb\u540e\uff0c\u518d\u505c\u7528\u8be5\u7c7b\u76ee");
                }
                a.setStatus(Integer.valueOf(3));
                a.setUpdateTime(new Date());
                a.setUpdateUserName(userInfo.getName());
            });
            this.psTagCategoryService.updateBatchById(categoryList);
        }
        return ApiResponse.success();
    }

    private List<PsTagCategory> getChildList(Long id, List<PsTagCategory> categoryList) {
        List list = this.psTagCategoryService.getByPid(id);
        if (CollUtil.isNotEmpty((Collection)list)) {
            categoryList.addAll(list);
            list.forEach(category -> this.getChildList(category.getId(), categoryList));
        }
        return categoryList;
    }

    public Set<Long> selectParentCategoryId(Integer status, List<Long> childrenIds) {
        Assert.isTrue((boolean)CollUtil.isNotEmpty(childrenIds), (String)"\u5b50\u7ea7ID\u4e0d\u80fd\u4e3a\u7a7a");
        PsTagCategoryQueryDTO psTagCategoryQueryDTO = new PsTagCategoryQueryDTO();
        psTagCategoryQueryDTO.setStatus(status);
        List list = this.psTagCategoryService.getAllCategory(psTagCategoryQueryDTO);
        HashSet<Long> result = new HashSet<Long>();
        if (CollUtil.isNotEmpty((Collection)list)) {
            List<CategoryVO> res = BeanConvertUtil.convertList(list, CategoryVO.class);
            List childrenList = res.stream().filter(category -> childrenIds.contains(category.getId())).sorted(Comparator.comparing(CategoryVO::getSort)).collect(Collectors.toList());
            for (CategoryVO vo : childrenList) {
                result.add(vo.getId());
                this.getParentId(res, vo, result);
            }
        }
        return result;
    }

    private void getParentId(List<CategoryVO> list, CategoryVO categoryVO, Set<Long> result) {
        HashSet<CategoryVO> parentList = new HashSet<CategoryVO>();
        for (CategoryVO vo : list) {
            if (!vo.getId().equals(categoryVO.getPid())) continue;
            parentList.add(vo);
            result.add(vo.getId());
        }
        if (CollUtil.isNotEmpty(parentList)) {
            for (CategoryVO vo : parentList) {
                this.getParentId(list, vo, result);
            }
        }
    }

    public PsTagCategoryBiz(PsTagCategoryService psTagCategoryService, IdSequenceGenerator idSequenceGenerator, BaseDaoInitialService baseDaoInitialService, GateWayWebAuthService gateWayWebAuthService, PsTagService psTagService) {
        this.psTagCategoryService = psTagCategoryService;
        this.idSequenceGenerator = idSequenceGenerator;
        this.baseDaoInitialService = baseDaoInitialService;
        this.gateWayWebAuthService = gateWayWebAuthService;
        this.psTagService = psTagService;
    }
}

