/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.hanlder;

import cn.afterturn.easypoi.excel.entity.result.ExcelVerifyHandlerResult;
import cn.afterturn.easypoi.handler.inter.IExcelVerifyHandler;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.ps.dao.repository.BrandCategoryService;
import com.xinqiyi.ps.dao.repository.BrandService;
import com.xinqiyi.ps.dao.repository.CategoryService;
import com.xinqiyi.ps.dao.repository.SkuBarCodeService;
import com.xinqiyi.ps.dao.repository.SkuService;
import com.xinqiyi.ps.dao.repository.SpecService;
import com.xinqiyi.ps.dao.repository.SpecValueService;
import com.xinqiyi.ps.dao.repository.SpuService;
import com.xinqiyi.ps.dao.repository.UnitService;
import com.xinqiyi.ps.model.dto.enums.SkuSpecTypeEnums;
import com.xinqiyi.ps.model.dto.enums.StatusEnums;
import com.xinqiyi.ps.model.dto.enums.WhetherEnum;
import com.xinqiyi.ps.model.dto.excel.ImportSpuExcelDTO;
import com.xinqiyi.ps.model.dto.excel.ImportSpuExcelOfModeDTO;
import com.xinqiyi.ps.model.entity.Brand;
import com.xinqiyi.ps.model.entity.BrandCategory;
import com.xinqiyi.ps.model.entity.Category;
import com.xinqiyi.ps.model.entity.Sku;
import com.xinqiyi.ps.model.entity.SkuBarCode;
import com.xinqiyi.ps.model.entity.Spec;
import com.xinqiyi.ps.model.entity.SpecValue;
import com.xinqiyi.ps.model.entity.Spu;
import com.xinqiyi.ps.model.entity.Unit;
import com.xinqiyi.ps.service.helper.ImportHelper;
import jakarta.annotation.PostConstruct;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Lazy
@Component
@Scope(value="prototype")
public class ExcelVerifyHandlerImpl
implements IExcelVerifyHandler<ImportSpuExcelOfModeDTO> {
    private static final String NAME = "name";
    private static final String SPU_CODE = "spuCode";
    private static final String THIRD_PS_CATEGORY_NAME = "thirdPsCategoryName";
    private static final String CATEGORY_NAME = "categoryName";
    private static final String PS_BRAND_NAME = "psBrandName";
    private static final String PS_UNIT_NAME = "psUnitName";
    private static final String PS_SKU_UNIT_NAME = "psSkuUnitName";
    private static final String SKU_NAME = "skuName";
    private static final String SKU_CODE = "skuCode";
    private static final String PS_SPEC_NAME = "psSpecName";
    private static final String BAR_CODE = "barCode";
    private static final String KY_THIRD_PLATFORM_CODE = "kyThirdPlatformCode";
    private static final String WMS_THIRD_PLATFORM_CODE = "wmsThirdPlatformCode";
    private static final String WMS_THIRD_PLATFORM_CODE_1 = "wmsThirdPlatformCode1";
    private static final String WMS_THIRD_PLATFORM_CODE_2 = "wmsThirdPlatformCode2";
    private static final String WMS_THIRD_PLATFORM_CODE_3 = "wmsThirdPlatformCode3";
    private static final String WMS_THIRD_PLATFORM_CODE_4 = "wmsThirdPlatformCode4";
    private static final String WMS_THIRD_PLATFORM_CODE_5 = "wmsThirdPlatformCode5";
    private static final String KY_THIRD_PLATFORM_CODE_1 = "kyThirdPlatformCode1";
    private static final String KY_THIRD_PLATFORM_CODE_2 = "kyThirdPlatformCode2";
    private static final String KY_THIRD_PLATFORM_CODE_3 = "kyThirdPlatformCode3";
    private static final String KY_THIRD_PLATFORM_CODE_4 = "kyThirdPlatformCode4";
    private static final String KY_THIRD_PLATFORM_CODE_5 = "kyThirdPlatformCode5";
    private static final String PS_SPEC_VALUE_1 = "psSpecValue1";
    private static final String PS_SPEC_VALUE_2 = "psSpecValue2";
    private static final String PS_SPEC_VALUE_3 = "psSpecValue3";
    private static final String PS_SKU_SUPPLY_PRICE = "psSkuSupplyPrice";
    private static final String FIRST_PS_CATEGORY_NAME = "firstPsCategoryName";
    private static final String SECOND_PS_CATEGORY_NAME = "secondPsCategoryName";
    private static final String REPETITION = "\u91cd\u590d";
    private static final String NOT_EXIST = "\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528";
    private static final String NOT_BLANK = "\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String NEED_BLANK = "\u5fc5\u987b\u4e3a\u7a7a";
    private static final String BRAND_CATEGORY = "\u6b64\u54c1\u724c\u4e0d\u5c5e\u4e8e\u6b64\u7c7b\u76ee";
    private static final String DEFAULT_SPEC = "\u9ed8\u8ba4\u89c4\u683c";
    private static final String ILLEGAL_INPUT = "\u975e\u6cd5\u8f93\u5165";
    private static final String PRICE_INVALID = "\u4f9b\u8d27\u4ef7\u4e0d\u80fd\u5927\u4e8e\u4e13\u67dc\u4ef7,";
    private StringBuilder errorMsg;
    private ImportSpuExcelOfModeDTO dto;
    private SpuService spuService;
    private SkuService skuService;
    private CategoryService categoryService;
    private BrandService brandService;
    private UnitService unitService;
    private BrandCategoryService brandCategoryService;
    private SpecValueService specValueService;
    private SpecService specService;
    private SkuBarCodeService skuBarCodeService;
    private List<String> spuNames;
    private Map<String, ImportSpuExcelDTO> theSpuMap;
    private List<String> spuCodes;
    private List<String> skuNames;
    private List<String> skuCodes;
    private List<String> kyThirdPlatformCodes;
    private List<String> wmsThirdPlatformCodes;
    private List<Category> categorys;
    private List<Brand> brands;
    private List<Unit> units;
    private List<BrandCategory> brandCategories;
    private List<Spec> specs;
    private List<SpecValue> specValues;
    private List<String> barCodes;

    @Autowired
    public ExcelVerifyHandlerImpl(SpuService spuService, SkuService skuService, CategoryService categoryService, BrandService brandService, UnitService unitService, BrandCategoryService brandCategoryService, SpecValueService specValueService, SpecService specService, SkuBarCodeService skuBarCodeService) {
        this.spuService = spuService;
        this.skuService = skuService;
        this.categoryService = categoryService;
        this.brandService = brandService;
        this.unitService = unitService;
        this.brandCategoryService = brandCategoryService;
        this.specValueService = specValueService;
        this.specService = specService;
        this.skuBarCodeService = skuBarCodeService;
    }

    @PostConstruct
    private void init() {
        List skuList;
        this.spuNames = Lists.newArrayList();
        this.spuCodes = Lists.newArrayList();
        this.skuNames = Lists.newArrayList();
        this.skuCodes = Lists.newArrayList();
        this.categorys = Lists.newArrayList();
        this.kyThirdPlatformCodes = Lists.newArrayList();
        this.wmsThirdPlatformCodes = Lists.newArrayList();
        this.theSpuMap = Maps.newHashMap();
        List spuList = this.spuService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseDo::getIsDelete, (Object)false)).select(new SFunction[]{BaseDo::getId, Spu::getCode, Spu::getName}));
        if (CollUtil.isNotEmpty((Collection)spuList)) {
            spuList.forEach(spu -> {
                this.spuNames.add(spu.getName());
                this.spuCodes.add(spu.getCode());
            });
        }
        if (CollUtil.isNotEmpty((Collection)(skuList = this.skuService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseDo::getIsDelete, (Object)false)).select(new SFunction[]{BaseDo::getId, Sku::getCode, Sku::getName, Sku::getKyThirdPlatformCode, Sku::getWmsThirdPlatformCode}))))) {
            skuList.forEach(sku -> {
                this.skuNames.add(sku.getName());
                this.skuCodes.add(sku.getCode());
                this.kyThirdPlatformCodes.add(sku.getKyThirdPlatformCode());
                this.wmsThirdPlatformCodes.add(sku.getWmsThirdPlatformCode());
            });
        }
        this.categorys = this.categoryService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseDo::getIsDelete, (Object)false)).eq(Category::getStatus, (Object)StatusEnums.ENABLED.getCode())).select(new SFunction[]{BaseDo::getId, Category::getWholeName, Category::getName}));
        this.brands = this.brandService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseDo::getIsDelete, (Object)false)).eq(Brand::getStatus, (Object)StatusEnums.ENABLED.getCode())).select(new SFunction[]{BaseDo::getId, Brand::getName, Brand::getCountryName, Brand::getCode}));
        this.units = this.unitService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseDo::getIsDelete, (Object)false)).eq(Unit::getStatus, (Object)StatusEnums.ENABLED.getCode())).select(new SFunction[]{BaseDo::getId, Unit::getName}));
        this.brandCategories = this.brandCategoryService.list((Wrapper)Wrappers.lambdaQuery().eq(BaseDo::getIsDelete, (Object)false));
        this.specs = this.specService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseDo::getIsDelete, (Object)false)).eq(Spec::getStatus, (Object)StatusEnums.ENABLED.getCode()));
        this.specValues = this.specValueService.list((Wrapper)Wrappers.lambdaQuery().eq(BaseDo::getIsDelete, (Object)false));
        this.barCodes = this.skuBarCodeService.list((Wrapper)Wrappers.lambdaQuery().eq(BaseDo::getIsDelete, (Object)false)).stream().map(SkuBarCode::getBarCode).collect(Collectors.toList());
    }

    public ExcelVerifyHandlerResult verifyHandler(ImportSpuExcelOfModeDTO obj) {
        this.dto = obj;
        this.errorMsg = new StringBuilder();
        this.verifySpu((ImportSpuExcelDTO)obj);
        this.verifySku((ImportSpuExcelDTO)obj);
        return this.checkResult();
    }

    private ExcelVerifyHandlerResult checkResult() {
        if (this.errorMsg.length() <= 0) {
            return new ExcelVerifyHandlerResult(true, null);
        }
        return new ExcelVerifyHandlerResult(false, this.errorMsg.substring(0, this.errorMsg.length() - 1));
    }

    private void verifySpu(ImportSpuExcelDTO obj) {
        if (this.theSpuMap.containsKey(obj.getName())) {
            return;
        }
        this.checkBlank(obj.getName(), NAME, false);
        this.checkRepetitionExclusive(this.spuNames, obj.getName(), NAME, obj);
        this.checkBlank(obj.getCategoryName(), CATEGORY_NAME, false);
        this.checkBlank(obj.getPsBrandName(), PS_BRAND_NAME, false);
        this.checkNull(obj.getClassify(), "\u5546\u54c1\u7c7b\u578b(\u5fc5\u586b)\u975e\u6cd5\u8f93\u5165");
        this.checkNull(obj.getTaxCode(), "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\uff08\u5fc5\u586b\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkNull(obj.getMoneyType(), "\u4ef7\u683c\u5e01\u522b(\u5fc5\u586b)\u975e\u6cd5\u8f93\u5165");
        this.checkNull(obj.getPsUnitName(), "\u57fa\u672c\u5355\u4f4d (\u5fc5\u586b)\u975e\u6cd5\u8f93\u5165");
        this.checkNull(obj.getIsSpecialPrice(), "\u662f\u5426\u7279\u4ef7(\u5fc5\u586b)\u975e\u6cd5\u8f93\u5165");
        this.checkNull(obj.getIsSpecialPricePlus(), "\u662f\u5426\u7279\u7279\u4ef7(\u5fc5\u586b)\u975e\u6cd5\u8f93\u5165");
        this.checkNull(obj.getIsSpecialProcurement(), "\u662f\u5426\u7279\u91c7(\u5fc5\u586b)\u975e\u6cd5\u8f93\u5165");
        this.checkNull(obj.getIsTcTj(), "\u662f\u5426\u7279\u91c7\u7279\u4ef7(\u5fc5\u586b)\u975e\u6cd5\u8f93\u5165");
        this.checkNull(obj.getIsTcTtj(), "\u662f\u5426\u7279\u91c7\u7279\u7279\u4ef7(\u5fc5\u586b)\u975e\u6cd5\u8f93\u5165");
        this.checkNull(obj.getIsWmsCode(), "\u7b2c\u4e09\u65b9\u7f16\u7801\uff08WMS\uff09\u662f\u5426\u9ed8\u8ba4\u53d6\u89c4\u683c\u7f16\u7801(\u5fc5\u586b)\u975e\u6cd5\u8f93\u5165");
        this.verifyCategory(obj);
        this.verifyBrand(obj);
        this.verifyUnit(obj);
        this.checkExist(this.brandCategories, o -> o.getPsBrandId().equals(obj.getPsBrandId()) && o.getPsCategoryId().equals(obj.getPsCategoryId()), PS_BRAND_NAME, BRAND_CATEGORY);
        String invoiceItemName = obj.getInvoiceItemName();
        if (CharSequenceUtil.isBlank((CharSequence)invoiceItemName)) {
            obj.setInvoiceItemName(obj.getName());
        }
    }

    private void verifySku(ImportSpuExcelDTO obj) {
        this.checkRepetition(this.skuNames, obj.getSkuName(), SKU_NAME);
        this.verifyIsSpecialPrice(obj);
        this.verifySpec(obj);
        this.verifyBarCode(obj);
        if (CharSequenceUtil.isNotBlank((CharSequence)obj.getPsSkuUnitName())) {
            this.checkExist(this.units, o -> o.getName().equals(obj.getPsSkuUnitName()), PS_SKU_UNIT_NAME, NOT_EXIST).ifPresent(o -> {
                obj.setPsSkuUnitName(o.getName());
                obj.setPsSkuUnitId(o.getId());
            });
        }
        this.verifySkuSupplyPrice(obj);
    }

    private void verifySkuSupplyPrice(ImportSpuExcelDTO obj) {
        BigDecimal psSkuSupplyPrice = obj.getPsSkuSupplyPrice();
        BigDecimal counterPrice = obj.getCounterPrice();
        if (psSkuSupplyPrice == null || counterPrice == null) {
            return;
        }
        if (psSkuSupplyPrice.compareTo(counterPrice) > 0) {
            this.appendErrorMsg(null, PRICE_INVALID);
        }
    }

    private void verifyBarCode(ImportSpuExcelDTO obj) {
        String[] split;
        String barCodeList = obj.getBarCode();
        if (CharSequenceUtil.isBlank((CharSequence)barCodeList)) {
            return;
        }
        for (String barCode : split = barCodeList.split("/")) {
            this.checkRepetition(this.barCodes, barCode, BAR_CODE);
        }
    }

    private void verifyCategory(ImportSpuExcelDTO obj) {
        String categoryName = obj.getCategoryName();
        if (CharSequenceUtil.isBlank((CharSequence)categoryName)) {
            return;
        }
        Optional<Category> optional = this.checkExist(this.categorys, c -> c.getWholeName().trim().equalsIgnoreCase(categoryName.trim()), CATEGORY_NAME);
        optional.ifPresent(o -> {
            Optional<Category> any = this.categorys.stream().filter(c -> o.getId().equals(c.getPid())).findFirst();
            any.ifPresent(a -> this.appendErrorMsg(null, "\u7c7b\u76ee\u5fc5\u987b\u4e3a\u6700\u672b\u7ea7"));
            obj.setPsCategoryId(o.getId());
            obj.setPsCategoryName(o.getName());
        });
    }

    private void verifyBrand(ImportSpuExcelDTO obj) {
        String psBrandName = obj.getPsBrandName();
        if (CharSequenceUtil.isBlank((CharSequence)psBrandName)) {
            return;
        }
        Optional<Brand> optional = this.checkExist(this.brands, o -> o.getName().equalsIgnoreCase(psBrandName), PS_BRAND_NAME);
        optional.ifPresent(o -> {
            obj.setPsBrandId(o.getId());
            obj.setPsBrandName(o.getName());
            obj.setPsBrandCode(o.getCode());
            obj.setPsBrandCountryName(o.getCountryName());
        });
    }

    private void verifyUnit(ImportSpuExcelDTO obj) {
        String psUnitName = obj.getPsUnitName();
        if (CharSequenceUtil.isBlank((CharSequence)psUnitName)) {
            return;
        }
        Optional<Unit> optional = this.checkExist(this.units, o -> o.getName().equalsIgnoreCase(psUnitName), PS_UNIT_NAME);
        optional.ifPresent(o -> {
            obj.setPsUnitId(o.getId());
            obj.setPsUnitName(o.getName());
        });
    }

    private void verifyIsSpecialPrice(ImportSpuExcelDTO obj) {
        WhetherEnum isSpecialPrice = obj.getIsSpecialPrice();
        WhetherEnum isSpecialPricePlus = obj.getIsSpecialPricePlus();
        WhetherEnum isSpecialProcurement = obj.getIsSpecialProcurement();
        WhetherEnum isTcTj = obj.getIsTcTj();
        WhetherEnum isTcTtj = obj.getIsTcTtj();
        WhetherEnum isWms = obj.getIsWms();
        if (isSpecialPrice == null || isSpecialProcurement == null || isSpecialPricePlus == null || isTcTj == null || isTcTtj == null || isWms == null) {
            return;
        }
        if (WhetherEnum.NO.getCode().equals(isWms.getCode())) {
            this.checkBlank(obj.getWmsThirdPlatformCode(), WMS_THIRD_PLATFORM_CODE, false);
            this.checkBlank(obj.getWmsThirdPlatformCode1(), WMS_THIRD_PLATFORM_CODE_1, false);
            this.checkBlank(obj.getWmsThirdPlatformCode2(), WMS_THIRD_PLATFORM_CODE_2, false);
            this.checkBlank(obj.getWmsThirdPlatformCode3(), WMS_THIRD_PLATFORM_CODE_3, false);
            this.checkBlank(obj.getWmsThirdPlatformCode4(), WMS_THIRD_PLATFORM_CODE_4, false);
            this.checkBlank(obj.getWmsThirdPlatformCode5(), WMS_THIRD_PLATFORM_CODE_5, false);
        }
        if (WhetherEnum.YES.getCode().equals(isSpecialPrice.getCode())) {
            this.checkBlank(obj.getKyThirdPlatformCode1(), KY_THIRD_PLATFORM_CODE_1, false);
            this.checkRepetition(this.kyThirdPlatformCodes, obj.getKyThirdPlatformCode1(), KY_THIRD_PLATFORM_CODE_1);
            if (StrUtil.isNotBlank((CharSequence)obj.getWmsThirdPlatformCode1())) {
                this.checkRepetition(this.wmsThirdPlatformCodes, obj.getWmsThirdPlatformCode1(), WMS_THIRD_PLATFORM_CODE_1);
            }
        } else {
            this.checkBlank(obj.getKyThirdPlatformCode1(), KY_THIRD_PLATFORM_CODE_1, true);
            this.checkBlank(obj.getWmsThirdPlatformCode1(), WMS_THIRD_PLATFORM_CODE_1, true);
        }
        if (WhetherEnum.YES.getCode().equals(isSpecialPricePlus.getCode())) {
            this.checkBlank(obj.getKyThirdPlatformCode2(), KY_THIRD_PLATFORM_CODE_2, false);
            this.checkRepetition(this.kyThirdPlatformCodes, obj.getKyThirdPlatformCode2(), KY_THIRD_PLATFORM_CODE_2);
            if (StrUtil.isNotBlank((CharSequence)obj.getWmsThirdPlatformCode2())) {
                this.checkRepetition(this.wmsThirdPlatformCodes, obj.getWmsThirdPlatformCode2(), WMS_THIRD_PLATFORM_CODE_2);
            }
        } else {
            this.checkBlank(obj.getKyThirdPlatformCode2(), KY_THIRD_PLATFORM_CODE_2, true);
            this.checkBlank(obj.getWmsThirdPlatformCode2(), WMS_THIRD_PLATFORM_CODE_2, true);
        }
        if (WhetherEnum.YES.getCode().equals(isSpecialProcurement.getCode())) {
            this.checkBlank(obj.getKyThirdPlatformCode3(), KY_THIRD_PLATFORM_CODE_3, false);
            this.checkRepetition(this.kyThirdPlatformCodes, obj.getKyThirdPlatformCode3(), KY_THIRD_PLATFORM_CODE_3);
            if (StrUtil.isNotBlank((CharSequence)obj.getWmsThirdPlatformCode2())) {
                this.checkRepetition(this.wmsThirdPlatformCodes, obj.getWmsThirdPlatformCode3(), WMS_THIRD_PLATFORM_CODE_3);
            }
        } else {
            this.checkBlank(obj.getKyThirdPlatformCode3(), KY_THIRD_PLATFORM_CODE_3, true);
            this.checkBlank(obj.getWmsThirdPlatformCode3(), WMS_THIRD_PLATFORM_CODE_3, true);
        }
        if (WhetherEnum.YES.getCode().equals(isTcTj.getCode())) {
            this.checkBlank(obj.getKyThirdPlatformCode4(), KY_THIRD_PLATFORM_CODE_4, false);
            this.checkRepetition(this.kyThirdPlatformCodes, obj.getKyThirdPlatformCode4(), KY_THIRD_PLATFORM_CODE_4);
            if (StrUtil.isNotBlank((CharSequence)obj.getWmsThirdPlatformCode4())) {
                this.checkRepetition(this.wmsThirdPlatformCodes, obj.getWmsThirdPlatformCode4(), WMS_THIRD_PLATFORM_CODE_4);
            }
        } else {
            this.checkBlank(obj.getKyThirdPlatformCode4(), KY_THIRD_PLATFORM_CODE_4, true);
            this.checkBlank(obj.getWmsThirdPlatformCode4(), WMS_THIRD_PLATFORM_CODE_4, true);
        }
        if (WhetherEnum.YES.getCode().equals(isTcTtj.getCode())) {
            this.checkBlank(obj.getKyThirdPlatformCode5(), KY_THIRD_PLATFORM_CODE_5, false);
            this.checkRepetition(this.kyThirdPlatformCodes, obj.getKyThirdPlatformCode5(), KY_THIRD_PLATFORM_CODE_5);
            if (StrUtil.isNotBlank((CharSequence)obj.getWmsThirdPlatformCode5())) {
                this.checkRepetition(this.wmsThirdPlatformCodes, obj.getWmsThirdPlatformCode5(), WMS_THIRD_PLATFORM_CODE_5);
            }
        } else {
            this.checkBlank(obj.getKyThirdPlatformCode5(), KY_THIRD_PLATFORM_CODE_5, true);
            this.checkBlank(obj.getWmsThirdPlatformCode5(), WMS_THIRD_PLATFORM_CODE_5, true);
        }
    }

    private void verifySpec(ImportSpuExcelDTO obj) {
        HashSet set;
        String specNames = obj.getPsSpecName();
        ImportSpuExcelDTO importSpuExcelDTO = this.theSpuMap.get(obj.getName());
        if (importSpuExcelDTO != null && CharSequenceUtil.isNotBlank((CharSequence)specNames) && !specNames.equalsIgnoreCase(importSpuExcelDTO.getPsSpecName())) {
            this.appendErrorMsg(PS_SPEC_NAME, "\u540c\u5546\u54c1\u4e0b\u89c4\u683c\u5fc5\u987b\u4e00\u81f4");
            return;
        }
        if (CharSequenceUtil.isBlank((CharSequence)specNames) && CharSequenceUtil.isBlank((CharSequence)obj.getPsSpecValue1())) {
            obj.setPsSpecName(DEFAULT_SPEC);
            obj.setPsSpecName1(DEFAULT_SPEC);
            obj.setPsSpecValue1(DEFAULT_SPEC);
            obj.setSkuType(SkuSpecTypeEnums.DEFAULT.getCode());
            return;
        }
        if (CharSequenceUtil.isBlank((CharSequence)specNames) || CharSequenceUtil.isBlank((CharSequence)obj.getPsSpecValue1())) {
            this.checkNull(specNames, "\u89c4\u683c (\u5fc5\u586b) \u4e0d\u80fd\u4e3a\u7a7a");
            this.checkNull(obj.getPsSpecValue1(), "\u89c4\u683c\u503c1 (\u5fc5\u586b) \u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        Object[] split = specNames.split("/");
        if (split.length > (set = Sets.newHashSet((Object[])split)).size()) {
            this.appendErrorMsg(PS_SPEC_NAME, REPETITION);
            return;
        }
        AtomicInteger atomicInteger = new AtomicInteger(0);
        for (Object specName : split) {
            Optional<Spec> specOptional = this.checkExist(this.specs, arg_0 -> ExcelVerifyHandlerImpl.lambda$verifySpec$13((String)specName, arg_0), PS_SPEC_NAME);
            int num = atomicInteger.incrementAndGet();
            specOptional.ifPresent(o -> {
                ReflectUtil.setFieldValue((Object)obj, (String)(PS_SPEC_NAME + num), (Object)o.getName());
                ReflectUtil.setFieldValue((Object)obj, (String)("psSpecId" + num), (Object)o.getId());
            });
        }
        this.verifySpecValue(obj.getPsSpecValue1(), obj, PS_SPEC_VALUE_1, 1);
        obj.setSkuType(SkuSpecTypeEnums.MANY.getCode());
        if (set.size() == 2) {
            this.verifySpecValue(obj.getPsSpecValue2(), obj, PS_SPEC_VALUE_2, 2);
        }
        if (set.size() == 3) {
            this.verifySpecValue(obj.getPsSpecValue2(), obj, PS_SPEC_VALUE_2, 2);
            this.verifySpecValue(obj.getPsSpecValue3(), obj, PS_SPEC_VALUE_3, 3);
        }
    }

    private void verifySpecValue(String value, ImportSpuExcelDTO obj, String field, Integer num) {
        try {
            Optional<SpecValue> specValueOptional = this.checkExist(this.specValues, o -> o.getValue().equalsIgnoreCase(value.trim()) && o.getPsSpecId().equals(ReflectUtil.getFieldValue((Object)obj, (String)("psSpecId" + num))), field);
            specValueOptional.ifPresent(o -> {
                ReflectUtil.setFieldValue((Object)obj, (String)("psSpecValue" + num), (Object)o.getValue());
                ReflectUtil.setFieldValue((Object)obj, (String)("psSpecValueId" + num), (Object)o.getId());
            });
        }
        catch (Exception e) {
            System.out.println(this.dto.getRowNum() + this.dto.getErrorMsg());
        }
    }

    private <T> Optional<T> checkExist(List<T> list, Predicate<? super T> predicate, String field) {
        return this.checkExist(list, predicate, field, NOT_EXIST);
    }

    private <T> Optional<T> checkExist(List<T> list, Predicate<? super T> predicate, String field, String Msg) {
        Optional<T> optional = list.stream().filter(predicate).findFirst();
        if (!optional.isPresent()) {
            this.appendErrorMsg(field, Msg);
        }
        return optional;
    }

    private void appendErrorMsg(String field, String msg) {
        if (CharSequenceUtil.isNotBlank((CharSequence)field)) {
            this.errorMsg.append(ImportHelper.getExcelName(ImportSpuExcelDTO.class, field));
        }
        this.errorMsg.append(msg).append(",");
    }

    private <T> void checkRepetition(List<T> list, T value, String field) {
        if (ObjectUtil.isEmpty(value)) {
            return;
        }
        if (list.contains(value)) {
            this.appendErrorMsg(field, REPETITION);
        }
        list.add(value);
    }

    private <T> void checkRepetitionExclusive(List<T> list, T value, String field, ImportSpuExcelDTO obj) {
        if (ObjectUtil.isEmpty(value)) {
            return;
        }
        if (list.contains(value)) {
            this.appendErrorMsg(field, REPETITION);
            return;
        }
        this.theSpuMap.put((String)value, obj);
    }

    private void checkBlank(String value, String field, boolean needBlank) {
        if (needBlank && CharSequenceUtil.isNotBlank((CharSequence)value)) {
            this.appendErrorMsg(field, NEED_BLANK);
        } else if (!needBlank && CharSequenceUtil.isBlank((CharSequence)value)) {
            this.appendErrorMsg(field, NOT_BLANK);
        }
    }

    private void checkNull(Object value, String msg) {
        if (ObjectUtil.isEmpty((Object)value)) {
            this.appendErrorMsg(null, msg);
        }
    }

    private static /* synthetic */ boolean lambda$verifySpec$13(String specName, Spec o) {
        return o.getName().equalsIgnoreCase(specName);
    }
}

