/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.hanlder;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xinqiyi.dynamicform.model.enums.DynamicTableKey;
import com.xinqiyi.dynamicform.service.DynamicTableOperator;
import com.xinqiyi.dynamicform.service.task.DynamicExcelExporter;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.excel.model.ExcelHeadData;
import com.xinqiyi.ps.model.dto.dept.PsCauseDeptSkuSupplyPriceDTO;
import com.xinqiyi.ps.model.dto.spu.SpuQueryDTO;
import com.xinqiyi.ps.service.adapter.sc.ScAdapter;
import com.xinqiyi.ps.service.business.PsCauseDeptSkuSupplyPriceBiz;
import com.xinqiyi.systemcenter.web.sc.model.dto.habit.SysTableConfigDto;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PsCauseDeptSkuSupplyPriceExportHandler
extends DynamicExcelExporter {
    private static final Logger log = LoggerFactory.getLogger(PsCauseDeptSkuSupplyPriceExportHandler.class);
    @Autowired
    PsCauseDeptSkuSupplyPriceBiz psCauseDeptSkuSupplyPriceBiz;
    @Autowired
    ScAdapter scAdapter;
    private static final String CUSTOM_COLUMN_TABLE_NAME = "ps_cause_dept_supply_price_2";
    private static final String CUSTOMER_COLUMN_SUPPLY_PRICE_VIRTUAL = "ps_cause_dept_supply_price_virtual_2";

    public PsCauseDeptSkuSupplyPriceExportHandler(DynamicTableOperator dynamicTableOperator) {
        super(dynamicTableOperator);
    }

    public int getTotalRowCount(JSONObject paramObj) {
        JSONObject jsonObject = paramObj.getJSONObject(DynamicTableKey.JSON_DATA.getCode());
        SpuQueryDTO searchRequest = (SpuQueryDTO)JSON.toJavaObject((JSON)jsonObject, SpuQueryDTO.class);
        return (int)this.psCauseDeptSkuSupplyPriceBiz.selectTableCountAndReturnNumber((ApiRequest<SpuQueryDTO>)new ApiRequest((Object)searchRequest));
    }

    public List<Map<String, Object>> getContentDatas(JSONObject paramObj) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<Map<String, Object>> contentData = new ArrayList<Map<String, Object>>();
        Page<PsCauseDeptSkuSupplyPriceDTO> causeDeptSkuSupplyPriceDTOS = this.getPageFromJsonObject(paramObj);
        List records = causeDeptSkuSupplyPriceDTOS.getRecords();
        records.forEach(causeDeptSkuSupplyPriceDTO -> {
            Map map = BeanUtil.beanToMap((Object)causeDeptSkuSupplyPriceDTO, (String[])new String[0]);
            df.format(causeDeptSkuSupplyPriceDTO.getEffectiveTime());
            String effectiveTime = df.format(causeDeptSkuSupplyPriceDTO.getEffectiveTime());
            String invalidTime = df.format(causeDeptSkuSupplyPriceDTO.getInvalidTime());
            map.put("valiTime", effectiveTime + " \u81f3 " + invalidTime);
            map.put("isFreightCost", ObjectUtil.isNull((Object)causeDeptSkuSupplyPriceDTO.getFreightCost()) ? "\u5426" : "\u662f");
            if (ObjectUtil.isNotNull((Object)map)) {
                contentData.add(map);
            }
        });
        Map originDictMap = this.getDictListMap(paramObj);
        HashMap<String, List> dictMap = new HashMap<String, List>();
        for (Map.Entry entry : originDictMap.entrySet()) {
            dictMap.put(CharSequenceUtil.toCamelCase((CharSequence)((CharSequence)entry.getKey())), (List)entry.getValue());
        }
        ArrayList contentDataList = new ArrayList();
        contentData.forEach(gridData -> {
            this.assembleDictMap((Map)gridData, dictMap);
            contentDataList.add(gridData);
        });
        return contentData;
    }

    public List<ExcelHeadData> getExcelHeadData(JSONObject jsonObject) {
        LoginUserInfo loginUserInfo = (LoginUserInfo)jsonObject.getObject("loginUserInfo", LoginUserInfo.class);
        if (loginUserInfo == null) {
            log.error("DynamicExcelExporter.getExcelHeadData.loginUserInfo.ERROR");
            throw new IllegalArgumentException("\u7528\u6237\u672a\u767b\u5f55");
        }
        List<SysTableConfigDto> sysTableConfigDTOS = this.scAdapter.selectHabitConfig(CUSTOM_COLUMN_TABLE_NAME, loginUserInfo.getUserId());
        if (CollectionUtils.isEmpty(sysTableConfigDTOS)) {
            sysTableConfigDTOS = this.scAdapter.selectHabitConfig(CUSTOMER_COLUMN_SUPPLY_PRICE_VIRTUAL, loginUserInfo.getUserId());
        }
        ArrayList<ExcelHeadData> resultList = new ArrayList<ExcelHeadData>();
        sysTableConfigDTOS.forEach(sysTableConfigDTO -> {
            if (ObjectUtil.equal((Object)sysTableConfigDTO.getIsDisable(), (Object)false)) {
                ExcelHeadData excelHeadData = new ExcelHeadData();
                switch (sysTableConfigDTO.getColumnName()) {
                    case "code1": {
                        excelHeadData.setColname("code");
                        break;
                    }
                    case "currentSupplyPrice": {
                        excelHeadData.setColname("supplyPrice");
                        break;
                    }
                    default: {
                        excelHeadData.setColname(sysTableConfigDTO.getColumnName());
                    }
                }
                excelHeadData.setName(sysTableConfigDTO.getColumnTitle());
                excelHeadData.setType("STRING");
                resultList.add(excelHeadData);
            }
        });
        return resultList;
    }

    private Page<PsCauseDeptSkuSupplyPriceDTO> getPageFromJsonObject(JSONObject paramObj) {
        JSONObject jsonObject = paramObj.getJSONObject(DynamicTableKey.JSON_DATA.getCode());
        SpuQueryDTO searchRequest = (SpuQueryDTO)JSON.toJavaObject((JSON)jsonObject, SpuQueryDTO.class);
        return this.psCauseDeptSkuSupplyPriceBiz.selectPage((ApiRequest<SpuQueryDTO>)new ApiRequest((Object)searchRequest));
    }
}

