/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.hanlder;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xinqiyi.dynamicform.model.enums.DynamicTableKey;
import com.xinqiyi.dynamicform.service.DynamicTableOperator;
import com.xinqiyi.dynamicform.service.task.DynamicExcelExporter;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.excel.model.ExcelHeadData;
import com.xinqiyi.ps.model.dto.sku.SkuSupplyPriceDTO;
import com.xinqiyi.ps.model.dto.spu.SpuQueryDTO;
import com.xinqiyi.ps.service.adapter.sc.ScAdapter;
import com.xinqiyi.ps.service.business.SkuSupplyPriceBiz;
import com.xinqiyi.systemcenter.web.sc.model.dto.habit.SysTableConfigDto;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PsSkuSupplyPriceExportHandler
extends DynamicExcelExporter {
    private static final Logger log = LoggerFactory.getLogger(PsSkuSupplyPriceExportHandler.class);
    @Autowired
    SkuSupplyPriceBiz skuSupplyPriceBiz;
    @Autowired
    ScAdapter scAdapter;
    private static final String CUSTOM_COLUMN_TABLE_NAME = "ps_sku_supply_price_";

    public PsSkuSupplyPriceExportHandler(DynamicTableOperator dynamicTableOperator) {
        super(dynamicTableOperator);
    }

    public int getTotalRowCount(JSONObject paramObj) {
        JSONObject jsonObject = paramObj.getJSONObject(DynamicTableKey.JSON_DATA.getCode());
        SpuQueryDTO searchRequest = (SpuQueryDTO)JSON.toJavaObject((JSON)jsonObject, SpuQueryDTO.class);
        return (int)this.skuSupplyPriceBiz.selectCurrentSkuSupplyPriceTableCount((ApiRequest<SpuQueryDTO>)new ApiRequest((Object)searchRequest));
    }

    public List<Map<String, Object>> getContentDatas(JSONObject paramObj) {
        ArrayList<Map<String, Object>> contentData = new ArrayList<Map<String, Object>>();
        Page<SkuSupplyPriceDTO> skuSupplyPriceDTOS = this.getPageFromJsonObject(paramObj);
        List records = skuSupplyPriceDTOS.getRecords();
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
        records.forEach(skuSupplyPriceDTO -> {
            Map map = BeanUtil.beanToMap((Object)skuSupplyPriceDTO, (String[])new String[0]);
            map.put("dfIsFreightCost", ObjectUtil.isNull((Object)skuSupplyPriceDTO.getDfFreightCost()) ? "\u5426" : "\u662f");
            map.put("pcIsFreightCost", ObjectUtil.isNull((Object)skuSupplyPriceDTO.getPcFreightCost()) ? "\u5426" : "\u662f");
            if (ObjectUtil.isNotNull((Object)skuSupplyPriceDTO.getEffectiveTime())) {
                map.put("effectiveTime", ft.format(skuSupplyPriceDTO.getEffectiveTime()));
            }
            if (ObjectUtil.isNotNull((Object)map)) {
                contentData.add(map);
            }
        });
        Map originDictMap = this.getDictListMap(paramObj);
        HashMap<String, List> dictMap = new HashMap<String, List>();
        for (Map.Entry entry : originDictMap.entrySet()) {
            dictMap.put(CharSequenceUtil.toCamelCase((CharSequence)((CharSequence)entry.getKey())), (List)entry.getValue());
        }
        ArrayList contentDataList = new ArrayList();
        contentData.forEach(gridData -> {
            this.assembleDictMap((Map)gridData, dictMap);
            contentDataList.add(gridData);
        });
        return contentData;
    }

    public List<ExcelHeadData> getExcelHeadData(JSONObject jsonObject) {
        LoginUserInfo loginUserInfo = (LoginUserInfo)jsonObject.getObject("loginUserInfo", LoginUserInfo.class);
        if (loginUserInfo == null) {
            log.error("DynamicExcelExporter.getExcelHeadData.loginUserInfo.ERROR");
            throw new IllegalArgumentException("\u7528\u6237\u672a\u767b\u5f55");
        }
        JSONObject queryObject = jsonObject.getJSONObject(DynamicTableKey.JSON_DATA.getCode());
        SpuQueryDTO searchRequest = (SpuQueryDTO)JSON.toJavaObject((JSON)queryObject, SpuQueryDTO.class);
        String tableName = CUSTOM_COLUMN_TABLE_NAME + searchRequest.getSkuSupplyPriceStatus();
        log.info("\u7edf\u4e00\u4f9b\u8d27\u4ef7\u5bfc\u51fa\u67e5\u8be2tableName:{}\u5b9a\u5236\u5217", (Object)tableName);
        List<SysTableConfigDto> sysTableConfigDTOS = this.scAdapter.selectHabitConfig(tableName, loginUserInfo.getUserId());
        ArrayList<ExcelHeadData> resultList = new ArrayList<ExcelHeadData>();
        sysTableConfigDTOS.forEach(sysTableConfigDTO -> {
            if (ObjectUtil.equal((Object)sysTableConfigDTO.getIsDisable(), (Object)false) && !StringUtils.equals((CharSequence)sysTableConfigDTO.getColumnName(), (CharSequence)"spuPictureUrl")) {
                ExcelHeadData excelHeadData = new ExcelHeadData();
                switch (sysTableConfigDTO.getColumnName()) {
                    case "createTime": {
                        excelHeadData.setColname("submitTime");
                        break;
                    }
                    default: {
                        excelHeadData.setColname(sysTableConfigDTO.getColumnName());
                    }
                }
                excelHeadData.setName(sysTableConfigDTO.getColumnTitle());
                excelHeadData.setType("STRING");
                resultList.add(excelHeadData);
            }
        });
        return resultList;
    }

    private Page<SkuSupplyPriceDTO> getPageFromJsonObject(JSONObject paramObj) {
        JSONObject jsonObject = paramObj.getJSONObject(DynamicTableKey.JSON_DATA.getCode());
        SpuQueryDTO searchRequest = (SpuQueryDTO)JSON.toJavaObject((JSON)jsonObject, SpuQueryDTO.class);
        return this.skuSupplyPriceBiz.selectPageSkuSupplyPrice(searchRequest);
    }
}

