/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.helper;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.afterturn.easypoi.handler.inter.IExcelDataModel;
import cn.afterturn.easypoi.handler.inter.IExcelModel;
import cn.afterturn.easypoi.handler.inter.IExcelVerifyHandler;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Component
public class ImportHelper {
    private ImportHelper() {
    }

    public static <T extends IExcelModel & IExcelDataModel> List<T> importExcelToBean(MultipartFile file, Class<T> clazz) {
        ImportParams params = new ImportParams();
        params.setVerifyHandler((IExcelVerifyHandler)SpringUtil.getBean(IExcelVerifyHandler.class));
        params.setNeedVerify(true);
        ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), clazz, (ImportParams)params);
        boolean verifyFail = result.isVerifyFail();
        if (verifyFail) {
            StringBuilder sb = new StringBuilder();
            List failList = result.getFailList();
            for (IExcelModel dto : failList) {
                Integer rowNum = ((IExcelDataModel)dto).getRowNum();
                String errorMsg = dto.getErrorMsg();
                sb.append("\u7b2c[").append(rowNum).append("]\u884c,").append(errorMsg);
            }
            throw new IllegalArgumentException(sb.toString());
        }
        return result.getList();
    }

    public static <T extends IExcelModel & IExcelDataModel> List<T> importExcelToBeanExport(MultipartFile file, Class<T> clazz, Integer sheetNum, IExcelVerifyHandler<T> excelVerifyHandler, HttpServletResponse response) {
        try {
            ExcelImportResult<T> result = ImportHelper.importExcelToBeanReturn(file, clazz, sheetNum, excelVerifyHandler);
            boolean verifyFail = result.isVerifyFail();
            if (verifyFail) {
                String exportExcelName = "\u6570\u636e\u683c\u5f0f\u6821\u9a8c\u5931\u8d25\u7684\u6570\u636e";
                response.setHeader("content-Type", "application/vnd.ms-excel");
                response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(exportExcelName, "UTF-8") + ".xls");
                ExportParams exportParams = new ExportParams();
                List list = result.getList();
                list.addAll(result.getFailList());
                Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, clazz, (Collection)list);
                workbook.write((OutputStream)response.getOutputStream());
                return Lists.newArrayList();
            }
            return result.getList();
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                Assert.isTrue((boolean)false, (String)("\u5bfc\u5165\u5931\u8d25\uff1a" + e.getCause().getMessage()));
            } else {
                Assert.isTrue((boolean)false, (String)("\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage()));
            }
            return Lists.newArrayList();
        }
    }

    public static <T extends IExcelModel & IExcelDataModel> ExcelImportResult<T> importExcelToBeanReturn(MultipartFile file, Class<T> clazz, Integer sheetNum, IExcelVerifyHandler<T> excelVerifyHandler) {
        ImportParams params = new ImportParams();
        params.setVerifyHandler(excelVerifyHandler);
        params.setNeedVerify(true);
        params.setStartSheetIndex(sheetNum.intValue());
        return ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), clazz, (ImportParams)params);
    }

    public static <T> String getExcelName(Class<T> clazz, String field) {
        return ReflectUtil.getField(clazz, (String)field).getAnnotation(Excel.class).name();
    }
}

