/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.mq;

import com.alibaba.fastjson.JSONObject;
import com.xinqiyi.framework.mq.AbstractMqProcessor;
import com.xinqiyi.framework.mq.MqProcessResult;
import com.xinqiyi.ps.service.config.ConstantPropertiesUtil;
import com.xinqiyi.ps.service.mq.MqCallBack;
import com.xinqiyi.ps.service.mq.MqFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class MqProcessor
extends AbstractMqProcessor {
    private static final Logger log = LoggerFactory.getLogger(MqProcessor.class);

    public MqProcessResult startProcess(String messageTopic, String messageKey, String messageBody, String messageTag) {
        log.info("startProcess messageTopic=[{}], messageKey=[{}], messageBody=[{}], messageTag=[{}]", new Object[]{messageTopic, messageKey, messageBody, messageTag});
        MqProcessResult result = new MqProcessResult();
        if (!(ConstantPropertiesUtil.OA_SPU_TAG.equals(messageTag) || ConstantPropertiesUtil.OA_SKU_PRICE_TAG.equals(messageTag) || ConstantPropertiesUtil.OA_CUSTOMER_PRICE.equals(messageTag) || ConstantPropertiesUtil.OA_CAUSE_DEPT_PRICE.equals(messageTag) || ConstantPropertiesUtil.OA_SKU_PRICE_WHOLESALE_TAG.equals(messageTag) || ConstantPropertiesUtil.OA_CUSTOMER_WHOLESALE_PRICE.equals(messageTag) || ConstantPropertiesUtil.OA_CAUSE_DEPT_WHOLESALE_PRICE.equals(messageTag))) {
            result.setSuccess(false);
            log.info("startProcess fail messageTag=[{}]", (Object)messageTag);
            return result;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)messageBody);
        MqFactory mqFactory = new MqFactory();
        MqCallBack mqCallBack = mqFactory.getMqCallBack(messageTag);
        try {
            mqCallBack.oaCallback(jsonObject.getString("processInstanceId"), jsonObject.getString("result"), jsonObject.getString("status"));
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error("Error mq callBack  msg=[{}]", (Object)e.getMessage());
            e.printStackTrace();
            result.setSuccess(false);
        }
        return result;
    }

    public boolean checkCanExecuteProcess(String messageTopic, String messageKey, String messageBody, String messageTag) {
        log.info(" checkCanExecuteProcess  messageTopic=[{}], messageKey=[{}], messageBody=[{}], messageTag=[{}]", new Object[]{messageTopic, messageKey, messageBody, messageTag});
        return ConstantPropertiesUtil.OA_SPU_TAG.equals(messageTag) || ConstantPropertiesUtil.OA_SKU_PRICE_TAG.equals(messageTag) || ConstantPropertiesUtil.OA_CUSTOMER_PRICE.equals(messageTag) || ConstantPropertiesUtil.OA_CAUSE_DEPT_PRICE.equals(messageTag) || ConstantPropertiesUtil.OA_SKU_PRICE_WHOLESALE_TAG.equals(messageTag) || ConstantPropertiesUtil.OA_CUSTOMER_WHOLESALE_PRICE.equals(messageTag) || ConstantPropertiesUtil.OA_CAUSE_DEPT_WHOLESALE_PRICE.equals(messageTag);
    }

    public void initialMqOrderProcessor(ApplicationContext applicationContext) {
    }
}

