/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.util;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanCopier;

public class BeanConvertUtil {
    private static final Logger log = LoggerFactory.getLogger(BeanConvertUtil.class);

    public static <T> List<T> convertList(List sourceList, Class<T> clazz) {
        if (CollectionUtil.isEmpty((Collection)sourceList)) {
            return Collections.emptyList();
        }
        ArrayList<T> resultList = new ArrayList<T>(sourceList.size());
        if (clazz.getName().equals(sourceList.get(0).getClass().getName())) {
            return sourceList;
        }
        try {
            for (Object source : sourceList) {
                T target = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                BeanConvertUtil.copyProperties(source, target);
                resultList.add(target);
            }
        }
        catch (Exception e) {
            log.error("\u5bf9\u8c61\u8f6c\u6362\u5f02\u5e38, class = [{}]", (Object)clazz.getName());
        }
        return resultList;
    }

    public static <T, VO> Page<VO> convertPage(Page<T> page, Class<VO> clazz) {
        List sourceList = page.getRecords();
        List<VO> convertList = BeanConvertUtil.convertList(sourceList, clazz);
        Page voPage = new Page();
        voPage.setTotal(page.getTotal());
        voPage.setSize(page.getSize());
        voPage.setCurrent(page.getCurrent());
        voPage.setRecords(convertList);
        return voPage;
    }

    public static void copyProperties(Object source, Object target) {
        BeanCopier copier = BeanCopier.create(source.getClass(), target.getClass(), (boolean)false);
        copier.copy(source, target, null);
    }

    public static <T> T humpToUnderline(Object source, Class<T> clazz) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            String reqJson = mapper.writeValueAsString(source);
            return (T)JSONObject.parseObject((String)reqJson, clazz);
        }
        catch (JsonProcessingException e) {
            e.getLocalizedMessage();
            return null;
        }
    }
}

