/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;

public class BigDecimalUtils {
    private BigDecimalUtils() {
    }

    public static boolean lessThan(BigDecimal num1, BigDecimal num2) {
        return num1.compareTo(num2) == -1;
    }

    public static boolean lessEqual(BigDecimal num1, BigDecimal num2) {
        return num1.compareTo(num2) == -1 || num1.compareTo(num2) == 0;
    }

    public static boolean greaterThan(BigDecimal num1, BigDecimal num2) {
        return num1.compareTo(num2) == 1;
    }

    public static boolean greaterEqual(BigDecimal num1, BigDecimal num2) {
        return num1.compareTo(num2) == 1 || num1.compareTo(num2) == 0;
    }

    public static boolean equal(BigDecimal num1, BigDecimal num2) {
        if (num1 == null || num2 == null) {
            return Boolean.FALSE;
        }
        return num1.compareTo(num2) == 0;
    }

    public static BigDecimal getValue(BigDecimal param) {
        if (null != param) {
            param = new BigDecimal(String.format("%.2f", param));
        }
        return param;
    }

    public static BigDecimal convert(BigDecimal bigDecimal, int num) {
        if (bigDecimal == null) {
            return null;
        }
        return bigDecimal.setScale(num, 4);
    }

    public static BigDecimal convertDown(BigDecimal bigDecimal, int num) {
        if (bigDecimal == null) {
            return null;
        }
        return bigDecimal.setScale(num, 1);
    }

    public static String thousandthCalculation(BigDecimal bigDecimal) {
        DecimalFormat decimalFormat = new DecimalFormat("###,##0.00");
        return decimalFormat.format(bigDecimal);
    }
}

