/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.util;

import cn.hutool.core.text.StrBuilder;
import com.xinqiyi.framework.excel.model.ExcelHeadData;
import com.xinqiyi.ps.model.annotation.GetHeader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class CamelTransformUnderlineUtils {
    public static <T> Map transformToUnderlineCase(T object) {
        if (object == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> tempClass = object.getClass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        for (int i = 0; i < fieldList.size(); ++i) {
            String fieldName = ((Field)fieldList.get(i)).getName();
            if ("serialVersionUID".equalsIgnoreCase(fieldName)) continue;
            String transformFieldName = CamelTransformUnderlineUtils.toUnderlineCase(fieldName);
            Object fieldValue = CamelTransformUnderlineUtils.getFiledValue(object, (Field)fieldList.get(i));
            map.put(transformFieldName, fieldValue);
        }
        return map;
    }

    private static <T> Object getFiledValue(T object, Field field) {
        String fieldName = field.getName();
        Object fieldValue = null;
        String name = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        try {
            String type = field.getGenericType().toString();
            Method m = object.getClass().getMethod("get" + name, new Class[0]);
            switch (type) {
                case "class java.lang.String": 
                case "class java.lang.Boolean": 
                case "class java.util.Date": 
                case "class java.lang.Integer": 
                case "class java.lang.Long": {
                    fieldValue = m.invoke(object, new Object[0]);
                    break;
                }
                case "class java.math.BigDecimal": {
                    fieldValue = m.invoke(object, new Object[0]);
                    if (null != fieldValue) {
                        fieldValue = CamelTransformUnderlineUtils.numberFormatThousandth(new BigDecimal(String.valueOf(fieldValue)));
                    }
                    break;
                }
                default: {
                    Object obj = m.invoke(object, new Object[0]);
                    fieldValue = CamelTransformUnderlineUtils.transformToUnderlineCase(obj);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fieldValue;
    }

    public static <T> List transferToUnderLineList(List<T> list) {
        return list.stream().map(task -> CamelTransformUnderlineUtils.transformToUnderlineCase(task)).collect(Collectors.toList());
    }

    public static Map<String, Object> beanToMap(Object object) {
        try {
            Field[] fields;
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Field field : fields = object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                map.put(field.getName(), field.get(object));
            }
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap<String, Object>();
        }
    }

    private static String toUnderlineCase(String str) {
        char symbol = '_';
        if (str == null) {
            return null;
        }
        int length = str.length();
        StrBuilder sb = new StrBuilder();
        for (int i = 0; i < length; ++i) {
            Character preChar;
            char c = str.charAt(i);
            Character c2 = preChar = i > 0 ? Character.valueOf(str.charAt(i - 1)) : null;
            if (Character.isUpperCase(c)) {
                Character nextChar;
                Character c3 = nextChar = i < str.length() - 1 ? Character.valueOf(str.charAt(i + 1)) : null;
                if (null != preChar && Character.isUpperCase(preChar.charValue())) {
                    sb.append(c);
                    continue;
                }
                if (null != nextChar && !Character.isLowerCase(nextChar.charValue())) {
                    if (null != preChar && symbol != preChar.charValue()) {
                        sb.append(symbol);
                    }
                    sb.append(c);
                    continue;
                }
                if (null != preChar && symbol != preChar.charValue()) {
                    sb.append(symbol);
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (symbol != c && sb.length() > 0 && Character.isUpperCase(sb.charAt(-1)) && Character.isLowerCase(c)) {
                sb.append(symbol);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String changeColumn(String column) {
        if (ObjectUtils.isNotEmpty((Object)column)) {
            StringBuilder sb = new StringBuilder();
            String[] split = column.split("_");
            for (int i = 0; i < Arrays.asList(split).size(); ++i) {
                if (0 == i) {
                    sb.append(split[i]);
                    continue;
                }
                sb.append(split[i].substring(0, 1).toUpperCase()).append(split[i].substring(1));
            }
            return sb.toString();
        }
        return "";
    }

    public static void main(String[] args) {
        String transformFieldName = CamelTransformUnderlineUtils.toUnderlineCase("fieldName");
        System.out.println(transformFieldName);
    }

    public static List<ExcelHeadData> getDTOColumns(Class<?> clazz) {
        TreeMap<Integer, ExcelHeadData> orderMap = new TreeMap<Integer, ExcelHeadData>();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> tempClass = clazz; tempClass != null; tempClass = tempClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        for (Field field : fieldList) {
            GetHeader getHeader = field.getAnnotation(GetHeader.class);
            if (getHeader == null) continue;
            ExcelHeadData excelHeadData = new ExcelHeadData();
            excelHeadData.setColname(field.getName());
            excelHeadData.setName(getHeader.value());
            orderMap.put(getHeader.order(), excelHeadData);
        }
        return new LinkedList<ExcelHeadData>(orderMap.values());
    }

    public static String numberFormatThousandth(BigDecimal bigDecimal) {
        if (bigDecimal != null) {
            NumberFormat numberFormat1 = NumberFormat.getNumberInstance();
            numberFormat1.setMaximumFractionDigits(8);
            return numberFormat1.format(bigDecimal);
        }
        return "";
    }
}

