/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;

public class DateUtil {
    public static final String DATAFORMAT_STR = "yyyy-MM-dd";
    public static final String YYYY_MM_DATAFORMAT_STR = "yyyy-MM";
    public static final String DATATIMEF_STR = "yyyy-MM-dd HH:mm:ss";
    public static final String DATATIMEF_STR2 = "yyyyMMdd HH:mm:ss";
    public static final String DATATIMEF_STR_MIS = "yyyyMMddHHmmssSSS";
    public static final String DATATIMEF_STR_MI = "yyyy-MM-dd HH:mm";
    public static final String DATATIMEF_STR_MDHm = "MM.dd HH:mm";
    public static final String HH_STR = "HH";
    public static final String DATATIMEF_STR_SEC = "yyyyMMddHHmmss";
    public static final String ZHCN_DATAFORMAT_STR = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String ZHCN_DATATIMEF_STR = "yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2";
    public static final String ZHCN_DATATIMEF_STR_4yMMddHHmm = "yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206";
    public static final String MONTHANDDATE_STR = "MM.dd";
    public static final String DATATIMEF_STR_MIN = "yyyyMMddHHmm";
    public static final String DATAFORMAT_STR3 = "yyyyMM";
    public static final String DATAFORMAT_STR4 = "yyyyMMdd";
    public static final String HOUR_END = " 23:59:59";
    public static final String HOUR_START = " 00:00:00";
    public static final int NUMBER_VALUE_31 = 31;
    public static final int NUMBER_VALUE_60 = 60;
    public static final int NUMBER_VALUE_1000 = 1000;
    public static final int NUMBER_VALUE_60000 = 60000;
    public static final int NUMBER_VALUE_86400 = 86400;
    public static final int NUMBER_VALUE_3600000 = 3600000;
    public static final int NUMBER_VALUE_11 = 11;
    public static final int NUMBER_VALUE_24 = 24;

    private DateUtil() {
    }

    public static Date now() {
        return Calendar.getInstance(Locale.CHINESE).getTime();
    }

    public static Date getStartOfDay(Date date) {
        Calendar calendar = Calendar.getInstance(Locale.CHINESE);
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getEndOfDay(Date date) {
        Calendar calendar = Calendar.getInstance(Locale.CHINESE);
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static Date yearsAfter(Date baseDate, int increaseDate) {
        Calendar calendar = Calendar.getInstance(Locale.CHINESE);
        calendar.setTime(baseDate);
        calendar.add(1, increaseDate);
        return calendar.getTime();
    }

    public static Date daysAfter(Date baseDate, int increaseDate) {
        Calendar calendar = Calendar.getInstance(Locale.CHINESE);
        calendar.setTime(baseDate);
        calendar.add(5, increaseDate);
        return calendar.getTime();
    }

    public static Date hoursAfter(Date baseDate, int increaseHours) {
        Calendar calendar = Calendar.getInstance(Locale.CHINESE);
        calendar.setTime(baseDate);
        calendar.add(11, increaseHours);
        return calendar.getTime();
    }

    public static Date minuteAfter(Date baseDate, int increaseMinute) {
        Calendar calendar = Calendar.getInstance(Locale.CHINESE);
        calendar.setTime(baseDate);
        calendar.add(12, increaseMinute);
        return calendar.getTime();
    }

    public static Date monthAfter(Date baseDate, int increaseMonths) {
        Calendar calendar = Calendar.getInstance(Locale.CHINESE);
        calendar.setTime(baseDate);
        calendar.add(2, increaseMonths);
        return calendar.getTime();
    }

    public static Date getInternalDateByDay(Date d, int days) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(d);
        now.add(5, days);
        return now.getTime();
    }

    public static Date getInternalDateByMinute(Date d, int minutes) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(d);
        now.add(12, minutes);
        return now.getTime();
    }

    public static String dateToDateString(Date date) {
        return DateUtil.dateToDateString(date, DATATIMEF_STR);
    }

    public static String dateToDayString(Date date) {
        return DateUtil.dateToDateString(date, DATAFORMAT_STR);
    }

    public static String dateToDateString2(Date date) {
        return DateUtil.dateToDateString(date, DATATIMEF_STR2);
    }

    public static String dateToDateString(Date date, String formatStr) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat df = DateUtil.getDateFormat(formatStr);
        return df.format(date);
    }

    public static Date getDate(String dateTimeStr, String formatStr) {
        try {
            if (dateTimeStr == null || dateTimeStr.equals("")) {
                return null;
            }
            SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
            Date d = sdf.parse(dateTimeStr);
            return d;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getCurDate() {
        return DateUtil.dateToDateString(Calendar.getInstance().getTime(), DATAFORMAT_STR);
    }

    public static String getCurHour() {
        return DateUtil.dateToDateString(Calendar.getInstance().getTime(), HH_STR);
    }

    public static int getThisMonth() {
        Calendar c = Calendar.getInstance(Locale.CHINESE);
        int month = c.get(2) + 1;
        return month;
    }

    public static int getCurrentMonthDay() {
        Calendar ca = Calendar.getInstance();
        int day = ca.get(5);
        return day;
    }

    public static SimpleDateFormat getDateFormat(String formatStr) {
        return new SimpleDateFormat(formatStr);
    }

    public static String getFirstDateOfMonth(Date now) {
        SimpleDateFormat df1 = new SimpleDateFormat(DATATIMEF_STR);
        Date da = new Date(now.getYear(), now.getMonth(), 1);
        return df1.format(da);
    }

    public static String getLastDateOfMonth(Date now) {
        SimpleDateFormat df1 = new SimpleDateFormat(DATATIMEF_STR);
        Date da = new Date(now.getYear(), now.getMonth(), 31);
        return df1.format(da);
    }

    public static Date getHalfYearEndTime(Date date) {
        SimpleDateFormat shortSdf = new SimpleDateFormat(DATAFORMAT_STR);
        SimpleDateFormat longSdf = new SimpleDateFormat(DATATIMEF_STR);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int currentMonth = c.get(2) + 1;
        Date now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 6) {
                c.set(2, 5);
                c.set(5, 30);
            } else if (currentMonth >= 7 && currentMonth <= 12) {
                c.set(2, 11);
                c.set(5, 31);
            }
            now = longSdf.parse(shortSdf.format(c.getTime()) + HOUR_END);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static int getMinutesBetweenMillis(long t1, long t2) {
        return (int)((t1 - t2) / 60000L);
    }

    public static boolean compareTargetTime(Date target, String begin, String end) {
        String targetTime = DateUtil.dateToDateString(target, DATATIMEF_STR).substring(11);
        return targetTime.compareTo(begin) >= 0 && end.compareTo(targetTime) >= 0;
    }

    public static boolean compareTime(Date time1, Date time2) {
        if (time1 == null || time2 == null) {
            return false;
        }
        return time1.getTime() < time2.getTime();
    }

    public static boolean sameDate(Date time1, Date time2) {
        if (time1 == null || time2 == null) {
            return false;
        }
        LocalDate localDate1 = ZonedDateTime.ofInstant(time1.toInstant(), ZoneId.systemDefault()).toLocalDate();
        LocalDate localDate2 = ZonedDateTime.ofInstant(time2.toInstant(), ZoneId.systemDefault()).toLocalDate();
        return localDate1.isEqual(localDate2);
    }

    public static int getBetweenDays(String t1, String t2) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(DATAFORMAT_STR);
        int betweenDays = 0;
        Date d1 = format.parse(t1);
        Date d2 = format.parse(t2);
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(d1);
        c2.setTime(d2);
        if (c1.after(c2)) {
            c1 = c2;
            c2.setTime(d1);
        }
        int betweenYears = c2.get(1) - c1.get(1);
        betweenDays = c2.get(6) - c1.get(6);
        for (int i = 0; i < betweenYears; ++i) {
            c1.set(1, c1.get(1) + 1);
            betweenDays += c1.getMaximum(6);
        }
        return betweenDays;
    }

    public static String getFormatDate(Date date) {
        return new SimpleDateFormat().format(date);
    }

    public static Date getFormatDate(Date dateTimer, String formatStr) {
        try {
            if (dateTimer == null) {
                return null;
            }
            SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
            String timeStr = sdf.format(dateTimer);
            Date formateDate = sdf.parse(timeStr);
            return formateDate;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getFormatDateStr(Date dateTimer, String formatStr) {
        try {
            if (dateTimer == null) {
                return null;
            }
            SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
            String timeStr = sdf.format(dateTimer);
            return timeStr;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static long getQuot(String time1, String time2) {
        long quot = 0L;
        SimpleDateFormat ft = new SimpleDateFormat(DATAFORMAT_STR);
        try {
            Date date1 = ft.parse(time1);
            Date date2 = ft.parse(time2);
            quot = date1.getTime() - date2.getTime();
            quot = quot / 1000L / 60L / 60L / 24L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return quot;
    }

    public static long getQuot(Date time1, Date time2) {
        if (time1 == null || time2 == null) {
            return -1L;
        }
        long quot = 0L;
        quot = time1.getTime() - time2.getTime();
        quot = quot / 1000L / 60L;
        return quot;
    }

    public static long getDiffenceValue(Date begin) {
        Calendar cal = Calendar.getInstance();
        Date now = cal.getTime();
        long value = (begin.getTime() - now.getTime()) / 1000L / 60L;
        return value;
    }

    public static long getMillsBetweenTwoDate(Date date1, Date date2) {
        return date1.getTime() - date2.getTime();
    }

    public static Date addDate(int field, int day) {
        Calendar nowCalendar = Calendar.getInstance(Locale.CHINESE);
        nowCalendar.setTime(DateUtil.now());
        nowCalendar.add(field, day);
        return nowCalendar.getTime();
    }

    public static Date addDateSecond(int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, second);
        return calendar.getTime();
    }

    public static String getCurrFirstDay() {
        SimpleDateFormat format = new SimpleDateFormat(DATAFORMAT_STR);
        Calendar c = Calendar.getInstance();
        c.add(2, 0);
        c.set(5, 1);
        String first = format.format(c.getTime());
        return first;
    }

    public static String getCurrLastDay() {
        SimpleDateFormat format = new SimpleDateFormat(DATAFORMAT_STR);
        Calendar ca = Calendar.getInstance();
        ca.set(5, ca.getActualMaximum(5));
        String last = format.format(ca.getTime());
        return last;
    }

    public static Date getAssignCurrFirstDay(Date date) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(DATAFORMAT_STR);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, 0);
        c.set(5, 1);
        String first = format.format(c.getTime());
        return format.parse(first);
    }

    public static Date getAssignCurrLastDay(Date date) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(DATAFORMAT_STR);
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(5, ca.getActualMaximum(5));
        String last = format.format(ca.getTime());
        return format.parse(last);
    }

    public static Date startOneDay(Date date) {
        try {
            String halfFormat = new SimpleDateFormat(DATAFORMAT_STR).format(date);
            return new SimpleDateFormat(DATATIMEF_STR).parse(halfFormat + HOUR_START);
        }
        catch (ParseException e) {
            return date;
        }
    }

    public static Date endOneDay(Date date) {
        try {
            String halfFormat = new SimpleDateFormat(DATAFORMAT_STR).format(date);
            return new SimpleDateFormat(DATATIMEF_STR).parse(halfFormat + HOUR_END);
        }
        catch (ParseException e) {
            return date;
        }
    }

    public static String getCurrentDay() {
        SimpleDateFormat format = new SimpleDateFormat(DATAFORMAT_STR4);
        Calendar ca = Calendar.getInstance();
        String last = format.format(ca.getTime());
        return last;
    }

    public static long getFragmentInSeconds(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        long result = 0L;
        result += (long)(calendar.get(11) * 3600000 / 1000);
        result += (long)(calendar.get(12) * 60000 / 1000);
        result += (long)(calendar.get(13) * 1000 / 1000);
        return result += (long)(calendar.get(14) * 1 / 1000);
    }

    public static long getDistanceSeconds(Calendar calendar) {
        return 86400L - DateUtil.getFragmentInSeconds(calendar);
    }

    public static long getRemainingSecondsFromNowToDayOff() {
        return 86400L - DateUtil.getFragmentInSeconds(Calendar.getInstance());
    }

    public static long getDistanceMonthSeconds(Calendar c) {
        int d = c.getActualMaximum(5);
        int now = c.get(5);
        int a = (d - now) * 24 * 60 * 60;
        return (long)a + DateUtil.getDistanceSeconds(c);
    }

    public static Date getCurrYearFirst() {
        Calendar currCal = Calendar.getInstance();
        int currentYear = currCal.get(1);
        return DateUtil.getYearFirst(currentYear);
    }

    public static Date getCurrYearLast() {
        Calendar currCal = Calendar.getInstance();
        int currentYear = currCal.get(1);
        return DateUtil.getYearLast(currentYear);
    }

    public static Date getYearFirst(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        Date currYearFirst = calendar.getTime();
        return currYearFirst;
    }

    public static Date getYearLast(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        Date currYearLast = calendar.getTime();
        return currYearLast;
    }

    public static Integer getYear(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        return Integer.valueOf(sdf.format(date));
    }

    public static Integer getMonthSpace(String str1, String str2) {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DATAFORMAT_STR);
        Calendar bef = Calendar.getInstance();
        Calendar aft = Calendar.getInstance();
        try {
            bef.setTime(sdf.parse(str1));
            aft.setTime(sdf.parse(str2));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int result = aft.get(2) - bef.get(2);
        int month = (aft.get(1) - bef.get(1)) * 12;
        return Math.abs(month + result) + 1;
    }

    public static Date formatTime(String dateStr) {
        if (null == dateStr) {
            return null;
        }
        if (dateStr.length() == 14) {
            try {
                return new SimpleDateFormat(DATATIMEF_STR_SEC).parse(dateStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            Date date = new SimpleDateFormat(DATAFORMAT_STR4).parse(dateStr);
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getDate(String dateStr) {
        if (null == dateStr) {
            return null;
        }
        if (dateStr.length() > 14) {
            try {
                return new SimpleDateFormat(DATATIMEF_STR).parse(dateStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            Date date = new SimpleDateFormat(DATAFORMAT_STR).parse(dateStr);
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isRunYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static String getStringFeeMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int currentMonth = c.get(2) + 1;
        Object now = null;
        int year = c.get(1);
        int month = c.get(2) + 1;
        StringBuffer result = new StringBuffer();
        result.append(year).append("\u5e74");
        try {
            if (month >= 1 && month <= 6) {
                result.append("1-6\u6708\u4efd");
            } else if (month >= 7 && month <= 12) {
                result.append("7-12\u6708\u4efd");
            }
            return result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getDateByString(String dateStr) {
        if (null == dateStr) {
            return null;
        }
        try {
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            int year = c.get(1);
            return new SimpleDateFormat(DATAFORMAT_STR).parse(year + "-" + dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getBetweenDays(Date startTime, Date endTime) {
        long start = startTime.getTime();
        long end = endTime.getTime();
        return (int)(Math.abs(end - start) / 86400000L);
    }

    public static int differTimeSecond(Date startDate, Date endDate) {
        long end = endDate.getTime();
        long start = startDate.getTime();
        return (int)(end - start) / 1000;
    }

    public static int getBetweenHours(Date startTime, Date endTime) {
        long start = startTime.getTime();
        long end = endTime.getTime();
        return (int)(Math.abs(end - start) / 3600000L);
    }

    public static int differentDays(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 != year2) {
            int timeDistance = 0;
            for (int i = year1; i < year2; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return timeDistance + (day2 - day1);
        }
        System.out.println("\u5224\u65adday2 - day1 : " + (day2 - day1));
        return day2 - day1;
    }

    public static int getSecondTimestampTwo(Date date) {
        if (null == date) {
            return 0;
        }
        String timestamp = String.valueOf(date.getTime() / 1000L);
        return Integer.valueOf(timestamp);
    }

    public static String getOverTime(Date overTime) {
        long diff;
        if (Objects.nonNull(overTime) && (diff = DateUtil.getDiffenceValue(overTime)) > 0L) {
            return DateUtil.getFormatDateStr(DateUtil.minuteAfter(DateUtil.now(), diff > 60L ? 60 : (int)diff), DATATIMEF_STR_SEC);
        }
        return null;
    }

    public static Date addDateMinut(Date date, int x) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, x);
        date = cal.getTime();
        return date;
    }

    public static int getSecondTimestamp(Date date) {
        if (null == date) {
            return 0;
        }
        String timestamp = String.valueOf(date.getTime());
        int length = timestamp.length();
        if (length > 3) {
            return Integer.valueOf(timestamp.substring(0, length - 3));
        }
        return 0;
    }

    public static int findLastDay(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        int lastDay = calendar.getActualMaximum(5);
        return lastDay;
    }
}

