/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import com.xinqiyi.framework.file.StorageFileHelper;
import com.xinqiyi.framework.file.exception.DownFileException;
import com.xinqiyi.ps.service.config.ConstantPropertiesUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FileUploadUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUploadUtil.class);
    @Autowired
    private StorageFileHelper storageFileHelper;

    public String uploadExcelFile(String module, String localExcelFile, String userName) {
        File excelFile = new File(localExcelFile);
        String path = module + DateUtil.format((Date)new Date(), (String)"yyyy/MM/dd");
        String uploadUrl = this.storageFileHelper.getDefaultStorageFileOperate().uploadFile(path, excelFile.getName().replace(".xlsx", ""), ".xlsx", localExcelFile, userName).replace("ali-oss://", "");
        uploadUrl = this.storageFileHelper.getDefaultStorageFileOperate().buildDownloadFileHttpUrl(uploadUrl);
        excelFile.delete();
        return uploadUrl;
    }

    public String uploadExcelFileLongTeam(String module, String localExcelFile, String userName) {
        File excelFile = new File(localExcelFile);
        String path = module + DateUtil.format((Date)new Date(), (String)"yyyy/MM/dd");
        String uploadUrl = this.storageFileHelper.getDefaultStorageFileOperate().uploadFile(path, excelFile.getName().replace(".xlsx", ""), ".xlsx", localExcelFile, userName);
        excelFile.delete();
        return uploadUrl;
    }

    public String uploadExcelFileXls(String module, String localExcelFile, String userName) {
        File excelFile = new File(localExcelFile);
        String path = module + DateUtil.format((Date)new Date(), (String)"yyyy/MM/dd");
        String uploadUrl = this.storageFileHelper.getDefaultStorageFileOperate().uploadFile(path, excelFile.getName().replace(".xls", ""), ".xls", localExcelFile, userName).replace("ali-oss://", "");
        uploadUrl = this.storageFileHelper.getDefaultStorageFileOperate().buildDownloadFileHttpUrl(uploadUrl);
        return uploadUrl;
    }

    public void downLoadFile(String sourceFileName, String saveFileName) {
        try {
            File destFile = new File(sourceFileName);
            if (destFile.exists()) {
                return;
            }
            this.storageFileHelper.getDefaultStorageFileOperate().downloadFile(sourceFileName, saveFileName);
        }
        catch (FileNotFoundException e) {
            log.error(sourceFileName + "\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
        }
        catch (DownFileException e) {
            log.error(sourceFileName + "\u4e0b\u8f7d\u5931\u8d252", (Throwable)e);
        }
    }

    public void downLoadPictureFileByWholeUrl(String filePrefix, String sourceFileName, String saveFileName) {
        String fileUrl = ConstantPropertiesUtil.DEFAULT_FILE_OPERATE_NAME + filePrefix;
        FileUtil.mkdir((String)fileUrl);
        String localPath = fileUrl + saveFileName;
        boolean exist = FileUtil.exist((String)localPath);
        if (!exist) {
            try {
                int questionMarkIndex = sourceFileName.indexOf("?");
                sourceFileName = questionMarkIndex != -1 ? sourceFileName.substring(0, questionMarkIndex) : sourceFileName;
                String fileExtension = "." + FileUploadUtil.getFileExtension(sourceFileName);
                URL url = new URL(sourceFileName);
                HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
                try (InputStream inputStream = httpURLConnection.getInputStream();
                     FileOutputStream outputStream = new FileOutputStream(localPath + fileExtension);){
                    int bytesRead;
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String getFileExtension(String fileName) {
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex > 0 && lastDotIndex < fileName.length() - 1) {
            return fileName.substring(lastDotIndex + 1);
        }
        return "";
    }
}

