/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.util;

import cn.hutool.core.io.FileUtil;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;

public class FileZipUtil {
    private FileZipUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipAndDownload(HttpServletResponse response, String zipFileName, FolderInfo ... subFolders) throws IOException {
        zipFileName = StringUtils.isBlank((CharSequence)zipFileName) ? "download.zip" : zipFileName;
        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", "attachment; filename=" + zipFileName);
        try (ZipOutputStream zipOut = new ZipOutputStream((OutputStream)response.getOutputStream());){
            for (FolderInfo subFolder : subFolders) {
                FileZipUtil.zipFolder(zipOut, subFolder);
            }
        }
        finally {
            FileZipUtil.deleteLocalFiles(subFolders);
        }
    }

    private static void zipFolder(ZipOutputStream zipOut, FolderInfo folderInfo) throws IOException {
        File folder = new File(folderInfo.getPath());
        if (!folder.exists() || !folder.isDirectory()) {
            return;
        }
        File[] files = folder.listFiles();
        if (files != null && files.length > 0) {
            zipOut.putNextEntry(new ZipEntry(folderInfo.getName() + "/"));
            for (File file : files) {
                try (FileInputStream fis = new FileInputStream(file);){
                    int length;
                    zipOut.putNextEntry(new ZipEntry(folderInfo.getName() + "/" + file.getName()));
                    byte[] bytes = new byte[1024];
                    while ((length = fis.read(bytes)) >= 0) {
                        zipOut.write(bytes, 0, length);
                    }
                    zipOut.closeEntry();
                }
            }
        }
    }

    private static void deleteLocalFiles(FolderInfo ... subFolders) {
        for (FolderInfo subFolder : subFolders) {
            FileUtil.del((String)subFolder.getPath());
        }
    }

    public static class FolderInfo {
        private String name;
        private String path;

        public FolderInfo() {
        }

        public FolderInfo(String name, String path) {
            this.name = name;
            this.path = path;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FolderInfo)) {
                return false;
            }
            FolderInfo other = (FolderInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            return !(this$path == null ? other$path != null : !this$path.equals(other$path));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FolderInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            return result;
        }

        public String toString() {
            return "FileZipUtil.FolderInfo(name=" + this.getName() + ", path=" + this.getPath() + ")";
        }
    }
}

