/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.auth.GateWayWebAuthService;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class HttpRequestUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestUtil.class);
    @Autowired
    private GateWayWebAuthService gateWayWebAuthService;
    @Autowired
    private RestTemplate restTemplate;

    public ApiResponse doHttpRequest(String url, Object obj) {
        String token = this.gateWayWebAuthService.getCurrentRequestToken();
        log.info("token:{}", (Object)token);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity entity = new HttpEntity((Object)JSON.toJSONString((Object)obj), (MultiValueMap)headers);
        ApiResponse res = new ApiResponse();
        try {
            res = (ApiResponse)this.restTemplate.postForObject(url, (Object)entity, ApiResponse.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u670d\u52a1\u5931\u8d25" + e.getMessage());
            e.printStackTrace();
            Assert.isTrue((boolean)false, (String)"\u8c03\u7528\u670d\u52a1\u5931\u8d25");
        }
        return res;
    }

    public String doHttpRequestList(String url, Object obj) {
        String token = this.gateWayWebAuthService.getCurrentRequestToken();
        log.info("token:{}", (Object)token);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity entity = new HttpEntity((Object)JSON.toJSONString((Object)obj), (MultiValueMap)headers);
        this.restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, entity, String.class, new Object[0]);
        JSONObject jsonObject = JSONObject.parseObject((String)((String)responseEntity.getBody()));
        String code = jsonObject.getString("code");
        String desc = jsonObject.getString("desc");
        Assert.isTrue((boolean)"000".equals(code), (String)desc);
        return jsonObject.getString("content");
    }

    public ApiResponse doRequest(String url, Object obj, String token) {
        token = StringUtils.isBlank((CharSequence)token) ? this.gateWayWebAuthService.getCurrentRequestToken() : token;
        log.info("token:{}", (Object)token);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity entity = new HttpEntity((Object)JSON.toJSONString((Object)obj), (MultiValueMap)headers);
        ApiResponse res = new ApiResponse();
        try {
            res = (ApiResponse)this.restTemplate.postForObject(url, (Object)entity, ApiResponse.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u670d\u52a1\u5931\u8d25" + e.getMessage());
            e.printStackTrace();
            Assert.isTrue((boolean)false, (String)"\u8c03\u7528\u670d\u52a1\u5931\u8d25");
        }
        return res;
    }
}

