/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.util;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.xinqiyi.ps.service.util.IntersectionOrUnionConstant;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ParameterColumnHandler {
    public static void convertParameter(Object object, List<String> columnList, String suffix) {
        if (ObjectUtil.isNull((Object)object)) {
            return;
        }
        Class<?> clazz = object.getClass();
        List<Field> fieldList = Arrays.asList(clazz.getDeclaredFields());
        columnList.forEach(column -> fieldList.forEach(field -> {
            String fieldName = field.getName();
            if (StringUtils.equals((CharSequence)fieldName, (CharSequence)column)) {
                try {
                    String getterMethodName = ParameterColumnHandler.getGetterMethodName(fieldName);
                    Method getMethod = clazz.getMethod(getterMethodName, new Class[0]);
                    Object invoke = getMethod.invoke(object, new Object[0]);
                    String getMethodValue = "";
                    if (ObjectUtil.isNotNull((Object)invoke)) {
                        getMethodValue = getMethod.invoke(object, new Object[0]).toString();
                    }
                    if (StringUtils.isNotBlank((CharSequence)getMethodValue)) {
                        String[] split;
                        String setterMethodName = ParameterColumnHandler.getSetterMethodName(fieldName);
                        Method setMethod = clazz.getMethod(setterMethodName + suffix, Integer.class);
                        if (getMethodValue.contains("\n")) {
                            split = getMethodValue.split("\n");
                            setMethod.invoke(object, IntersectionOrUnionConstant.UNION);
                        } else {
                            split = getMethodValue.split(" ");
                            setMethod.invoke(object, IntersectionOrUnionConstant.INTERSECTION);
                        }
                        Method method = clazz.getMethod(setterMethodName, String.class);
                        method.invoke(object, new Object[]{null});
                        ArrayList<String> paramsList = new ArrayList<String>(Arrays.asList(split));
                        List<String> params = paramsList.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
                        params.forEach(CharSequenceUtil::cleanBlank);
                        Method setListMethod = clazz.getMethod(setterMethodName + "List", List.class);
                        setListMethod.invoke(object, params);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
    }

    private static String getGetterMethodName(String fieldName) {
        return "get" + ParameterColumnHandler.firstWordCapital(fieldName);
    }

    private static String getSetterMethodName(String fieldName) {
        return "set" + ParameterColumnHandler.firstWordCapital(fieldName);
    }

    private static String firstWordCapital(String word) {
        String first = word.substring(0, 1);
        String tail = word.substring(1);
        return first.toUpperCase() + tail;
    }
}

