/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.util;

import cn.hutool.core.collection.CollUtil;
import com.xinqiyi.framework.redis.RedisHelper;
import com.xinqiyi.mdm.common.PsRedisKeyConstants;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisUtils {
    private static final Logger log = LoggerFactory.getLogger(RedisUtils.class);

    public static void cacheValue(String key, String value) {
        try {
            RedisHelper.getRedisTemplate().opsForValue().set((Object)key, (Object)value);
        }
        catch (Exception t) {
            log.error("\u7f13\u5b58[{}]\u5931\u8d25, value[{}], \u9519\u8bef\u63cf\u8ff0[{}]", new Object[]{key, value, t.getMessage()});
        }
    }

    public static boolean spuAliasCache(Map<String, String> spuAliasMap, Long psStoreId) {
        if (CollUtil.isEmpty(spuAliasMap) || Objects.isNull(psStoreId)) {
            return false;
        }
        String dictRedisKey = PsRedisKeyConstants.getPrefixPsStoreSpuAlias((Long)psStoreId);
        RedisHelper.getRedisTemplate().opsForHash().putAll((Object)dictRedisKey, spuAliasMap);
        return true;
    }

    public static boolean deleteSpuAliasCache(List<String> spuIds, Long psStoreId) {
        if (CollUtil.isEmpty(spuIds) || Objects.isNull(psStoreId)) {
            return false;
        }
        String dictRedisKey = PsRedisKeyConstants.getPrefixPsStoreSpuAlias((Long)psStoreId);
        for (String spuId : spuIds) {
            RedisHelper.getRedisTemplate().opsForHash().delete((Object)dictRedisKey, new Object[]{spuId});
        }
        return true;
    }

    public static void deleteKey(String key) {
        try {
            RedisHelper.getRedisTemplate().delete((Object)key);
        }
        catch (Exception t) {
            log.error("\u5220\u9664[{}]\u5931\u8d25, \u9519\u8bef\u63cf\u8ff0[{}]", (Object)key, (Object)t.getMessage());
        }
    }

    public static void deleteHashKey(String key, String key2) {
        try {
            RedisHelper.getRedisTemplate().boundHashOps((Object)key).delete(new Object[]{key2});
        }
        catch (Exception t) {
            log.error("\u5220\u9664[{}]\u5931\u8d25, \u9519\u8bef\u63cf\u8ff0[{}]", (Object)key, (Object)t.getMessage());
        }
    }
}

