/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.util;

import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    public static final String allChar = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String letterChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String numberChar = "0123456789";
    public static final String mailPattern = "^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$";
    public static final Pattern subAccountPattern = Pattern.compile("^[a-zA-Z][0-9a-zA-Z]{7,15}$");
    public static final Pattern subPasswordPattern = Pattern.compile("^[0-9a-zA-Z]{6,16}$");
    public static final int DEFAULT_LENGTH = 5;
    public static final Pattern PasswordPattern = Pattern.compile("^(?![0-9]+$)(?![a-zA-Z]+$)(?!([^(0-9a-zA-Z)]|[\\(\\)])+$)([^(0-9a-zA-Z)]|[\\(\\)]|[a-zA-Z]|[0-9]){6,30}$");
    public static final String MOB_PHONE_BLUR_REGEX = "(\\d{3})\\d{4}(\\d{4})";
    public static final String TEL_PHONE_BLUR_REGEX1 = "(\\d{3})-\\d{4}(\\d{4})";
    public static final String TEL_PHONE_BLUR_REGEX2 = "(\\d{4})-\\d{4}(\\d{3,4})";
    public static final String PHONE_BLUR_REPLACE_REGEX = "$1****$2";
    public static final String TEL_PHONE_BLUR_REPLACE_REGEX = "$1-****$2";
    public static final String ID_CARD_BLUR_REGEX = "([0-9]{4})[0-9]{11}([0-9Xx]{3})";
    public static final String ENTERPRISE_CREDIT_CODE_BLUR_REGEX = "([0-9A-Z]{4})[0-9A-Z]{11}([0-9A-Z]{3})";
    public static final String PASSPORT_BLUR_REGEX = "(\\d{3})\\d{3}(\\d{2})";
    public static final String BLUR_REPLACE_REGEX = "$1****$2";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static boolean isValidPhoneNumber(String phoneNumber) {
        String regex = "^1[0-9]{10}$";
        return phoneNumber.matches(regex);
    }

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpperCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtil.isBlank(str);
    }

    public static boolean isAllEmpty(String ... strings) {
        if (strings == null) {
            return true;
        }
        for (String str : strings) {
            if (!StringUtil.isNotEmpty(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isHasEmpty(String ... strings) {
        if (strings == null) {
            return true;
        }
        for (String str : strings) {
            if (!StringUtil.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static String isEmpty(String checkValue, String defaultValue) {
        return StringUtil.isEmpty(checkValue) ? defaultValue : checkValue;
    }

    public static boolean isNotEmptyAndEquelsOther(String str, String other) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        return str.equals(other);
    }

    public static boolean isNotEmptyAndNotEquelsOther(String str, String ... other) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        for (int i = 0; i < other.length; ++i) {
            if (!str.equals(other[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEquelsOther(String str, String ... other) {
        for (int i = 0; i < other.length; ++i) {
            if (!other[i].equals(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(String ... strings) {
        if (strings == null) {
            return false;
        }
        for (String str : strings) {
            if (str != null && !"".equals(str.trim())) continue;
            return false;
        }
        return true;
    }

    public static boolean isPassLegal(String str) {
        if (Objects.isNull(str) || str.length() == 0) {
            return Boolean.FALSE;
        }
        return PasswordPattern.matcher(str).matches();
    }

    public static boolean equals(String value, String equals) {
        if (StringUtil.isAllEmpty(value, equals)) {
            return true;
        }
        if (value == null) {
            return false;
        }
        return value.equals(equals);
    }

    public static boolean isNotEquals(String value, String equals) {
        return !StringUtil.equals(value, equals);
    }

    public static String[] split(String content, String separatorChars) {
        return StringUtil.splitWorker(content, separatorChars, -1, false);
    }

    public static String[] split(String str, String separatorChars, int max) {
        return StringUtil.splitWorker(str, separatorChars, max, false);
    }

    private static String[] splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i < len) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < len) {
                if (str.charAt(i) == sep) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(EMPTY_STRING_ARRAY);
    }

    public static String escapeXML(String str) {
        if (str == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block8: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '$': 
                case '\u00ff': {
                    continue block8;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block8;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block8;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block8;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block8;
                }
                default: {
                    if (c >= '\u0000' && c <= '\u001f' || c >= '\ue000' && c <= '\uf8ff' || c >= '\ufff0' && c <= '\uffff') continue block8;
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String replace(String s, Map<String, Object> map) {
        int end;
        int start;
        StringBuilder ret = new StringBuilder((int)((double)s.length() * 1.5));
        int cursor = 0;
        while ((start = s.indexOf("${", cursor)) != -1 && (end = s.indexOf("}", start)) != -1) {
            ret.append(s.substring(cursor, start)).append(map.get(s.substring(start + 2, end)));
            cursor = end + 1;
        }
        ret.append(s.substring(cursor, s.length()));
        return ret.toString();
    }

    public static String replace(String s, Object ... objs) {
        int start;
        if (objs == null || objs.length == 0) {
            return s;
        }
        if (s.indexOf("{}") == -1) {
            return s;
        }
        StringBuilder ret = new StringBuilder((int)((double)s.length() * 1.5));
        int cursor = 0;
        int index = 0;
        while ((start = s.indexOf("{}", cursor)) != -1) {
            ret.append(s.substring(cursor, start));
            if (index < objs.length) {
                ret.append(objs[index]);
            } else {
                ret.append("{}");
            }
            cursor = start + 2;
            ++index;
        }
        ret.append(s.substring(cursor, s.length()));
        return ret.toString();
    }

    public static String replaceArgs(String source, Object ... params) {
        if (params == null || params.length == 0 || source == null || source.isEmpty()) {
            return source;
        }
        StringBuilder buff = new StringBuilder(source);
        StringBuilder temp = new StringBuilder();
        int startIndex = 0;
        int endIndex = 0;
        String param = null;
        for (int count = 0; count < params.length; ++count) {
            param = params[count] == null ? null : params[count].toString();
            temp.delete(0, temp.length());
            temp.append("{");
            temp.append(count);
            temp.append("}");
            while ((startIndex = buff.indexOf(temp.toString(), endIndex)) != -1) {
                endIndex = startIndex + temp.length();
                buff.replace(startIndex, endIndex, param == null ? "" : param);
            }
            startIndex = 0;
            endIndex = 0;
        }
        return buff.toString();
    }

    public static String substringBefore(String s, String separator) {
        if (StringUtil.isEmpty(s) || separator == null) {
            return s;
        }
        if (separator.isEmpty()) {
            return "";
        }
        int pos = s.indexOf(separator);
        if (pos < 0) {
            return s;
        }
        return s.substring(0, pos);
    }

    public static String substringBetween(String str, String open, String close) {
        int end;
        if (str == null || open == null || close == null) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            return str.substring(start + open.length(), end);
        }
        return null;
    }

    public static String substringAfter(String str, String separator) {
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String toString(byte[] bytes) {
        try {
            return new String(bytes, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static byte[] getBytes(String str) {
        if (str != null) {
            try {
                return str.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return null;
    }

    public static String generateStr(int len) {
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < len; ++i) {
            sb.append(allChar.charAt(random.nextInt(allChar.length())));
        }
        return sb.toString();
    }

    public static String generateMixStr(int length) {
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append(letterChar.charAt(random.nextInt(letterChar.length())));
        }
        return sb.toString();
    }

    public static String generateLowerStr(int length) {
        return StringUtil.generateMixStr(length).toLowerCase();
    }

    public static String generateUpperStr(int length) {
        return StringUtil.generateMixStr(length).toUpperCase();
    }

    public static String generateZeroStr(int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            sb.append('0');
        }
        return sb.toString();
    }

    public static String toFixedLengthStr(long num, int fixdlenth) {
        StringBuffer sb = new StringBuffer();
        String strNum = String.valueOf(num);
        if (fixdlenth - strNum.length() < 0) {
            throw new RuntimeException("\u5c06\u6570\u5b57" + num + "\u8f6c\u5316\u4e3a\u957f\u5ea6\u4e3a" + fixdlenth + "\u7684\u5b57\u7b26\u4e32\u53d1\u751f\u5f02\u5e38\uff01");
        }
        sb.append(StringUtil.generateZeroStr(fixdlenth - strNum.length()));
        sb.append(strNum);
        return sb.toString();
    }

    public static boolean contains(String sourceStr, String separator) {
        if (StringUtil.isBlank(sourceStr)) {
            return false;
        }
        return sourceStr.trim().contains(separator);
    }

    public static String getStringRandom(int length) {
        Object val = "";
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            String charOrNum;
            String string = charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                int temp = random.nextInt(2) % 2 == 0 ? 65 : 97;
                val = (String)val + (char)(random.nextInt(26) + temp);
                continue;
            }
            if (!"num".equalsIgnoreCase(charOrNum)) continue;
            val = (String)val + String.valueOf(random.nextInt(10));
        }
        return "tmz_" + (String)val;
    }

    public static boolean isNetUrl(String url) {
        boolean reault = false;
        if (url != null && (url.toLowerCase().startsWith("http") || url.toLowerCase().startsWith("rtsp") || url.toLowerCase().startsWith("mms"))) {
            reault = true;
        }
        return reault;
    }

    public static String generateUserName(String phone) {
        String str = UUID.randomUUID().toString().replace("-", "").substring(0, 8);
        return phone + "_" + str;
    }

    public static String generateOrderNo(String type) {
        String temp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        Random random = new Random();
        String num = StringUtil.generateRandomNum(5);
        return type + temp + num;
    }

    public static String generateTGOrderNo(String type, long sequence) {
        StringBuilder sb = new StringBuilder();
        String timeStr = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        sb.append(type).append(timeStr).append(StringUtil.getSequence(sequence));
        return sb.toString();
    }

    public static String generateDateTimeNo() {
        String temp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        String num = StringUtil.generateRandomNum(5);
        return temp + num;
    }

    public static String generateRandomNum(int count) {
        Random random = new Random();
        StringBuffer flag = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            flag.append(numberChar.charAt(random.nextInt(9)));
        }
        return flag.toString();
    }

    public static String getMethodAnnotationOne(Method method, String validationParamValue) {
        String retParam = null;
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (int j = 0; j < parameterAnnotations[i].length; ++j) {
                String str = parameterAnnotations[i][j].toString();
                if (str.indexOf(validationParamValue) <= 0) continue;
                retParam = str.substring(str.indexOf("=") + 1, str.indexOf(")"));
            }
        }
        return retParam;
    }

    public static Boolean isMail(String email) {
        if (StringUtil.isBlank(email)) {
            return Boolean.FALSE;
        }
        return Pattern.matches(mailPattern, email);
    }

    public static String removeAllBlank(String s) {
        String result = "";
        if (null != s && !"".equals(s)) {
            result = s.replaceAll("[\u3000*| *| *|//s*]*", "");
        }
        return result;
    }

    public static String trim(String s) {
        String result = "";
        if (null != s && !"".equals(s)) {
            result = s.replaceAll("^[\u3000*| *| *|//s*]*", "").replaceAll("[\u3000*| *| *|//s*]*$", "");
        }
        return result;
    }

    public static String renderString(String content, Map<String, String> map) {
        Set<Map.Entry<String, String>> sets = map.entrySet();
        for (Map.Entry<String, String> entry : sets) {
            String regex = "\\$\\{" + entry.getKey() + "\\}";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(content);
            content = matcher.replaceAll(entry.getValue());
        }
        return content;
    }

    public static String replace(String str, String content, int startIndex, int endIndex) {
        return str.substring(0, startIndex) + content + str.substring(endIndex);
    }

    public static boolean isPassEnligsh(String str) {
        if (Objects.isNull(str) || str.length() == 0) {
            return Boolean.FALSE;
        }
        return subPasswordPattern.matcher(str).matches();
    }

    public static boolean isAccountEnligsh(String str) {
        if (Objects.isNull(str) || str.length() == 0) {
            return Boolean.FALSE;
        }
        return subAccountPattern.matcher(str).matches();
    }

    public static String getSequence(long seq) {
        String str = String.valueOf(seq);
        int len = str.length();
        if (len >= 5) {
            return str;
        }
        return String.format("%05d", seq);
    }

    public static final String phoneEncrypt(String phone) {
        if (StringUtil.isEmpty(phone)) {
            return phone;
        }
        if (phone.matches(TEL_PHONE_BLUR_REGEX1)) {
            return phone.replaceAll(TEL_PHONE_BLUR_REGEX1, TEL_PHONE_BLUR_REPLACE_REGEX);
        }
        if (phone.matches(TEL_PHONE_BLUR_REGEX2)) {
            return phone.replaceAll(TEL_PHONE_BLUR_REGEX2, TEL_PHONE_BLUR_REPLACE_REGEX);
        }
        return phone.replaceAll(MOB_PHONE_BLUR_REGEX, "$1****$2");
    }

    public static final String identityNoEncrypt(String identityNo) {
        if (StringUtil.isEmpty(identityNo)) {
            return identityNo;
        }
        return identityNo.replaceAll("(?<=\\w{6})\\w(?=\\w{4})", "*");
    }

    public static final String leftThreeRightTwoEncrypt(String no) {
        if (StringUtil.isEmpty(no)) {
            return no;
        }
        return no.replaceAll("(?<=\\w{3})\\w(?=\\w{2})", "*");
    }

    public static final String emailEncrypt(String email) {
        if (StringUtil.isEmpty(email)) {
            return email;
        }
        int index = StringUtils.indexOf((CharSequence)email, (CharSequence)"@");
        if (index <= 1) {
            return email;
        }
        return StringUtils.rightPad((String)StringUtils.left((String)email, (int)0), (int)6, (String)"*").concat(StringUtils.mid((String)email, (int)index, (int)StringUtils.length((CharSequence)email)));
    }

    public static final String enterpriseCreditCodeEncrypt(String enterpriseCreditCode) {
        if (StringUtil.isEmpty(enterpriseCreditCode)) {
            return enterpriseCreditCode;
        }
        return enterpriseCreditCode.replaceAll(ENTERPRISE_CREDIT_CODE_BLUR_REGEX, "$1****$2");
    }

    public static final String idCardEncrypt(String phone) {
        if (StringUtil.isEmpty(phone)) {
            return phone;
        }
        return phone.replaceAll(ID_CARD_BLUR_REGEX, "$1****$2");
    }

    public static final String passportEncrypt(String phone) {
        if (StringUtil.isEmpty(phone)) {
            return phone;
        }
        return phone.replaceAll(PASSPORT_BLUR_REGEX, "$1****$2");
    }

    public static BigDecimal newbigDecimal(BigDecimal param) {
        if (null != param) {
            param = new BigDecimal(String.format("%.2f", param));
        }
        return param;
    }

    public static String bigDecimalStr(BigDecimal param) {
        if (null != param) {
            param = new BigDecimal(String.format("%.2f", param));
            return param.toString();
        }
        return "";
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static String changeFieldToColumnName(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        StringBuffer columnName = new StringBuffer();
        int length = fieldName.length();
        for (int i = 0; i < length; ++i) {
            char c = fieldName.charAt(i);
            if ('A' <= c && 'Z' >= c) {
                columnName.append("_").append((char)(c + 32));
                continue;
            }
            columnName.append(fieldName.charAt(i));
        }
        return columnName.toString();
    }

    public static String toSBC(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    public static String toDBC(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] <= ' ' || c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String symbolToSBC(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (!(c[i] > '\uff00' && c[i] <= '\uff0f' || c[i] >= '\uff1a' && c[i] <= '\uff20' || c[i] >= '\uff3b' && c[i] <= '\uff40') && (c[i] < '\uff5b' || c[i] > '\uff5e')) continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    public static String symbolToDBC(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (!(c[i] > ' ' && c[i] <= '/' || c[i] >= ':' && c[i] <= '@' || c[i] >= '[' && c[i] <= '`') && (c[i] < '{' || c[i] > '~')) continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String processPayerName(String payerName) {
        if (StringUtils.isNotBlank((CharSequence)payerName)) {
            boolean hasChinese = ReUtil.contains((String)"[\u2e80-\u2eff\u2f00-\u2fdf\u31c0-\u31ef\u3400-\u4dbf\u4e00-\u9fff\uf900-\ufaff\ud840\udc00-\ud869\udedf\ud869\udf00-\ud86d\udf3f\ud86d\udf40-\ud86e\udc1f\ud86e\udc20-\ud873\udeaf\ud87e\udc00-\ud87e\ude1f]+", (CharSequence)payerName);
            boolean hasEnglish = ReUtil.contains((String)"[a-zA-Z]+", (CharSequence)payerName);
            if (hasChinese && !hasEnglish) {
                payerName = StringUtil.symbolToDBC(payerName);
            } else if (!hasChinese && hasEnglish) {
                payerName = StringUtil.symbolToSBC(payerName);
            }
        }
        return payerName;
    }

    public static String trimAllSpace(String str) {
        return StringUtils.isEmpty((CharSequence)str) ? null : str.replaceAll("^[\\s\u3000]*|[\\s\u3000]*$", "");
    }

    public static String desensitized(String str, int prefix, int suffix, String maskStr) {
        if (StrUtil.isEmpty((CharSequence)str)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            if (i < prefix) {
                sb.append(str.charAt(i));
                continue;
            }
            if (i > n - suffix - 1) {
                sb.append(str.charAt(i));
                continue;
            }
            sb.append(maskStr);
        }
        return sb.toString();
    }

    public static List<String> extractImageUrls(String html) {
        ArrayList<String> imageUrls = new ArrayList<String>();
        if (StringUtil.isEmpty(html)) {
            return imageUrls;
        }
        String pattern = "<img[^>]+src\\s*=\\s*\"([^\"]+)\"";
        Pattern imgPattern = Pattern.compile(pattern);
        Matcher matcher = imgPattern.matcher(html);
        while (matcher.find()) {
            try {
                String imageUrl = URLDecoder.decode(matcher.group(1), "UTF-8");
                imageUrls.add(imageUrl);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return imageUrls;
    }
}

