/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.sg.basic.api.model.vo.SgStorageBatchUpdateVo;
import com.xinqiyi.sg.basic.model.common.SgConstantsIF;
import com.xinqiyi.sg.basic.model.dto.SgStorageSingleUpdateDto;
import com.xinqiyi.sg.basic.model.dto.SgStorageUpdateBillDto;
import com.xinqiyi.sg.basic.model.dto.SgStorageUpdateBillItemDto;
import com.xinqiyi.sg.basic.model.dto.SgStorageUpdateControlDto;
import com.xinqiyi.sg.basic.model.entity.SgStore;
import com.xinqiyi.sg.basic.service.business.SgStorageRedisBillUpdateBiz;
import com.xinqiyi.sg.basic.service.config.SgResultMqConfig;
import com.xinqiyi.sg.store.model.dto.receive.SgReceiveBillSaveDto;
import com.xinqiyi.sg.store.model.entity.SgBReceive;
import com.xinqiyi.sg.store.model.entity.SgBReceiveEffectiveItem;
import com.xinqiyi.sg.store.model.entity.SgBReceiveItem;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SgStoreStorageBiz {
    private static final Logger log = LoggerFactory.getLogger(SgStoreStorageBiz.class);
    @Value(value="${sg.control.is_negative_receive:false}")
    private Boolean isNegativeInStorage;
    @Resource
    SgStorageRedisBillUpdateBiz sgStorageRedisBillUpdateBiz;
    @Resource
    SgResultMqConfig sgResultMqConfig;

    public ApiResponse<SgStorageBatchUpdateVo> updateReceiveStoragePrein(SgBReceive receive, SgReceiveBillSaveDto request, Map<String, SgBReceiveItem> map, Map<Long, SgStore> negativeStock, Map<String, SgBReceiveEffectiveItem> effectivemap) {
        ApiResponse storageResult;
        try {
            SgStorageUpdateBillDto billRequest = this.buildReceiveStorageBill(receive);
            billRequest.setItemList(this.builUpdatedReceiveStorageItems(request, map, negativeStock));
            if (request.getIsOpenEffective().booleanValue()) {
                billRequest.setEffectiveItemList(this.builUpdatedReceiveStorageEffectiveItems(request, effectivemap, negativeStock));
            }
            SgStorageUpdateControlDto controlModel = new SgStorageUpdateControlDto();
            controlModel.setPreoutOperateType(2);
            SgStorageSingleUpdateDto updateRequest = new SgStorageSingleUpdateDto();
            updateRequest.setBill(billRequest);
            updateRequest.setMessageKey(this.sgResultMqConfig.MSG_TAG_RECEIVE + ":" + receive.getBillNo());
            updateRequest.setControlModel(controlModel);
            if (log.isInfoEnabled()) {
                log.info("\u6765\u6e90\u5355\u636eid[" + receive.getSourceBillId() + "],\u5f00\u59cb\u5360\u7528\u5e93\u5b58\u5728\u9014\u5165\u53c2:" + JSONObject.toJSONString((Object)updateRequest));
            }
            updateRequest.setIsOpenEffective(request.getIsOpenEffective());
            storageResult = this.sgStorageRedisBillUpdateBiz.updateStorageBill(updateRequest);
            if (log.isInfoEnabled()) {
                log.info("\u6765\u6e90\u5355\u636eid[" + receive.getSourceBillId() + "],\u5360\u7528\u5e93\u5b58\u5728\u9014\u51fa\u53c2:" + JSON.toJSONString((Object)storageResult));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("\u540c\u6b65\u5e93\u5b58\u5360\u7528\u63a5\u53e3\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
        }
        return storageResult;
    }

    private List<SgStorageUpdateBillItemDto> builUpdatedReceiveStorageItems(SgReceiveBillSaveDto request, Map<String, SgBReceiveItem> map, Map<Long, SgStore> negativeStock) {
        ArrayList<SgStorageUpdateBillItemDto> itemList = new ArrayList<SgStorageUpdateBillItemDto>();
        if (SgConstantsIF.ITEM_UPDATE_TYPE_ALL.equals(request.getUpdateMethod())) {
            request.getItemList().forEach(itemSaveRequest -> {
                SgBReceiveItem receiveItem;
                if (itemSaveRequest.getIsReceiveStorage().booleanValue() && (receiveItem = (SgBReceiveItem)map.get(itemSaveRequest.getPsCSkuId() + "_" + itemSaveRequest.getCpCStoreId() + "_" + itemSaveRequest.getSourceBillItemId())) != null && 0 != BigDecimal.ZERO.compareTo(receiveItem.getQtyPrein()) && 0 != BigDecimal.ZERO.compareTo(itemSaveRequest.getQtyPrein())) {
                    SgStorageUpdateBillItemDto item = new SgStorageUpdateBillItemDto();
                    BeanUtils.copyProperties((Object)receiveItem, (Object)item);
                    item.setBillItemId(receiveItem.getId());
                    item.setQtyPreinChange(receiveItem.getQtyPrein().negate());
                    this.setIsNegative(item, negativeStock, request.getIsNegativePrein(), null);
                    itemList.add(item);
                }
            });
        }
        request.getItemList().forEach(itemSaveRequest -> {
            if (itemSaveRequest.getIsReceiveStorage().booleanValue() && 0 != BigDecimal.ZERO.compareTo(itemSaveRequest.getQtyPrein())) {
                SgStorageUpdateBillItemDto item = new SgStorageUpdateBillItemDto();
                BeanUtils.copyProperties((Object)itemSaveRequest, (Object)item);
                item.setBillItemId(itemSaveRequest.getId());
                item.setQtyPreinChange(itemSaveRequest.getQtyPrein());
                this.setIsNegative(item, negativeStock, request.getIsNegativePrein(), null);
                itemList.add(item);
            }
        });
        return itemList;
    }

    public void setIsNegative(SgStorageUpdateBillItemDto item, Map<Long, SgStore> negativeStock, Boolean isNegativePrein, Integer preoutWarningType) {
        SgStorageUpdateControlDto controlRequest = new SgStorageUpdateControlDto();
        SgStore store = negativeStock == null ? null : negativeStock.get(item.getCpCStoreId());
        boolean isnegative = false;
        if (isNegativePrein != null && isNegativePrein.booleanValue()) {
            isnegative = true;
        } else if (store != null && store.getIsNegative().equals(0)) {
            isnegative = true;
        } else if (this.isNegativeInStorage.booleanValue()) {
            isnegative = true;
        }
        controlRequest.setNegativePrein(isnegative);
        controlRequest.setPreoutOperateType(preoutWarningType == null ? 2 : preoutWarningType);
        item.setControlmodel(controlRequest);
    }

    public ApiResponse<SgStorageBatchUpdateVo> submitReceiveStoragePrein(SgBReceive receive, List<SgBReceiveItem> bReceiveItems, Map<Long, SgStore> negativeStock, Boolean isNegativePrein, Long noticesId, String noticesBillno, List<SgBReceiveEffectiveItem> storageEffectiveItemList, Boolean isOpenEffective) {
        ApiResponse storageResult;
        try {
            SgStorageUpdateBillDto billRequest = this.buildReceiveStorageBill(receive);
            billRequest.setPhyInNoticesId(noticesId);
            billRequest.setPhyOutNoticesNo(noticesBillno);
            billRequest.setItemList(this.buildSubmitReceiveStoragePrein(bReceiveItems, negativeStock, isNegativePrein));
            if (isOpenEffective.booleanValue()) {
                billRequest.setEffectiveItemList(this.buildSubmitReceiveStorageEffectivePrein(storageEffectiveItemList, negativeStock, isNegativePrein));
            }
            SgStorageUpdateControlDto controlModel = new SgStorageUpdateControlDto();
            controlModel.setPreoutOperateType(2);
            SgStorageSingleUpdateDto updateRequest = new SgStorageSingleUpdateDto();
            updateRequest.setBill(billRequest);
            updateRequest.setMessageKey(this.sgResultMqConfig.MSG_TAG_RECEIVE + ":" + receive.getBillNo());
            updateRequest.setControlModel(controlModel);
            if (log.isInfoEnabled()) {
                log.info("\u6765\u6e90\u5355\u636eid[" + receive.getSourceBillId() + "],\u5f00\u59cb\u5360\u7528\u5e93\u5b58\u5728\u9014\u5165\u53c2:" + JSONObject.toJSONString((Object)updateRequest));
            }
            updateRequest.setIsOpenEffective(isOpenEffective);
            storageResult = this.sgStorageRedisBillUpdateBiz.updateStorageBill(updateRequest);
            if (log.isInfoEnabled()) {
                log.info("\u6765\u6e90\u5355\u636eid[" + receive.getSourceBillId() + "],\u5360\u7528\u5e93\u5b58\u5728\u9014\u51fa\u53c2:" + JSONObject.toJSONString((Object)storageResult));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("\u540c\u6b65\u5e93\u5b58\u5360\u7528\u63a5\u53e3\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
        }
        return storageResult;
    }

    public SgStorageUpdateBillDto buildReceiveStorageBill(SgBReceive receive) {
        SgStorageUpdateBillDto billRequest = new SgStorageUpdateBillDto();
        billRequest.setBillId(receive.getId());
        billRequest.setBillNo(receive.getBillNo());
        billRequest.setBillDate(receive.getBillDate());
        billRequest.setBillType(receive.getSourceBillType());
        billRequest.setChangeDate((Date)new Timestamp(System.currentTimeMillis()));
        billRequest.setCpCshopId(receive.getCpCShopId());
        billRequest.setServiceNode(receive.getServiceNode());
        billRequest.setSourceBillId(receive.getSourceBillId());
        billRequest.setSourceBillNo(receive.getSourceBillNo());
        billRequest.setSapNo(receive.getExternalSystemNo());
        return billRequest;
    }

    private List<SgStorageUpdateBillItemDto> buildSubmitReceiveStoragePrein(List<SgBReceiveItem> stoInItems, Map<Long, SgStore> negativeStock, Boolean isNegativePrein) {
        ArrayList<SgStorageUpdateBillItemDto> itemList = new ArrayList<SgStorageUpdateBillItemDto>();
        for (SgBReceiveItem item : stoInItems) {
            BigDecimal preinQtyChange = item.getQtyPrein().negate();
            BigDecimal storageQtyChange = item.getQtyReceive();
            SgStorageUpdateBillItemDto storage = new SgStorageUpdateBillItemDto();
            BeanUtils.copyProperties((Object)item, (Object)storage);
            storage.setBillItemId(item.getId());
            storage.setQtyPreinChange(preinQtyChange);
            storage.setQtyStorageChange(storageQtyChange);
            storage.setPsPackageUnitQty(Integer.valueOf(1));
            this.setIsNegative(storage, negativeStock, isNegativePrein, null);
            itemList.add(storage);
        }
        return itemList;
    }

    private List<SgStorageUpdateBillItemDto> buildSubmitReceiveStorageEffectivePrein(List<SgBReceiveEffectiveItem> stoInItems, Map<Long, SgStore> negativeStock, Boolean isNegativePrein) {
        ArrayList<SgStorageUpdateBillItemDto> itemList = new ArrayList<SgStorageUpdateBillItemDto>();
        for (SgBReceiveEffectiveItem item : stoInItems) {
            BigDecimal preinQtyChange = item.getQtyPrein().negate();
            BigDecimal storageQtyChange = item.getQtyReceive();
            SgStorageUpdateBillItemDto storage = new SgStorageUpdateBillItemDto();
            BeanUtils.copyProperties((Object)item, (Object)storage);
            storage.setBillItemId(item.getId());
            storage.setQtyPreinChange(preinQtyChange);
            storage.setQtyStorageChange(storageQtyChange);
            storage.setPsPackageUnitQty(Integer.valueOf(1));
            this.setIsNegative(storage, negativeStock, isNegativePrein, null);
            itemList.add(storage);
        }
        return itemList;
    }

    public ApiResponse<SgStorageBatchUpdateVo> cleanOrVoidReceiveStoragePrein(SgBReceive receive, List<SgBReceiveItem> bReceiveItems, Map<Long, SgStore> negativeStock, Boolean isNegativePrein) {
        ApiResponse storageResult;
        try {
            SgStorageUpdateBillDto billRequest = this.buildReceiveStorageBill(receive);
            billRequest.setItemList(this.buildCleanReceiveStoragePrein(bReceiveItems, negativeStock, isNegativePrein));
            SgStorageUpdateControlDto controlModel = new SgStorageUpdateControlDto();
            controlModel.setPreoutOperateType(2);
            SgStorageSingleUpdateDto updateRequest = new SgStorageSingleUpdateDto();
            updateRequest.setBill(billRequest);
            updateRequest.setMessageKey(this.sgResultMqConfig.MSG_TAG_RECEIVE + ":" + receive.getBillNo());
            updateRequest.setControlModel(controlModel);
            if (log.isInfoEnabled()) {
                log.info("\u6765\u6e90\u5355\u636eid[" + receive.getSourceBillId() + "],\u5f00\u59cb\u5360\u7528\u5e93\u5b58\u5728\u9014\u5165\u53c2:" + JSONObject.toJSONString((Object)updateRequest));
            }
            storageResult = this.sgStorageRedisBillUpdateBiz.updateStorageBill(updateRequest);
            if (log.isInfoEnabled()) {
                log.info("\u6765\u6e90\u5355\u636eid[" + receive.getSourceBillId() + "],\u5360\u7528\u5e93\u5b58\u5728\u9014\u51fa\u53c2:" + storageResult);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("\u540c\u6b65\u5e93\u5b58\u5360\u7528\u63a5\u53e3\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
        }
        return storageResult;
    }

    private List<SgStorageUpdateBillItemDto> buildCleanReceiveStoragePrein(List<SgBReceiveItem> stoInItems, Map<Long, SgStore> negativeStock, Boolean isNegativePrein) {
        ArrayList<SgStorageUpdateBillItemDto> itemList = new ArrayList<SgStorageUpdateBillItemDto>();
        for (SgBReceiveItem item : stoInItems) {
            BigDecimal preinQtyChange = item.getQtyPrein().negate();
            SgStorageUpdateBillItemDto storage = new SgStorageUpdateBillItemDto();
            BeanUtils.copyProperties((Object)item, (Object)storage);
            storage.setBillItemId(item.getId());
            storage.setQtyPreinChange(preinQtyChange);
            this.setIsNegative(storage, negativeStock, isNegativePrein, null);
            itemList.add(storage);
        }
        return itemList;
    }

    public ApiResponse<SgStorageBatchUpdateVo> changeSkuReceiveStoragePrein(SgBReceive receive, List<SgBReceiveItem> oldItemList, List<SgBReceiveItem> newItemList, Map<Long, SgStore> negativeStock, Boolean isNegativePrein) {
        ApiResponse storageResult;
        try {
            SgStorageUpdateBillDto billRequest = this.buildReceiveStorageBill(receive);
            billRequest.setItemList(this.changeSkuReceiveStoragePreinItem(oldItemList, newItemList, negativeStock, isNegativePrein));
            SgStorageUpdateControlDto controlModel = new SgStorageUpdateControlDto();
            controlModel.setPreoutOperateType(2);
            SgStorageSingleUpdateDto updateRequest = new SgStorageSingleUpdateDto();
            updateRequest.setBill(billRequest);
            updateRequest.setMessageKey(this.sgResultMqConfig.MSG_TAG_RECEIVE + ":" + receive.getBillNo());
            updateRequest.setControlModel(controlModel);
            if (log.isInfoEnabled()) {
                log.info("\u6765\u6e90\u5355\u636eid[" + receive.getSourceBillId() + "],\u5f00\u59cb\u5360\u7528\u5e93\u5b58\u5728\u9014\u5165\u53c2:" + JSONObject.toJSONString((Object)updateRequest));
            }
            storageResult = this.sgStorageRedisBillUpdateBiz.updateStorageBill(updateRequest);
            if (log.isInfoEnabled()) {
                log.info("\u6765\u6e90\u5355\u636eid[" + receive.getSourceBillId() + "],\u5360\u7528\u5e93\u5b58\u5728\u9014\u51fa\u53c2:" + storageResult);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("\u540c\u6b65\u5e93\u5b58\u5360\u7528\u63a5\u53e3\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
        }
        return storageResult;
    }

    private List<SgStorageUpdateBillItemDto> changeSkuReceiveStoragePreinItem(List<SgBReceiveItem> oldItemList, List<SgBReceiveItem> newItemList, Map<Long, SgStore> negativeStock, Boolean isNegativePrein) {
        SgStorageUpdateBillItemDto storage;
        ArrayList<SgStorageUpdateBillItemDto> itemList = new ArrayList<SgStorageUpdateBillItemDto>();
        for (SgBReceiveItem item : oldItemList) {
            storage = new SgStorageUpdateBillItemDto();
            BeanUtils.copyProperties((Object)item, (Object)storage);
            storage.setBillItemId(item.getId());
            storage.setQtyPreinChange(item.getQtyPrein().negate());
            this.setIsNegative(storage, negativeStock, isNegativePrein, null);
            itemList.add(storage);
        }
        for (SgBReceiveItem item : newItemList) {
            storage = new SgStorageUpdateBillItemDto();
            BeanUtils.copyProperties((Object)item, (Object)storage);
            storage.setBillItemId(item.getId());
            storage.setQtyPreinChange(item.getQtyPrein());
            this.setIsNegative(storage, negativeStock, isNegativePrein, null);
            itemList.add(storage);
        }
        return itemList;
    }

    private List<SgStorageUpdateBillItemDto> builUpdatedReceiveStorageEffectiveItems(SgReceiveBillSaveDto request, Map<String, SgBReceiveEffectiveItem> map, Map<Long, SgStore> negativeStock) {
        ArrayList<SgStorageUpdateBillItemDto> itemList = new ArrayList<SgStorageUpdateBillItemDto>();
        if (SgConstantsIF.ITEM_UPDATE_TYPE_ALL.equals(request.getUpdateMethod())) {
            request.getItemEffectiveList().forEach(itemSaveRequest -> {
                SgBReceiveEffectiveItem receiveItem;
                if (itemSaveRequest.getIsReceiveStorage().booleanValue() && (receiveItem = (SgBReceiveEffectiveItem)map.get(itemSaveRequest.getPsCSkuId() + "_" + itemSaveRequest.getCpCStoreId() + "_" + itemSaveRequest.getSourceBillItemId() + "_" + itemSaveRequest.getBatchCode())) != null && 0 != BigDecimal.ZERO.compareTo(receiveItem.getQtyPrein()) && 0 != BigDecimal.ZERO.compareTo(itemSaveRequest.getQtyPrein())) {
                    SgStorageUpdateBillItemDto item = new SgStorageUpdateBillItemDto();
                    BeanUtils.copyProperties((Object)receiveItem, (Object)item);
                    item.setBillItemId(receiveItem.getId());
                    item.setQtyPreinChange(receiveItem.getQtyPrein().negate());
                    item.setPsPackageUnitQty(Integer.valueOf(1));
                    this.setIsNegative(item, negativeStock, request.getIsNegativePrein(), null);
                    itemList.add(item);
                }
            });
        }
        request.getItemEffectiveList().forEach(itemSaveRequest -> {
            if (itemSaveRequest.getIsReceiveStorage().booleanValue() && 0 != BigDecimal.ZERO.compareTo(itemSaveRequest.getQtyPrein())) {
                SgStorageUpdateBillItemDto item = new SgStorageUpdateBillItemDto();
                BeanUtils.copyProperties((Object)itemSaveRequest, (Object)item);
                item.setBillItemId(itemSaveRequest.getId());
                item.setQtyPreinChange(itemSaveRequest.getQtyPrein());
                item.setPsPackageUnitQty(Integer.valueOf(1));
                this.setIsNegative(item, negativeStock, request.getIsNegativePrein(), null);
                itemList.add(item);
            }
        });
        return itemList;
    }
}

