/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.adjust;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.google.common.collect.Lists;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.auth.GateWayWebAuthService;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.bizlog.annotation.LogAnnotation;
import com.xinqiyi.framework.bizlog.entity.InnerLog;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.framework.util.BeanConvertUtil;
import com.xinqiyi.sg.basic.api.model.vo.SgStorageBatchUpdateVo;
import com.xinqiyi.sg.basic.model.common.ServiceNodeEnum;
import com.xinqiyi.sg.basic.model.common.SourceBillTypeEnum;
import com.xinqiyi.sg.basic.model.dto.SgStorageSingleUpdateDto;
import com.xinqiyi.sg.basic.model.dto.SgStorageUpdateBillDto;
import com.xinqiyi.sg.basic.model.dto.SgStorageUpdateBillItemDto;
import com.xinqiyi.sg.basic.model.dto.SgStorageUpdateControlDto;
import com.xinqiyi.sg.basic.service.SgOrderNoBiz;
import com.xinqiyi.sg.basic.service.business.SgPhyStorageRedisBillUpdateBiz;
import com.xinqiyi.sg.basic.service.business.SgStorageRedisBillUpdateBiz;
import com.xinqiyi.sg.basic.service.business.SgStorageRollBackBiz;
import com.xinqiyi.sg.basic.service.config.SgResultMqConfig;
import com.xinqiyi.sg.store.model.dto.adjust.SgBAdjustSaveDTO;
import com.xinqiyi.sg.store.model.dto.enums.SgBAdjustBillStatusEnum;
import com.xinqiyi.sg.store.model.entity.SgBAdjust;
import com.xinqiyi.sg.store.model.entity.SgBAdjustItem;
import com.xinqiyi.sg.store.service.SgBAdjustService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SgBAdjustSaveBiz {
    private static final Logger log = LoggerFactory.getLogger(SgBAdjustSaveBiz.class);
    @Autowired
    IdSequenceGenerator idSequenceGenerator;
    @Autowired
    BaseDaoInitialService baseDaoInitialService;
    @Autowired
    SgOrderNoBiz orderNoBiz;
    @Autowired
    SgStorageRollBackBiz sgStorageRollBackBiz;
    @Autowired
    SgPhyStorageRedisBillUpdateBiz phyStorageRedisBillUpdateBiz;
    @Autowired
    SgBAdjustService adjustService;
    @Autowired
    SgStorageRedisBillUpdateBiz storageRedisBillUpdateBiz;
    @Autowired
    GateWayWebAuthService gateWayWebAuthService;
    @Autowired
    SgResultMqConfig sgResultMqConfig;

    @LogAnnotation
    public ApiResponse<SgStorageBatchUpdateVo> saveAdjust(SgBAdjustSaveDTO adjustSaveDTO) {
        this.checkParams(adjustSaveDTO);
        try {
            SgBAdjust adjust = new SgBAdjust();
            LoginUserInfo currentUser = this.gateWayWebAuthService.getCurrentLoginUserInfo();
            BeanConvertUtil.copyProperties((Object)adjustSaveDTO, (Object)adjust);
            Long id = this.idSequenceGenerator.generateId(SgBAdjust.class);
            adjust.setId(id);
            adjust.setBillNo(this.orderNoBiz.getAdjustOrderNo());
            adjust.setBillStatus(SgBAdjustBillStatusEnum.CHECKED.getCode());
            adjust.setCheckerEname(currentUser.getName());
            adjust.setCheckerId(Long.valueOf(currentUser.getUserId()));
            adjust.setCheckerName(currentUser.getFullName());
            adjust.setCheckTime((Date)DateUtil.date());
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)adjust);
            List adjustItems = BeanConvertUtil.convertList((List)adjustSaveDTO.getItemSaveDTOList(), SgBAdjustItem.class);
            adjustItems.forEach(o -> {
                o.setId(this.idSequenceGenerator.generateId(SgBAdjustItem.class));
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)o);
                o.setSgBAdjustId(adjust.getId());
            });
            InnerLog.addLog((Long)id, (String)"\u65b0\u589e\u5e93\u5b58\u8c03\u6574\u5355", (String)"sg_b_adjust", null, (String)"\u65b0\u589e");
            InnerLog.addLog((Long)id, (String)"\u5ba1\u6838\u5e93\u5b58\u8c03\u6574\u5355", (String)"sg_b_adjust", null, (String)"\u5ba1\u6838");
            this.adjustService.saveAdjust(adjust, adjustItems);
            return this.updateSgStorage(adjust, adjustItems);
        }
        catch (Exception e) {
            if (!(e instanceof IllegalArgumentException)) {
                log.error("Adjust.SgBAdjustSaveBiz.saveAdjust Error:", (Throwable)e);
            }
            throw e;
        }
    }

    private void checkParams(SgBAdjustSaveDTO adjustSaveDTO) {
        Assert.notNull((Object)adjustSaveDTO, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isTrue((boolean)ObjectUtil.isNotNull((Object)adjustSaveDTO.getBillDate()), (String)"\u5355\u636e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Integer billType = adjustSaveDTO.getBillType();
        Assert.isTrue((boolean)ObjectUtil.isNotNull((Object)billType), (String)"\u8c03\u6574\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isTrue((boolean)ObjectUtil.isNotNull((Object)adjustSaveDTO.getCpCPhyWarehouseEname()), (String)"\u5b9e\u4f53\u4ed3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isTrue((boolean)ObjectUtil.isNotNull((Object)adjustSaveDTO.getCpCStoreEname()), (String)"\u903b\u8f91\u4ed3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List itemSaveDTOList = adjustSaveDTO.getItemSaveDTOList();
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)itemSaveDTOList), (String)"\u8c03\u6574\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    public ApiResponse<SgStorageBatchUpdateVo> updateSgStorage(SgBAdjust adjust, List<SgBAdjustItem> adjustItems) {
        SgStorageSingleUpdateDto dto = new SgStorageSingleUpdateDto();
        SgStorageUpdateBillDto billRequest = new SgStorageUpdateBillDto();
        billRequest.setBillId(adjust.getId());
        billRequest.setBillNo(adjust.getBillNo());
        billRequest.setSourceBillId(adjust.getSgBPhyAdjustId());
        billRequest.setSourceBillNo(adjust.getSgBPhyAdjustBillNo());
        billRequest.setBillDate(adjust.getBillDate());
        billRequest.setBillType(Integer.valueOf(SourceBillTypeEnum.ADJUST.getCode()));
        billRequest.setChangeDate((Date)new Timestamp(System.currentTimeMillis()));
        billRequest.setServiceNode(ServiceNodeEnum.ADJUST_SUBMIT.getCode());
        ArrayList billItemList = Lists.newArrayList();
        adjustItems.forEach(adjustItem -> {
            SgStorageUpdateBillItemDto item = new SgStorageUpdateBillItemDto();
            BeanUtils.copyProperties((Object)adjustItem, (Object)item);
            item.setBillItemId(adjustItem.getId());
            item.setCpCStoreId(adjust.getCpCStoreId());
            item.setCpCStoreEcode(adjust.getCpCStoreEcode());
            item.setCpCStoreEname(adjust.getCpCStoreEname());
            item.setQtyStorageChange(adjustItem.getQty());
            item.setPriceCost(adjustItem.getPriceCostActual());
            item.setPriceList(adjustItem.getPriceList());
            item.setPsCBrandId(adjustItem.getPsBrandId());
            item.setPsCBrandName(adjustItem.getPsBrandName());
            item.setCpCPhyWarehouseEcode(adjust.getCpCPhyWarehouseEcode());
            item.setCpCPhyWarehouseEname(adjust.getCpCPhyWarehouseEname());
            item.setCpCPhyWarehouseId(adjust.getCpCPhyWarehouseId());
            item.setWmsThirdCode(adjustItem.getWmsThirdCode());
            billItemList.add(item);
        });
        billRequest.setItemList((List)billItemList);
        SgStorageUpdateControlDto controlRequest = new SgStorageUpdateControlDto();
        String messageKey = this.sgResultMqConfig.MSG_TAG_ADJUST + ":" + adjust.getBillNo();
        dto.setControlModel(controlRequest);
        dto.setMessageKey(messageKey);
        dto.setBill(billRequest);
        return this.storageRedisBillUpdateBiz.updateStorageBill(dto);
    }
}

