/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.common;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.util.BeanConvertUtil;
import com.xinqiyi.ps.model.dto.enums.YesOrNoEnum;
import com.xinqiyi.sg.basic.model.common.ServiceNodeEnum;
import com.xinqiyi.sg.basic.model.common.SourceBillTypeEnum;
import com.xinqiyi.sg.basic.model.dto.SgStorageItemUpdateCommonModelDto;
import com.xinqiyi.sg.basic.model.dto.SgStorageLogicUpdateResultDTO;
import com.xinqiyi.sg.basic.model.dto.SgStorageUpdateBillDto;
import com.xinqiyi.sg.basic.model.dto.SgStorageUpdateBillItemDto;
import com.xinqiyi.sg.basic.model.dto.out.SgOutItemSaveDto;
import com.xinqiyi.sg.basic.model.dto.out.SgOutMainDto;
import com.xinqiyi.sg.basic.model.entity.SgPreOccupationOrder;
import com.xinqiyi.sg.basic.model.entity.SgPreOccupationOrderItem;
import com.xinqiyi.sg.basic.model.entity.SgPreOccupationOrderUsedItem;
import com.xinqiyi.sg.basic.service.SgBStorageService;
import com.xinqiyi.sg.basic.service.SgPreOccupationOrderItemService;
import com.xinqiyi.sg.basic.service.SgPreOccupationOrderService;
import com.xinqiyi.sg.basic.service.SgPreOccupationOrderUsedItemService;
import com.xinqiyi.sg.basic.service.business.SgStorageRollBackBiz;
import com.xinqiyi.sg.basic.service.logic.SgStorageLogic;
import com.xinqiyi.sg.store.model.dto.send.SgSendOccupyDto;
import com.xinqiyi.sg.store.model.entity.SgSend;
import com.xinqiyi.sg.store.model.entity.SgSendItem;
import com.xinqiyi.sg.store.service.business.send.restructure.SgSendCommonBiz;
import com.xinqiyi.sg.store.service.business.send.restructure.SgSendOccupyBiz;
import com.xinqiyi.sg.store.service.business.send.restructure.SgStoreOccupyBiz;
import com.xinqiyi.sg.warehouse.model.dto.enums.SgPreOccupationOrderBillStatusEnum;
import com.xinqiyi.sg.warehouse.model.dto.preOccupation.SgPreOccupationInfoDTO;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SgPreOccupationOccupyCommonBiz {
    private static final Logger log = LoggerFactory.getLogger(SgPreOccupationOccupyCommonBiz.class);
    @Autowired
    private SgPreOccupationOrderService sgPreOccupationOrderService;
    @Autowired
    private SgPreOccupationOrderItemService sgPreOccupationOrderItemService;
    @Autowired
    private SgPreOccupationOrderUsedItemService sgPreOccupationOrderUsedItemService;
    @Resource
    private BaseDaoInitialService initialService;
    @Resource
    private SgSendOccupyBiz sgSendOccupyBiz;
    @Resource
    SgStoreOccupyBiz storeOccupyBiz;
    @Autowired
    SgBStorageService storageService;
    @Autowired
    SgStorageRollBackBiz sgStorageRollBackBiz;
    @Resource
    private SgStorageLogic sgStorageLogic;

    public List<SgStorageItemUpdateCommonModelDto> buildStorageItemUpdateModel(SgStorageUpdateBillDto billInfo) {
        ArrayList storageChangeFtpList = com.google.common.collect.Lists.newArrayList();
        for (SgStorageUpdateBillItemDto itemInfo : billInfo.getItemList()) {
            SgStorageItemUpdateCommonModelDto itemUpdateCommonModelVo = new SgStorageItemUpdateCommonModelDto();
            BeanUtils.copyProperties((Object)billInfo, (Object)itemUpdateCommonModelVo);
            BeanUtils.copyProperties((Object)itemInfo, (Object)itemUpdateCommonModelVo);
            itemUpdateCommonModelVo.setIsPreOrderOccupy(Boolean.valueOf(true));
            if (billInfo.getIsCancel().booleanValue()) {
                itemUpdateCommonModelVo.setQtyPreinChange(itemUpdateCommonModelVo.getQtyPreinChange().negate());
                itemUpdateCommonModelVo.setQtyPreoutChange(itemUpdateCommonModelVo.getQtyPreoutChange().negate());
                itemUpdateCommonModelVo.setQtyStorageChange(itemUpdateCommonModelVo.getQtyStorageChange().negate());
            }
            storageChangeFtpList.add(itemUpdateCommonModelVo);
        }
        return storageChangeFtpList;
    }

    public List<SgStorageItemUpdateCommonModelDto> buildStorageItemUpdateModel(List<SgSendItem> mergeSendItemList, SgSend send) {
        ArrayList storageChangeFtpList = Lists.newArrayList();
        for (SgSendItem sendItemDto : mergeSendItemList) {
            SgStorageItemUpdateCommonModelDto modelDto = new SgStorageItemUpdateCommonModelDto();
            BeanConvertUtil.copyProperties((Object)sendItemDto, (Object)modelDto);
            BeanConvertUtil.copyProperties((Object)send, (Object)modelDto);
            modelDto.setBillId(send.getId());
            modelDto.setBillNo(send.getBillNo());
            modelDto.setSourceBillId(send.getSourceBillId());
            modelDto.setSourceBillNo(send.getSourceBillNo());
            modelDto.setServiceNode(send.getServiceNode());
            modelDto.setPsCSkuEcode(sendItemDto.getPsSkuCode());
            modelDto.setPsCSkuId(sendItemDto.getPsSkuId());
            modelDto.setPsCProEcode(sendItemDto.getPsProCode());
            modelDto.setPsCProEname(sendItemDto.getPsProName());
            modelDto.setPsCProId(sendItemDto.getPsProId());
            modelDto.setPsCSpec1Ecode(sendItemDto.getPsSpec1Code());
            modelDto.setPsCSpec1Id(sendItemDto.getPsSpec1Id());
            modelDto.setPsCSpec1Ename(sendItemDto.getPsSpec1Name());
            modelDto.setPsCBrandId(sendItemDto.getPsBrandId());
            modelDto.setPsCBrandName(sendItemDto.getPsBrandName());
            modelDto.setBarCode(sendItemDto.getBarCode());
            modelDto.setBillType(send.getSourceBillType());
            modelDto.setBillItemId(sendItemDto.getId());
            modelDto.setBillDate(send.getBillDate());
            modelDto.setSourceItemId(sendItemDto.getSourceBillItemId());
            modelDto.setCpCStoreId(sendItemDto.getSgStoreId());
            modelDto.setCpCStoreEcode(sendItemDto.getSgStoreCode());
            modelDto.setCpCStoreEname(sendItemDto.getSgStoreName());
            modelDto.setWmsThirdCode(sendItemDto.getWmsThirdCode());
            modelDto.setCpCPhyWarehouseId(send.getSgWarehouseId());
            modelDto.setCpCPhyWarehouseEcode(send.getSgWarehouseCode());
            modelDto.setCpCPhyWarehouseEname(send.getSgWarehouseName());
            modelDto.setChangeDate(sendItemDto.getCreateTime());
            modelDto.setQtyPreoutChange(sendItemDto.getQty());
            modelDto.setQtyPreinChange(BigDecimal.ZERO);
            modelDto.setQtyStorageChange(BigDecimal.ZERO);
            storageChangeFtpList.add(modelDto);
        }
        return storageChangeFtpList;
    }

    public List<SgSendOccupyDto.SgSendItemDto> buildOrderOccupyItem(List<SgPreOccupationOrderUsedItem> usedItemList, Boolean isRelease) {
        List<SgSendOccupyDto.SgSendItemDto> itemList = usedItemList.stream().map(o -> {
            SgSendOccupyDto.SgSendItemDto itemSaveDto = new SgSendOccupyDto.SgSendItemDto();
            itemSaveDto.setSourceBillItemId(o.getId());
            itemSaveDto.setSgStoreId(o.getCpCStoreId());
            itemSaveDto.setSgStoreCode(o.getCpCStoreEcode());
            itemSaveDto.setSgStoreName(o.getCpCStoreEname());
            itemSaveDto.setPsSkuId(o.getPsCSkuId());
            itemSaveDto.setPsSkuCode(o.getPsCSkuEcode());
            if (isRelease.booleanValue()) {
                itemSaveDto.setQty(o.getReleaseQty().negate());
            } else {
                itemSaveDto.setQty(o.getQty());
            }
            itemSaveDto.setPsProId(o.getPsCProId());
            itemSaveDto.setPsProCode(o.getPsCProEcode());
            itemSaveDto.setPsProName(o.getPsCProEname());
            itemSaveDto.setPsSpec1Id(o.getPsCSpec1Id());
            itemSaveDto.setPsSpec1Code(o.getPsCSpec1Ecode());
            itemSaveDto.setPsSpec1Name(o.getPsCSpec1Ename());
            itemSaveDto.setPsProClassify(o.getPsProClassify());
            itemSaveDto.setPsBrandId(o.getPsCBrandId());
            itemSaveDto.setPsBrandName(o.getPsCBrandName());
            itemSaveDto.setBarCode(o.getBarCode());
            itemSaveDto.setWmsThirdCode(o.getWmsThirdCode());
            return itemSaveDto;
        }).collect(Collectors.toList());
        return itemList;
    }

    public SgSendOccupyDto.SgSendDto buildOrderOccupyMain(SgOutMainDto paramMain, SgPreOccupationInfoDTO preOccupationInfoDTO) {
        SgSendOccupyDto.SgSendDto saveDto = new SgSendOccupyDto.SgSendDto();
        BeanUtils.copyProperties((Object)paramMain, (Object)saveDto);
        saveDto.setCpShopId(paramMain.getShopId());
        saveDto.setCpShopTitle(paramMain.getShopTitle());
        saveDto.setOrderId(paramMain.getOrderId());
        saveDto.setOrderNo(paramMain.getOrderNo());
        saveDto.setSourceBillId(paramMain.getSourceBillId());
        saveDto.setSourceBillNo(paramMain.getSourceBillNo());
        saveDto.setSgWarehouseId(preOccupationInfoDTO.getMain().getCpCPhyWarehouseId());
        saveDto.setSgWarehouseCode(preOccupationInfoDTO.getMain().getCpCPhyWarehouseEcode());
        saveDto.setSgWarehouseName(preOccupationInfoDTO.getMain().getCpCPhyWarehouseEname());
        return saveDto;
    }

    public List<SgOutItemSaveDto> mergeSameSkuIdQty(List<SgOutItemSaveDto> itemList) {
        if (log.isDebugEnabled()) {
            log.info("SgStorageQueryRedisBiz.mergeSameSkuIdQty \u5408\u5e76\u524d {}", (Object)JSON.toJSONString(itemList));
        }
        Map<Long, List<SgOutItemSaveDto>> newSendItemMap = itemList.stream().collect(Collectors.groupingBy(obj -> obj.getPsSkuId()));
        Iterator<Long> it = newSendItemMap.keySet().iterator();
        ArrayList<SgOutItemSaveDto> newItemList = new ArrayList<SgOutItemSaveDto>();
        while (it.hasNext()) {
            Long skuId = it.next();
            List<SgOutItemSaveDto> sameSkuList = newSendItemMap.get(skuId);
            BigDecimal newQty = sameSkuList.stream().map(SgOutItemSaveDto::getQty).reduce(BigDecimal.ZERO, BigDecimal::add);
            SgOutItemSaveDto sgSendItemDto = sameSkuList.get(0);
            SgOutItemSaveDto sgOutItemSaveDto = new SgOutItemSaveDto();
            BeanUtils.copyProperties((Object)sgSendItemDto, (Object)sgOutItemSaveDto);
            sgOutItemSaveDto.setQty(newQty);
            newItemList.add(sgOutItemSaveDto);
        }
        if (log.isDebugEnabled()) {
            log.info("SgStorageQueryRedisBiz.mergeSameSkuIdQty \u5408\u5e76\u524d\u540e {}", (Object)JSON.toJSONString(newItemList));
        }
        return newItemList;
    }

    public void recalculationUpdatePreOrder(SgPreOccupationOrder main) {
        List allItem = this.sgPreOccupationOrderItemService.getByParentId(main.getId(), YesOrNoEnum.NO.getCode());
        BigDecimal totQty = BigDecimal.ZERO;
        BigDecimal totUsedQty = BigDecimal.ZERO;
        BigDecimal totUnusedQty = BigDecimal.ZERO;
        BigDecimal totReleaseQty = BigDecimal.ZERO;
        BigDecimal totAutoReleaseQty = BigDecimal.ZERO;
        BigDecimal totManualReleaseQty = BigDecimal.ZERO;
        for (SgPreOccupationOrderItem item : allItem) {
            totQty = totQty.add(item.getQty());
            totUsedQty = totUsedQty.add(item.getUsedQty());
            totUnusedQty = totUnusedQty.add(item.getUnusedQty());
            totReleaseQty = totReleaseQty.add(item.getReleaseQty());
            totAutoReleaseQty = totAutoReleaseQty.add(item.getAutoReleaseQty());
            totManualReleaseQty = totManualReleaseQty.add(item.getManualReleaseQty());
        }
        SgPreOccupationOrder sgPreOccupationOrder = new SgPreOccupationOrder();
        sgPreOccupationOrder.setId(main.getId());
        sgPreOccupationOrder.setTotQty(totQty);
        sgPreOccupationOrder.setTotUsedQty(totUsedQty);
        sgPreOccupationOrder.setTotUnusedQty(totUnusedQty);
        sgPreOccupationOrder.setTotReleaseQty(totReleaseQty);
        sgPreOccupationOrder.setTotAutoReleaseQty(totAutoReleaseQty);
        sgPreOccupationOrder.setTotManualReleaseQty(totManualReleaseQty);
        sgPreOccupationOrder.setBillStatus(SgPreOccupationOrderBillStatusEnum.AUDITED.getCode());
        this.initialService.initialUpdateBaseDaoSystemValue((BaseDo)sgPreOccupationOrder);
        this.sgPreOccupationOrderService.updateById((Object)sgPreOccupationOrder);
    }

    public List<SgSendOccupyDto.SgSendItemDto> buildPreOccupationItem(List<SgPreOccupationOrderUsedItem> value, Boolean isRelease) {
        List<SgSendOccupyDto.SgSendItemDto> itemList = value.stream().map(o -> {
            SgSendOccupyDto.SgSendItemDto itemSaveDto = new SgSendOccupyDto.SgSendItemDto();
            itemSaveDto.setSourceBillItemId(o.getId());
            itemSaveDto.setSgStoreId(o.getCpCStoreId());
            itemSaveDto.setSgStoreCode(o.getCpCStoreEcode());
            itemSaveDto.setSgStoreName(o.getCpCStoreEname());
            itemSaveDto.setPsSkuId(o.getPsCSkuId());
            itemSaveDto.setPsSkuCode(o.getPsCSkuEcode());
            if (isRelease.booleanValue()) {
                itemSaveDto.setQty(o.getQty().negate());
            } else {
                itemSaveDto.setQty(o.getReleaseQty());
            }
            itemSaveDto.setPsProId(o.getPsCProId());
            itemSaveDto.setPsProCode(o.getPsCProEcode());
            itemSaveDto.setPsProName(o.getPsCProEname());
            itemSaveDto.setPsSpec1Id(o.getPsCSpec1Id());
            itemSaveDto.setPsSpec1Code(o.getPsCSpec1Ecode());
            itemSaveDto.setPsSpec1Name(o.getPsCSpec1Ename());
            itemSaveDto.setPsProClassify(o.getPsProClassify());
            itemSaveDto.setPsBrandId(o.getPsCBrandId());
            itemSaveDto.setPsBrandName(o.getPsCBrandName());
            itemSaveDto.setBarCode(o.getBarCode());
            itemSaveDto.setWmsThirdCode(o.getWmsThirdCode());
            return itemSaveDto;
        }).collect(Collectors.toList());
        return itemList;
    }

    public SgSendOccupyDto.SgSendDto buildPreOccupationMain(SgPreOccupationOrder main) {
        SgSendOccupyDto.SgSendDto saveDto = new SgSendOccupyDto.SgSendDto();
        saveDto.setSourceBillId(main.getId());
        saveDto.setSourceBillNo(main.getBillNo());
        saveDto.setCpShopId(main.getCpCShopId());
        saveDto.setCpShopTitle(main.getCpCShopTitle());
        saveDto.setSourceBillType(Integer.valueOf(SourceBillTypeEnum.PRE_OCCUPATION_ORDER.getCode()));
        saveDto.setSgWarehouseId(main.getCpCPhyWarehouseId());
        saveDto.setSgWarehouseCode(main.getCpCPhyWarehouseEcode());
        saveDto.setSgWarehouseName(main.getCpCPhyWarehouseEname());
        saveDto.setMdmBelongCompany(main.getMdmBelongCompany());
        saveDto.setMdmBelongCompanyId(main.getMdmBelongCompanyId());
        saveDto.setRemark(main.getRemark());
        saveDto.setServiceNode(ServiceNodeEnum.PRE_OCCUPATION_ORDER_RELEASE.getCode());
        return saveDto;
    }

    public SgStorageLogicUpdateResultDTO insertStorageChangeFtpList(List<SgPreOccupationOrderUsedItem> usedItemList, List<SgSendOccupyDto.SgSendItemDto> mergeSendItemList, ApiResponse<SgSendCommonBiz.SendSaveVO> sendApiRes) {
        SgSendCommonBiz.SendSaveVO content = (SgSendCommonBiz.SendSaveVO)sendApiRes.getContent();
        SgSendCommonBiz.StoragePreOutEntity storagePreOutEntity = new SgSendCommonBiz.StoragePreOutEntity();
        storagePreOutEntity.setOrigSendEntity(content.getOrigSendEntity());
        storagePreOutEntity.setNewSendEntity(content.getNewSendEntity());
        SgStorageUpdateBillDto billInfo = this.storeOccupyBiz.buildBillInfo(storagePreOutEntity);
        List<SgStorageItemUpdateCommonModelDto> storageChangeFtpList = this.buildStorageItemUpdateModel(billInfo);
        Collections.sort(storageChangeFtpList);
        HashMap<Long, Long> storeMap = new HashMap<Long, Long>();
        HashMap<Long, Long> skuMap = new HashMap<Long, Long>();
        for (SgPreOccupationOrderUsedItem usedItem : usedItemList) {
            storeMap.put(usedItem.getCpCStoreId(), usedItem.getCpCStoreId());
            skuMap.put(usedItem.getPsCSkuId(), usedItem.getPsCSkuId());
        }
        List storageList = this.storageService.selectQtyByStoreAndSkuMap(storeMap, skuMap);
        ApiResponse saveStorageResponse = this.sgStorageLogic.batchSaveStorageInfo(storageChangeFtpList, storageList);
        Assert.isTrue((boolean)saveStorageResponse.isSuccess(), (String)("\u8ba2\u5355\u751f\u6210\u5360\u7528\u6d41\u6c34\u5931\u8d25\uff1a" + saveStorageResponse.getDesc()), (Object[])new Object[0]);
        return (SgStorageLogicUpdateResultDTO)saveStorageResponse.getContent();
    }
}

