/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.common;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.sg.basic.api.model.vo.SgStorageBatchUpdateVo;
import com.xinqiyi.sg.basic.model.common.SgConstantsIF;
import com.xinqiyi.sg.basic.model.common.SourceBillTypeEnum;
import com.xinqiyi.sg.basic.model.dto.SgStorageSingleUpdateDto;
import com.xinqiyi.sg.basic.model.dto.SgStorageUpdateBillDto;
import com.xinqiyi.sg.basic.model.dto.SgStorageUpdateBillItemDto;
import com.xinqiyi.sg.basic.model.dto.SgStorageUpdateControlDto;
import com.xinqiyi.sg.basic.model.entity.SgStore;
import com.xinqiyi.sg.basic.service.business.SgStorageRedisBillUpdateBiz;
import com.xinqiyi.sg.basic.service.config.SgResultMqConfig;
import com.xinqiyi.sg.basic.service.config.SgStorageEffectiveConfig;
import com.xinqiyi.sg.basic.service.exception.BusinessException;
import com.xinqiyi.sg.store.model.dto.send.SgSendBillSaveDto;
import com.xinqiyi.sg.store.model.dto.send.SgSendItemSaveDto;
import com.xinqiyi.sg.store.model.entity.SgSend;
import com.xinqiyi.sg.store.model.entity.SgSendEffectiveItem;
import com.xinqiyi.sg.store.model.entity.SgSendItem;
import com.xinqiyi.sg.store.service.business.common.PropertyCopyByStoreBiz;
import com.xinqiyi.sg.store.service.business.send.SgPreOccupationReleaseSendBiz;
import com.xinqiyi.sg.store.service.business.utils.StoreUtils;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SgStoreStorageBySendBiz {
    private static final Logger log = LoggerFactory.getLogger(SgStoreStorageBySendBiz.class);
    @Resource
    private SgStorageRedisBillUpdateBiz sgStorageRedisBillUpdateBiz;
    @Resource
    private IdSequenceGenerator idSequenceGenerator;
    @Resource
    private PropertyCopyByStoreBiz propertyCopyByStoreBiz;
    @Autowired
    SgResultMqConfig sgResultMqConfig;
    @Resource
    private SgPreOccupationReleaseSendBiz sgPreOccupationReleaseSendBiz;
    @Resource
    private SgStorageEffectiveConfig sgStorageEffectiveConfig;

    public ApiResponse<SgStorageBatchUpdateVo> updateSendStoragePreOut(SgSendBillSaveDto request, SgSend send, Map<String, SgSendItem> sendItemMapDB, Map<Long, SgStore> negativeStock) {
        ApiResponse response;
        SgStorageSingleUpdateDto storageSingleUpdateDto = new SgStorageSingleUpdateDto();
        try {
            SgStorageUpdateControlDto controlModel = new SgStorageUpdateControlDto();
            controlModel.setPreoutOperateType(request != null ? request.getPreOutWarningType() : 2);
            SgStorageUpdateBillDto sgStorageUpdateBillDto = this.buildBillInfo(send, request, sendItemMapDB, null, negativeStock, request.getIsNegativePreOut(), null);
            String messageKey = this.sgResultMqConfig.MSG_TAG_SEND + ":" + send.getBillNo();
            storageSingleUpdateDto.setControlModel(controlModel);
            storageSingleUpdateDto.setMessageKey(messageKey);
            storageSingleUpdateDto.setBill(sgStorageUpdateBillDto);
            log.info("\u6765\u6e90\u5355\u636eid[" + send.getSourceBillId() + "],\u5f00\u59cb\u5360\u7528\u5e93\u5b58\u5360\u7528\u5165\u53c2" + JSONObject.toJSONString((Object)storageSingleUpdateDto));
            response = this.sgStorageRedisBillUpdateBiz.updateStorageBill(storageSingleUpdateDto);
            log.info("\u6765\u6e90\u5355\u636eid[" + send.getSourceBillId() + "],\u5360\u7528\u5e93\u5b58\u5360\u7528\u51fa\u53c2" + JSON.toJSONString((Object)response));
        }
        catch (Exception e) {
            log.error("\u5e93\u5b58\u5360\u7528\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("\u540c\u6b65\u5e93\u5b58\u5360\u7528\u63a5\u53e3\u670d\u52a1\u5f02\u5e38:" + e);
        }
        return response;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<SgStorageBatchUpdateVo> cleanOrVoidSendStoragePreOut(Long serviceNode, SgSend send, List<SgSendItem> sgSendItemList, Map<Long, SgStore> negativeStock, List<SgSendEffectiveItem> sgSendEffectiveItemDBList) {
        ApiResponse<List<SgSendItem>> response = null;
        try {
            if (!ObjectUtil.equal((Object)send.getSourceBillType(), (Object)SourceBillTypeEnum.PRE_OCCUPATION_ORDER.getCode())) {
                log.info("\u6e05\u7a7a\u6216\u4f5c\u5e9f\u903b\u8f91\u53d1\u8d27\u5355\uff0c\u6765\u6e90\u7c7b\u578b\u975e\u9884\u5360\u5355\uff0c\u67e5\u8be2\u662f\u5426\u5b58\u5728\u9884\u5360\u5355\u5360\u7528");
                response = this.sgPreOccupationReleaseSendBiz.releaseByVoidSend(serviceNode, send, sgSendItemList);
                if (log.isDebugEnabled()) {
                    log.debug("\u903b\u8f91\u53d1\u8d27\u5355\u91ca\u653e\u5e93\u5b58\u56de\u9884\u5360\u5355\u7ed3\u679c:{}", (Object)JSON.toJSONString(response));
                }
                if (response.isSuccess() && CollUtil.isNotEmpty((Collection)((Collection)response.getContent()))) {
                    sgSendItemList = (List)response.getContent();
                }
            }
        }
        catch (Exception e) {
            log.error("\u903b\u8f91\u53d1\u8d27\u5355\u6e05\u7a7a\uff0c\u91ca\u653e\u56de\u9884\u5360\u5355\u5360\u7528\u5f02\u5e38:", (Throwable)e);
        }
        return this.cleanOrVoidSendStorage(serviceNode, send, sgSendItemList, negativeStock, sgSendEffectiveItemDBList);
    }

    public ApiResponse<SgStorageBatchUpdateVo> cleanOrVoidSendStorage(Long serviceNode, SgSend send, List<SgSendItem> sgSendItemList, Map<Long, SgStore> negativeStock, List<SgSendEffectiveItem> sgSendEffectiveItemDBList) {
        ApiResponse response;
        Boolean isOpenEffective = this.sgStorageEffectiveConfig.isOpenEffective != null && this.sgStorageEffectiveConfig.isOpenEffective != false;
        SgStorageSingleUpdateDto storageSingleUpdateDto = new SgStorageSingleUpdateDto();
        try {
            SgStorageUpdateControlDto controlModel = new SgStorageUpdateControlDto();
            controlModel.setPreoutOperateType(2);
            SgStorageUpdateBillDto sgStorageUpdateBillDto = this.buildBillInfoByCleanOrVoid(send, sgSendItemList, negativeStock, false, sgSendEffectiveItemDBList);
            sgStorageUpdateBillDto.setServiceNode(serviceNode);
            String messageKey = this.sgResultMqConfig.MSG_TAG_SEND + ":" + send.getBillNo();
            storageSingleUpdateDto.setControlModel(controlModel);
            storageSingleUpdateDto.setMessageKey(messageKey);
            storageSingleUpdateDto.setBill(sgStorageUpdateBillDto);
            storageSingleUpdateDto.setIsOpenEffective(isOpenEffective);
            log.info("SgStoreStorageBySendBiz.cleanOrVoidSendStoragePreOut \u6e05\u7a7a\u6216\u4f5c\u5e9f \u6765\u6e90\u5355\u636e\u7f16\u53f7\uff1a{} \u5165\u53c2\uff1a{}", (Object)send.getSourceBillNo(), (Object)JSONObject.toJSONString((Object)storageSingleUpdateDto));
            response = this.sgStorageRedisBillUpdateBiz.updateStorageBill(storageSingleUpdateDto);
            log.info("SgStoreStorageBySendBiz.cleanOrVoidSendStoragePreOut \u6e05\u7a7a\u6216\u4f5c\u5e9f \u6765\u6e90\u5355\u636e\u7f16\u53f7\uff1a{} \u8fd4\u56de\u503c\uff1a{}", (Object)send.getSourceBillNo(), (Object)JSON.toJSONString((Object)response));
        }
        catch (Exception e) {
            log.error("\u5e93\u5b58\u5360\u7528\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("\u540c\u6b65\u5e93\u5b58\u5360\u7528\u63a5\u53e3\u670d\u52a1\u5f02\u5e38:" + e);
        }
        return response;
    }

    private SgStorageUpdateBillDto buildBillInfoByCleanOrVoid(SgSend send, List<SgSendItem> sendItemList, Map<Long, SgStore> negativeStock, Boolean isNegative, List<SgSendEffectiveItem> sgSendEffectiveItemDBList) {
        SgStorageUpdateBillDto billRequest = new SgStorageUpdateBillDto();
        this.propertyCopyByStoreBiz.initBillInfo(send, billRequest);
        billRequest.setItemList(this.buildItemCleanSendStoragePreOut(send, sendItemList, negativeStock, isNegative));
        if (this.sgStorageEffectiveConfig.isOpenEffective != null && this.sgStorageEffectiveConfig.isOpenEffective.booleanValue()) {
            billRequest.setEffectiveItemList(this.buildItemCleanSendStorageEffectivePreOut(send, sgSendEffectiveItemDBList, negativeStock, isNegative));
        }
        return billRequest;
    }

    private List<SgStorageUpdateBillItemDto> buildItemCleanSendStoragePreOut(SgSend send, List<SgSendItem> sendItemList, Map<Long, SgStore> negativeStock, Boolean isNegative) {
        ArrayList<SgStorageUpdateBillItemDto> itemList = new ArrayList<SgStorageUpdateBillItemDto>();
        Map<String, List<SgSendItem>> sgSendItemMap = sendItemList.stream().collect(Collectors.groupingBy(o -> o.getSgStoreId() + ":" + o.getPsSkuCode()));
        Iterator<String> it = sgSendItemMap.keySet().iterator();
        while (it.hasNext()) {
            List<SgSendItem> list = sgSendItemMap.get(it.next());
            SgSendItem item = list.get(0);
            BigDecimal totalQtyPreOutDB = list.stream().map(SgSendItem::getQtyPreOut).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal preOutQtyChange = totalQtyPreOutDB.negate();
            SgStorageUpdateBillItemDto storage = new SgStorageUpdateBillItemDto();
            BeanUtils.copyProperties((Object)item, (Object)storage);
            this.propertyCopyByStoreBiz.copyProperties(send, item, storage);
            storage.setBillItemId(item.getId());
            storage.setQtyPreoutChange(preOutQtyChange);
            SgStorageUpdateControlDto controlDto = this.buildStorageUpdateControlInfo(isNegative, null, negativeStock, storage.getCpCStoreId());
            storage.setControlmodel(controlDto);
            itemList.add(storage);
        }
        return itemList;
    }

    private List<SgStorageUpdateBillItemDto> buildItemCleanSendStorageEffectivePreOut(SgSend send, List<SgSendEffectiveItem> sendItemList, Map<Long, SgStore> negativeStock, Boolean isNegative) {
        ArrayList<SgStorageUpdateBillItemDto> itemList = new ArrayList<SgStorageUpdateBillItemDto>();
        Map<String, List<SgSendEffectiveItem>> sgSendItemMap = sendItemList.stream().collect(Collectors.groupingBy(o -> o.getSgStoreId() + ":" + o.getPsSkuCode() + ":" + o.getPreoutBatchCode()));
        Iterator<String> it = sgSendItemMap.keySet().iterator();
        while (it.hasNext()) {
            List<SgSendEffectiveItem> list = sgSendItemMap.get(it.next());
            SgSendEffectiveItem item = list.get(0);
            BigDecimal totalQtyPreOutDB = list.stream().map(SgSendEffectiveItem::getQtyPreOut).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal preOutQtyChange = totalQtyPreOutDB.negate();
            SgStorageUpdateBillItemDto storage = new SgStorageUpdateBillItemDto();
            BeanUtils.copyProperties((Object)item, (Object)storage);
            this.propertyCopyByStoreBiz.copyPropertiesEffective(send, item, storage);
            storage.setBillItemId(item.getId());
            storage.setQtyPreoutChange(preOutQtyChange);
            SgStorageUpdateControlDto controlDto = this.buildStorageUpdateControlInfo(isNegative, null, negativeStock, storage.getCpCStoreId());
            storage.setControlmodel(controlDto);
            itemList.add(storage);
        }
        return itemList;
    }

    private SgStorageUpdateBillDto buildBillInfo(SgSend send, SgSendBillSaveDto request, Map<String, SgSendItem> sendItemMapDB, List<SgSendItem> sgSendItemListDB, Map<Long, SgStore> negativeStock, Boolean isAllowNegativeStorage, List<SgSendEffectiveItem> sgSendEffectiveItemList) {
        SgStorageUpdateBillDto billRequest = new SgStorageUpdateBillDto();
        this.propertyCopyByStoreBiz.initBillInfo(send, billRequest);
        if (request != null && request.getStrategyPriorityList() != null) {
            billRequest.setStrategyPriorityList(request.getStrategyPriorityList());
        }
        boolean isCancel = request != null ? request.getIsCancel() : false;
        billRequest.setIsCancel(Boolean.valueOf(isCancel));
        List<SgStorageUpdateBillItemDto> itemList = request != null ? this.buildSendStorageItems(request, send, sendItemMapDB, negativeStock) : this.buildSendStorageItemsForRelease(send, sgSendItemListDB, negativeStock, isAllowNegativeStorage);
        billRequest.setItemList(itemList);
        if (CollectionUtils.isNotEmpty(sgSendEffectiveItemList)) {
            List<SgStorageUpdateBillItemDto> itemEffectiveList = request != null ? this.buildSendStorageItems(request, send, sendItemMapDB, negativeStock) : this.buildSendStorageItemsEffexctiveForRelease(send, sgSendEffectiveItemList, negativeStock, isAllowNegativeStorage);
            billRequest.setEffectiveItemList(itemEffectiveList);
        }
        return billRequest;
    }

    private List<SgStorageUpdateBillItemDto> buildSendStorageItems(SgSendBillSaveDto request, SgSend send, Map<String, SgSendItem> sendItemMapDB, Map<Long, SgStore> negativeStock) {
        ArrayList<SgStorageUpdateBillItemDto> storageUpdateBillItemList = new ArrayList<SgStorageUpdateBillItemDto>();
        List sendItemSaveDtoList = request.getSendItemSaveDtoList();
        if (SgConstantsIF.ITEM_UPDATE_TYPE_ALL.equals(request.getUpdateMethod())) {
            List<SgStorageUpdateBillItemDto> itemDtoList = this.buildReverseStorageUpdateBillItem(request.getIsNegativePreOut(), sendItemSaveDtoList, send, sendItemMapDB, negativeStock);
            storageUpdateBillItemList.addAll(itemDtoList);
        }
        List<SgStorageUpdateBillItemDto> billItemList = this.buildStorageUpdateBillItem(send, request.getIsNegativePreOut(), sendItemSaveDtoList, negativeStock);
        storageUpdateBillItemList.addAll(billItemList);
        return storageUpdateBillItemList;
    }

    private List<SgStorageUpdateBillItemDto> buildSendStorageItemsForRelease(SgSend send, List<SgSendItem> bSendItems, Map<Long, SgStore> negativeStock, Boolean isAllowNegativeStorage) {
        ArrayList<SgStorageUpdateBillItemDto> itemList = new ArrayList<SgStorageUpdateBillItemDto>();
        bSendItems.forEach(bSendItem -> {
            BigDecimal preOutQtyChange = bSendItem.getQtyPreOut().negate();
            BigDecimal storageQtyChange = bSendItem.getQtySend().negate();
            if (0 != BigDecimal.ZERO.compareTo(preOutQtyChange) || 0 != BigDecimal.ZERO.compareTo(storageQtyChange)) {
                SgStorageUpdateBillItemDto item = new SgStorageUpdateBillItemDto();
                BeanUtils.copyProperties((Object)bSendItem, (Object)item);
                this.propertyCopyByStoreBiz.copyProperties(send, (SgSendItem)bSendItem, item);
                item.setBillItemId(bSendItem.getId());
                item.setSourceItemId(bSendItem.getSourceBillItemId());
                item.setQtyPreoutChange(preOutQtyChange);
                item.setQtyStorageChange(storageQtyChange);
                SgStorageUpdateControlDto controlRequest = this.buildStorageUpdateControlInfo(isAllowNegativeStorage, null, negativeStock, bSendItem.getSgStoreId());
                item.setControlmodel(controlRequest);
                itemList.add(item);
            }
        });
        return itemList;
    }

    private List<SgStorageUpdateBillItemDto> buildReverseStorageUpdateBillItem(Boolean isNegativePreOut, List<SgSendItemSaveDto> sendItemSaveDtoList, SgSend send, Map<String, SgSendItem> sendItemMapDB, Map<Long, SgStore> negativeStock) {
        ArrayList<SgStorageUpdateBillItemDto> storageUpdateBillItemList = new ArrayList<SgStorageUpdateBillItemDto>();
        for (SgSendItemSaveDto itemSaveRequest : sendItemSaveDtoList) {
            if (!itemSaveRequest.getIsSendStorage().booleanValue()) continue;
            String key = StoreUtils.getSendItemMapForMapKey(itemSaveRequest.getPsSkuId(), itemSaveRequest.getSgStoreId(), itemSaveRequest.getSourceBillItemId());
            SgSendItem sgBSendItemDB = sendItemMapDB != null ? sendItemMapDB.get(key) : null;
            if (sgBSendItemDB == null || 0 == BigDecimal.ZERO.compareTo(sgBSendItemDB.getQtyPreOut().negate())) continue;
            BigDecimal qtyPreOutChange = sgBSendItemDB.getQtyPreOut().negate();
            SgStorageUpdateBillItemDto storageUpdateBillItem = new SgStorageUpdateBillItemDto();
            BeanUtils.copyProperties((Object)sgBSendItemDB, (Object)storageUpdateBillItem);
            this.propertyCopyByStoreBiz.copyProperties(send, sgBSendItemDB, storageUpdateBillItem);
            storageUpdateBillItem.setBillItemId(sgBSendItemDB.getId());
            storageUpdateBillItem.setSourceItemId(sgBSendItemDB.getSourceBillItemId());
            storageUpdateBillItem.setQtyPreoutChange(qtyPreOutChange);
            SgStorageUpdateControlDto controlRequest = this.buildStorageUpdateControlInfo(isNegativePreOut, itemSaveRequest.getPreOutWarningType(), negativeStock, sgBSendItemDB.getSgStoreId());
            storageUpdateBillItem.setControlmodel(controlRequest);
            storageUpdateBillItemList.add(storageUpdateBillItem);
        }
        return storageUpdateBillItemList;
    }

    private List<SgStorageUpdateBillItemDto> buildStorageUpdateBillItem(SgSend send, Boolean isNegativePreOut, List<SgSendItemSaveDto> sendItemSaveDtoList, Map<Long, SgStore> negativeStock) {
        ArrayList<SgStorageUpdateBillItemDto> storageUpdateBillItemList = new ArrayList<SgStorageUpdateBillItemDto>();
        for (SgSendItemSaveDto itemSaveRequest : sendItemSaveDtoList) {
            if (!itemSaveRequest.getIsSendStorage().booleanValue() || 0 == BigDecimal.ZERO.compareTo(itemSaveRequest.getQtyPreOut())) continue;
            SgStorageUpdateBillItemDto storageUpdateBillItem = new SgStorageUpdateBillItemDto();
            BeanUtils.copyProperties((Object)itemSaveRequest, (Object)storageUpdateBillItem);
            this.propertyCopyByStoreBiz.copyProperties(send, itemSaveRequest, storageUpdateBillItem);
            Long id = itemSaveRequest.getId() == null ? this.idSequenceGenerator.generateId(SgSendItem.class) : itemSaveRequest.getId();
            storageUpdateBillItem.setBillItemId(id);
            storageUpdateBillItem.setSourceItemId(itemSaveRequest.getSourceBillItemId());
            storageUpdateBillItem.setQtyPreoutChange(itemSaveRequest.getQtyPreOut());
            SgStorageUpdateControlDto controlRequest = this.buildStorageUpdateControlInfo(isNegativePreOut, itemSaveRequest.getPreOutWarningType(), negativeStock, itemSaveRequest.getSgStoreId());
            storageUpdateBillItem.setControlmodel(controlRequest);
            storageUpdateBillItemList.add(storageUpdateBillItem);
        }
        return storageUpdateBillItemList;
    }

    private SgStorageUpdateControlDto buildStorageUpdateControlInfo(Boolean isNegativePreOut, Integer itemPreOutWarningType, Map<Long, SgStore> negativeStock, Long sgStoreId) {
        SgStorageUpdateControlDto controlRequest = null;
        if (MapUtils.isNotEmpty(negativeStock)) {
            controlRequest = new SgStorageUpdateControlDto();
            boolean isNegative = false;
            if ((isNegativePreOut = Boolean.valueOf(isNegativePreOut == null ? false : isNegativePreOut)).booleanValue()) {
                isNegative = true;
            } else {
                SgStore cpStore = negativeStock.get(sgStoreId);
                if (cpStore != null) {
                    isNegative = cpStore.getIsNegative() != null && cpStore.getIsNegative() == 1;
                }
            }
            controlRequest.setNegativePreout(isNegative);
            controlRequest.setNegativeAvailable(isNegative);
            if (itemPreOutWarningType != null) {
                controlRequest.setPreoutOperateType(itemPreOutWarningType.intValue());
            }
        }
        return controlRequest;
    }

    public ApiResponse<SgStorageBatchUpdateVo> submitSendStoragePreOut(Long serviceNode, SgSend send, List<SgSendItem> bSendItems, Map<Long, SgStore> negativeStock, Boolean isAllowNegativeStorage, Long noticesId, String noticesBillNo, Boolean isOpenEffective, List<SgSendEffectiveItem> sgSendEffectiveItemList, Boolean isHaveRowNo) {
        ApiResponse response;
        SgStorageSingleUpdateDto storageSingleUpdateDto = new SgStorageSingleUpdateDto();
        try {
            SgStorageUpdateControlDto controlModel = new SgStorageUpdateControlDto();
            controlModel.setPreoutOperateType(2);
            if (isHaveRowNo.booleanValue()) {
                controlModel.setNegativeStorage(true);
                controlModel.setNegativeAvailable(true);
            }
            SgStorageUpdateBillDto sgStorageUpdateBillDto = this.buildBillInfo(send, null, null, bSendItems, negativeStock, isAllowNegativeStorage, sgSendEffectiveItemList);
            sgStorageUpdateBillDto.setPhyOutNoticesId(noticesId);
            sgStorageUpdateBillDto.setPhyOutNoticesNo(noticesBillNo);
            sgStorageUpdateBillDto.setServiceNode(serviceNode);
            String messageKey = this.sgResultMqConfig.MSG_TAG_SEND + ":" + send.getBillNo();
            storageSingleUpdateDto.setControlModel(controlModel);
            storageSingleUpdateDto.setMessageKey(messageKey);
            storageSingleUpdateDto.setBill(sgStorageUpdateBillDto);
            storageSingleUpdateDto.setIsOpenEffective(isOpenEffective);
            log.info("\u6765\u6e90\u5355\u636eid[" + send.getSourceBillId() + "],\u5f00\u59cb\u5360\u7528\u5e93\u5b58\u5360\u7528\u5165\u53c2" + JSONObject.toJSONString((Object)storageSingleUpdateDto));
            response = this.sgStorageRedisBillUpdateBiz.updateStorageBill(storageSingleUpdateDto);
            log.info("\u6765\u6e90\u5355\u636eid[" + send.getSourceBillId() + "],\u5360\u7528\u5e93\u5b58\u5360\u7528\u51fa\u53c2" + JSON.toJSONString((Object)response));
        }
        catch (Exception e) {
            log.error("\u5e93\u5b58\u5360\u7528\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("\u540c\u6b65\u5e93\u5b58\u5360\u7528\u63a5\u53e3\u670d\u52a1\u5f02\u5e38:" + e);
        }
        return response;
    }

    public ApiResponse<SgStorageBatchUpdateVo> submitSendStoragePreOutByTransfer(SgSend send, List<SgSendItem> sendItemList, Long serviceNode) {
        ApiResponse response;
        SgStorageSingleUpdateDto storageSingleUpdateDto = new SgStorageSingleUpdateDto();
        try {
            SgStorageUpdateControlDto controlModel = new SgStorageUpdateControlDto();
            controlModel.setPreoutOperateType(2);
            SgStorageUpdateBillDto sgStorageUpdateBillDto = new SgStorageUpdateBillDto();
            this.propertyCopyByStoreBiz.initBillInfo(send, sgStorageUpdateBillDto);
            sgStorageUpdateBillDto.setServiceNode(serviceNode);
            sgStorageUpdateBillDto.setIsCancel(Boolean.valueOf(false));
            ArrayList<SgStorageUpdateBillItemDto> itemList = new ArrayList<SgStorageUpdateBillItemDto>();
            for (SgSendItem sgSendItem : sendItemList) {
                BigDecimal preOutQtyChange = sgSendItem.getQtyPreOut().negate();
                BigDecimal storageQtyChange = sgSendItem.getQtySend().negate();
                if (0 == BigDecimal.ZERO.compareTo(preOutQtyChange) && 0 == BigDecimal.ZERO.compareTo(storageQtyChange)) continue;
                SgStorageUpdateBillItemDto item = new SgStorageUpdateBillItemDto();
                BeanUtils.copyProperties((Object)sgSendItem, (Object)item);
                this.propertyCopyByStoreBiz.copyProperties(send, sgSendItem, item);
                item.setBillItemId(sgSendItem.getId());
                item.setSourceItemId(sgSendItem.getSourceBillItemId());
                item.setQtyPreoutChange(preOutQtyChange);
                item.setQtyStorageChange(storageQtyChange);
                item.setControlmodel(null);
                itemList.add(item);
            }
            sgStorageUpdateBillDto.setItemList(itemList);
            storageSingleUpdateDto.setControlModel(controlModel);
            storageSingleUpdateDto.setMessageKey(this.sgResultMqConfig.MSG_TAG_SEND + ":" + send.getBillNo());
            storageSingleUpdateDto.setBill(sgStorageUpdateBillDto);
            log.info("\u6765\u6e90\u5355\u636e\u7f16\u53f7[" + send.getBillNo() + "],\u5e93\u5b58\u5360\u7528\u66f4\u65b0\u5165\u53c2" + JSONObject.toJSONString((Object)storageSingleUpdateDto));
            response = this.sgStorageRedisBillUpdateBiz.updateStorageBill(storageSingleUpdateDto);
            log.info("\u6765\u6e90\u5355\u636e\u7f16\u53f7[" + send.getBillNo() + "],\u5e93\u5b58\u5360\u7528\u66f4\u65b0\u51fa\u53c2" + JSON.toJSONString((Object)response));
        }
        catch (Exception e) {
            log.error("\u5e93\u5b58\u5360\u7528\u66f4\u65b0\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("\u540c\u6b65\u5e93\u5b58\u5360\u7528\u63a5\u53e3\u670d\u52a1\u5f02\u5e38:" + e);
        }
        return response;
    }

    private List<SgStorageUpdateBillItemDto> buildSendStorageItemsEffexctiveForRelease(SgSend send, List<SgSendEffectiveItem> bSendItems, Map<Long, SgStore> negativeStock, Boolean isAllowNegativeStorage) {
        ArrayList itemList = new ArrayList();
        HashMap afterMergeSendEffectiveItemMap = new HashMap();
        bSendItems.forEach(bSendItem -> {
            BigDecimal preOutQtyChange = bSendItem.getQtyPreOut().negate();
            BigDecimal storageQtyChange = bSendItem.getQtySend().negate();
            if (0 != BigDecimal.ZERO.compareTo(preOutQtyChange) || 0 != BigDecimal.ZERO.compareTo(storageQtyChange)) {
                SgStorageUpdateBillItemDto item = new SgStorageUpdateBillItemDto();
                BeanUtils.copyProperties((Object)bSendItem, (Object)item);
                this.propertyCopyByStoreBiz.copyProperties(send, (SgSendEffectiveItem)bSendItem, item);
                item.setBillItemId(bSendItem.getId());
                item.setSourceItemId(bSendItem.getSourceBillItemId());
                item.setQtyPreoutChange(preOutQtyChange);
                item.setQtyStorageChange(storageQtyChange);
                SgStorageUpdateControlDto controlRequest = this.buildStorageUpdateControlInfo(isAllowNegativeStorage, null, negativeStock, bSendItem.getSgStoreId());
                item.setControlmodel(controlRequest);
                String skuIdAndCStoreId = item.getCpCStoreId() + "_" + item.getPsCSkuId() + "_" + item.getBatchCode();
                if (afterMergeSendEffectiveItemMap.containsKey(skuIdAndCStoreId)) {
                    SgStorageUpdateBillItemDto oldItem = (SgStorageUpdateBillItemDto)afterMergeSendEffectiveItemMap.get(skuIdAndCStoreId);
                    BigDecimal oldQtyStorageChange = oldItem.getQtyStorageChange() == null ? BigDecimal.ZERO : oldItem.getQtyStorageChange();
                    BigDecimal oldQtyPreoutChange = oldItem.getQtyPreoutChange() == null ? BigDecimal.ZERO : oldItem.getQtyPreoutChange();
                    oldItem.setQtyStorageChange(oldQtyStorageChange.add(item.getQtyStorageChange()));
                    oldItem.setQtyPreoutChange(oldQtyPreoutChange.add(item.getQtyPreoutChange()));
                } else {
                    afterMergeSendEffectiveItemMap.put(skuIdAndCStoreId, item);
                }
            }
        });
        return new ArrayList<SgStorageUpdateBillItemDto>(afterMergeSendEffectiveItemMap.values());
    }
}

