/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.receive;

import com.alibaba.fastjson.JSONObject;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.bizlog.annotation.LogAnnotation;
import com.xinqiyi.framework.bizlog.entity.InnerLog;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.redis.lock.RedisReentrantLock;
import com.xinqiyi.sg.basic.api.model.vo.SgStorageBatchUpdateVo;
import com.xinqiyi.sg.basic.model.common.ReceiveEnum;
import com.xinqiyi.sg.basic.model.dto.SgBasicDto;
import com.xinqiyi.sg.basic.model.dto.SgStorageRollBackDto;
import com.xinqiyi.sg.basic.service.business.SgBasicCheckBiz;
import com.xinqiyi.sg.basic.service.business.SgStorageRollBackBiz;
import com.xinqiyi.sg.basic.service.utils.SgRedisLockUtils;
import com.xinqiyi.sg.store.api.model.vo.receive.SgReceiveBillCleanVo;
import com.xinqiyi.sg.store.model.dto.receive.SgReceiveBillCleanDto;
import com.xinqiyi.sg.store.model.entity.SgBReceive;
import com.xinqiyi.sg.store.service.SgBReceiveItemService;
import com.xinqiyi.sg.store.service.SgBReceiveService;
import com.xinqiyi.sg.store.service.business.SgStoreStorageBiz;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class SgReceiveCleanBiz
extends SgBasicCheckBiz {
    private static final Logger log = LoggerFactory.getLogger(SgReceiveCleanBiz.class);
    @Resource
    SgBReceiveService receiveService;
    @Resource
    SgStorageRollBackBiz sgStorageRollBackBiz;
    @Resource
    SgBReceiveItemService receiveItemService;
    @Resource
    BaseDaoInitialService initialService;
    @Resource
    SgStoreStorageBiz storeStorageBiz;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    @LogAnnotation
    public ApiResponse<SgReceiveBillCleanVo> cleanReceive(SgReceiveBillCleanDto dto) {
        ApiResponse<List<SgBReceive>> checkResponse;
        if (log.isDebugEnabled()) {
            log.debug("Start SgReceiveCleanBiz.cleanReceive.request={};", (Object)JSONObject.toJSONString((Object)dto));
        }
        if (!(checkResponse = this.checkParams(dto)).isSuccess()) {
            return ApiResponse.failed((String)checkResponse.getDesc());
        }
        List redisBillFtpKeyList = dto.getRedisBillFtpKeyList();
        String lockKey = "sg_b_receive:" + dto.getSourceBillNo() + ":" + dto.getSourceBillType();
        RedisReentrantLock lock = SgRedisLockUtils.lock((String)lockKey);
        SgReceiveBillCleanVo vo = new SgReceiveBillCleanVo();
        List orgReceiveList = (List)checkResponse.getContent();
        Long id = null;
        try {
            for (SgBReceive orgReceive : orgReceiveList) {
                id = orgReceive.getId();
                List receiveItemList = this.receiveItemService.selectListByParentId(orgReceive.getId());
                SgBReceive update = new SgBReceive();
                update.setId(orgReceive.getId());
                update.setTotQtyPrein(BigDecimal.ZERO);
                update.setServiceNode(dto.getServiceNode());
                this.initialService.initialUpdateBaseDaoSystemValue((BaseDo)update, dto.getLoginUser());
                this.receiveService.updateById((Object)update);
                this.receiveItemService.deleteByParent(orgReceive.getId());
                orgReceive.setServiceNode(dto.getServiceNode());
                ApiResponse<SgStorageBatchUpdateVo> storageRespone = this.storeStorageBiz.cleanOrVoidReceiveStoragePrein(orgReceive, receiveItemList, null, dto.getIsNegativePrein());
                if (!storageRespone.isSuccess()) {
                    ApiResponse apiResponse = ApiResponse.failed((String)storageRespone.getDesc());
                    return apiResponse;
                }
                vo.setRedisBillFtpKeyList(((SgStorageBatchUpdateVo)storageRespone.getContent()).getRedisBillFtpKeyList());
                InnerLog.addLog((Long)orgReceive.getId(), (String)"\u6e05\u7a7a\u6210\u529f", (String)"sg_b_receive", null, (String)"\u6e05\u7a7a");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SgStorageRollBackDto rollBackDto = new SgStorageRollBackDto();
            rollBackDto.setRollbackDBflag(true);
            rollBackDto.setRedisBillFtpKeyList(redisBillFtpKeyList);
            this.sgStorageRollBackBiz.rollbackStorageBill(rollBackDto);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            InnerLog.addLog((Long)id, (String)("\u6e05\u7a7a\u5931\u8d25\uff1a" + e.getMessage()), (String)"sg_b_receive", null, (String)"\u6e05\u7a7a");
            ApiResponse apiResponse = ApiResponse.failed((String)e.getMessage());
            return apiResponse;
        }
        finally {
            SgRedisLockUtils.unlock((RedisReentrantLock)lock, (String)lockKey, (Logger)log, (String)((Object)((Object)this)).getClass().getName());
        }
        return ApiResponse.success((Object)vo, (String)"\u6e05\u7a7a\u6210\u529f");
    }

    public ApiResponse<List<SgBReceive>> checkParams(SgReceiveBillCleanDto dto) {
        if (dto.getSourceBillNo() == null || dto.getSourceBillType() == null) {
            return ApiResponse.failed((String)"\u6765\u6e90\u5355\u636e\u7c7b\u578b\u548c\u6765\u6e90\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<SgBReceive> orgReceiveList = Lists.newArrayList();
        if (dto.getCpCPhyWarehouseId() == null) {
            orgReceiveList = this.receiveService.selectBySource(dto.getSourceBillNo(), dto.getSourceBillType());
        } else {
            SgBReceive orgReceive = this.receiveService.selectBySourceAndWareHouseAndRemark(dto.getSourceBillNo(), dto.getSourceBillType(), dto.getCpCPhyWarehouseId(), dto.getReserveVarchar08());
            if (orgReceive == null) {
                return ApiResponse.failed((String)"\u903b\u8f91\u6536\u8d27\u5355\u4e0d\u5b58\u5728");
            }
            orgReceiveList.add(orgReceive);
        }
        for (SgBReceive orgReceive : orgReceiveList) {
            if (ReceiveEnum.Status.CREATE.getCode().equals(orgReceive.getBillStatus()) || ReceiveEnum.Status.UPDATE.getCode().equals(orgReceive.getBillStatus())) continue;
            return ApiResponse.failed((String)MessageFormat.format("\u5f53\u524d\u5355\u636e\u72b6\u6001\u4e3a{0}\u4e0d\u5141\u8bb8\u4f5c\u5e9f!", ReceiveEnum.Status.getName((Integer)orgReceive.getBillStatus())));
        }
        this.baiscCheck((SgBasicDto)dto);
        return ApiResponse.success(orgReceiveList);
    }
}

