/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.receive;

import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.util.BeanConvertUtil;
import com.xinqiyi.sg.basic.common.StorageBasicDaoConstants;
import com.xinqiyi.sg.store.api.model.vo.receive.SgReceiveBillDetailVO;
import com.xinqiyi.sg.store.api.model.vo.receive.SgReceiveDetailVo;
import com.xinqiyi.sg.store.api.model.vo.receive.SgReceiveEffectiveItemQueryVO;
import com.xinqiyi.sg.store.api.model.vo.receive.SgReceiveEffectiveItemVO;
import com.xinqiyi.sg.store.api.model.vo.receive.SgReceiveItemDetailVo;
import com.xinqiyi.sg.store.model.dto.receive.SgReceiveEffectiveItemQueryDto;
import com.xinqiyi.sg.store.model.entity.SgBReceive;
import com.xinqiyi.sg.store.service.SgBReceiveEffectiveItemService;
import com.xinqiyi.sg.store.service.SgBReceiveItemService;
import com.xinqiyi.sg.store.service.SgBReceiveService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SgReceiveQueryBiz {
    private static final Logger log = LoggerFactory.getLogger(SgReceiveQueryBiz.class);
    @Resource
    SgBReceiveService receiveService;
    @Resource
    SgBReceiveItemService receiveItemService;
    @Resource
    SgBReceiveEffectiveItemService sgBReceiveEffectiveItemService;

    public ApiResponse<SgReceiveBillDetailVO> query(Long id) {
        if (log.isDebugEnabled()) {
            log.debug("Start SgReceiveQueryBiz.query.request={};", (Object)id);
        }
        SgReceiveBillDetailVO vo = new SgReceiveBillDetailVO();
        SgBReceive main = (SgBReceive)this.receiveService.getById((Serializable)id);
        if (main == null || main.getIsDelete().equals(StorageBasicDaoConstants.IS_DELETE_Y)) {
            return ApiResponse.failed((String)"\u5f53\u524d\u8bb0\u5f55\u4e0d\u5b58\u5728!");
        }
        List itemList = this.receiveItemService.selectListByParentId(id);
        SgReceiveDetailVo mainVo = new SgReceiveDetailVo();
        BeanConvertUtil.copyProperties((Object)main, (Object)mainVo);
        vo.setMain(mainVo);
        vo.setItemList(BeanConvertUtil.convertList((List)itemList, SgReceiveItemDetailVo.class));
        return ApiResponse.success((Object)vo);
    }

    public ApiResponse<SgReceiveEffectiveItemQueryVO> queryReceiveEffectiveItems(SgReceiveEffectiveItemQueryDto dto) {
        SgReceiveEffectiveItemQueryVO vo = new SgReceiveEffectiveItemQueryVO();
        List itemList = this.sgBReceiveEffectiveItemService.selectReceiveEffectiveItemList(dto.getSgReceiveItemId());
        vo.setEffectiveItemTotal(Integer.valueOf(itemList.size()));
        vo.setSgReceiveEffectiveItemList(BeanConvertUtil.convertList((List)itemList, SgReceiveEffectiveItemVO.class));
        return ApiResponse.success((Object)vo);
    }
}

