/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.receive;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.bizlog.annotation.LogAnnotation;
import com.xinqiyi.framework.bizlog.entity.InnerLog;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.redis.lock.RedisReentrantLock;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.api.model.vo.spu.QueryInteriorSkuVO;
import com.xinqiyi.sg.basic.api.model.vo.SgStorageBatchUpdateVo;
import com.xinqiyi.sg.basic.model.common.ReceiveEnum;
import com.xinqiyi.sg.basic.model.common.SgConstantsIF;
import com.xinqiyi.sg.basic.model.dto.SgBasicDto;
import com.xinqiyi.sg.basic.model.dto.SgStorageRollBackDto;
import com.xinqiyi.sg.basic.model.dto.SgStoreBillItemBaseDto;
import com.xinqiyi.sg.basic.model.entity.SgWarehouse;
import com.xinqiyi.sg.basic.service.SgOrderNoBiz;
import com.xinqiyi.sg.basic.service.TableIdBatchGet;
import com.xinqiyi.sg.basic.service.adapter.common.PsAdapter;
import com.xinqiyi.sg.basic.service.adapter.common.SgWarehouseAdapter;
import com.xinqiyi.sg.basic.service.business.SgBasicCheckBiz;
import com.xinqiyi.sg.basic.service.business.SgStorageEffectiveRollBackBiz;
import com.xinqiyi.sg.basic.service.business.SgStorageRollBackBiz;
import com.xinqiyi.sg.basic.service.common.SgConstants;
import com.xinqiyi.sg.basic.service.config.SgStorageEffectiveConfig;
import com.xinqiyi.sg.basic.service.utils.SgRedisLockUtils;
import com.xinqiyi.sg.store.api.model.vo.receive.SgReceiveBillSaveVo;
import com.xinqiyi.sg.store.model.dto.receive.SgReceiveBillSaveDto;
import com.xinqiyi.sg.store.model.dto.receive.SgReceiveItemSaveDto;
import com.xinqiyi.sg.store.model.dto.receive.SgReceiveSaveDto;
import com.xinqiyi.sg.store.model.entity.SgBReceive;
import com.xinqiyi.sg.store.model.entity.SgBReceiveEffectiveItem;
import com.xinqiyi.sg.store.model.entity.SgBReceiveItem;
import com.xinqiyi.sg.store.service.SgBReceiveEffectiveItemService;
import com.xinqiyi.sg.store.service.SgBReceiveItemService;
import com.xinqiyi.sg.store.service.SgBReceiveService;
import com.xinqiyi.sg.store.service.business.SgStoreStorageBiz;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SgReceiveSaveBiz
extends SgBasicCheckBiz {
    private static final Logger log = LoggerFactory.getLogger(SgReceiveSaveBiz.class);
    @Resource
    SgStorageRollBackBiz sgStorageRollBackBiz;
    @Resource
    SgBReceiveService receiveService;
    @Resource
    SgBReceiveItemService receiveItemService;
    @Resource
    IdSequenceGenerator idSequenceGenerator;
    @Resource
    SgStoreStorageBiz sgStoreStorageBiz;
    @Resource
    SgOrderNoBiz orderNoBiz;
    @Resource
    BaseDaoInitialService initialService;
    @Resource
    TableIdBatchGet tableIdBatchGet;
    @Resource
    private PsAdapter psAdapter;
    @Resource
    private SgWarehouseAdapter sgWarehouseAdapter;
    @Resource
    public SgStorageEffectiveConfig sgStorageEffectiveConfig;
    @Resource
    SgBReceiveEffectiveItemService sgBReceiveEffectiveItemService;
    @Resource
    SgStorageEffectiveRollBackBiz sgStorageEffectiveRollBackBiz;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    @LogAnnotation
    public ApiResponse<SgReceiveBillSaveVo> saveReceive(SgReceiveBillSaveDto dto) {
        Boolean isOpenEffective = this.sgStorageEffectiveConfig.isOpenEffective != null && this.sgStorageEffectiveConfig.isOpenEffective != false;
        dto.setIsOpenEffective(isOpenEffective);
        if (log.isDebugEnabled()) {
            log.debug("Start SgReceiveSaveBiz.saveSgBStoIn.saveSgBReceive.request={};", (Object)JSONObject.toJSONString((Object)dto));
        }
        List redisBillFtpKeyList = dto.getRedisBillFtpKeyList();
        List redisBillFtpKeyListByBatchCode = dto.getRedisBillFtpKeyListByBatchCode();
        ApiResponse response = null;
        ApiResponse<SgBReceive> checkResponse = this.checkParams(dto);
        if (!checkResponse.isSuccess()) {
            return ApiResponse.failed((String)checkResponse.getDesc());
        }
        String lockKey = "sg_b_receive:" + dto.getMain().getSourceBillNo() + ":" + dto.getMain().getSourceBillType();
        RedisReentrantLock lock = SgRedisLockUtils.lock((String)lockKey);
        try {
            ApiResponse<SgStorageBatchUpdateVo> storageResponse;
            SgBReceive receive = (SgBReceive)checkResponse.getContent();
            Map<Object, Object> map = Maps.newHashMap();
            Map<Object, Object> effectivemap = Maps.newHashMap();
            if (receive != null) {
                map = this.receiveItemService.selectListByParentId(receive.getId()).stream().collect(Collectors.toMap(o -> o.getPsCSkuId() + "_" + o.getCpCStoreId() + "_" + o.getSourceBillItemId(), Function.identity()));
                effectivemap = this.sgBReceiveEffectiveItemService.selectListByParentId(receive.getId()).stream().collect(Collectors.toMap(o -> o.getPsCSkuId() + "_" + o.getCpCStoreId() + "_" + o.getSourceBillItemId() + "_" + o.getBatchCode(), Function.identity()));
            }
            if ((storageResponse = this.sgStoreStorageBiz.updateReceiveStoragePrein(receive = this.saveOrUpdateRecord(dto, receive), dto, map, null, effectivemap)).isSuccess()) {
                redisBillFtpKeyList.addAll(((SgStorageBatchUpdateVo)storageResponse.getContent()).getRedisBillFtpKeyList());
                if (isOpenEffective.booleanValue()) {
                    redisBillFtpKeyListByBatchCode.addAll(((SgStorageBatchUpdateVo)storageResponse.getContent()).getSgStorageEffectiveBatchUpdateVo().getRedisBillFtpKeyList());
                }
            }
            SgReceiveBillSaveVo vo = new SgReceiveBillSaveVo();
            vo.setRedisBillFtpKeyList(redisBillFtpKeyList);
            vo.setId(receive.getId());
            vo.setRedisBillFtpKeyListByBatchCode(redisBillFtpKeyListByBatchCode);
            response = ApiResponse.success((Object)vo);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                SgStorageRollBackDto rollBackDto = new SgStorageRollBackDto();
                rollBackDto.setRollbackDBflag(true);
                rollBackDto.setRedisBillFtpKeyList(redisBillFtpKeyList);
                this.sgStorageRollBackBiz.rollbackStorageBill(rollBackDto);
                if (isOpenEffective.booleanValue()) {
                    SgStorageRollBackDto rollBackEffectiveDto = new SgStorageRollBackDto();
                    rollBackEffectiveDto.setRollbackDBflag(true);
                    rollBackEffectiveDto.setRedisBillFtpKeyList(redisBillFtpKeyListByBatchCode);
                    this.sgStorageEffectiveRollBackBiz.rollbackStorageBill(rollBackEffectiveDto);
                }
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                response = ApiResponse.failed((String)e.getMessage());
            }
            catch (Throwable throwable) {
                if (log.isDebugEnabled()) {
                    log.debug("Finish SgReceiveSaveBiz.saveSgBReceive.ReturnResult={};", (Object)JSONObject.toJSONString(response));
                }
                SgRedisLockUtils.unlock((RedisReentrantLock)lock, (String)lockKey, (Logger)log, (String)((Object)((Object)this)).getClass().getName());
                throw throwable;
            }
            if (log.isDebugEnabled()) {
                log.debug("Finish SgReceiveSaveBiz.saveSgBReceive.ReturnResult={};", (Object)JSONObject.toJSONString((Object)response));
            }
            SgRedisLockUtils.unlock((RedisReentrantLock)lock, (String)lockKey, (Logger)log, (String)((Object)((Object)this)).getClass().getName());
        }
        if (log.isDebugEnabled()) {
            log.debug("Finish SgReceiveSaveBiz.saveSgBReceive.ReturnResult={};", (Object)JSONObject.toJSONString((Object)response));
        }
        SgRedisLockUtils.unlock((RedisReentrantLock)lock, (String)lockKey, (Logger)log, (String)((Object)((Object)this)).getClass().getName());
        return response;
    }

    @LogAnnotation
    private SgBReceive saveOrUpdateRecord(SgReceiveBillSaveDto dto, SgBReceive originalReceive) {
        SgBReceive receive = new SgBReceive();
        try {
            boolean isAll = dto.getUpdateMethod() != null && dto.getUpdateMethod().intValue() == SgConstantsIF.ITEM_UPDATE_TYPE_ALL.intValue();
            BeanUtils.copyProperties((Object)dto.getMain(), (Object)receive);
            BigDecimal totalQtyPrein = BigDecimal.ZERO;
            BigDecimal totalQtyReceive = BigDecimal.ZERO;
            if (originalReceive != null) {
                totalQtyPrein = Optional.ofNullable(originalReceive.getTotQtyPrein()).orElse(BigDecimal.ZERO);
                totalQtyReceive = Optional.ofNullable(originalReceive.getTotQtyReceive()).orElse(BigDecimal.ZERO);
                if (originalReceive.getBillStatus().equals(ReceiveEnum.Status.PART_RECEIVE.getCode()) || originalReceive.getBillStatus().equals(ReceiveEnum.Status.ALL_RECEIVE.getCode())) {
                    receive.setBillStatus(ReceiveEnum.Status.PART_RECEIVE.getCode());
                } else {
                    receive.setBillStatus(ReceiveEnum.Status.UPDATE.getCode());
                }
            } else {
                receive.setBillStatus(ReceiveEnum.Status.CREATE.getCode());
                receive.setBillNo(this.orderNoBiz.getReceiveOrderNo());
            }
            receive.setId(originalReceive == null ? this.idSequenceGenerator.generateId(SgBReceive.class) : originalReceive.getId());
            ArrayList updateList = Lists.newArrayList();
            ArrayList insertList = Lists.newArrayList();
            Map<String, List<SgReceiveItemSaveDto>> itemMap = dto.getItemList().stream().collect(Collectors.groupingBy(o -> o.getPsCSkuId() + ":" + o.getCpCStoreId()));
            ArrayList itemSaveDtoList = Lists.newArrayList();
            for (String key : itemMap.keySet()) {
                List<SgReceiveItemSaveDto> itemList1 = itemMap.get(key);
                SgReceiveItemSaveDto itemSaveDto = itemList1.get(0);
                if (itemList1.size() > 1) {
                    BigDecimal qty = BigDecimal.ZERO;
                    BigDecimal qtyPreIn = BigDecimal.ZERO;
                    for (SgReceiveItemSaveDto item : itemList1) {
                        qty = qty.add(item.getQty());
                        qtyPreIn = qtyPreIn.add(item.getQtyPrein());
                    }
                    itemSaveDto.setQty(qty);
                    itemSaveDto.setQtyPrein(qtyPreIn);
                }
                itemSaveDtoList.add(itemSaveDto);
            }
            dto.setItemList((List)itemSaveDtoList);
            int itemSize = itemSaveDtoList.size();
            Long[] itemIdArr = this.tableIdBatchGet.batchGenerateId(SgBReceiveItem.class, itemSize);
            List skuIdList = itemSaveDtoList.stream().map(SgStoreBillItemBaseDto::getPsCSkuId).distinct().collect(Collectors.toList());
            Map skuInfoMap = this.psAdapter.getSkuInfoMap(skuIdList);
            Assert.notNull((Object)skuInfoMap, (String)("\u672a\u67e5\u8be2\u5230SKU\u4fe1\u606f\u3002skuIdList:" + JSON.toJSONString(skuIdList)));
            String thirdPartyType = "2";
            SgWarehouse sgWarehouse = this.sgWarehouseAdapter.getWarehouse(receive.getCpCPhyWarehouseId());
            Assert.notNull((Object)sgWarehouse, (String)("\u672a\u67e5\u8be2\u5230\u5b9e\u4f53\u4ed3\u4fe1\u606f \u5b9e\u4f53\u4ed3ID" + receive.getCpCPhyWarehouseId()));
            if (sgWarehouse.getCallType() != null) {
                thirdPartyType = sgWarehouse.getCallType().toString();
            }
            String ownerCode = sgWarehouse.getOwnerCode();
            for (int i = 0; i < itemSize; ++i) {
                SgReceiveItemSaveDto item = (SgReceiveItemSaveDto)itemSaveDtoList.get(i);
                SgBReceiveItem receiveItemEntity = this.receiveItemService.selectOne(receive.getId(), item);
                SgBReceiveItem receiveItem = new SgBReceiveItem();
                item.setId(null == receiveItemEntity ? itemIdArr[i] : receiveItemEntity.getId());
                item.setSgBReceiveId(receive.getId());
                QueryInteriorSkuVO skuVO = (QueryInteriorSkuVO)skuInfoMap.get(item.getPsCSkuId());
                if (skuVO != null) {
                    item.setWmsThirdCode(skuVO.getWmsThirdPlatformCode(thirdPartyType, ownerCode));
                }
                BeanUtils.copyProperties((Object)item, (Object)receiveItem);
                if (null == receiveItemEntity) {
                    this.initialService.initialInsertBaseDaoSystemValue((BaseDo)receiveItem, dto.getLoginUser());
                    insertList.add(receiveItem);
                } else {
                    totalQtyPrein = totalQtyPrein.subtract(receiveItemEntity.getQtyPrein());
                    totalQtyReceive = totalQtyReceive.subtract(receiveItemEntity.getQtyReceive());
                    BigDecimal originalPrein = Optional.ofNullable(receiveItemEntity.getQtyPrein()).orElse(BigDecimal.ZERO);
                    BigDecimal reqQtyPrein = Optional.ofNullable(item.getQtyPrein()).orElse(BigDecimal.ZERO);
                    receiveItem.setQtyPrein(isAll ? reqQtyPrein : originalPrein.add(reqQtyPrein));
                    BigDecimal originalQtyReceive = Optional.ofNullable(receiveItemEntity.getQtyReceive()).orElse(BigDecimal.ZERO);
                    BigDecimal reqQtyReceive = Optional.ofNullable(item.getQtyReceive()).orElse(BigDecimal.ZERO);
                    receiveItem.setQtyReceive(isAll ? originalQtyReceive : originalQtyReceive.add(reqQtyReceive));
                    BigDecimal originalQty = Optional.ofNullable(receiveItemEntity.getQty()).orElse(BigDecimal.ZERO);
                    BigDecimal reqQty = Optional.ofNullable(item.getQty()).orElse(BigDecimal.ZERO);
                    receiveItem.setQty(isAll ? originalQty : originalQty.add(reqQty));
                    this.initialService.initialUpdateBaseDaoSystemValue((BaseDo)receiveItem, dto.getLoginUser());
                    updateList.add(receiveItem);
                }
                totalQtyPrein = totalQtyPrein.add(receiveItem.getQtyPrein());
                totalQtyReceive = totalQtyReceive.add(receiveItem.getQtyReceive());
            }
            if (!CollectionUtils.isEmpty((Collection)insertList)) {
                this.receiveItemService.saveBatch((Collection)insertList, SgConstants.SG_COMMON_INSERT_PAGE_SIZE);
            }
            if (!CollectionUtils.isEmpty((Collection)updateList)) {
                this.receiveItemService.updateBatchById((Collection)updateList, 500);
            }
            if (dto.getIsOpenEffective().booleanValue()) {
                ArrayList sgBReceiveItemList = Lists.newArrayList();
                sgBReceiveItemList.addAll(insertList);
                sgBReceiveItemList.addAll(updateList);
                this.saveOrUpdateEffective(dto, receive, isAll, sgBReceiveItemList);
            }
            receive.setTotQtyPrein(totalQtyPrein);
            receive.setTotQtyReceive(totalQtyReceive);
            receive.setTotQty(totalQtyPrein.add(totalQtyReceive));
            if (null == originalReceive) {
                this.initialService.initialInsertBaseDaoSystemValue((BaseDo)receive, dto.getLoginUser());
            } else {
                this.initialService.initialUpdateBaseDaoSystemValue((BaseDo)receive, dto.getLoginUser());
            }
            this.receiveService.saveOrUpdate((Object)receive);
            if (originalReceive == null) {
                InnerLog.addLog((Long)receive.getId(), (String)"\u65b0\u589e\u6210\u529f", (String)"sg_b_receive", null, (String)"\u65b0\u589e");
                return receive;
            }
            InnerLog.addLog((Long)receive.getId(), (String)"\u4fee\u6539\u6210\u529f", (String)"sg_b_receive", null, (String)"\u4fee\u6539");
            return originalReceive;
        }
        catch (Exception e) {
            log.error("SgBReceive.saveOrUpdateRecord.Error", (Throwable)e);
            InnerLog.addLog((Long)receive.getId(), (String)("\u4fee\u6539\u5931\u8d25\uff1a" + e.getMessage()), (String)"sg_b_receive", null, (String)"\u4fee\u6539");
            throw new IllegalArgumentException("\u4fdd\u5b58\u903b\u8f91\u6536\u8d27\u5355\u5f02\u5e38:" + e.getMessage());
        }
    }

    public ApiResponse<SgBReceive> checkParams(SgReceiveBillSaveDto dto) {
        boolean anyMatch;
        SgReceiveSaveDto main = dto.getMain();
        if (main == null) {
            return ApiResponse.failed((String)"\u4e3b\u8868\u4e3a\u7a7a");
        }
        SgBReceive receive = null;
        if (main.getId() == null) {
            Integer sourceBillType = main.getSourceBillType();
            String sourceBillNo = main.getSourceBillNo();
            if (sourceBillType == null) {
                return ApiResponse.failed((String)"\u6765\u6e90\u5355\u636e\u7c7b\u578b\u548c\u6765\u6e90\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (main.getCpCPhyWarehouseId() == null || StringUtils.isEmpty((Object)main.getCpCPhyWarehouseEcode()) || StringUtils.isEmpty((Object)main.getCpCPhyWarehouseEname())) {
                return ApiResponse.failed((String)"\u5b9e\u4f53\u4ed3\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (main.getServiceNode() == null) {
                return ApiResponse.failed((String)"\u4e1a\u52a1\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            receive = this.receiveService.selectBySourceAndWareHouseAndRemark(sourceBillNo, sourceBillType, main.getCpCPhyWarehouseId(), main.getReserveVarchar08());
            if (receive != null && !StringUtils.isEmpty((Object)dto.getType())) {
                return ApiResponse.failed((String)"\u903b\u8f91\u6536\u8d27\u5355\u5df2\u5b58\u5728\uff01\uff01");
            }
        } else if (main.getId() != null) {
            receive = (SgBReceive)this.receiveService.getById((Serializable)main.getId());
            if (receive == null) {
                return ApiResponse.failed((String)"\u903b\u8f91\u6536\u8d27\u5355\u4e0d\u5b58\u5728\uff01");
            }
            main.setSourceBillId(receive.getSourceBillId());
            main.setSourceBillType(receive.getSourceBillType());
        }
        if (anyMatch = dto.getItemList().stream().anyMatch(itemSaveRequest -> itemSaveRequest.getPsCSkuId() == null || StringUtils.isEmpty((Object)itemSaveRequest.getPsCSkuEcode()) || itemSaveRequest.getSourceBillItemId() == null || itemSaveRequest.getCpCStoreId() == null || itemSaveRequest.getCpCPhyWarehouseId() == null)) {
            return ApiResponse.failed((String)"\u660e\u7ec6skuid\u3001\u6765\u6e90\u660e\u7ec6ID\u3001\u903b\u8f91\u4ed3\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a(0)!");
        }
        this.baiscCheck((SgBasicDto)dto);
        return ApiResponse.success((Object)receive);
    }

    public void saveOrUpdateEffective(SgReceiveBillSaveDto dto, SgBReceive receive, boolean isAll, List<SgBReceiveItem> sgBReceiveItemList) {
        ArrayList updateList = Lists.newArrayList();
        ArrayList insertList = Lists.newArrayList();
        Map<String, List<SgReceiveItemSaveDto>> itemMap = dto.getItemList().stream().collect(Collectors.groupingBy(o -> o.getPsCSkuId() + ":" + o.getCpCStoreId() + ":" + o.getBatchCode()));
        ArrayList itemSaveDtoList = Lists.newArrayList();
        for (String key : itemMap.keySet()) {
            List<SgReceiveItemSaveDto> itemList1 = itemMap.get(key);
            SgReceiveItemSaveDto itemSaveDto = itemList1.get(0);
            if (itemList1.size() > 1) {
                BigDecimal qty = BigDecimal.ZERO;
                BigDecimal qtyPreIn = BigDecimal.ZERO;
                for (SgReceiveItemSaveDto item : itemList1) {
                    qty = qty.add(item.getQty());
                    qtyPreIn = qtyPreIn.add(item.getQtyPrein());
                }
                itemSaveDto.setQty(qty);
                itemSaveDto.setQtyPrein(qtyPreIn);
            }
            itemSaveDtoList.add(itemSaveDto);
        }
        dto.setItemEffectiveList((List)itemSaveDtoList);
        int itemSize = itemSaveDtoList.size();
        Long[] itemIdArr = this.tableIdBatchGet.batchGenerateId(SgBReceiveEffectiveItem.class, itemSize);
        List skuIdList = itemSaveDtoList.stream().map(SgStoreBillItemBaseDto::getPsCSkuId).distinct().collect(Collectors.toList());
        Map skuInfoMap = this.psAdapter.getSkuInfoMap(skuIdList);
        Assert.notNull((Object)skuInfoMap, (String)("\u672a\u67e5\u8be2\u5230SKU\u4fe1\u606f\u3002skuIdList:" + JSON.toJSONString(skuIdList)));
        String thirdPartyType = "2";
        SgWarehouse sgWarehouse = this.sgWarehouseAdapter.getWarehouse(receive.getCpCPhyWarehouseId());
        Assert.notNull((Object)sgWarehouse, (String)("\u672a\u67e5\u8be2\u5230\u5b9e\u4f53\u4ed3\u4fe1\u606f \u5b9e\u4f53\u4ed3ID" + receive.getCpCPhyWarehouseId()));
        if (sgWarehouse.getCallType() != null) {
            thirdPartyType = sgWarehouse.getCallType().toString();
        }
        String ownerCode = sgWarehouse.getOwnerCode();
        for (int i = 0; i < itemSize; ++i) {
            SgReceiveItemSaveDto item = (SgReceiveItemSaveDto)itemSaveDtoList.get(i);
            SgBReceiveEffectiveItem receiveItemEntity = this.sgBReceiveEffectiveItemService.selectOne(receive.getId(), item);
            SgBReceiveEffectiveItem receiveItem = new SgBReceiveEffectiveItem();
            item.setId(null == receiveItemEntity ? itemIdArr[i] : receiveItemEntity.getId());
            item.setSgBReceiveId(receive.getId());
            SgBReceiveItem sgBReceiveItem = (SgBReceiveItem)sgBReceiveItemList.stream().filter(o -> o.getCpCStoreId().equals(item.getCpCStoreId()) && o.getPsCSkuId().equals(item.getPsCSkuId())).collect(Collectors.toList()).get(0);
            receiveItem.setSgBReceiveItemId(sgBReceiveItem.getId());
            QueryInteriorSkuVO skuVO = (QueryInteriorSkuVO)skuInfoMap.get(item.getPsCSkuId());
            if (skuVO != null) {
                item.setWmsThirdCode(skuVO.getWmsThirdPlatformCode(thirdPartyType, ownerCode));
            }
            BeanUtils.copyProperties((Object)item, (Object)receiveItem);
            if (null == receiveItemEntity) {
                this.initialService.initialInsertBaseDaoSystemValue((BaseDo)receiveItem, dto.getLoginUser());
                insertList.add(receiveItem);
                continue;
            }
            BigDecimal originalPrein = Optional.ofNullable(receiveItemEntity.getQtyPrein()).orElse(BigDecimal.ZERO);
            BigDecimal reqQtyPrein = Optional.ofNullable(item.getQtyPrein()).orElse(BigDecimal.ZERO);
            receiveItem.setQtyPrein(isAll ? reqQtyPrein : originalPrein.add(reqQtyPrein));
            BigDecimal originalQtyReceive = Optional.ofNullable(receiveItemEntity.getQtyReceive()).orElse(BigDecimal.ZERO);
            BigDecimal reqQtyReceive = Optional.ofNullable(item.getQtyReceive()).orElse(BigDecimal.ZERO);
            receiveItem.setQtyReceive(isAll ? originalQtyReceive : originalQtyReceive.add(reqQtyReceive));
            BigDecimal originalQty = Optional.ofNullable(receiveItemEntity.getQty()).orElse(BigDecimal.ZERO);
            BigDecimal reqQty = Optional.ofNullable(item.getQty()).orElse(BigDecimal.ZERO);
            receiveItem.setQty(isAll ? originalQty : originalQty.add(reqQty));
            this.initialService.initialUpdateBaseDaoSystemValue((BaseDo)receiveItem, dto.getLoginUser());
            updateList.add(receiveItem);
        }
        if (!CollectionUtils.isEmpty((Collection)insertList)) {
            this.sgBReceiveEffectiveItemService.saveBatch((Collection)insertList, SgConstants.SG_COMMON_INSERT_PAGE_SIZE);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.sgBReceiveEffectiveItemService.updateBatchById((Collection)updateList, 500);
        }
    }
}

