/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.receive;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.bizlog.annotation.LogAnnotation;
import com.xinqiyi.framework.bizlog.entity.InnerLog;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.redis.lock.RedisReentrantLock;
import com.xinqiyi.sg.basic.api.model.vo.SgStorageBatchUpdateVo;
import com.xinqiyi.sg.basic.model.common.ReceiveEnum;
import com.xinqiyi.sg.basic.model.dto.SgBasicDto;
import com.xinqiyi.sg.basic.model.dto.SgStorageRollBackDto;
import com.xinqiyi.sg.basic.service.business.SgBasicCheckBiz;
import com.xinqiyi.sg.basic.service.business.SgStorageEffectiveRollBackBiz;
import com.xinqiyi.sg.basic.service.business.SgStorageRollBackBiz;
import com.xinqiyi.sg.basic.service.utils.QtyUtils;
import com.xinqiyi.sg.basic.service.utils.SgRedisLockUtils;
import com.xinqiyi.sg.store.api.model.vo.receive.SgReceiveBillSubmitVo;
import com.xinqiyi.sg.store.model.dto.receive.SgReceiveBillSubmitDto;
import com.xinqiyi.sg.store.model.dto.receive.SgReceiveItemSubmitDto;
import com.xinqiyi.sg.store.model.entity.SgBReceive;
import com.xinqiyi.sg.store.model.entity.SgBReceiveEffectiveItem;
import com.xinqiyi.sg.store.model.entity.SgBReceiveItem;
import com.xinqiyi.sg.store.service.SgBReceiveEffectiveItemService;
import com.xinqiyi.sg.store.service.SgBReceiveItemService;
import com.xinqiyi.sg.store.service.SgBReceiveService;
import com.xinqiyi.sg.store.service.business.SgStoreStorageBiz;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class SgReceiveSubmitBiz
extends SgBasicCheckBiz {
    private static final Logger log = LoggerFactory.getLogger(SgReceiveSubmitBiz.class);
    @Resource
    SgBReceiveService receiveService;
    @Resource
    SgStorageRollBackBiz sgStorageRollBackBiz;
    @Resource
    SgBReceiveItemService receiveItemService;
    @Resource
    SgBReceiveEffectiveItemService sgBReceiveEffectiveItemService;
    @Resource
    SgStoreStorageBiz sgStoreStorageBiz;
    @Resource
    BaseDaoInitialService initialService;
    @Autowired
    private SgStorageEffectiveRollBackBiz sgStorageEffectiveRollBackBiz;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    @LogAnnotation
    public ApiResponse<SgReceiveBillSubmitVo> submitSgBReceive(SgReceiveBillSubmitDto dto) {
        ApiResponse<SgBReceive> checkResponse;
        if (log.isDebugEnabled()) {
            log.debug("Start SgReceiveSubmitBiz.submitSgBReceive.request={};", (Object)JSONObject.toJSONString((Object)dto));
        }
        if (!(checkResponse = this.checkParams(dto)).isSuccess()) {
            return ApiResponse.failed((String)checkResponse.getDesc());
        }
        List redisBillFtpKeyList = dto.getRedisBillFtpKeyList();
        List redisBillFtpKeyListByBatchCode = dto.getRedisBillFtpKeyListByBatchCode();
        String lockKey = "sg_b_receive:" + dto.getMain().getSourceBillNo() + ":" + dto.getMain().getSourceBillType();
        RedisReentrantLock lock = SgRedisLockUtils.lock((String)lockKey);
        SgReceiveBillSubmitVo vo = new SgReceiveBillSubmitVo();
        SgBReceive orgReceive = (SgBReceive)checkResponse.getContent();
        try {
            Map<Long, List<SgBReceiveItem>> itemQtyMap = this.receiveItemService.selectListByParentId(orgReceive.getId()).stream().collect(Collectors.groupingBy(SgBReceiveItem::getPsCSkuId));
            ArrayList storageItemList = Lists.newArrayList();
            ArrayList storageEffectiveItemList = Lists.newArrayList();
            BigDecimal totQtyPrein = orgReceive.getTotQtyPrein();
            BigDecimal totQtyReceive = orgReceive.getTotQtyReceive();
            for (SgReceiveItemSubmitDto reqItem : dto.getItemList()) {
                List<SgBReceiveItem> orgItemList;
                if (!itemQtyMap.containsKey(reqItem.getPsCSkuId()) || (orgItemList = itemQtyMap.get(reqItem.getPsCSkuId())) == null) continue;
                BigDecimal totQtyIn = reqItem.getQtyIn();
                BigDecimal totItemQtyPrein = orgItemList.stream().map(SgBReceiveItem::getQtyPrein).reduce(BigDecimal.ZERO, BigDecimal::add);
                Map<Long, BigDecimal> itemInMap = SgReceiveSubmitBiz.getQtyIn(totQtyIn, orgItemList, totItemQtyPrein);
                BigDecimal deductionQtyPrein = reqItem.getDeductionQtyPrein();
                boolean isAll = deductionQtyPrein.compareTo(totItemQtyPrein) == 0;
                HashMap updateItemMap = Maps.newHashMap();
                HashMap storageItemMap = Maps.newHashMap();
                for (SgBReceiveItem storageItem : orgItemList) {
                    storageItemMap.put(storageItem.getId(), storageItem);
                    if (!itemInMap.containsKey(storageItem.getId())) continue;
                    SgBReceiveItem updateItem = new SgBReceiveItem();
                    updateItem.setId(storageItem.getId());
                    BigDecimal qtyIn = itemInMap.get(storageItem.getId());
                    updateItem.setQtyReceive(storageItem.getQtyReceive().add(qtyIn));
                    totQtyReceive = totQtyReceive.add(qtyIn);
                    storageItem.setQtyReceive(qtyIn);
                    updateItem.setQtyPrein(isAll ? BigDecimal.ZERO : storageItem.getQtyPrein().subtract(qtyIn));
                    storageItem.setQtyPrein(isAll ? storageItem.getQtyPrein() : qtyIn);
                    totQtyPrein = totQtyPrein.subtract(storageItem.getQtyPrein());
                    deductionQtyPrein = deductionQtyPrein.subtract(storageItem.getQtyPrein());
                    this.initialService.initialUpdateBaseDaoSystemValue((BaseDo)updateItem, dto.getLoginUser());
                    updateItemMap.put(storageItem.getId(), updateItem);
                }
                ArrayList updateItemList = Lists.newArrayList();
                if (deductionQtyPrein.compareTo(BigDecimal.ZERO) > 0) {
                    Map<Long, BigDecimal> itemPreinMap = SgReceiveSubmitBiz.getQtyIn(deductionQtyPrein, orgItemList, totItemQtyPrein);
                    for (Long id : itemPreinMap.keySet()) {
                        BigDecimal qtyPrein = itemPreinMap.get(id);
                        if (updateItemMap.containsKey(id)) {
                            updateItem = (SgBReceiveItem)updateItemMap.get(id);
                            storageItem = (SgBReceiveItem)storageItemMap.get(id);
                            updateItem.setQtyPrein(updateItem.getQtyPrein().subtract(qtyPrein));
                            storageItem.setQtyPrein(storageItem.getQtyPrein().add(qtyPrein));
                            updateItemList.add(updateItem);
                            storageItemList.add(storageItem);
                            updateItemMap.remove(id);
                        } else {
                            updateItem = new SgBReceiveItem();
                            updateItem.setId(id);
                            storageItem = (SgBReceiveItem)storageItemMap.get(id);
                            updateItem.setQtyPrein(storageItem.getQtyPrein().subtract(qtyPrein));
                            storageItem.setQtyPrein(qtyPrein);
                            storageItem.setQtyReceive(BigDecimal.ZERO);
                            updateItemList.add(updateItem);
                            storageItemList.add(storageItem);
                        }
                        totQtyPrein = totQtyPrein.subtract(qtyPrein);
                        deductionQtyPrein = deductionQtyPrein.subtract(qtyPrein);
                    }
                }
                for (SgBReceiveItem updateItem : updateItemMap.values()) {
                    updateItemList.add(updateItem);
                    SgBReceiveItem orgItem = (SgBReceiveItem)storageItemMap.get(updateItem.getId());
                    storageItemList.add(orgItem);
                }
                this.receiveItemService.updateBatchById((Collection)updateItemList);
            }
            if (dto.getIsOpenEffective().booleanValue()) {
                this.updateReceiverEffectiveItem(orgReceive.getId(), storageEffectiveItemList, dto);
            }
            SgBReceive update = new SgBReceive();
            update.setId(orgReceive.getId());
            update.setTotQtyReceive(totQtyReceive);
            update.setTotQtyPrein(totQtyPrein);
            if (update.getTotQtyPrein().compareTo(BigDecimal.ZERO) == 0) {
                update.setBillStatus(ReceiveEnum.Status.ALL_RECEIVE.getCode());
            } else {
                update.setBillStatus(ReceiveEnum.Status.PART_RECEIVE.getCode());
            }
            update.setReceiveTime(dto.getMain().getInTime());
            orgReceive.setServiceNode(dto.getMain().getServiceNode());
            update.setServiceNode(dto.getMain().getServiceNode());
            this.initialService.initialUpdateBaseDaoSystemValue((BaseDo)update, dto.getLoginUser());
            this.receiveService.updateById((Object)update);
            ApiResponse<SgStorageBatchUpdateVo> storageResponse = this.sgStoreStorageBiz.submitReceiveStoragePrein(orgReceive, storageItemList, null, dto.getIsNegativePrein(), dto.getMain().getPhyInNoticesId(), dto.getMain().getPhyInNoticesBillno(), storageEffectiveItemList, dto.getIsOpenEffective());
            if (storageResponse.isSuccess()) {
                vo.setRedisBillFtpKeyList(((SgStorageBatchUpdateVo)storageResponse.getContent()).getRedisBillFtpKeyList());
                if (dto.getIsOpenEffective().booleanValue() && CollectionUtils.isNotEmpty((Collection)((SgStorageBatchUpdateVo)storageResponse.getContent()).getSgStorageEffectiveBatchUpdateVo().getRedisBillFtpKeyList())) {
                    vo.setRedisBillFtpKeyListByBatchCode(((SgStorageBatchUpdateVo)storageResponse.getContent()).getSgStorageEffectiveBatchUpdateVo().getRedisBillFtpKeyList());
                }
            } else {
                throw new IllegalArgumentException(storageResponse.getDesc());
            }
            log.info("SgReceiveSubmitBiz.orgReceive.id={}", (Object)orgReceive.getId());
            if (StringUtils.isNotEmpty((CharSequence)dto.getResultBillNo())) {
                InnerLog.addLog((Long)orgReceive.getId(), (String)(ReceiveEnum.Status.getName((Integer)update.getBillStatus()) + "\uff08\u5165\u5e93\u7ed3\u679c\u5355\uff1a" + dto.getResultBillNo() + "\uff09"), (String)"sg_b_receive", null, (String)"\u63d0\u4ea4");
            } else {
                InnerLog.addLog((Long)orgReceive.getId(), (String)(ReceiveEnum.Status.getName((Integer)update.getBillStatus()) + "\uff08\u5165\u5e93\u901a\u77e5\u5355\uff1a" + dto.getNoticeBillNo() + "\u5b8c\u6210\u529f\u80fd\uff09"), (String)"sg_b_receive", null, (String)"\u63d0\u4ea4");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SgStorageRollBackDto rollBackDto = new SgStorageRollBackDto();
            rollBackDto.setRollbackDBflag(true);
            rollBackDto.setRedisBillFtpKeyList(redisBillFtpKeyList);
            this.sgStorageRollBackBiz.rollbackStorageBill(rollBackDto);
            if (dto.getIsOpenEffective().booleanValue()) {
                SgStorageRollBackDto rollBackEffectiveDto = new SgStorageRollBackDto();
                rollBackEffectiveDto.setRollbackDBflag(true);
                rollBackEffectiveDto.setRedisBillFtpKeyList(redisBillFtpKeyListByBatchCode);
                this.sgStorageEffectiveRollBackBiz.rollbackStorageBill(rollBackEffectiveDto);
            }
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            InnerLog.addLog((Long)orgReceive.getId(), (String)("\u63d0\u4ea4\u5931\u8d25\uff08\u5165\u5e93\u7ed3\u679c\u5355\uff1a" + dto.getResultBillNo() + "\uff09" + e.getMessage()), (String)"sg_b_phy_in_notices", null, (String)"\u63d0\u4ea4");
            ApiResponse apiResponse = ApiResponse.failed((String)e.getMessage());
            return apiResponse;
        }
        finally {
            SgRedisLockUtils.unlock((RedisReentrantLock)lock, (String)lockKey, (Logger)log, (String)((Object)((Object)this)).getClass().getName());
        }
        if (log.isDebugEnabled()) {
            log.debug("End SgReceiveSubmitBiz.submitSgBReceive.result={};", (Object)JSONObject.toJSONString((Object)vo));
        }
        return ApiResponse.success((Object)vo, (String)"\u63d0\u4ea4\u6210\u529f\uff01");
    }

    public ApiResponse<SgBReceive> checkParams(SgReceiveBillSubmitDto dto) {
        ApiResponse response = new ApiResponse("000", "");
        if (dto.getMain() == null || dto.getMain().getSourceBillType() == null) {
            return ApiResponse.failed((String)"\u6765\u6e90\u5355\u636e\u7c7b\u578b\u548c\u6765\u6e90\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (dto.getItemList() == null) {
            return ApiResponse.failed((String)"\u660e\u7ec6\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SgBReceive orgReceive = this.receiveService.selectBySourceAndWareHouseAndRemark(dto.getMain().getSourceBillNo(), dto.getMain().getSourceBillType(), dto.getMain().getCpCPhyWarehouseId(), dto.getReserveVarchar08());
        if (orgReceive == null) {
            return ApiResponse.failed((String)"\u903b\u8f91\u6536\u8d27\u5355\u4e0d\u5b58\u5728");
        }
        if (ReceiveEnum.Status.ALL_RECEIVE.getCode().equals(orgReceive.getBillStatus()) || ReceiveEnum.Status.CANCELED.getCode().equals(orgReceive.getBillStatus())) {
            return ApiResponse.failed((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0\uff01");
        }
        response.setContent((Object)orgReceive);
        this.baiscCheck((SgBasicDto)dto);
        return response;
    }

    public static Map<Long, BigDecimal> getQtyIn(BigDecimal totQtyIn, List<SgBReceiveItem> orgItemList, BigDecimal totItemQtyPrein) {
        BigDecimal totSurplusQty = totQtyIn;
        HashMap itemPreinMap = Maps.newHashMap();
        while (totSurplusQty.compareTo(BigDecimal.ZERO) > 0) {
            boolean flag = true;
            for (SgBReceiveItem orgItem : orgItemList) {
                BigDecimal qtyIn;
                BigDecimal qtyPrein = orgItem.getQtyPrein();
                if (qtyPrein.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal radio = orgItem.getQtyPrein().divide(totItemQtyPrein, 4, 4);
                if (itemPreinMap.containsKey(orgItem.getId())) {
                    qtyPrein = qtyPrein.subtract((BigDecimal)itemPreinMap.get(orgItem.getId()));
                }
                if ((qtyIn = QtyUtils.getItemQtyoutByRadio((BigDecimal)totSurplusQty, (BigDecimal)qtyPrein, (BigDecimal)totQtyIn, (BigDecimal)radio)).compareTo(BigDecimal.ZERO) > 0) {
                    flag = false;
                }
                itemPreinMap.put(orgItem.getId(), itemPreinMap.containsKey(orgItem.getId()) ? ((BigDecimal)itemPreinMap.get(orgItem.getId())).add(qtyIn) : qtyIn);
                if ((totSurplusQty = totSurplusQty.subtract(qtyIn)).compareTo(BigDecimal.ZERO) != 0) continue;
                break;
            }
            if (!flag) continue;
            break;
        }
        return itemPreinMap;
    }

    private void updateReceiverEffectiveItem(Long orgReceiveId, List<SgBReceiveEffectiveItem> storageEffectiveItemList, SgReceiveBillSubmitDto dto) {
        Map<String, List<SgBReceiveEffectiveItem>> itemQtyMap = this.sgBReceiveEffectiveItemService.selectListByParentId(orgReceiveId).stream().collect(Collectors.groupingBy(item -> item.getPsCSkuId() + "_" + item.getBatchCode()));
        for (SgReceiveItemSubmitDto reqItem : dto.getItemEffectiveList()) {
            List<SgBReceiveEffectiveItem> orgItemList;
            if (!itemQtyMap.containsKey(reqItem.getPsCSkuId() + "_" + reqItem.getBatchCode()) || (orgItemList = itemQtyMap.get(reqItem.getPsCSkuId() + "_" + reqItem.getBatchCode())) == null) continue;
            BigDecimal totQtyIn = reqItem.getQtyIn();
            BigDecimal totItemQtyPrein = orgItemList.stream().map(SgBReceiveEffectiveItem::getQtyPrein).reduce(BigDecimal.ZERO, BigDecimal::add);
            Map<Long, BigDecimal> itemInMap = SgReceiveSubmitBiz.getQtyInEffective(totQtyIn, orgItemList, totItemQtyPrein);
            BigDecimal deductionQtyPrein = reqItem.getDeductionQtyPrein();
            boolean isAll = deductionQtyPrein.compareTo(totItemQtyPrein) == 0;
            HashMap updateItemMap = Maps.newHashMap();
            HashMap storageItemMap = Maps.newHashMap();
            for (SgBReceiveEffectiveItem storageItem : orgItemList) {
                storageItemMap.put(storageItem.getId(), storageItem);
                if (!itemInMap.containsKey(storageItem.getId())) continue;
                SgBReceiveEffectiveItem updateItem = new SgBReceiveEffectiveItem();
                updateItem.setId(storageItem.getId());
                BigDecimal qtyIn = itemInMap.get(storageItem.getId());
                updateItem.setQtyReceive(storageItem.getQtyReceive().add(qtyIn));
                storageItem.setQtyReceive(qtyIn);
                updateItem.setQtyPrein(isAll ? BigDecimal.ZERO : storageItem.getQtyPrein().subtract(qtyIn));
                storageItem.setQtyPrein(isAll ? storageItem.getQtyPrein() : qtyIn);
                deductionQtyPrein = deductionQtyPrein.subtract(storageItem.getQtyPrein());
                this.initialService.initialUpdateBaseDaoSystemValue((BaseDo)updateItem, dto.getLoginUser());
                updateItemMap.put(storageItem.getId(), updateItem);
            }
            ArrayList updateItemList = Lists.newArrayList();
            if (deductionQtyPrein.compareTo(BigDecimal.ZERO) > 0) {
                Map<Long, BigDecimal> itemPreinMap = SgReceiveSubmitBiz.getQtyInEffective(deductionQtyPrein, orgItemList, totItemQtyPrein);
                for (Long id : itemPreinMap.keySet()) {
                    BigDecimal qtyPrein = itemPreinMap.get(id);
                    if (updateItemMap.containsKey(id)) {
                        updateItem = (SgBReceiveEffectiveItem)updateItemMap.get(id);
                        storageItem = (SgBReceiveEffectiveItem)storageItemMap.get(id);
                        updateItem.setQtyPrein(updateItem.getQtyPrein().subtract(qtyPrein));
                        storageItem.setQtyPrein(storageItem.getQtyPrein().add(qtyPrein));
                        updateItemList.add(updateItem);
                        storageEffectiveItemList.add(storageItem);
                        updateItemMap.remove(id);
                    } else {
                        updateItem = new SgBReceiveEffectiveItem();
                        updateItem.setId(id);
                        storageItem = (SgBReceiveEffectiveItem)storageItemMap.get(id);
                        updateItem.setQtyPrein(storageItem.getQtyPrein().subtract(qtyPrein));
                        storageItem.setQtyPrein(qtyPrein);
                        storageItem.setQtyReceive(BigDecimal.ZERO);
                        updateItemList.add(updateItem);
                        storageEffectiveItemList.add(storageItem);
                    }
                    deductionQtyPrein = deductionQtyPrein.subtract(qtyPrein);
                }
            }
            for (SgBReceiveEffectiveItem updateItem : updateItemMap.values()) {
                updateItemList.add(updateItem);
                SgBReceiveEffectiveItem orgItem = (SgBReceiveEffectiveItem)storageItemMap.get(updateItem.getId());
                storageEffectiveItemList.add(orgItem);
            }
            this.sgBReceiveEffectiveItemService.updateBatchById((Collection)updateItemList);
        }
    }

    public static Map<Long, BigDecimal> getQtyInEffective(BigDecimal totQtyIn, List<SgBReceiveEffectiveItem> orgItemList, BigDecimal totItemQtyPrein) {
        BigDecimal totSurplusQty = totQtyIn;
        HashMap itemPreinMap = Maps.newHashMap();
        while (totSurplusQty.compareTo(BigDecimal.ZERO) > 0) {
            boolean flag = true;
            for (SgBReceiveEffectiveItem orgItem : orgItemList) {
                BigDecimal qtyIn;
                BigDecimal qtyPrein = orgItem.getQtyPrein();
                if (qtyPrein.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal radio = orgItem.getQtyPrein().divide(totItemQtyPrein, 4, 4);
                if (itemPreinMap.containsKey(orgItem.getId())) {
                    qtyPrein = qtyPrein.subtract((BigDecimal)itemPreinMap.get(orgItem.getId()));
                }
                if ((qtyIn = QtyUtils.getItemQtyoutByRadio((BigDecimal)totSurplusQty, (BigDecimal)qtyPrein, (BigDecimal)totQtyIn, (BigDecimal)radio)).compareTo(BigDecimal.ZERO) > 0) {
                    flag = false;
                }
                itemPreinMap.put(orgItem.getId(), itemPreinMap.containsKey(orgItem.getId()) ? ((BigDecimal)itemPreinMap.get(orgItem.getId())).add(qtyIn) : qtyIn);
                if ((totSurplusQty = totSurplusQty.subtract(qtyIn)).compareTo(BigDecimal.ZERO) != 0) continue;
                break;
            }
            if (!flag) continue;
            break;
        }
        return itemPreinMap;
    }
}

