/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.send;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.bizlog.entity.InnerLog;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.redis.lock.RedisReentrantLock;
import com.xinqiyi.framework.util.BeanConvertUtil;
import com.xinqiyi.sg.basic.enums.SgYesOrNoEnum;
import com.xinqiyi.sg.basic.model.common.SgBizEnum;
import com.xinqiyi.sg.basic.model.dto.SgStorageLogicUpdateResultDTO;
import com.xinqiyi.sg.basic.model.dto.out.SgOutBillDto;
import com.xinqiyi.sg.basic.model.dto.out.SgOutItemSaveDto;
import com.xinqiyi.sg.basic.model.dto.out.SgOutMainDto;
import com.xinqiyi.sg.basic.model.dto.storage.SgStorageMergeItemDto;
import com.xinqiyi.sg.basic.model.entity.SgPreOccupationOrder;
import com.xinqiyi.sg.basic.model.entity.SgPreOccupationOrderItem;
import com.xinqiyi.sg.basic.model.entity.SgPreOccupationOrderUsedItem;
import com.xinqiyi.sg.basic.service.SgBStorageService;
import com.xinqiyi.sg.basic.service.SgPreOccupationOrderItemService;
import com.xinqiyi.sg.basic.service.SgPreOccupationOrderService;
import com.xinqiyi.sg.basic.service.SgPreOccupationOrderUsedItemService;
import com.xinqiyi.sg.basic.service.business.SgStorageRollBackBiz;
import com.xinqiyi.sg.basic.service.utils.SgRedisLockUtils;
import com.xinqiyi.sg.store.model.dto.send.SgSendOccupyDto;
import com.xinqiyi.sg.store.model.dto.send.SgStorageCancelMergeSplitMappingDto;
import com.xinqiyi.sg.store.model.entity.SgSend;
import com.xinqiyi.sg.store.model.entity.SgSendItem;
import com.xinqiyi.sg.store.service.SgSendItemService;
import com.xinqiyi.sg.store.service.SgSendService;
import com.xinqiyi.sg.store.service.business.common.SgPreOccupationOccupyCommonBiz;
import com.xinqiyi.sg.store.service.business.send.restructure.SgSendCommonBiz;
import com.xinqiyi.sg.store.service.business.send.restructure.SgSendOccupyBiz;
import com.xinqiyi.sg.warehouse.model.dto.enums.SgPreOccupationOrderBillStatusEnum;
import com.xinqiyi.sg.warehouse.model.dto.preOccupation.SgPreOccupationInfoDTO;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SgPreOccupationReleaseCommonBiz {
    private static final Logger log = LoggerFactory.getLogger(SgPreOccupationReleaseCommonBiz.class);
    @Autowired
    private SgPreOccupationOrderService sgPreOccupationOrderService;
    @Autowired
    private SgPreOccupationOrderItemService sgPreOccupationOrderItemService;
    @Autowired
    private SgPreOccupationOrderUsedItemService sgPreOccupationOrderUsedItemService;
    @Resource
    private SgSendOccupyBiz sgSendOccupyBiz;
    @Resource
    private SgSendService sgSendService;
    @Resource
    private SgSendItemService sgSendItemService;
    @Autowired
    SgBStorageService storageService;
    @Autowired
    SgStorageRollBackBiz sgStorageRollBackBiz;
    @Resource
    private SgPreOccupationOccupyCommonBiz sgPreOccupationOccupyCommonBiz;
    @Autowired
    BaseDaoInitialService initialService;

    public void preOccupyRelease(SgOutBillDto dto, SgOutMainDto paramMain, Map<String, SgOutItemSaveDto> outItemMap, List<String> skuCodeList, Map<Long, List<SgPreOccupationOrderUsedItem>> usedItemMapByPreOrderId, Map<Long, SgPreOccupationInfoDTO> preOrderInfoMap, List<Long> usedItemIds, List<SgOutItemSaveDto> orderRelease) {
        List validUsedItemList = this.sgPreOccupationOrderUsedItemService.listByIds(usedItemIds);
        ArrayList preOrderReleaseList = Lists.newArrayList();
        Map<String, List<SgSendItem>> orderSendItemMap = this.getOrderSendItemMap(dto, skuCodeList);
        if (CollUtil.isEmpty(outItemMap)) {
            log.info("\u8ba2\u5355\u672a\u67e5\u8be2\u5230\u6709\u6548\u903b\u8f91\u53d1\u8d27\u5355,ocOrderNo:{}, sourceBillNo\uff1a{}", (Object)paramMain.getOrderNo(), (Object)paramMain.getSourceBillNo());
            return;
        }
        Map<String, List<SgPreOccupationOrderUsedItem>> usedItemMapBySku = validUsedItemList.stream().collect(Collectors.groupingBy(SgPreOccupationOrderUsedItem::getPsCSkuEcode));
        this.buildReleaseList(outItemMap, preOrderReleaseList, orderRelease, orderSendItemMap, usedItemMapBySku);
        if (log.isDebugEnabled()) {
            log.debug("SgPreOccupationReleaseCommonBiz.preOccupyRelease \u8ba1\u7b97\u91ca\u653e\u6570 outItemMap:{} preOrderReleaseList:{} orderRelease:{} orderSendItemMap:{} usedItemMapBySku:{}", new Object[]{JSON.toJSONString(outItemMap), JSON.toJSONString((Object)preOrderReleaseList), JSON.toJSONString(orderRelease), JSON.toJSONString(orderSendItemMap), JSON.toJSONString(usedItemMapBySku)});
        }
        Map<Long, List<SgPreOccupationOrderUsedItem>> preOrderReleaseListMapByPreOrder = preOrderReleaseList.stream().collect(Collectors.groupingBy(SgPreOccupationOrderUsedItem::getSgPreOccupationOrderId));
        for (Map.Entry<Long, List<SgPreOccupationOrderUsedItem>> entry : preOrderReleaseListMapByPreOrder.entrySet()) {
            Long key = entry.getKey();
            List<SgPreOccupationOrderUsedItem> value = entry.getValue();
            this.preOccupationSend(value, preOrderInfoMap.get(key), dto.getUserInfo(), paramMain);
        }
        this.orderOccupationReleaseSend(paramMain, preOrderInfoMap, usedItemMapByPreOrderId, preOrderReleaseList, dto.getUserInfo());
    }

    public List<SgPreOccupationOrder> getValidPreOccupationOrders(Map<Long, List<SgPreOccupationOrderUsedItem>> usedItemMapByPreOrderId) {
        List preOccupationOrders = this.sgPreOccupationOrderService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SgPreOccupationOrder::getId, usedItemMapByPreOrderId.keySet())).eq(BaseDo::getIsDelete, (Object)false)).eq(BaseDo::getIsDelete, (Object)false)).eq(SgPreOccupationOrder::getBillStatus, (Object)SgPreOccupationOrderBillStatusEnum.AUDITED.getCode()));
        return preOccupationOrders;
    }

    public List<SgPreOccupationOrderUsedItem> getUsedItemList(Long ocOrderId, Integer sourceBillType, List<String> skuCodeList) {
        List usedItemList = this.sgPreOccupationOrderUsedItemService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SgPreOccupationOrderUsedItem::getOmsOcOrderId, (Object)ocOrderId)).eq(SgPreOccupationOrderUsedItem::getSourceBillType, (Object)sourceBillType)).in(SgPreOccupationOrderUsedItem::getPsCSkuEcode, skuCodeList)).eq(BaseDo::getIsDelete, (Object)false));
        return usedItemList;
    }

    public void buildReleaseList(Map<String, SgOutItemSaveDto> outItemMap, List<SgPreOccupationOrderUsedItem> preOrderRelease, List<SgOutItemSaveDto> orderRelease, Map<String, List<SgSendItem>> orderSendItemMap, Map<String, List<SgPreOccupationOrderUsedItem>> usedItemMapBySku) {
        block0: for (Map.Entry<String, SgOutItemSaveDto> entry : outItemMap.entrySet()) {
            String key = entry.getKey();
            SgOutItemSaveDto value = entry.getValue();
            BigDecimal totalReleaseQty = value.getQty();
            List<SgSendItem> sgSendItems = orderSendItemMap.get(key);
            BigDecimal totalQtyPreOutDB = sgSendItems.stream().map(SgSendItem::getQtyPreOut).reduce(BigDecimal.ZERO, BigDecimal::add);
            ApiResponse<Void> checkReleaseRational = this.checkReleaseRational(key, totalReleaseQty, totalQtyPreOutDB);
            Assert.isTrue((boolean)checkReleaseRational.isSuccess(), (String)checkReleaseRational.getDesc(), (Object[])new Object[0]);
            List<SgPreOccupationOrderUsedItem> usedItems = usedItemMapBySku.get(key);
            if (CollUtil.isEmpty(usedItems)) {
                orderRelease.add(value);
                continue;
            }
            BigDecimal totalUsedQty = usedItems.stream().map(SgPreOccupationOrderUsedItem::getQty).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal orderPreOutQty = totalQtyPreOutDB.subtract(totalUsedQty);
            if (totalReleaseQty.compareTo(orderPreOutQty) <= 0) {
                orderRelease.add(value);
                continue;
            }
            if (BigDecimal.ZERO.compareTo(orderPreOutQty) != 0) {
                SgOutItemSaveDto outItemSaveDto = new SgOutItemSaveDto();
                BeanConvertUtil.copyProperties((Object)value, (Object)outItemSaveDto);
                outItemSaveDto.setQty(orderPreOutQty);
                orderRelease.add(outItemSaveDto);
            }
            BigDecimal usedReleaseQty = totalReleaseQty.subtract(orderPreOutQty);
            for (SgPreOccupationOrderUsedItem usedItem : usedItems) {
                SgPreOccupationOrderUsedItem releaseItem;
                BigDecimal subtractResult = usedReleaseQty.subtract(usedItem.getQty());
                if (subtractResult.compareTo(BigDecimal.ZERO) <= 0) {
                    releaseItem = new SgPreOccupationOrderUsedItem();
                    BeanConvertUtil.copyProperties((Object)usedItem, (Object)releaseItem);
                    releaseItem.setId(usedItem.getId());
                    if (subtractResult.compareTo(BigDecimal.ZERO) == 0) {
                        releaseItem.setIsDelete(SgYesOrNoEnum.YES.getValue());
                    }
                    releaseItem.setQty(subtractResult.negate());
                    releaseItem.setReleaseQty(usedReleaseQty);
                    preOrderRelease.add(releaseItem);
                    continue block0;
                }
                releaseItem = new SgPreOccupationOrderUsedItem();
                BeanConvertUtil.copyProperties((Object)usedItem, (Object)releaseItem);
                releaseItem.setId(usedItem.getId());
                releaseItem.setIsDelete(SgYesOrNoEnum.YES.getValue());
                releaseItem.setQty(usedItem.getQty());
                releaseItem.setReleaseQty(usedItem.getQty());
                preOrderRelease.add(releaseItem);
                usedReleaseQty = subtractResult;
            }
        }
    }

    private ApiResponse<Void> checkReleaseRational(String key, BigDecimal totalReleaseQty, BigDecimal totalQtyPreOutDB) {
        if (totalReleaseQty.compareTo(totalQtyPreOutDB) > 0) {
            String msg = "\u89c4\u683c\u7f16\u7801\uff1a" + key + " \u5f85\u91ca\u653e\u7684\u6570\u91cf\uff1a" + totalReleaseQty + " \u603b\u5360\u7528\u6570\uff1a" + totalQtyPreOutDB;
            return ApiResponse.failed((String)("\u91ca\u653e\u7684\u5360\u7528\u6570\u4e0d\u80fd\u5927\u4e8e\u903b\u8f91\u53d1\u8d27\u5355\u5df2\u5360\u7528\u6570\u3002" + msg));
        }
        return ApiResponse.success();
    }

    private ApiResponse<Void> checkParam(SgOutBillDto dto) {
        if (dto == null || dto.getMain() == null || CollectionUtils.isEmpty((Collection)dto.getItemList())) {
            return ApiResponse.failed((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ApiResponse.success();
    }

    public Map<String, List<SgSendItem>> getOrderSendItemMap(SgOutBillDto dto, List<String> skuCodeParamsList) {
        SgSend sgSend;
        if (log.isDebugEnabled()) {
            log.debug("SgPreOccupationReleaseOccupyBiz.getOrderSend \u5165\u53c2{};", (Object)JSONObject.toJSONString((Object)dto));
        }
        if ((sgSend = this.sgSendService.selectEffectiveSend(dto.getMain().getSourceBillNo(), dto.getMain().getOrderNo(), dto.getMain().getSourceBillType())) == null) {
            return null;
        }
        List sgSendItemListDb = this.sgSendItemService.getSendItemList(sgSend.getId(), skuCodeParamsList);
        Map<String, List<SgSendItem>> origSendItemMap = sgSendItemListDb.stream().collect(Collectors.groupingBy(SgSendItem::getPsSkuCode));
        return origSendItemMap;
    }

    public void preOccupationSend(List<SgPreOccupationOrderUsedItem> usedItemList, SgPreOccupationInfoDTO preOccupationInfoDTO, LoginUserInfo userInfo, SgOutMainDto paramMain) {
        SgPreOccupationOrder main = preOccupationInfoDTO.getMain();
        SgSendOccupyDto sendOccupyDto = new SgSendOccupyDto();
        sendOccupyDto.setMain(this.sgPreOccupationOccupyCommonBiz.buildPreOccupationMain(main));
        List<SgSendOccupyDto.SgSendItemDto> itemList = this.sgPreOccupationOccupyCommonBiz.buildPreOccupationItem(usedItemList, false);
        List<SgSendOccupyDto.SgSendItemDto> mergeSendItemList = this.sgSendOccupyBiz.mergeSameSkuIdAndSgStoreId(itemList);
        sendOccupyDto.setItemList(mergeSendItemList);
        sendOccupyDto.setOccupyType(SgBizEnum.SendItemOccupyType.INCREMENT.getValue());
        sendOccupyDto.setUserInfo(userInfo);
        sendOccupyDto.setIsPreOrderOccupy(Boolean.valueOf(true));
        ApiResponse<SgSendCommonBiz.SendSaveVO> sendApiRes = this.updateOrSaveSend(sendOccupyDto);
        if (log.isDebugEnabled()) {
            log.debug("\u539f\u9884\u5360\u5355\u903b\u8f91\u53d1\u8d27\u5355\u5360\u7528\u8fd4\u56de\u503c:{}", (Object)JSON.toJSONString(sendApiRes));
        }
        Assert.isTrue((boolean)sendApiRes.isSuccess(), (String)("\u539f\u9884\u5360\u5355\u66f4\u65b0\u53d1\u8d27\u5355\u5931\u8d25\uff1a" + sendApiRes.getDesc()), (Object[])new Object[0]);
        SgStorageLogicUpdateResultDTO redisBillFtpKeyList = this.sgPreOccupationOccupyCommonBiz.insertStorageChangeFtpList(usedItemList, mergeSendItemList, sendApiRes);
        for (SgPreOccupationOrderUsedItem item : usedItemList) {
            this.sgPreOccupationOrderItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SgPreOccupationOrderItem::getId, (Object)item.getSgPreOccupationOrderItemId())).set(BaseDo::getUpdateTime, (Object)new Date())).setSql("used_qty = used_qty - " + item.getReleaseQty(), new Object[0])).setSql("unused_qty = unused_qty + " + item.getReleaseQty(), new Object[0]));
        }
        this.sgPreOccupationOrderUsedItemService.updateBatchById(usedItemList);
        this.sgPreOccupationOccupyCommonBiz.recalculationUpdatePreOrder(main);
        String orderNo = paramMain.getOrderNo();
        List logItemList = usedItemList.stream().map(o -> "\u5546\u54c1\u89c4\u683c\u7f16\u7801\uff1a" + o.getPsCSkuEcode() + "\u91ca\u653e\u6570\u91cf\uff1a" + o.getReleaseQty()).collect(Collectors.toList());
        InnerLog.addLog((Long)main.getId(), (String)("\u8ba2\u5355\u53d6\u6d88\u5360\u7528\uff1a" + CharSequenceUtil.format((CharSequence)"\u8ba2\u5355:{},\u91ca\u653e\u660e\u7ec6\uff1a{}", (Object[])new Object[]{paramMain.getSourceBillNo(), logItemList})), (String)"sg_pre_occupation_order", null, (String)"\u53d6\u6d88\u5360\u7528");
    }

    public void orderOccupationReleaseSend(SgOutMainDto paramMain, Map<Long, SgPreOccupationInfoDTO> preOccupationInfoMap, Map<Long, List<SgPreOccupationOrderUsedItem>> usedItemListMap, List<SgPreOccupationOrderUsedItem> usedItemList, LoginUserInfo userInfo) {
        if (CollUtil.isEmpty(usedItemList)) {
            log.info("orderOccupationReleaseSend \u8ba2\u5355\u65e0\u53ef\u91ca\u653e\u9884\u5360\u5355\u660e\u7ec6");
            return;
        }
        Long key = usedItemListMap.keySet().iterator().next();
        SgPreOccupationInfoDTO preOccupationInfoDTO = preOccupationInfoMap.get(key);
        SgSendOccupyDto sendOccupyDto = new SgSendOccupyDto();
        SgSendOccupyDto.SgSendDto saveDto = this.sgPreOccupationOccupyCommonBiz.buildOrderOccupyMain(paramMain, preOccupationInfoDTO);
        List<SgSendOccupyDto.SgSendItemDto> itemList = this.sgPreOccupationOccupyCommonBiz.buildOrderOccupyItem(usedItemList, true);
        List<SgSendOccupyDto.SgSendItemDto> mergeSendItemList = this.sgSendOccupyBiz.mergeSameSkuIdAndSgStoreId(itemList);
        sendOccupyDto.setMain(saveDto);
        sendOccupyDto.setItemList(mergeSendItemList);
        sendOccupyDto.setOccupyType(SgBizEnum.SendItemOccupyType.INCREMENT.getValue());
        sendOccupyDto.setUserInfo(userInfo);
        sendOccupyDto.setIsPreOrderOccupy(Boolean.valueOf(true));
        ApiResponse<SgSendCommonBiz.SendSaveVO> sendApiRes = this.updateOrSaveSend(sendOccupyDto);
        if (log.isDebugEnabled()) {
            log.debug("\u8ba2\u5355\u66f4\u65b0\u903b\u8f91\u53d1\u8d27\u5355\u5360\u7528\u8fd4\u56de\u503c:{}", (Object)JSON.toJSONString(sendApiRes));
        }
        Assert.isTrue((boolean)sendApiRes.isSuccess(), (String)("\u8ba2\u5355\u66f4\u65b0\u903b\u8f91\u53d1\u8d27\u5355\u5931\u8d25\uff1a" + sendApiRes.getDesc()), (Object[])new Object[0]);
        SgStorageLogicUpdateResultDTO redisBillFtpKeyList = this.sgPreOccupationOccupyCommonBiz.insertStorageChangeFtpList(usedItemList, mergeSendItemList, sendApiRes);
    }

    private ApiResponse<SgSendCommonBiz.SendSaveVO> updateOrSaveSend(SgSendOccupyDto sendOccupyDto) {
        sendOccupyDto.setIsPreOrderOccupy(Boolean.valueOf(true));
        ApiResponse<SgSendCommonBiz.SendSaveVO> sendApiRes = this.sgSendOccupyBiz.sendSave(sendOccupyDto);
        return sendApiRes;
    }

    public ApiResponse getPreOrderUsedList(Long ocOrderId, String orderNo, Integer sourceBillType, List<String> skuCodeList) {
        List<SgPreOccupationOrderUsedItem> usedItemList = this.getUsedItemList(ocOrderId, sourceBillType, skuCodeList);
        if (CollUtil.isEmpty(usedItemList)) {
            log.info("\u672a\u67e5\u8be2\u5230\u9884\u5360\u5355\u5360\u7528\u660e\u7ec6,ocOrderNo\uff1a{},itemCodes:{}", (Object)orderNo, skuCodeList);
            return ApiResponse.failed((String)"\u672a\u67e5\u8be2\u5230\u9884\u5360\u5355\u5360\u7528\u660e\u7ec6");
        }
        return ApiResponse.success();
    }

    public void addLock(List<SgPreOccupationOrderUsedItem> validUsedItemList, List<RedisReentrantLock> lockList, List<Long> usedItemIds, List<String> continskey) {
        for (SgPreOccupationOrderUsedItem usedItem : validUsedItemList) {
            Long sgPreOccupationOrderId = usedItem.getSgPreOccupationOrderId();
            Long sgPreOccupationOrderItemId = usedItem.getSgPreOccupationOrderItemId();
            usedItemIds.add(usedItem.getId());
            String key = sgPreOccupationOrderId + ":" + sgPreOccupationOrderItemId;
            if (continskey.contains(key)) continue;
            continskey.add(key);
            String lockKey = "sg_pre_occupation_order:" + key;
            RedisReentrantLock lock = SgRedisLockUtils.lock((String)lockKey);
            lockList.add(lock);
        }
    }

    public void refreshOccupyItemOcOrder(Long orderId, String orderNo, List<SgStorageMergeItemDto> itemList, String tid, Integer sourceBillType) {
        log.info("\u5237\u65b0\u9884\u5360\u5355\u5360\u4f7f\u7528\u660e\u7ec6orderNo:{},orderId:{}", (Object)orderNo, (Object)orderId);
        if (log.isDebugEnabled()) {
            log.debug("\u5237\u65b0\u9884\u5360\u5355\u5360\u4f7f\u7528\u660e\u7ec6.Param.orderNo:{},orderId:{}, itemList:{}", new Object[]{orderNo, orderId, JSON.toJSONString(itemList)});
        }
        for (SgStorageMergeItemDto sgStorageMergeItemDto : itemList) {
            List usedItemList = this.sgPreOccupationOrderUsedItemService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(sgStorageMergeItemDto.getOrderId() != null, SgPreOccupationOrderUsedItem::getOmsOcOrderId, (Object)sgStorageMergeItemDto.getOrderId())).eq(StrUtil.isNotEmpty((CharSequence)sgStorageMergeItemDto.getOrderNo()), SgPreOccupationOrderUsedItem::getOmsOcOrderBillNo, (Object)sgStorageMergeItemDto.getOrderNo())).eq(StrUtil.isNotEmpty((CharSequence)sgStorageMergeItemDto.getSourceBillNo()), SgPreOccupationOrderUsedItem::getSourceBillNo, (Object)sgStorageMergeItemDto.getSourceBillNo())).eq(SgPreOccupationOrderUsedItem::getSourceBillType, (Object)sgStorageMergeItemDto.getSourceBillType())).eq(BaseDo::getIsDelete, (Object)false));
            if (log.isDebugEnabled()) {
                log.debug("\u5237\u65b0\u9884\u5360\u5355\u5360\u4f7f\u7528\u660e\u7ec6,\u5df2\u4f7f\u7528\u660e\u7ec6usedItemList:{}", (Object)JSON.toJSONString((Object)usedItemList));
            }
            if (CollUtil.isEmpty((Collection)usedItemList)) {
                log.info("\u5f53\u524d\u5355\u636e\u65e0\u9884\u5360\u5355\u5360\u4f7f\u7528\u660e\u7ec6id:{},\u7f16\u53f7:{}", (Object)orderId, (Object)orderNo);
                return;
            }
            ArrayList updateUsedItemList = Lists.newArrayList();
            for (SgPreOccupationOrderUsedItem item : usedItemList) {
                SgPreOccupationOrderUsedItem usedItem = new SgPreOccupationOrderUsedItem();
                usedItem.setId(item.getId());
                usedItem.setOmsOcOrderId(orderId);
                usedItem.setOmsOcOrderBillNo(orderNo);
                usedItem.setSourceBillNo(tid);
                if (item.getOrigOmsOcOrderId() == null) {
                    usedItem.setOrigOmsOcOrderId(item.getOmsOcOrderId());
                    usedItem.setOrigOmsOcOrderBillNo(item.getOmsOcOrderBillNo());
                }
                if (sourceBillType != null) {
                    usedItem.setSourceBillType(sourceBillType);
                }
                this.initialService.initialInsertBaseDaoSystemValue((BaseDo)usedItem);
                updateUsedItemList.add(usedItem);
            }
            this.sgPreOccupationOrderUsedItemService.updateBatchById((Collection)updateUsedItemList);
        }
    }

    public void refreshOccupyItemOcOrder(Long orderId, String orderNo, Integer sourceBillType, HashMap<String, SgStorageCancelMergeSplitMappingDto> mappingMap) {
        log.info("\u5237\u65b0\u9884\u5360\u5355\u5360\u4f7f\u7528\u660e\u7ec6\u4e3a\u539f\u59cb\u5173\u8054\u5355orderNo:{},orderId:{}", (Object)orderNo, (Object)orderId);
        List usedItemList = this.sgPreOccupationOrderUsedItemService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(orderId != null, SgPreOccupationOrderUsedItem::getOmsOcOrderId, (Object)orderId)).eq(StrUtil.isNotEmpty((CharSequence)orderNo), SgPreOccupationOrderUsedItem::getOmsOcOrderBillNo, (Object)orderNo)).eq(SgPreOccupationOrderUsedItem::getSourceBillType, (Object)sourceBillType)).eq(BaseDo::getIsDelete, (Object)false));
        if (log.isDebugEnabled()) {
            log.debug("\u5237\u65b0\u9884\u5360\u5355\u5360\u4f7f\u7528\u660e\u7ec6\u4e3a\u539f\u59cb\u5173\u8054\u5355,\u5df2\u4f7f\u7528\u660e\u7ec6usedItemList:{}", (Object)JSON.toJSONString((Object)usedItemList));
        }
        if (CollUtil.isEmpty((Collection)usedItemList)) {
            log.info("\u5f53\u524d\u5355\u636e\u65e0\u9884\u5360\u5355\u5360\u4f7f\u7528\u660e\u7ec6id:{},\u7f16\u53f7:{}", (Object)orderId, (Object)orderNo);
            return;
        }
        ArrayList updateUsedItemList = Lists.newArrayList();
        for (SgPreOccupationOrderUsedItem item : usedItemList) {
            String sourceBillNo = item.getSourceBillNo();
            if (!mappingMap.containsKey(sourceBillNo)) continue;
            SgStorageCancelMergeSplitMappingDto mergeSplitMappingDto = mappingMap.get(sourceBillNo);
            SgPreOccupationOrderUsedItem usedItem = new SgPreOccupationOrderUsedItem();
            usedItem.setId(item.getId());
            usedItem.setOmsOcOrderId(mergeSplitMappingDto.getOrderId());
            usedItem.setOmsOcOrderBillNo(mergeSplitMappingDto.getOrderNo());
            this.initialService.initialInsertBaseDaoSystemValue((BaseDo)usedItem);
            updateUsedItemList.add(usedItem);
        }
        this.sgPreOccupationOrderUsedItemService.updateBatchById((Collection)updateUsedItemList);
    }

    public void refreshOccupyItemOcOrder(String tid, Integer sourceBillType) {
        log.info("\u5237\u65b0\u9884\u5360\u5355\u5360\u4f7f\u7528\u660e\u7ec6\u4e3a\u539f\u59cb\u5173\u8054\u5355tid:{},sourceBillType:{}", (Object)tid, (Object)sourceBillType);
        List<SgPreOccupationOrderUsedItem> usedItemList = this.getPreOccupationOrderUsedItemsByTid(tid, sourceBillType);
        if (log.isDebugEnabled()) {
            log.debug("\u5237\u65b0\u9884\u5360\u5355\u5360\u4f7f\u7528\u660e\u7ec6\u4e3a\u539f\u59cb\u5173\u8054\u5355,\u5df2\u4f7f\u7528\u660e\u7ec6usedItemList:{}", (Object)JSON.toJSONString(usedItemList));
        }
        if (CollUtil.isEmpty(usedItemList)) {
            log.info("\u5f53\u524d\u5355\u636e\u65e0\u9884\u5360\u5355\u5360\u4f7f\u7528\u660e\u7ec6tid:{},sourceBillType:{}", (Object)tid, (Object)sourceBillType);
            return;
        }
        ArrayList updateUsedItemList = Lists.newArrayList();
        for (SgPreOccupationOrderUsedItem item : usedItemList) {
            SgPreOccupationOrderUsedItem usedItem = new SgPreOccupationOrderUsedItem();
            usedItem.setId(item.getId());
            usedItem.setOmsOcOrderId(item.getOrigOmsOcOrderId());
            usedItem.setOmsOcOrderBillNo(item.getOrigOmsOcOrderBillNo());
            this.initialService.initialInsertBaseDaoSystemValue((BaseDo)usedItem);
            updateUsedItemList.add(usedItem);
        }
        this.sgPreOccupationOrderUsedItemService.updateBatchById((Collection)updateUsedItemList);
    }

    public List<SgPreOccupationOrderUsedItem> getPreOccupationOrderUsedItemsByTid(String tid, Integer sourceBillType) {
        List usedItemList = this.sgPreOccupationOrderUsedItemService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SgPreOccupationOrderUsedItem::getSourceBillNo, (Object)tid)).eq(SgPreOccupationOrderUsedItem::getSourceBillType, (Object)sourceBillType)).eq(BaseDo::getIsDelete, (Object)false));
        return usedItemList;
    }
}

