/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.send;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.business.model.BizOperatorInfo;
import com.xinqiyi.framework.business.service.BizOperatorService;
import com.xinqiyi.framework.redis.lock.RedisReentrantLock;
import com.xinqiyi.framework.util.BeanConvertUtil;
import com.xinqiyi.sg.basic.model.dto.out.SgOutBillDto;
import com.xinqiyi.sg.basic.model.dto.out.SgOutItemSaveDto;
import com.xinqiyi.sg.basic.model.dto.out.SgOutMainDto;
import com.xinqiyi.sg.basic.model.entity.SgPreOccupationOrder;
import com.xinqiyi.sg.basic.model.entity.SgPreOccupationOrderUsedItem;
import com.xinqiyi.sg.basic.service.SgBStorageService;
import com.xinqiyi.sg.basic.service.business.SgStorageRollBackBiz;
import com.xinqiyi.sg.store.model.entity.SgSend;
import com.xinqiyi.sg.store.model.entity.SgSendItem;
import com.xinqiyi.sg.store.service.SgSendItemService;
import com.xinqiyi.sg.store.service.business.common.SgPreOccupationOccupyCommonBiz;
import com.xinqiyi.sg.store.service.business.send.SgPreOccupationReleaseCommonBiz;
import com.xinqiyi.sg.warehouse.model.dto.preOccupation.SgPreOccupationInfoDTO;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SgPreOccupationReleaseSendBiz {
    private static final Logger log = LoggerFactory.getLogger(SgPreOccupationReleaseSendBiz.class);
    @Resource
    private SgSendItemService sgSendItemService;
    @Autowired
    SgBStorageService storageService;
    @Autowired
    SgStorageRollBackBiz sgStorageRollBackBiz;
    @Resource
    private BizOperatorService bizOperatorService;
    @Resource
    private SgPreOccupationReleaseCommonBiz sgPreOccupationReleaseCommonBiz;
    @Resource
    private SgPreOccupationOccupyCommonBiz sgPreOccupationOccupyCommonBiz;

    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<List<SgSendItem>> releaseByVoidSend(Long serviceNode, SgSend send, List<SgSendItem> sgSendItemList) {
        if (log.isDebugEnabled()) {
            log.debug("SgPreOccupationReleaseSendBiz.releaseByVoidSend \u5165\u53c2 send:{}, sendItem:{};", (Object)JSON.toJSONString((Object)send), (Object)JSON.toJSONString(sgSendItemList));
        }
        SgOutBillDto dto = new SgOutBillDto();
        SgOutMainDto sgOutMainDto = new SgOutMainDto();
        BeanConvertUtil.copyProperties((Object)send, (Object)sgOutMainDto);
        sgOutMainDto.setServiceNode(serviceNode);
        sgOutMainDto.setOrderId(send.getOrderId());
        sgOutMainDto.setSourceBillNo(send.getSourceBillNo());
        dto.setMain(sgOutMainDto);
        dto.setItemList(BeanConvertUtil.convertList(sgSendItemList, SgOutItemSaveDto.class));
        LoginUserInfo userInfo = new LoginUserInfo();
        BizOperatorInfo bizOperatorInfo = this.bizOperatorService.selectCurrentBizOperator();
        BeanUtils.copyProperties((Object)bizOperatorInfo, (Object)userInfo);
        dto.setUserInfo(userInfo);
        if (log.isDebugEnabled()) {
            log.debug("SgPreOccupationReleaseOccupyBiz.releaseByVoidSend sgOutBillDto:{}", (Object)JSON.toJSONString((Object)dto));
        }
        ApiResponse<Void> response = this.checkParam(dto);
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getDesc(), (Object[])new Object[0]);
        SgOutMainDto paramMain = dto.getMain();
        Long ocOrderId = paramMain.getOrderId();
        String orderNo = paramMain.getOrderNo();
        String sourceBillNo = paramMain.getSourceBillNo();
        Integer sourceBillType = paramMain.getSourceBillType();
        List<SgOutItemSaveDto> sgOutItemSaveDtos = this.sgPreOccupationOccupyCommonBiz.mergeSameSkuIdQty(dto.getItemList());
        Map<String, SgOutItemSaveDto> outItemMap = sgOutItemSaveDtos.stream().collect(Collectors.toMap(SgOutItemSaveDto::getPsSkuCode, Function.identity()));
        ArrayList<String> skuCodeList = new ArrayList<String>(outItemMap.keySet());
        List<SgPreOccupationOrderUsedItem> usedItemList = send.getOrderId() != null ? this.sgPreOccupationReleaseCommonBiz.getUsedItemList(ocOrderId, sourceBillType, skuCodeList) : this.sgPreOccupationReleaseCommonBiz.getPreOccupationOrderUsedItemsByTid(send.getSourceBillNo(), sourceBillType);
        if (CollUtil.isEmpty(usedItemList)) {
            log.info("\u672a\u67e5\u8be2\u5230\u9884\u5360\u5355\u5360\u7528\u660e\u7ec6,ocOrderId\uff1a{},itemCodes:{}", (Object)ocOrderId, skuCodeList);
            return ApiResponse.success();
        }
        Map<Long, List<SgPreOccupationOrderUsedItem>> usedItemMapByPreOrderId = usedItemList.stream().collect(Collectors.groupingBy(SgPreOccupationOrderUsedItem::getSgPreOccupationOrderId));
        List<SgPreOccupationOrder> preOccupationOrders = this.sgPreOccupationReleaseCommonBiz.getValidPreOccupationOrders(usedItemMapByPreOrderId);
        if (CollUtil.isEmpty(preOccupationOrders)) {
            log.info("\u672a\u67e5\u8be2\u5230\u6709\u6548\u9884\u5360\u5355\u5360\u7528,ocOrderId\uff1a{},preOrderNo:{}", (Object)ocOrderId, (Object)JSON.toJSONString(usedItemMapByPreOrderId.keySet()));
            return ApiResponse.success();
        }
        ArrayList infoList = Lists.newArrayList();
        HashMap preOrderInfoMap = Maps.newHashMap();
        ArrayList validUsedItemList = Lists.newArrayList();
        for (SgPreOccupationOrder preOccupationOrder : preOccupationOrders) {
            SgPreOccupationInfoDTO infoDTO = new SgPreOccupationInfoDTO();
            infoDTO.setMain(preOccupationOrder);
            List<SgPreOccupationOrderUsedItem> list = usedItemMapByPreOrderId.get(preOccupationOrder.getId());
            infoDTO.setUsedItemList(list);
            infoList.add(infoDTO);
            validUsedItemList.addAll(list);
            preOrderInfoMap.put(preOccupationOrder.getId(), infoDTO);
        }
        ArrayList lockList = Lists.newArrayList();
        try {
            ArrayList usedItemIds = Lists.newArrayList();
            ArrayList continskey = Lists.newArrayList();
            this.sgPreOccupationReleaseCommonBiz.addLock(validUsedItemList, lockList, usedItemIds, continskey);
            ArrayList orderRelease = Lists.newArrayList();
            this.sgPreOccupationReleaseCommonBiz.preOccupyRelease(dto, sgOutMainDto, outItemMap, skuCodeList, usedItemMapByPreOrderId, preOrderInfoMap, usedItemIds, orderRelease);
            List sgSendItemDBList = this.sgSendItemService.selectSendItemList(send.getId());
            ApiResponse apiResponse = ApiResponse.success((Object)sgSendItemDBList);
            return apiResponse;
        }
        catch (Exception e) {
            log.error("\u9884\u5360\u5355\u91ca\u653e\u660e\u7ec6\u5360\u7528\u5e93\u5b58\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
        finally {
            if (CollUtil.isNotEmpty((Collection)lockList)) {
                lockList.forEach(RedisReentrantLock::unlock);
            }
        }
    }

    private ApiResponse<Void> checkParam(SgOutBillDto dto) {
        if (dto == null || dto.getMain() == null || CollectionUtils.isEmpty((Collection)dto.getItemList())) {
            return ApiResponse.failed((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ApiResponse.success();
    }
}

