/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.send;

import com.alibaba.fastjson.JSON;
import com.mysql.cj.util.StringUtils;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.bizlog.annotation.LogAnnotation;
import com.xinqiyi.framework.bizlog.entity.InnerLog;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.redis.lock.RedisReentrantLock;
import com.xinqiyi.sg.basic.api.model.vo.SgStorageBatchUpdateVo;
import com.xinqiyi.sg.basic.model.common.SgBizEnum;
import com.xinqiyi.sg.basic.model.common.SgErrorCodeEnum;
import com.xinqiyi.sg.basic.model.dto.SgStorageRollBackDto;
import com.xinqiyi.sg.basic.service.business.SgStorageEffectiveRollBackBiz;
import com.xinqiyi.sg.basic.service.business.SgStorageRollBackBiz;
import com.xinqiyi.sg.basic.service.config.SgStorageEffectiveConfig;
import com.xinqiyi.sg.basic.service.exception.BizException;
import com.xinqiyi.sg.basic.service.utils.AssertBiz;
import com.xinqiyi.sg.basic.service.utils.SgRedisKey;
import com.xinqiyi.sg.basic.service.utils.SgRedisLockUtils;
import com.xinqiyi.sg.store.api.model.vo.send.SgSendBillCleanVo;
import com.xinqiyi.sg.store.model.dto.send.SgSendBillCleanDto;
import com.xinqiyi.sg.store.model.entity.SgSend;
import com.xinqiyi.sg.store.service.SgSendEffectiveItemService;
import com.xinqiyi.sg.store.service.SgSendItemService;
import com.xinqiyi.sg.store.service.SgSendService;
import com.xinqiyi.sg.store.service.business.common.SgStoreStorageBySendBiz;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class SgSendCleanBiz {
    private static final Logger log = LoggerFactory.getLogger(SgSendCleanBiz.class);
    @Resource
    private SgSendService sgSendService;
    @Resource
    private SgSendItemService sgSendItemService;
    @Resource
    private BaseDaoInitialService baseDaoInitialService;
    @Resource
    private SgStoreStorageBySendBiz sgStoreStorageBySendBiz;
    @Resource
    private SgStorageRollBackBiz sgStorageRollBackBiz;
    @Resource
    private SgSendEffectiveItemService sgSendEffectiveItemService;
    @Resource
    private SgStorageEffectiveConfig sgStorageEffectiveConfig;
    @Resource
    private SgStorageEffectiveRollBackBiz sgStorageEffectiveRollBackBiz;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LogAnnotation
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<SgSendBillCleanVo> cleanSend(SgSendBillCleanDto dto) {
        if (log.isDebugEnabled()) {
            log.debug("SgSendCleanBiz.cleanSend params:{}", (Object)JSON.toJSONString((Object)dto));
        }
        Boolean isOpenEffective = this.sgStorageEffectiveConfig.isOpenEffective != null && this.sgStorageEffectiveConfig.isOpenEffective != false;
        List redisBillFtpKeyList = dto.getRedisBillFtpKeyList();
        ArrayList redisBillFtpKeyListByBatchCode = dto.getRedisBillFtpKeyListByBatchCode();
        if (CollectionUtils.isEmpty((Collection)redisBillFtpKeyListByBatchCode)) {
            redisBillFtpKeyListByBatchCode = new ArrayList();
        }
        SgSendBillCleanVo returnVO = new SgSendBillCleanVo();
        returnVO.setRedisBillFtpKeyList(redisBillFtpKeyList);
        returnVO.setRedisBillFtpKeyListByBatchCode(redisBillFtpKeyListByBatchCode);
        ApiResponse<Void> checkRes = this.checkParams(dto);
        if (!checkRes.isSuccess()) {
            return ApiResponse.failed((String)checkRes.getDesc());
        }
        String sourceBillNo = dto.getSourceBillNo();
        if (!StringUtils.isNullOrEmpty((String)dto.getOrderNo())) {
            sourceBillNo = dto.getOrderNo();
        }
        String lockRedisKey = SgRedisKey.getSendRedisKey((String)sourceBillNo, (Integer)dto.getSourceBillType());
        RedisReentrantLock redisLock = SgRedisLockUtils.getReentrantLock((String)lockRedisKey);
        try {
            if (!redisLock.tryLock(0L, TimeUnit.MINUTES)) {
                ApiResponse apiResponse = ApiResponse.failed(null, (String)SgErrorCodeEnum.IN_PROGRESS.getCode(), (String)"\u903b\u8f91\u53d1\u8d27\u5355\u6b63\u5728\u88ab\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                return apiResponse;
            }
            ApiResponse<SgSend> res = this.getSendFormDBAndCheckData(dto);
            if (!res.isSuccess()) {
                ApiResponse apiResponse = ApiResponse.failed((String)res.getDesc());
                return apiResponse;
            }
            SgSend sgSendDB = (SgSend)res.getContent();
            Long sendId = sgSendDB.getId();
            List sendItemListDB = this.sgSendItemService.selectSendItemList(sendId);
            List sgSendEffectiveItemDBList = this.sgSendEffectiveItemService.selectSendEffectiveItemBysendIdList(sendId);
            ApiResponse<SgStorageBatchUpdateVo> storageRes = this.sgStoreStorageBySendBiz.cleanOrVoidSendStoragePreOut(dto.getServiceNode(), sgSendDB, sendItemListDB, null, sgSendEffectiveItemDBList);
            if (storageRes.isSuccess()) {
                returnVO.setRedisBillFtpKeyList(((SgStorageBatchUpdateVo)storageRes.getContent()).getRedisBillFtpKeyList());
                if (isOpenEffective.booleanValue() && ObjectUtils.isNotEmpty((Object)((SgStorageBatchUpdateVo)storageRes.getContent()).getSgStorageEffectiveBatchUpdateVo())) {
                    returnVO.setRedisBillFtpKeyListByBatchCode(((SgStorageBatchUpdateVo)storageRes.getContent()).getSgStorageEffectiveBatchUpdateVo().getRedisBillFtpKeyList());
                }
            }
            SgSend updateSgSend = new SgSend();
            updateSgSend.setId(sendId);
            updateSgSend.setTotQtyPreOut(BigDecimal.ZERO);
            updateSgSend.setServiceNode(dto.getServiceNode());
            updateSgSend.setBillStatus(SgBizEnum.SendBillStatus.UPDATE.getValue());
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSgSend);
            this.sgSendService.updateById((Object)updateSgSend);
            this.sgSendItemService.deleteSendItemBySendId(sendId);
            if (isOpenEffective.booleanValue()) {
                this.sgSendEffectiveItemService.deleteSendItemBySendId(sendId);
            }
            InnerLog.addLog((Long)sendId, (String)"\u903b\u8f91\u53d1\u8d27\u5355\u6e05\u7a7a", (String)"sg_send", null, (String)"\u6e05\u7a7a");
        }
        catch (Exception e) {
            log.error("SgSendBiz.cleanSend \u5f02\u5e38:", (Throwable)e);
            SgStorageRollBackDto rollBackDto = new SgStorageRollBackDto();
            rollBackDto.setRollbackDBflag(true);
            rollBackDto.setRedisBillFtpKeyList(redisBillFtpKeyList);
            this.sgStorageRollBackBiz.rollbackStorageBill(rollBackDto);
            if (isOpenEffective.booleanValue() && CollectionUtils.isNotEmpty(redisBillFtpKeyListByBatchCode)) {
                SgStorageRollBackDto rollBackEffectiveDto = new SgStorageRollBackDto();
                rollBackEffectiveDto.setRollbackDBflag(true);
                rollBackEffectiveDto.setRedisBillFtpKeyList(redisBillFtpKeyListByBatchCode);
                this.sgStorageEffectiveRollBackBiz.rollbackStorageBill(rollBackEffectiveDto);
            }
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            ApiResponse apiResponse = ApiResponse.failed((String)e.getMessage());
            return apiResponse;
        }
        finally {
            redisLock.unlock();
        }
        return ApiResponse.success((Object)returnVO, (String)"\u6e05\u7a7a\u903b\u8f91\u53d1\u8d27\u5355\u6210\u529f");
    }

    private ApiResponse<Void> checkParams(SgSendBillCleanDto dto) {
        try {
            AssertBiz.notNull((Object)dto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getSourceBillId(), (String)"\u6765\u6e90\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getSourceBillNo(), (String)"\u6765\u6e90\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getSourceBillType(), (String)"\u6765\u6e90\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (BizException e) {
            e.printStackTrace();
            return ApiResponse.failed((String)e.getMessage());
        }
        return ApiResponse.success();
    }

    private ApiResponse<SgSend> getSendFormDBAndCheckData(SgSendBillCleanDto dto) {
        List sgSendList = this.sgSendService.selectSendList(dto.getSourceBillId(), dto.getSourceBillNo(), dto.getSourceBillType());
        if (CollectionUtils.isEmpty((Collection)sgSendList)) {
            return ApiResponse.failed((String)"\u5355\u636e\u4e0d\u5b58\u5728");
        }
        if (sgSendList.size() > 1) {
            return ApiResponse.failed((String)"\u5b58\u5728\u591a\u6761\u5355\u636e");
        }
        SgSend sgSend = (SgSend)sgSendList.get(0);
        String billStatus = sgSend.getBillStatus();
        if (SgBizEnum.SendBillStatus.CANCELED.getValue().equals(billStatus)) {
            return ApiResponse.failed((String)"\u5355\u636e\u72b6\u6001\u5df2\u7ecf\u4f5c\u5e9f\uff0c\u4e0d\u80fd\u91cd\u590d\u4f5c\u5e9f");
        }
        return ApiResponse.success((Object)sgSend);
    }
}

