/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.send;

import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.util.BeanConvertUtil;
import com.xinqiyi.sg.basic.common.StorageBasicDaoConstants;
import com.xinqiyi.sg.store.api.model.vo.send.SgSendBillQueryVO;
import com.xinqiyi.sg.store.api.model.vo.send.SgSendEffectiveItemQueryVO;
import com.xinqiyi.sg.store.api.model.vo.send.SgSendEffectiveItemVO;
import com.xinqiyi.sg.store.api.model.vo.send.SgSendItemVO;
import com.xinqiyi.sg.store.api.model.vo.send.SgSendVO;
import com.xinqiyi.sg.store.model.dto.send.SgSendBillVoidDto;
import com.xinqiyi.sg.store.model.dto.send.SgSendEffectiveItemQueryDto;
import com.xinqiyi.sg.store.model.entity.SgSend;
import com.xinqiyi.sg.store.model.entity.SgSendEffectiveItem;
import com.xinqiyi.sg.store.service.SgSendEffectiveItemService;
import com.xinqiyi.sg.store.service.SgSendItemService;
import com.xinqiyi.sg.store.service.SgSendService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SgSendQueryBiz {
    private static final Logger log = LoggerFactory.getLogger(SgSendQueryBiz.class);
    @Resource
    private SgSendService sgSendService;
    @Resource
    private SgSendItemService sgSendItemService;
    @Resource
    private SgSendEffectiveItemService sgSendEffectiveItemService;

    public ApiResponse<SgSendBillQueryVO> query(Long id) {
        SgSendBillQueryVO vo = new SgSendBillQueryVO();
        SgSend main = (SgSend)this.sgSendService.getById((Serializable)id);
        if (main == null || main.getIsDelete().equals(StorageBasicDaoConstants.IS_DELETE_Y)) {
            return ApiResponse.failed((String)"\u5f53\u524d\u8bb0\u5f55\u4e0d\u5b58\u5728!");
        }
        List itemList = this.sgSendItemService.selectSendItemList(id);
        SgSendVO mainVo = new SgSendVO();
        BeanConvertUtil.copyProperties((Object)main, (Object)mainVo);
        vo.setMain(mainVo);
        vo.setItemList(BeanConvertUtil.convertList((List)itemList, SgSendItemVO.class));
        return ApiResponse.success((Object)vo);
    }

    public ApiResponse<SgSendBillQueryVO> queryEffectiveSend(SgSendBillVoidDto dto) {
        SgSendBillQueryVO vo = new SgSendBillQueryVO();
        SgSend main = this.sgSendService.selectEffectiveSend(dto.getSourceBillNo(), dto.getOrderNo(), dto.getSourceBillType());
        if (main == null) {
            return ApiResponse.failed((String)("\u903b\u8f91\u53d1\u8d27\u5355\u4e0d\u5b58\u5728\u3002\u6765\u6e90\u5355\u636e\u7f16\u53f7\uff1a" + dto.getSourceBillNo()));
        }
        List itemList = this.sgSendItemService.selectSendItemList(main.getId());
        SgSendVO mainVo = new SgSendVO();
        BeanConvertUtil.copyProperties((Object)main, (Object)mainVo);
        vo.setMain(mainVo);
        vo.setItemList(BeanConvertUtil.convertList((List)itemList, SgSendItemVO.class));
        List itemEffectiveList = this.sgSendEffectiveItemService.selectSendEffectiveItemBysendIdList(main.getId());
        if (CollectionUtils.isNotEmpty((Collection)itemEffectiveList)) {
            int itemIndex = 1;
            for (SgSendEffectiveItem item : itemEffectiveList) {
                item.setRowNo(Integer.valueOf(itemIndex * 10));
                ++itemIndex;
            }
            this.sgSendEffectiveItemService.saveOrUpdateBatch((Collection)itemEffectiveList);
            vo.setItemEffectiveList(BeanConvertUtil.convertList((List)itemEffectiveList, SgSendEffectiveItemVO.class));
        }
        return ApiResponse.success((Object)vo);
    }

    public ApiResponse<SgSendEffectiveItemQueryVO> querySendEffectiveItems(SgSendEffectiveItemQueryDto dto) {
        SgSendEffectiveItemQueryVO vo = new SgSendEffectiveItemQueryVO();
        List itemList = this.sgSendEffectiveItemService.selectSendEffectiveItemList(dto.getSgSendItemId());
        vo.setEffectiveItemTotal(Integer.valueOf(itemList.size()));
        vo.setSgSendEffectiveItemList(BeanConvertUtil.convertList((List)itemList, SgSendEffectiveItemVO.class));
        return ApiResponse.success((Object)vo);
    }
}

