/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.send;

import com.alibaba.fastjson.JSON;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.bizlog.annotation.LogAnnotation;
import com.xinqiyi.framework.bizlog.entity.InnerLog;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.redis.lock.RedisReentrantLock;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.api.model.vo.spu.QueryInteriorSkuVO;
import com.xinqiyi.sg.basic.api.model.vo.SgStorageBatchUpdateVo;
import com.xinqiyi.sg.basic.model.common.SgBizEnum;
import com.xinqiyi.sg.basic.model.common.SgErrorCodeEnum;
import com.xinqiyi.sg.basic.model.dto.SgStorageItemUpdateCommonModelDto;
import com.xinqiyi.sg.basic.model.dto.SgStoreBillItemBaseDtoBySend;
import com.xinqiyi.sg.basic.model.entity.SgStore;
import com.xinqiyi.sg.basic.service.SgOrderNoBiz;
import com.xinqiyi.sg.basic.service.adapter.common.PsAdapter;
import com.xinqiyi.sg.basic.service.common.CommonStorageRollBackBiz;
import com.xinqiyi.sg.basic.service.exception.BizException;
import com.xinqiyi.sg.basic.service.utils.AssertBiz;
import com.xinqiyi.sg.basic.service.utils.SgRedisKey;
import com.xinqiyi.sg.basic.service.utils.SgRedisLockUtils;
import com.xinqiyi.sg.store.api.model.vo.send.SgSendBillSaveVo;
import com.xinqiyi.sg.store.model.dto.send.SgSendBillSaveDto;
import com.xinqiyi.sg.store.model.dto.send.SgSendItemSaveDto;
import com.xinqiyi.sg.store.model.dto.send.SgSendSaveDto;
import com.xinqiyi.sg.store.model.entity.SgSend;
import com.xinqiyi.sg.store.model.entity.SgSendItem;
import com.xinqiyi.sg.store.service.SgSendItemService;
import com.xinqiyi.sg.store.service.SgSendService;
import com.xinqiyi.sg.store.service.business.common.CommonService;
import com.xinqiyi.sg.store.service.business.common.SgStoreStorageBySendBiz;
import com.xinqiyi.sg.store.service.business.utils.StoreUtils;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Deprecated
@Service
public class SgSendSaveBiz {
    private static final Logger log = LoggerFactory.getLogger(SgSendSaveBiz.class);
    @Resource
    private SgSendService sgSendService;
    @Resource
    private SgSendItemService sgSendItemService;
    @Resource
    private IdSequenceGenerator idSequenceGenerator;
    @Resource
    private CommonService commonService;
    @Resource
    private SgStoreStorageBySendBiz sgStoreStorageBySendBiz;
    @Resource
    private BaseDaoInitialService baseDaoInitialService;
    @Resource
    private SgOrderNoBiz sgOrderNoBiz;
    @Resource
    private PsAdapter psAdapter;
    @Resource
    private CommonStorageRollBackBiz commonStorageRollBackBiz;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LogAnnotation
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NESTED)
    public ApiResponse<SgSendBillSaveVo> saveSend(SgSendBillSaveDto dto) {
        ApiResponse<Void> checkRes;
        if (log.isDebugEnabled()) {
            log.debug("SgSendBiz.saveSend params:{}", (Object)JSON.toJSONString((Object)dto));
        }
        if (!(checkRes = this.checkParams(dto)).isSuccess()) {
            return ApiResponse.failed((String)checkRes.getDesc());
        }
        ArrayList redisBillFtpKeyList = new ArrayList();
        Long sourceBillId = dto.getSendSaveDto().getSourceBillId();
        String sourceBillNo = dto.getSendSaveDto().getSourceBillNo();
        Integer sourceBillType = dto.getSendSaveDto().getSourceBillType();
        String orderNo = dto.getSendSaveDto().getOrderNo();
        SgSendBillSaveVo returnVO = new SgSendBillSaveVo();
        returnVO.setRedisBillFtpKeyList(redisBillFtpKeyList);
        String lockRedisKey = SgRedisKey.getSendRedisKey((String)sourceBillNo, (Integer)sourceBillType);
        RedisReentrantLock redisLock = dto.getRedisReentrantLock();
        if (redisLock == null) {
            redisLock = SgRedisLockUtils.getReentrantLock((String)lockRedisKey);
        }
        try {
            if (!redisLock.tryLock(0L, TimeUnit.MINUTES)) {
                ApiResponse apiResponse = ApiResponse.failed(null, (String)SgErrorCodeEnum.IN_PROGRESS.getCode(), (String)"\u903b\u8f91\u53d1\u8d27\u5355\u6b63\u5728\u88ab\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                return apiResponse;
            }
            boolean isCreate = true;
            ApiResponse<SgSend> res = this.getSgSendFromDBAndCheckData(sourceBillId, sourceBillNo, orderNo, sourceBillType);
            if (!res.isSuccess()) {
                ApiResponse apiResponse = ApiResponse.failed((String)res.getDesc());
                return apiResponse;
            }
            SgSend sgSendDB = (SgSend)res.getContent();
            Map<String, SgSendItem> sendItemMapDB = null;
            if (sgSendDB != null) {
                boolean flag;
                isCreate = false;
                String billStatus = sgSendDB.getBillStatus();
                boolean bl = flag = !SgBizEnum.SendBillStatus.CREATE.getValue().equals(billStatus) && !SgBizEnum.SendBillStatus.UPDATE.getValue().equals(billStatus);
                if (flag) {
                    String msg = "\u5f53\u524d\u903b\u8f91\u53d1\u8d27\u5355\u636e\u72b6\u6001\u4e3a[" + SgBizEnum.SendBillStatus.getDesc((String)billStatus) + "]\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002";
                    ApiResponse apiResponse = ApiResponse.failed((String)msg);
                    return apiResponse;
                }
                sendItemMapDB = this.getSendItemMapFromDB(sgSendDB.getId());
                if (log.isDebugEnabled()) {
                    log.debug("\u805a\u5408\u7684\u903b\u8f91\u4ed3\u53d1\u8d27\u5355\u660e\u7ec6 {}", (Object)JSON.toJSONString(sendItemMapDB));
                }
            }
            SgSend sgSend = this.updateOrInsertSendBill(isCreate, dto, sendItemMapDB, sgSendDB);
            Long sgSendId = sgSend.getId();
            returnVO.setId(sgSendId);
            List<Long> storeIdList = dto.getSendItemSaveDtoList().stream().map(obj -> obj.getSgStoreId()).collect(Collectors.toList());
            Map<Long, SgStore> negativeStock = this.commonService.getNegativeStockOfStore(storeIdList);
            ApiResponse<SgStorageBatchUpdateVo> apiResponse = this.sgStoreStorageBySendBiz.updateSendStoragePreOut(dto, sgSend, sendItemMapDB, negativeStock);
            if (!apiResponse.isSuccess()) {
                throw new IllegalArgumentException(apiResponse.getDesc());
            }
            SgStorageBatchUpdateVo resultData = (SgStorageBatchUpdateVo)apiResponse.getContent();
            returnVO.setRedisSynchMqItemList(resultData.getRedisSynchMqItemList());
            int preOutUpdateResult = resultData.getPreoutUpdateResult();
            List outStockItemList = resultData.getOutStockItemList();
            if (!CollectionUtils.isEmpty((Collection)outStockItemList)) {
                preOutUpdateResult = 3;
                this.batchUpdateSendItemOfQtyPreOut(outStockItemList);
                this.updateTotalQtyPreOut(sgSendId);
            }
            redisBillFtpKeyList.addAll(resultData.getRedisBillFtpKeyList());
            returnVO.setRedisBillFtpKeyList(resultData.getRedisBillFtpKeyList());
            returnVO.setPreOutUpdateResult(preOutUpdateResult);
            returnVO.setUpdateResult(resultData);
            InnerLog.addLog((Long)sgSendId, (String)"\u65b0\u589e\u903b\u8f91\u53d1\u8d27\u5355", (String)"sg_send", null, (String)"\u65b0\u589e");
        }
        catch (Exception e) {
            log.error("SgSendBiz.saveSend \u5f02\u5e38:", (Throwable)e);
            this.commonStorageRollBackBiz.rollBackStorage(redisBillFtpKeyList);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            ApiResponse apiResponse = ApiResponse.failed((String)e.getMessage());
            return apiResponse;
        }
        finally {
            redisLock.unlock();
        }
        return ApiResponse.success((Object)returnVO);
    }

    private void batchUpdateSendItemOfQtyPreOut(List<SgStorageItemUpdateCommonModelDto> outStockItemList) {
        for (SgStorageItemUpdateCommonModelDto outStockResult : outStockItemList) {
            Long billId = outStockResult.getBillId();
            Long billItemId = outStockResult.getBillItemId();
            BigDecimal qtyOutOfStock = Optional.ofNullable(outStockResult.getQtyPreoutChange()).orElse(BigDecimal.ZERO);
            boolean result = this.sgSendItemService.updateByOutStock(billItemId, qtyOutOfStock);
            if (!log.isDebugEnabled()) continue;
            log.info("\u903b\u8f91\u53d1\u8d27\u5355\u7f3a\u8d27\u660e\u7ec6\u5360\u7528\u56de\u6eda!\u7ed3\u679c:{} \u53d1\u8d27\u5355id:{},\u7f3a\u8d27\u660e\u7ec6:{};", new Object[]{result, billId, billItemId});
        }
    }

    private void updateTotalQtyPreOut(Long sendId) {
        List sendItems = this.sgSendItemService.selectSendItemList(sendId);
        BigDecimal reduce = sendItems.stream().map(SgSendItem::getQtyPreOut).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b));
        reduce = reduce == null ? BigDecimal.ZERO : reduce;
        SgSend updateSend = new SgSend();
        updateSend.setId(sendId);
        updateSend.setTotQtyPreOut(reduce);
        boolean flag = this.sgSendService.updateById((Object)updateSend);
        if (log.isDebugEnabled()) {
            log.info("\u903b\u8f91\u53d1\u8d27\u5355ID\uff1a" + sendId + "\uff0c\u66f4\u65b0\u903b\u8f91\u53d1\u8d27\u7684\u603b\u5360\u7528\u6570\u7ed3\u679c\uff1a" + flag);
        }
    }

    private ApiResponse<Void> checkParams(SgSendBillSaveDto dto) {
        try {
            AssertBiz.notNull((Object)dto, (String)"\u903b\u8f91\u53d1\u8d27\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getSendSaveDto(), (String)"\u903b\u8f91\u53d1\u8d27\u5355\u4e3b\u8868\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getUserInfo(), (String)"\u903b\u8f91\u53d1\u8d27\u5355UserInfo\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getSendSaveDto().getSourceBillNo(), (String)"\u6765\u6e90\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getSendSaveDto().getSourceBillType(), (String)"\u6765\u6e90\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getSendSaveDto().getSgWarehouseId(), (String)"\u5b9e\u4f53\u4ed3ID\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getSendSaveDto().getSgWarehouseCode(), (String)"\u5b9e\u4f53\u4ed3\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getSendSaveDto().getSgWarehouseName(), (String)"\u5b9e\u4f53\u4ed3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.isTrue((!CollectionUtils.isEmpty((Collection)dto.getSendItemSaveDtoList()) ? 1 : 0) != 0, (String)"\u903b\u8f91\u53d1\u8d27\u5355\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            List sendItemSaveDtoList = dto.getSendItemSaveDtoList();
            for (SgSendItemSaveDto item : sendItemSaveDtoList) {
                AssertBiz.notNull((Object)item, (String)"\u6765\u6e90\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                String psSkuCode = item.getPsSkuCode();
                AssertBiz.notNull((Object)psSkuCode, (String)"\u89c4\u683c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                AssertBiz.notNull((Object)item.getSourceBillItemId(), (String)("[" + psSkuCode + "]\u6765\u6e90\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                AssertBiz.notNull((Object)item.getSgStoreId(), (String)("[" + psSkuCode + "]\u903b\u8f91\u4ed3ID\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                AssertBiz.notNull((Object)item.getSgStoreCode(), (String)("[" + psSkuCode + "]\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                AssertBiz.notNull((Object)item.getSgStoreName(), (String)("[" + psSkuCode + "]\u903b\u8f91\u4ed3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                AssertBiz.notNull((Object)item.getPsSkuId(), (String)("[" + psSkuCode + "]\u89c4\u683cID\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                AssertBiz.notNull((Object)item.getPsProId(), (String)("[" + psSkuCode + "]\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                AssertBiz.notNull((Object)item.getPsProCode(), (String)("[" + psSkuCode + "]\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                AssertBiz.notNull((Object)item.getPsProName(), (String)("[" + psSkuCode + "]\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            }
        }
        catch (BizException e) {
            e.printStackTrace();
            return ApiResponse.failed((String)e.getMessage());
        }
        return ApiResponse.success();
    }

    private ApiResponse<SgSend> getSgSendFromDBAndCheckData(Long sourceBillId, String sourceBillNo, String orderNo, Integer sourceBillType) {
        SgSend sgSend = this.sgSendService.selectEffectiveSend(sourceBillNo, orderNo, sourceBillType);
        return ApiResponse.success((Object)sgSend);
    }

    private Map<String, SgSendItem> getSendItemMapFromDB(Long sendId) {
        Map map = null;
        List sendItemListDB = this.sgSendItemService.selectSendItemList(sendId);
        if (!CollectionUtils.isEmpty((Collection)sendItemListDB)) {
            map = sendItemListDB.stream().collect(Collectors.toMap(obj -> StoreUtils.getSendItemMapForMapKey(obj.getPsSkuId(), obj.getSgStoreId(), obj.getSourceBillItemId()), Function.identity()));
        }
        return map;
    }

    private SgSend buildSgSendForNew(SgSendSaveDto sendSaveDto, List<SgSendItemSaveDto> sendItemSaveDtoList) {
        SgSend send = new SgSend();
        BeanUtils.copyProperties((Object)sendSaveDto, (Object)send);
        String billNo = this.sgOrderNoBiz.getSendOrderNo();
        Long id = this.idSequenceGenerator.generateId(SgSend.class);
        send.setId(id);
        send.setBillNo(billNo);
        send.setBillStatus(SgBizEnum.SendBillStatus.CREATE.getValue());
        send.setBillDate(new Date());
        BigDecimal totalQtyPreOut = BigDecimal.ZERO;
        for (SgSendItemSaveDto sgSendItemSaveDto : sendItemSaveDtoList) {
            totalQtyPreOut = totalQtyPreOut.add(sgSendItemSaveDto.getQtyPreOut());
        }
        send.setTotQtyPreOut(totalQtyPreOut);
        this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)send);
        return send;
    }

    private List<SgSendItem> buildSgSendItemForNew(Long sgSendId, List<SgSendItemSaveDto> sendItemSaveDtoList) {
        ArrayList<SgSendItem> list = new ArrayList<SgSendItem>();
        List skuIdList = sendItemSaveDtoList.stream().map(SgStoreBillItemBaseDtoBySend::getPsSkuId).distinct().collect(Collectors.toList());
        Map skuMap = this.psAdapter.getSkuInfoMap(skuIdList);
        Assert.notNull((Object)skuMap, (String)("\u672a\u67e5\u8be2\u5230sku\u4fe1\u606f, skuIdList:" + JSON.toJSONString(skuIdList)));
        for (SgSendItemSaveDto sgSendItemSaveDto : sendItemSaveDtoList) {
            Long sendItemId = this.idSequenceGenerator.generateId(SgSendItem.class);
            sgSendItemSaveDto.setId(sendItemId);
            SgSendItem sgSendItem = new SgSendItem();
            BeanUtils.copyProperties((Object)sgSendItemSaveDto, (Object)sgSendItem);
            QueryInteriorSkuVO skuInfoVo = (QueryInteriorSkuVO)skuMap.get(sgSendItemSaveDto.getPsSkuId());
            if (skuInfoVo != null) {
                sgSendItem.setPsSpec1Id(skuInfoVo.getSkuId());
                sgSendItem.setPsSpec1Code(skuInfoVo.getSkuCode());
                sgSendItem.setPsSpec1Name(skuInfoVo.getSkuName());
                sgSendItem.setPsProClassify(skuInfoVo.getClassify());
                sgSendItem.setBarCode(skuInfoVo.getBarCode());
                sgSendItemSaveDto.setPsSpec1Id(skuInfoVo.getSkuId());
                sgSendItemSaveDto.setPsSpec1Code(skuInfoVo.getSkuCode());
                sgSendItemSaveDto.setPsSpec1Name(skuInfoVo.getSkuName());
                sgSendItemSaveDto.setPsProClassify(skuInfoVo.getClassify());
                sgSendItemSaveDto.setBarCode(skuInfoVo.getBarCode());
            }
            sgSendItem.setId(sendItemId);
            sgSendItem.setSgSendId(sgSendId);
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)sgSendItem);
            list.add(sgSendItem);
        }
        return list;
    }

    private SgSend buildSgSendForUpdate(Integer updateType, SgSendSaveDto sendSaveDto, List<SgSendItemSaveDto> sendItemSaveDtoList, SgSend sgBSendDB) {
        SgSend send = new SgSend();
        BeanUtils.copyProperties((Object)sendSaveDto, (Object)send);
        send.setId(sgBSendDB.getId());
        send.setBillNo(sgBSendDB.getBillNo());
        send.setBillStatus(SgBizEnum.SendBillStatus.UPDATE.getValue());
        send.setBillDate(sgBSendDB.getBillDate() == null ? new Date() : sgBSendDB.getBillDate());
        BigDecimal totalQtyPreOut = BigDecimal.ZERO;
        BigDecimal totalQtySend = BigDecimal.ZERO;
        for (SgSendItemSaveDto sgSendItemSaveDto : sendItemSaveDtoList) {
            totalQtyPreOut = totalQtyPreOut.add(Optional.ofNullable(sgSendItemSaveDto.getQtyPreOut()).orElse(BigDecimal.ZERO));
            totalQtySend = totalQtySend.add(Optional.ofNullable(sgSendItemSaveDto.getQtySend()).orElse(BigDecimal.ZERO));
        }
        if (!SgBizEnum.SendItemUpdateType.ALL.getValue().equals(updateType)) {
            BigDecimal totQtyPreOutDB = Optional.ofNullable(sgBSendDB.getTotQtyPreOut()).orElse(BigDecimal.ZERO);
            totalQtyPreOut = totalQtyPreOut.add(totQtyPreOutDB);
        }
        send.setTotQtyPreOut(totalQtyPreOut);
        send.setTotQtySend(totalQtySend);
        this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)send);
        return send;
    }

    private List<SgSendItem> buildSgSendItemForUpdate(Long sendId, Integer updateType, Map<String, SgSendItem> map, List<SgSendItemSaveDto> sendItemSaveDtoList) {
        ArrayList<SgSendItem> list = new ArrayList<SgSendItem>();
        for (SgSendItemSaveDto sgSendItemSaveDto : sendItemSaveDtoList) {
            SgSendItem sgBSendItemDB;
            SgSendItem sgSendItem = new SgSendItem();
            String key = StoreUtils.getSendItemMapForMapKey(sgSendItemSaveDto.getPsSkuId(), sgSendItemSaveDto.getSgStoreId(), sgSendItemSaveDto.getSourceBillItemId());
            SgSendItem sgSendItem2 = sgBSendItemDB = map != null ? map.get(key) : null;
            if (sgBSendItemDB != null) {
                sgSendItem.setId(sgBSendItemDB.getId());
                BigDecimal reqQty = Optional.ofNullable(sgSendItemSaveDto.getQty()).orElse(BigDecimal.ZERO);
                BigDecimal reqQtyPreOut = Optional.ofNullable(sgSendItemSaveDto.getQtyPreOut()).orElse(BigDecimal.ZERO);
                BigDecimal qtyPreOutDB = Optional.ofNullable(sgBSendItemDB.getQtyPreOut()).orElse(BigDecimal.ZERO);
                if (!SgBizEnum.SendItemUpdateType.ALL.getValue().equals(updateType)) {
                    reqQtyPreOut = qtyPreOutDB.add(reqQtyPreOut);
                }
                sgSendItem.setQtyPreOut(reqQtyPreOut);
                if (reqQty.compareTo(BigDecimal.ZERO) > 0) {
                    sgSendItem.setQty(reqQty);
                }
                this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)sgSendItem);
                list.add(sgSendItem);
                continue;
            }
            Long id = this.idSequenceGenerator.generateId(SgSendItem.class);
            sgSendItemSaveDto.setId(id);
            BeanUtils.copyProperties((Object)sgSendItemSaveDto, (Object)sgSendItem);
            sgSendItem.setId(id);
            sgSendItem.setSgSendId(sendId);
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)sgSendItem);
            list.add(sgSendItem);
        }
        return list;
    }

    public SgSend updateOrInsertSendBill(boolean isCreate, SgSendBillSaveDto dto, Map<String, SgSendItem> sendItemMapDB, SgSend sgSendDB) {
        SgSend sgSend;
        if (isCreate) {
            sgSend = this.buildSgSendForNew(dto.getSendSaveDto(), dto.getSendItemSaveDtoList());
            List<SgSendItem> sendItemList = this.buildSgSendItemForNew(sgSend.getId(), dto.getSendItemSaveDtoList());
            if (log.isDebugEnabled()) {
                log.debug("\u65b0\u589e\u7684\u903b\u8f91\u53d1\u8d27\u5355 sgSend\uff1a{} sendItemList\uff1a{}", (Object)JSON.toJSONString((Object)sgSend), (Object)JSON.toJSONString(sendItemList));
            }
            this.sgSendService.save((Object)sgSend);
            this.sgSendItemService.saveBatch(sendItemList);
            if (log.isDebugEnabled()) {
                log.debug("\u65b0\u589e\u903b\u8f91\u903b\u8f91\u53d1\u8d27\u5355\u6210\u529f");
            }
        } else {
            sgSend = this.buildSgSendForUpdate(dto.getUpdateMethod(), dto.getSendSaveDto(), dto.getSendItemSaveDtoList(), sgSendDB);
            List<SgSendItem> sendItemList = this.buildSgSendItemForUpdate(sgSend.getId(), dto.getUpdateMethod(), sendItemMapDB, dto.getSendItemSaveDtoList());
            if (log.isDebugEnabled()) {
                log.debug("\u66f4\u65b0\u7684\u903b\u8f91\u53d1\u8d27\u5355 sgSend\uff1a{} sendItemList\uff1a{}", (Object)JSON.toJSONString((Object)sgSend), (Object)JSON.toJSONString(sendItemList));
            }
            this.sgSendService.updateById((Object)sgSend);
            this.sgSendItemService.saveOrUpdateBatch(sendItemList);
            if (log.isDebugEnabled()) {
                log.debug("\u66f4\u65b0\u903b\u8f91\u53d1\u8d27\u5355\u6210\u529f");
            }
        }
        return sgSend;
    }
}

