/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.send;

import com.alibaba.fastjson.JSON;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.bizlog.annotation.LogAnnotation;
import com.xinqiyi.framework.bizlog.entity.InnerLog;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.redis.lock.RedisReentrantLock;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.sg.basic.model.common.SgBizEnum;
import com.xinqiyi.sg.basic.service.SgBStoragePreoutFtpService;
import com.xinqiyi.sg.basic.service.common.CommonStorageRollBackBiz;
import com.xinqiyi.sg.basic.service.exception.BizException;
import com.xinqiyi.sg.basic.service.utils.AssertBiz;
import com.xinqiyi.sg.basic.service.utils.SgRedisKey;
import com.xinqiyi.sg.basic.service.utils.SgRedisLockUtils;
import com.xinqiyi.sg.store.api.model.vo.send.SgSendBillVoidVo;
import com.xinqiyi.sg.store.model.dto.send.SgSendBillVoidDto;
import com.xinqiyi.sg.store.model.entity.SgSend;
import com.xinqiyi.sg.store.model.entity.SgSendItem;
import com.xinqiyi.sg.store.service.SgSendItemService;
import com.xinqiyi.sg.store.service.SgSendService;
import com.xinqiyi.sg.store.service.business.common.CommonService;
import com.xinqiyi.sg.store.service.business.common.SgStoreStorageBySendBiz;
import com.xinqiyi.sg.store.service.business.send.SgPreOccupationReleaseCommonBiz;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class SgSendSplitBiz {
    private static final Logger log = LoggerFactory.getLogger(SgSendSplitBiz.class);
    @Resource
    private SgSendService sgSendService;
    @Resource
    private SgSendItemService sgSendItemService;
    @Resource
    private BaseDaoInitialService baseDaoInitialService;
    @Resource
    private SgStoreStorageBySendBiz sgStoreStorageBySendBiz;
    @Resource
    private CommonService commonService;
    @Resource
    private CommonStorageRollBackBiz commonStorageRollBackBiz;
    @Resource
    SgBStoragePreoutFtpService sgBStoragePreoutFtpService;
    @Resource
    private IdSequenceGenerator idSequenceGenerator;
    @Resource
    SgPreOccupationReleaseCommonBiz sgPreOccupationReleaseCommonBiz;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LogAnnotation
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<SgSendBillVoidVo> splitSend(SgSendBillVoidDto dto) {
        if (log.isDebugEnabled()) {
            log.debug("SgSendSplitBiz.SgSendSplitBiz params:{}", (Object)JSON.toJSONString((Object)dto));
        }
        List redisBillFtpKeyList = dto.getRedisBillFtpKeyList();
        SgSendBillVoidVo returnVO = new SgSendBillVoidVo();
        ApiResponse<Void> checkRes = this.checkParams(dto);
        if (!checkRes.isSuccess()) {
            return ApiResponse.failed((String)checkRes.getDesc());
        }
        String sourceBillNo = dto.getSourceBillNo();
        String lockRedisKey = SgRedisKey.getSendRedisKey((String)sourceBillNo, (Integer)dto.getSourceBillType());
        RedisReentrantLock lock = SgRedisLockUtils.lock((String)lockRedisKey);
        try {
            ApiResponse<SgSend> res = this.checkData(dto);
            if (!res.isSuccess()) {
                ApiResponse apiResponse = ApiResponse.failed((String)res.getDesc());
                return apiResponse;
            }
            SgSend orgSend = (SgSend)res.getContent();
            Long sendId = orgSend.getId();
            Map<String, List<SgSendItem>> sgSendItemMap = this.sgSendItemService.selectSendItemList(sendId).stream().collect(Collectors.groupingBy(o -> o.getSgStoreId() + ":" + o.getPsSkuCode()));
            SgSend cancelSend = this.sgSendService.selectCancelSendBySourceBillNo(dto.getSourceBillNo(), dto.getSourceBillType());
            ArrayList updateItemList = Lists.newArrayList();
            ArrayList storageItemList = Lists.newArrayList();
            List cancelSendItem = this.sgSendItemService.selectSendItemList(cancelSend.getId());
            BigDecimal subtractQty = BigDecimal.ZERO;
            BigDecimal subtractQtyPreOut = BigDecimal.ZERO;
            ArrayList deleteItemIdList = Lists.newArrayList();
            for (SgSendItem cancelItem : cancelSendItem) {
                List<SgSendItem> skuItemList = sgSendItemMap.get(cancelItem.getSgStoreId() + ":" + cancelItem.getPsSkuCode());
                SgSendItem item = skuItemList.get(0);
                BigDecimal newQty = item.getQty().subtract(cancelItem.getQty());
                subtractQty = subtractQty.add(cancelItem.getQty());
                subtractQtyPreOut = subtractQtyPreOut.add(cancelItem.getQtyPreOut());
                if (newQty.compareTo(BigDecimal.ZERO) > 0) {
                    SgSendItem updateItem = new SgSendItem();
                    updateItem.setId(item.getId());
                    updateItem.setQty(newQty);
                    updateItem.setQtyPreOut(item.getQtyPreOut().subtract(cancelItem.getQtyPreOut()));
                    this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateItem, dto.getLoginUser());
                    updateItemList.add(updateItem);
                } else {
                    deleteItemIdList.add(item.getId());
                }
                SgSendItem storageItem = new SgSendItem();
                BeanUtils.copyProperties((Object)item, (Object)storageItem);
                storageItem.setQtyPreOut(newQty);
                storageItemList.add(item);
            }
            if (!CollectionUtils.isEmpty((Collection)updateItemList)) {
                this.sgSendItemService.updateBatchById((Collection)updateItemList);
            }
            if (!CollectionUtils.isEmpty((Collection)deleteItemIdList)) {
                this.sgSendItemService.removeByIds((Collection)deleteItemIdList);
            }
            this.updateMain(orgSend, dto, subtractQtyPreOut, returnVO);
            this.updateCancelMain(cancelSend, dto);
        }
        catch (Exception e) {
            log.error("SgSendBiz.voidSend \u5f02\u5e38:", (Throwable)e);
            this.commonStorageRollBackBiz.rollBackStorage(redisBillFtpKeyList);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            ApiResponse apiResponse = ApiResponse.failed((String)e.getMessage());
            return apiResponse;
        }
        finally {
            lock.unlock();
        }
        return ApiResponse.success((Object)returnVO, (String)"\u4f5c\u5e9f\u903b\u8f91\u53d1\u8d27\u5355\u6210\u529f");
    }

    public void updateMain(SgSend send, SgSendBillVoidDto dto, BigDecimal subtracQtyPreOut, SgSendBillVoidVo returnVO) {
        SgSend updateSgSend = new SgSend();
        updateSgSend.setId(send.getId());
        updateSgSend.setTotQtyPreOut(send.getTotQtyPreOut().subtract(subtracQtyPreOut));
        String[] billNoList = send.getSourceBillNo().split(",");
        Object[] billNoListNew = new String[billNoList.length - 1];
        int j = 0;
        for (int i = 0; i < billNoList.length; ++i) {
            if (billNoList[i].equals(dto.getSourceBillNo())) continue;
            billNoListNew[j++] = billNoList[i];
        }
        updateSgSend.setSourceBillNo(StringUtils.join((Object[])billNoListNew, (String)","));
        updateSgSend.setSourceCode(updateSgSend.getSourceBillNo());
        if (updateSgSend.getTotQtyPreOut().compareTo(BigDecimal.ZERO) <= 0) {
            updateSgSend.setBillStatus(SgBizEnum.SendBillStatus.CANCELED.getValue());
            returnVO.setBillStatus(SgBizEnum.SendBillStatus.CANCELED.getValue());
            InnerLog.addLog((Long)send.getId(), (String)("\u4f5c\u5e9f\u903b\u8f91\u53d1\u8d27\u5355\uff08" + dto.getSourceBillNo() + "\uff09"), (String)"sg_send", null, (String)"\u4f5c\u5e9f");
        } else {
            updateSgSend.setBillStatus(SgBizEnum.SendBillStatus.UPDATE.getValue());
            returnVO.setBillStatus(SgBizEnum.SendBillStatus.UPDATE.getValue());
            InnerLog.addLog((Long)send.getId(), (String)("\u903b\u8f91\u53d1\u8d27\u5355\u90e8\u5206\u91ca\u653e\uff08" + dto.getSourceBillNo() + "\uff09"), (String)"sg_send", null, (String)"\u66f4\u65b0");
        }
        updateSgSend.setServiceNode(dto.getServiceNode());
        this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSgSend, dto.getLoginUser());
        this.sgSendService.updateById((Object)updateSgSend);
    }

    public void updateCancelMain(SgSend cancelSend, SgSendBillVoidDto dto) {
        SgSend updateSgSend = new SgSend();
        updateSgSend.setId(cancelSend.getId());
        updateSgSend.setBillStatus(SgBizEnum.SendBillStatus.UPDATE.getValue());
        InnerLog.addLog((Long)cancelSend.getId(), (String)"\u53d6\u6d88\u51fa\u5e93\uff0c\u53d6\u6d88\u5408\u5e76", (String)"sg_send", null, (String)"\u66f4\u65b0");
        this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSgSend, dto.getLoginUser());
        this.sgSendService.updateById((Object)updateSgSend);
    }

    private ApiResponse<Void> checkParams(SgSendBillVoidDto dto) {
        try {
            AssertBiz.notNull((Object)dto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getSourceBillNo(), (String)"\u6765\u6e90\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getSourceBillType(), (String)"\u6765\u6e90\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (BizException e) {
            e.printStackTrace();
            return ApiResponse.failed((String)e.getMessage());
        }
        return ApiResponse.success();
    }

    private ApiResponse<SgSend> checkData(SgSendBillVoidDto dto) {
        boolean flag;
        SgSend sgSend = this.sgSendService.sendByOms(dto.getSourceBillNo(), dto.getSourceBillType());
        if (sgSend == null) {
            return ApiResponse.failed((String)("\u903b\u8f91\u53d1\u8d27\u5355\u4e0d\u5b58\u5728\u3002\u6765\u6e90\u5355\u636e\u7f16\u53f7\uff1a" + dto.getSourceBillNo()));
        }
        String billStatus = sgSend.getBillStatus();
        boolean bl = flag = !SgBizEnum.SendBillStatus.CREATE.getValue().equals(billStatus) && !SgBizEnum.SendBillStatus.UPDATE.getValue().equals(billStatus);
        if (flag) {
            String msg = "\u5f53\u524d\u903b\u8f91\u53d1\u8d27\u5355\u636e\u72b6\u6001\u4e0d\u5141\u8bb8\u4f5c\u5e9f\u3002\u5355\u636e\u72b6\u6001\uff1a" + SgBizEnum.SendBillStatus.getDesc((String)billStatus);
            return ApiResponse.failed((String)msg);
        }
        return ApiResponse.success((Object)sgSend);
    }

    public SgSendService getSgSendService() {
        return this.sgSendService;
    }

    public SgSendItemService getSgSendItemService() {
        return this.sgSendItemService;
    }

    public BaseDaoInitialService getBaseDaoInitialService() {
        return this.baseDaoInitialService;
    }

    public SgStoreStorageBySendBiz getSgStoreStorageBySendBiz() {
        return this.sgStoreStorageBySendBiz;
    }

    public CommonService getCommonService() {
        return this.commonService;
    }

    public CommonStorageRollBackBiz getCommonStorageRollBackBiz() {
        return this.commonStorageRollBackBiz;
    }

    public SgBStoragePreoutFtpService getSgBStoragePreoutFtpService() {
        return this.sgBStoragePreoutFtpService;
    }

    public IdSequenceGenerator getIdSequenceGenerator() {
        return this.idSequenceGenerator;
    }

    public SgPreOccupationReleaseCommonBiz getSgPreOccupationReleaseCommonBiz() {
        return this.sgPreOccupationReleaseCommonBiz;
    }

    public void setSgSendService(SgSendService sgSendService) {
        this.sgSendService = sgSendService;
    }

    public void setSgSendItemService(SgSendItemService sgSendItemService) {
        this.sgSendItemService = sgSendItemService;
    }

    public void setBaseDaoInitialService(BaseDaoInitialService baseDaoInitialService) {
        this.baseDaoInitialService = baseDaoInitialService;
    }

    public void setSgStoreStorageBySendBiz(SgStoreStorageBySendBiz sgStoreStorageBySendBiz) {
        this.sgStoreStorageBySendBiz = sgStoreStorageBySendBiz;
    }

    public void setCommonService(CommonService commonService) {
        this.commonService = commonService;
    }

    public void setCommonStorageRollBackBiz(CommonStorageRollBackBiz commonStorageRollBackBiz) {
        this.commonStorageRollBackBiz = commonStorageRollBackBiz;
    }

    public void setSgBStoragePreoutFtpService(SgBStoragePreoutFtpService sgBStoragePreoutFtpService) {
        this.sgBStoragePreoutFtpService = sgBStoragePreoutFtpService;
    }

    public void setIdSequenceGenerator(IdSequenceGenerator idSequenceGenerator) {
        this.idSequenceGenerator = idSequenceGenerator;
    }

    public void setSgPreOccupationReleaseCommonBiz(SgPreOccupationReleaseCommonBiz sgPreOccupationReleaseCommonBiz) {
        this.sgPreOccupationReleaseCommonBiz = sgPreOccupationReleaseCommonBiz;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SgSendSplitBiz)) {
            return false;
        }
        SgSendSplitBiz other = (SgSendSplitBiz)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SgSendService this$sgSendService = this.getSgSendService();
        SgSendService other$sgSendService = other.getSgSendService();
        if (this$sgSendService == null ? other$sgSendService != null : !this$sgSendService.equals(other$sgSendService)) {
            return false;
        }
        SgSendItemService this$sgSendItemService = this.getSgSendItemService();
        SgSendItemService other$sgSendItemService = other.getSgSendItemService();
        if (this$sgSendItemService == null ? other$sgSendItemService != null : !this$sgSendItemService.equals(other$sgSendItemService)) {
            return false;
        }
        BaseDaoInitialService this$baseDaoInitialService = this.getBaseDaoInitialService();
        BaseDaoInitialService other$baseDaoInitialService = other.getBaseDaoInitialService();
        if (this$baseDaoInitialService == null ? other$baseDaoInitialService != null : !this$baseDaoInitialService.equals(other$baseDaoInitialService)) {
            return false;
        }
        SgStoreStorageBySendBiz this$sgStoreStorageBySendBiz = this.getSgStoreStorageBySendBiz();
        SgStoreStorageBySendBiz other$sgStoreStorageBySendBiz = other.getSgStoreStorageBySendBiz();
        if (this$sgStoreStorageBySendBiz == null ? other$sgStoreStorageBySendBiz != null : !this$sgStoreStorageBySendBiz.equals(other$sgStoreStorageBySendBiz)) {
            return false;
        }
        CommonService this$commonService = this.getCommonService();
        CommonService other$commonService = other.getCommonService();
        if (this$commonService == null ? other$commonService != null : !this$commonService.equals(other$commonService)) {
            return false;
        }
        CommonStorageRollBackBiz this$commonStorageRollBackBiz = this.getCommonStorageRollBackBiz();
        CommonStorageRollBackBiz other$commonStorageRollBackBiz = other.getCommonStorageRollBackBiz();
        if (this$commonStorageRollBackBiz == null ? other$commonStorageRollBackBiz != null : !this$commonStorageRollBackBiz.equals(other$commonStorageRollBackBiz)) {
            return false;
        }
        SgBStoragePreoutFtpService this$sgBStoragePreoutFtpService = this.getSgBStoragePreoutFtpService();
        SgBStoragePreoutFtpService other$sgBStoragePreoutFtpService = other.getSgBStoragePreoutFtpService();
        if (this$sgBStoragePreoutFtpService == null ? other$sgBStoragePreoutFtpService != null : !this$sgBStoragePreoutFtpService.equals(other$sgBStoragePreoutFtpService)) {
            return false;
        }
        IdSequenceGenerator this$idSequenceGenerator = this.getIdSequenceGenerator();
        IdSequenceGenerator other$idSequenceGenerator = other.getIdSequenceGenerator();
        if (this$idSequenceGenerator == null ? other$idSequenceGenerator != null : !this$idSequenceGenerator.equals(other$idSequenceGenerator)) {
            return false;
        }
        SgPreOccupationReleaseCommonBiz this$sgPreOccupationReleaseCommonBiz = this.getSgPreOccupationReleaseCommonBiz();
        SgPreOccupationReleaseCommonBiz other$sgPreOccupationReleaseCommonBiz = other.getSgPreOccupationReleaseCommonBiz();
        return !(this$sgPreOccupationReleaseCommonBiz == null ? other$sgPreOccupationReleaseCommonBiz != null : !this$sgPreOccupationReleaseCommonBiz.equals(other$sgPreOccupationReleaseCommonBiz));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SgSendSplitBiz;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SgSendService $sgSendService = this.getSgSendService();
        result = result * 59 + ($sgSendService == null ? 43 : $sgSendService.hashCode());
        SgSendItemService $sgSendItemService = this.getSgSendItemService();
        result = result * 59 + ($sgSendItemService == null ? 43 : $sgSendItemService.hashCode());
        BaseDaoInitialService $baseDaoInitialService = this.getBaseDaoInitialService();
        result = result * 59 + ($baseDaoInitialService == null ? 43 : $baseDaoInitialService.hashCode());
        SgStoreStorageBySendBiz $sgStoreStorageBySendBiz = this.getSgStoreStorageBySendBiz();
        result = result * 59 + ($sgStoreStorageBySendBiz == null ? 43 : $sgStoreStorageBySendBiz.hashCode());
        CommonService $commonService = this.getCommonService();
        result = result * 59 + ($commonService == null ? 43 : $commonService.hashCode());
        CommonStorageRollBackBiz $commonStorageRollBackBiz = this.getCommonStorageRollBackBiz();
        result = result * 59 + ($commonStorageRollBackBiz == null ? 43 : $commonStorageRollBackBiz.hashCode());
        SgBStoragePreoutFtpService $sgBStoragePreoutFtpService = this.getSgBStoragePreoutFtpService();
        result = result * 59 + ($sgBStoragePreoutFtpService == null ? 43 : $sgBStoragePreoutFtpService.hashCode());
        IdSequenceGenerator $idSequenceGenerator = this.getIdSequenceGenerator();
        result = result * 59 + ($idSequenceGenerator == null ? 43 : $idSequenceGenerator.hashCode());
        SgPreOccupationReleaseCommonBiz $sgPreOccupationReleaseCommonBiz = this.getSgPreOccupationReleaseCommonBiz();
        result = result * 59 + ($sgPreOccupationReleaseCommonBiz == null ? 43 : $sgPreOccupationReleaseCommonBiz.hashCode());
        return result;
    }

    public String toString() {
        return "SgSendSplitBiz(sgSendService=" + this.getSgSendService() + ", sgSendItemService=" + this.getSgSendItemService() + ", baseDaoInitialService=" + this.getBaseDaoInitialService() + ", sgStoreStorageBySendBiz=" + this.getSgStoreStorageBySendBiz() + ", commonService=" + this.getCommonService() + ", commonStorageRollBackBiz=" + this.getCommonStorageRollBackBiz() + ", sgBStoragePreoutFtpService=" + this.getSgBStoragePreoutFtpService() + ", idSequenceGenerator=" + this.getIdSequenceGenerator() + ", sgPreOccupationReleaseCommonBiz=" + this.getSgPreOccupationReleaseCommonBiz() + ")";
    }
}

