/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.send;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mysql.cj.util.StringUtils;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.bizlog.annotation.LogAnnotation;
import com.xinqiyi.framework.bizlog.entity.InnerLog;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.redis.lock.RedisReentrantLock;
import com.xinqiyi.framework.util.BeanConvertUtil;
import com.xinqiyi.sg.basic.api.model.vo.SgStorageBatchUpdateVo;
import com.xinqiyi.sg.basic.common.StorageBasicDaoConstants;
import com.xinqiyi.sg.basic.model.common.ServiceNodeEnum;
import com.xinqiyi.sg.basic.model.common.SgBizEnum;
import com.xinqiyi.sg.basic.model.common.SgErrorCodeEnum;
import com.xinqiyi.sg.basic.model.common.SourceBillTypeEnum;
import com.xinqiyi.sg.basic.model.common.WarehouseTypeEnum;
import com.xinqiyi.sg.basic.model.entity.SgWarehouse;
import com.xinqiyi.sg.basic.service.common.CommonStorageRollBackBiz;
import com.xinqiyi.sg.basic.service.exception.BizException;
import com.xinqiyi.sg.basic.service.exception.BusinessException;
import com.xinqiyi.sg.basic.service.utils.AssertBiz;
import com.xinqiyi.sg.basic.service.utils.SgRedisKey;
import com.xinqiyi.sg.basic.service.utils.SgRedisLockUtils;
import com.xinqiyi.sg.basic.service.utils.StoreManager;
import com.xinqiyi.sg.store.api.model.vo.send.SgSendBillSubmitVo;
import com.xinqiyi.sg.store.model.dto.send.SgPhyOutResultDto;
import com.xinqiyi.sg.store.model.dto.send.SgPhyOutResultItemDto;
import com.xinqiyi.sg.store.model.dto.send.SgSendBillSubmitDto;
import com.xinqiyi.sg.store.model.entity.SgSend;
import com.xinqiyi.sg.store.model.entity.SgSendEffectiveItem;
import com.xinqiyi.sg.store.model.entity.SgSendItem;
import com.xinqiyi.sg.store.service.SgSendEffectiveItemService;
import com.xinqiyi.sg.store.service.SgSendItemService;
import com.xinqiyi.sg.store.service.SgSendService;
import com.xinqiyi.sg.store.service.business.common.SgStoreStorageBySendBiz;
import com.xinqiyi.sg.store.service.business.send.SgSendRel;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class SgSendSubmitBiz {
    private static final Logger log = LoggerFactory.getLogger(SgSendSubmitBiz.class);
    @Resource
    private SgSendService sgSendService;
    @Resource
    private SgSendItemService sgSendItemService;
    @Resource
    private BaseDaoInitialService baseDaoInitialService;
    @Resource
    private SgStoreStorageBySendBiz sgStoreStorageBySendBiz;
    @Resource
    private CommonStorageRollBackBiz commonStorageRollBackBiz;
    @Resource
    private SgSendEffectiveItemService sgSendEffectiveItemService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<SgSendBillSubmitVo> submitSend(SgSendBillSubmitDto request) {
        SgSendBillSubmitVo vo;
        block19: {
            if (log.isDebugEnabled()) {
                log.debug("SgSendSubmitBiz.submitSend params:{}", (Object)JSON.toJSONString((Object)request));
            }
            vo = new SgSendBillSubmitVo();
            ApiResponse<Void> checkRes = this.checkParams(request);
            if (!checkRes.isSuccess()) {
                return ApiResponse.failed((String)checkRes.getDesc());
            }
            List redisBillFtpKeyList = request.getRedisBillFtpKeyList();
            List redisBillFtpKeyListByBatchCode = request.getRedisBillFtpKeyListByBatchCode();
            SgPhyOutResultDto phyOutResult = request.getPhyOutResult();
            List phyOutResultItemList = request.getPhyOutResultItems();
            List phyOutResultEffectiveItems = request.getPhyOutResultEffectiveItems();
            String sourceBillNo = request.getSourceBillNo();
            if (!StringUtils.isNullOrEmpty((String)request.getOrderNo())) {
                sourceBillNo = request.getOrderNo();
            }
            String lockRedisKey = SgRedisKey.getSendRedisKey((String)sourceBillNo, (Integer)request.getSourceBillType());
            RedisReentrantLock redisLock = SgRedisLockUtils.lock((String)lockRedisKey);
            try {
                if (redisLock.tryLock(0L, TimeUnit.MINUTES)) {
                    ApiResponse<SgSend> res = this.getSendFormDBAndCheckData(request);
                    if (!res.isSuccess()) {
                        ApiResponse apiResponse = ApiResponse.failed((String)res.getDesc());
                        return apiResponse;
                    }
                    SgSend sgSendDB = (SgSend)res.getContent();
                    Long sendId = sgSendDB.getId();
                    List sgSendItemListDB = this.sgSendItemService.selectSendItemList(sendId);
                    List sgSendEffectiveItemListDB = this.sgSendEffectiveItemService.selectSendEffectiveItemBysendIdList(sendId);
                    BigDecimal totQtyPreOut = Optional.ofNullable(sgSendDB.getTotQtyPreOut()).orElse(BigDecimal.ZERO);
                    BigDecimal totQtyOut = Optional.ofNullable(phyOutResult.getTotQtyOut()).orElse(BigDecimal.ZERO);
                    BigDecimal releaseQty = totQtyPreOut.subtract(totQtyOut);
                    boolean isLast = StorageBasicDaoConstants.INT_ONE.equals(phyOutResult.getIsLast()) || 0 == BigDecimal.ZERO.compareTo(releaseQty);
                    Map<Long, SgPhyOutResultItemDto> skuIdAndPhyOutResultItemMap = this.aggregationOutResultItemBySkuId(phyOutResultItemList);
                    ArrayList<SgSendItem> releaseSgSendItemList = new ArrayList<SgSendItem>();
                    ArrayList<SgSendItem> lastReleaseSgSendItemList = new ArrayList<SgSendItem>();
                    ArrayList<SgSendEffectiveItem> releaseSgSendEffectiveItemList = new ArrayList<SgSendEffectiveItem>();
                    ArrayList<SgSendEffectiveItem> lastReleaseSgSendEffectiveItemList = new ArrayList<SgSendEffectiveItem>();
                    if (CollectionUtils.isNotEmpty((Collection)sgSendItemListDB)) {
                        this.updateSgSendAndSgSendItem(isLast, sendId, request.getSourceBillType(), phyOutResult.getOutTime(), sgSendItemListDB, skuIdAndPhyOutResultItemMap, releaseSgSendItemList, lastReleaseSgSendItemList, request.getUserInfo());
                    }
                    Boolean isHaveRowNo = false;
                    if (request.getIsOpenEffective().booleanValue()) {
                        int rowNo = ((SgSendEffectiveItem)sgSendEffectiveItemListDB.get(0)).getRowNo();
                        if (rowNo > 0) {
                            isHaveRowNo = true;
                        }
                        this.updateSendEffectiveItem(sendId, phyOutResultEffectiveItems, sgSendEffectiveItemListDB, isLast, releaseSgSendEffectiveItemList, lastReleaseSgSendEffectiveItemList, request.getUserInfo(), isHaveRowNo);
                    }
                    ArrayList<SgSendItem> sgSendItemList = isLast ? lastReleaseSgSendItemList : releaseSgSendItemList;
                    ArrayList<SgSendEffectiveItem> sgSendEffectiveItemList = isLast ? lastReleaseSgSendEffectiveItemList : releaseSgSendEffectiveItemList;
                    ApiResponse<SgStorageBatchUpdateVo> storageRes = this.sgStoreStorageBySendBiz.submitSendStoragePreOut(request.getServiceNode(), sgSendDB, sgSendItemList, null, false, phyOutResult.getSgPhyOutNoticesId(), phyOutResult.getSgPhyOutNoticesBillNo(), request.getIsOpenEffective(), sgSendEffectiveItemList, isHaveRowNo);
                    if (storageRes.isSuccess()) {
                        SgStorageBatchUpdateVo resultData = (SgStorageBatchUpdateVo)storageRes.getContent();
                        int preOutUpdateResult = resultData.getPreoutUpdateResult();
                        if (preOutUpdateResult == 2) {
                            throw new BizException("\u51fa\u5e93\u5931\u8d25!");
                        }
                        if (CollectionUtils.isNotEmpty((Collection)resultData.getRedisBillFtpKeyList())) {
                            vo.setRedisBillFtpKeyList(resultData.getRedisBillFtpKeyList());
                        }
                        if (request.getIsOpenEffective().booleanValue() && CollectionUtils.isNotEmpty((Collection)resultData.getSgStorageEffectiveBatchUpdateVo().getRedisBillFtpKeyList())) {
                            vo.setRedisBillFtpKeyListByBatchCode(resultData.getSgStorageEffectiveBatchUpdateVo().getRedisBillFtpKeyList());
                        }
                        break block19;
                    }
                    throw new BizException("\u903b\u8f91\u53d1\u8d27\u5355\u51fa\u5e93\u5931\u8d25!" + storageRes.getDesc());
                }
                ApiResponse res = ApiResponse.failed(null, (String)SgErrorCodeEnum.IN_PROGRESS.getCode(), (String)"\u903b\u8f91\u53d1\u8d27\u5355\u6b63\u5728\u88ab\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                return res;
            }
            catch (Exception e) {
                log.error("SgSendBiz.submitSend \u5f02\u5e38:", (Throwable)e);
                this.commonStorageRollBackBiz.rollBackStorage(redisBillFtpKeyList);
                if (request.getIsOpenEffective().booleanValue() && CollectionUtils.isNotEmpty((Collection)redisBillFtpKeyListByBatchCode)) {
                    this.commonStorageRollBackBiz.rollBackStorageEffective(redisBillFtpKeyListByBatchCode);
                }
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                ApiResponse apiResponse = ApiResponse.failed((String)e.getMessage());
                return apiResponse;
            }
            finally {
                redisLock.unlock();
            }
        }
        return ApiResponse.success((Object)vo);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<SgSendBillSubmitVo> allSend(SgSendRel sendRel) {
        ArrayList redisBillFtpKeyList = new ArrayList();
        try {
            ArrayList<SgSendItem> updateSendItemList = new ArrayList<SgSendItem>();
            ArrayList<SgSendItem> releaseSendItemList = new ArrayList<SgSendItem>();
            for (SgSendItem sendItem : sendRel.getSendItemList()) {
                SgSendItem updateSendItem = new SgSendItem();
                updateSendItem.setId(sendItem.getId());
                updateSendItem.setQtyPreOut(BigDecimal.ZERO);
                updateSendItem.setQtySend(sendItem.getQtyPreOut());
                this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSendItem, sendRel.getUserInfo());
                SgSendItem releaseSendItem = new SgSendItem();
                BeanUtils.copyProperties((Object)sendItem, (Object)releaseSendItem);
                releaseSendItem.setQtyPreOut(sendItem.getQtyPreOut());
                releaseSendItem.setQtySend(sendItem.getQtyPreOut());
                this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)releaseSendItem, sendRel.getUserInfo());
                updateSendItemList.add(updateSendItem);
                releaseSendItemList.add(releaseSendItem);
            }
            this.sgSendItemService.updateBatchById(updateSendItemList);
            SgSend updateSend = new SgSend();
            updateSend.setId(sendRel.getSend().getId());
            updateSend.setTotQtyPreOut(BigDecimal.ZERO);
            updateSend.setTotQtySend(sendRel.getSend().getTotQtyPreOut());
            updateSend.setBillStatus(SgBizEnum.SendBillStatus.ALL_SEND.getValue());
            updateSend.setSendTime(new Date());
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSend, sendRel.getUserInfo());
            this.sgSendService.updateById((Object)updateSend);
            ApiResponse<SgStorageBatchUpdateVo> apiRes = this.sgStoreStorageBySendBiz.submitSendStoragePreOutByTransfer(sendRel.getSend(), releaseSendItemList, sendRel.getServiceNode());
            if (!apiRes.isSuccess()) {
                throw new BusinessException(apiRes.getDesc());
            }
            redisBillFtpKeyList.addAll(((SgStorageBatchUpdateVo)apiRes.getContent()).getRedisBillFtpKeyList());
            SgSendBillSubmitVo sendBillSubmitVo = new SgSendBillSubmitVo();
            sendBillSubmitVo.setRedisBillFtpKeyList(redisBillFtpKeyList);
            return ApiResponse.success((Object)sendBillSubmitVo);
        }
        catch (Exception e) {
            log.error("SgSendBiz.allSend \u5f02\u5e38:", (Throwable)e);
            this.commonStorageRollBackBiz.rollBackStorage(redisBillFtpKeyList);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return ApiResponse.failed((String)e.getMessage());
        }
    }

    private Map<Long, SgPhyOutResultItemDto> aggregationOutResultItemBySkuId(List<SgPhyOutResultItemDto> phyOutResultItemList) {
        HashMap<Long, SgPhyOutResultItemDto> skuIdAndPhyOutResultItemMap = new HashMap<Long, SgPhyOutResultItemDto>();
        for (SgPhyOutResultItemDto phyOutResultItem : phyOutResultItemList) {
            Long skuId = phyOutResultItem.getPsSkuId();
            if (skuIdAndPhyOutResultItemMap.containsKey(skuId)) {
                SgPhyOutResultItemDto orgResultItem = (SgPhyOutResultItemDto)skuIdAndPhyOutResultItemMap.get(skuId);
                BigDecimal orgQty = Optional.ofNullable(orgResultItem.getQty()).orElse(BigDecimal.ZERO);
                BigDecimal qty = Optional.ofNullable(phyOutResultItem.getQty()).orElse(BigDecimal.ZERO);
                orgResultItem.setQty(qty.add(orgQty));
                continue;
            }
            skuIdAndPhyOutResultItemMap.put(skuId, phyOutResultItem);
        }
        return skuIdAndPhyOutResultItemMap;
    }

    @LogAnnotation
    private void updateSgSendAndSgSendItem(boolean isLast, Long sendId, Integer sourceBillType, Date outTime, List<SgSendItem> sgSendItemListDB, Map<Long, SgPhyOutResultItemDto> skuIdAndPhyOutResultItemMap, List<SgSendItem> releaseSgSendItemList, List<SgSendItem> lastReleaseSgSendItemList, LoginUserInfo userInfo) {
        Map<Long, List<SgSendItem>> skuIdAndSendItemDBMap = sgSendItemListDB.stream().collect(Collectors.groupingBy(SgSendItem::getPsSkuId));
        if (MapUtils.isNotEmpty(skuIdAndSendItemDBMap)) {
            for (Map.Entry<Long, List<SgSendItem>> sendEntry : skuIdAndSendItemDBMap.entrySet()) {
                SgPhyOutResultItemDto phyOutResultItem;
                Long skuId = sendEntry.getKey();
                List<Object> sendItemsDB = sendEntry.getValue();
                List rankNotNulls = sendItemsDB.stream().filter(s -> s.getRank() != null).collect(Collectors.toList());
                int skuIdSendItemLineCount = sendItemsDB.size();
                if (skuIdSendItemLineCount > 1 && skuIdSendItemLineCount == rankNotNulls.size()) {
                    sendItemsDB = sendItemsDB.stream().sorted((p1, p2) -> p2.getRank() - p1.getRank()).collect(Collectors.toList());
                }
                if ((phyOutResultItem = skuIdAndPhyOutResultItemMap.get(skuId)) != null) {
                    ArrayList<SgSendItem> updateSendItemList = new ArrayList<SgSendItem>();
                    BigDecimal outQty = phyOutResultItem.getQty();
                    this.processSendItem(isLast, outQty, sendItemsDB, skuIdSendItemLineCount, updateSendItemList, releaseSgSendItemList);
                    if (CollectionUtils.isNotEmpty(updateSendItemList)) {
                        this.sgSendItemService.updateBatchById(updateSendItemList);
                    }
                } else {
                    sendItemsDB.forEach(o -> o.setQtySend(BigDecimal.ZERO));
                }
                if (!isLast) continue;
                lastReleaseSgSendItemList.addAll(sendItemsDB);
            }
            if (isLast) {
                this.sgSendItemService.batchVoidUpdateSendItems(sendId, Long.valueOf(userInfo.getUserId()), userInfo.getFullName(), new Date());
            }
        }
        SgSend updateSend = this.buildUpdateSendInfo(sendId, isLast, sourceBillType, outTime);
        this.sgSendService.updateById((Object)updateSend);
        InnerLog.addLog((Long)sendId, (String)("\u903b\u8f91\u53d1\u8d27\u5355" + SgBizEnum.SendBillStatus.getDesc((String)updateSend.getBillStatus())), (String)"sg_send", null, (String)"\u66f4\u65b0");
    }

    private SgSend buildUpdateSendInfo(Long sendId, boolean isLast, Integer sourceBillType, Date outTime) {
        JSONObject jsonObject = this.sgSendItemService.sumBySendId(sendId);
        SgSend updateSend = new SgSend();
        updateSend.setId(sendId);
        updateSend.setBillStatus(isLast ? SgBizEnum.SendBillStatus.ALL_SEND.getValue() : SgBizEnum.SendBillStatus.PART_SEND.getValue());
        updateSend.setServiceNode(this.updateServiceNode(sourceBillType));
        updateSend.setTotQtyPreOut(jsonObject.getBigDecimal("qty_pre_out"));
        updateSend.setTotQtySend(jsonObject.getBigDecimal("qty_send"));
        if (!sourceBillType.equals(SourceBillTypeEnum.RETAIL_POS.getCode())) {
            if (sourceBillType.equals(SourceBillTypeEnum.TRANSFER.getCode()) && outTime != null) {
                updateSend.setSendTime(outTime);
            } else {
                updateSend.setSendTime(new Date());
            }
        }
        this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSend);
        return updateSend;
    }

    private Long updateServiceNode(int billType) {
        if (billType == SourceBillTypeEnum.SALE.getCode()) {
            return ServiceNodeEnum.SALE_OUT_SUBMIT.getCode();
        }
        if (billType == SourceBillTypeEnum.SALE_RETURN.getCode()) {
            return ServiceNodeEnum.REF_SALE_OUT_SUBMIT.getCode();
        }
        if (billType == SourceBillTypeEnum.PURCHASE_RETURN.getCode()) {
            return ServiceNodeEnum.REF_PUR_OUT_SUBMIT.getCode();
        }
        if (billType == SourceBillTypeEnum.TRANSFER.getCode()) {
            return ServiceNodeEnum.TRANSFER_OUT_SUBMIT.getCode();
        }
        if (billType == SourceBillTypeEnum.RETAIL_POS.getCode()) {
            return ServiceNodeEnum.RETAIL_POS_SUBMIT.getCode();
        }
        return null;
    }

    private void processSendItem(boolean isLast, BigDecimal outQty, List<SgSendItem> sendItemsDB, int skuIdSendItemLineCount, List<SgSendItem> updateSendItemList, List<SgSendItem> releaseSgSendItemList) {
        for (SgSendItem sendItemDB : sendItemsDB) {
            Long sendItemId = sendItemDB.getId();
            BigDecimal orgQtyPreOut = sendItemDB.getQtyPreOut();
            BigDecimal orgQtySend = sendItemDB.getQtySend() == null ? BigDecimal.ZERO : sendItemDB.getQtySend();
            BigDecimal subtract = outQty.abs().subtract(orgQtyPreOut.abs());
            SgSendItem updateSendItem = new SgSendItem();
            updateSendItem.setId(sendItemId);
            if (subtract.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal qtySend = skuIdSendItemLineCount > 1 ? orgQtyPreOut : outQty;
                sendItemDB.setQtySend(qtySend);
                sendItemDB.setQtyPreOut(qtySend);
                releaseSgSendItemList.add(sendItemDB);
                updateSendItem.setQtySend(orgQtySend.add(qtySend));
                updateSendItem.setQtyPreOut(BigDecimal.ZERO);
                this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSendItem);
                updateSendItemList.add(updateSendItem);
                outQty = subtract;
                --skuIdSendItemLineCount;
            }
            if (subtract.compareTo(BigDecimal.ZERO) == 0) {
                sendItemDB.setQtySend(outQty);
                sendItemDB.setQtyPreOut(outQty);
                releaseSgSendItemList.add(sendItemDB);
                updateSendItem.setQtySend(orgQtySend.add(outQty));
                updateSendItem.setQtyPreOut(BigDecimal.ZERO);
                this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSendItem);
                updateSendItemList.add(updateSendItem);
                break;
            }
            if (subtract.compareTo(BigDecimal.ZERO) >= 0) continue;
            sendItemDB.setQtySend(outQty);
            sendItemDB.setQtyPreOut(isLast ? orgQtyPreOut : outQty);
            releaseSgSendItemList.add(sendItemDB);
            updateSendItem.setQtySend(orgQtySend.add(outQty));
            updateSendItem.setQtyPreOut(isLast ? BigDecimal.ZERO : subtract.negate());
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSendItem);
            updateSendItemList.add(updateSendItem);
            break;
        }
    }

    private ApiResponse<Void> checkParams(SgSendBillSubmitDto dto) {
        try {
            AssertBiz.notNull((Object)dto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getPhyOutResult(), (String)"\u51fa\u5e93\u7ed3\u679c\u5355\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            AssertBiz.notEmpty((Collection)dto.getPhyOutResultItems(), (String)"\u51fa\u5e93\u7ed3\u679c\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        catch (BizException e) {
            e.printStackTrace();
            return ApiResponse.failed((String)e.getMessage());
        }
        return ApiResponse.success();
    }

    private ApiResponse<SgSend> getSendFormDBAndCheckData(SgSendBillSubmitDto dto) {
        SgSend send;
        String orderNo = null;
        if (SourceBillTypeEnum.RETAIL.getCode() == dto.getSourceBillType().intValue()) {
            orderNo = dto.getOrderNo();
        }
        if ((send = this.sgSendService.selectEffectiveSend(dto.getSourceBillNo(), orderNo, dto.getSourceBillType())) == null) {
            return ApiResponse.failed((String)("\u903b\u8f91\u53d1\u8d27\u5355\u4e0d\u5b58\u5728\u3002\u6765\u6e90\u5355\u636e\u7f16\u53f7\uff1a" + dto.getSourceBillNo()));
        }
        String billStatus = send.getBillStatus();
        if (SgBizEnum.SendBillStatus.ALL_SEND.getValue().equals(billStatus)) {
            return ApiResponse.failed((String)"\u903b\u8f91\u53d1\u8d27\u5355\u5355\u636e\u72b6\u6001\u5355\u5df2\u7ecf\u5168\u90e8\u53d1\u8d27\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u53d1\u8d27");
        }
        return ApiResponse.success((Object)send);
    }

    private void updateSendEffectiveItem(Long sendId, List<SgPhyOutResultItemDto> phyOutResultEffectiveItems, List<SgSendEffectiveItem> sgSendEffectiveItemListDB, boolean isLast, List<SgSendEffectiveItem> releaseSgSendEffectiveItemList, List<SgSendEffectiveItem> lastReleaseSgSendEffectiveItemList, LoginUserInfo userInfo, Boolean isHaveRowNo) {
        if (isHaveRowNo.booleanValue()) {
            SgSend send = (SgSend)this.sgSendService.getById((Serializable)sendId);
            SgWarehouse warehouse = StoreManager.getBean().getWarehouse(send.getSgWarehouseId().longValue());
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)WarehouseTypeEnum.FUTURES.getCode(), (CharSequence)warehouse.getWarehouseType())) {
                Map<String, SgPhyOutResultItemDto> skuIdAndPhyOutResultItemMap = this.aggregationOutResultItemBySkuIdAndRowNo(phyOutResultEffectiveItems);
                Map<String, List<SgSendEffectiveItem>> skuIdAndSendItemDBMap = sgSendEffectiveItemListDB.stream().collect(Collectors.groupingBy(item -> item.getPsSkuId() + "_" + item.getRowNo()));
                if (MapUtils.isNotEmpty(skuIdAndSendItemDBMap)) {
                    for (Map.Entry<String, List<SgSendEffectiveItem>> sendEntry : skuIdAndSendItemDBMap.entrySet()) {
                        SgPhyOutResultItemDto phyOutResultItem;
                        String skuIdAndRowNo = sendEntry.getKey();
                        List<Object> sendItemsDB = sendEntry.getValue();
                        List rankNotNulls = sendItemsDB.stream().filter(s -> s.getRank() != null).collect(Collectors.toList());
                        int skuIdSendItemLineCount = sendItemsDB.size();
                        if (skuIdSendItemLineCount > 1 && skuIdSendItemLineCount == rankNotNulls.size()) {
                            sendItemsDB = sendItemsDB.stream().sorted((p1, p2) -> p2.getRank() - p1.getRank()).collect(Collectors.toList());
                        }
                        if ((phyOutResultItem = skuIdAndPhyOutResultItemMap.get(skuIdAndRowNo)) != null) {
                            ArrayList<SgSendEffectiveItem> updateSendItemList = new ArrayList<SgSendEffectiveItem>();
                            BigDecimal outQty = phyOutResultItem.getQty();
                            this.processSendEffectiveItemByRow(isLast, outQty, sendItemsDB, skuIdSendItemLineCount, updateSendItemList, releaseSgSendEffectiveItemList);
                            if (CollectionUtils.isNotEmpty(updateSendItemList)) {
                                this.sgSendEffectiveItemService.updateBatchById(updateSendItemList);
                            }
                        } else {
                            sendItemsDB.forEach(o -> o.setQtySend(BigDecimal.ZERO));
                        }
                        if (!isLast) continue;
                        lastReleaseSgSendEffectiveItemList.addAll(sendItemsDB);
                    }
                    if (isLast) {
                        this.sgSendEffectiveItemService.batchVoidUpdateSendItems(sendId, Long.valueOf(userInfo.getUserId()), userInfo.getFullName(), new Date());
                    }
                }
            } else {
                Map<String, SgPhyOutResultItemDto> skuIdAndPhyOutResultItemMap = this.aggregationOutResultItemBySkuIdAndRowNoAndBatchCode(phyOutResultEffectiveItems, sgSendEffectiveItemListDB);
                Map<String, List<SgSendEffectiveItem>> skuIdAndSendItemDBMap = sgSendEffectiveItemListDB.stream().collect(Collectors.groupingBy(item -> item.getPsSkuId() + "_" + item.getPreoutBatchCode() + "_" + item.getRowNo()));
                Map<String, List<SgSendEffectiveItem>> skuIdAndSendItemDBMapByRow = sgSendEffectiveItemListDB.stream().collect(Collectors.groupingBy(item -> item.getPsSkuId() + "_" + item.getRowNo()));
                if (MapUtils.isNotEmpty(skuIdAndSendItemDBMap)) {
                    for (Map.Entry<String, SgPhyOutResultItemDto> sendEntry : skuIdAndPhyOutResultItemMap.entrySet()) {
                        String skuIdAndRowNoAndBatchCode = sendEntry.getKey();
                        SgPhyOutResultItemDto sgPhyOutResultItemDto = sendEntry.getValue();
                        List<SgSendEffectiveItem> sgSendEffectiveItems = skuIdAndSendItemDBMap.get(skuIdAndRowNoAndBatchCode);
                        List<SgSendEffectiveItem> sgSendEffectiveItemListByRow = skuIdAndSendItemDBMapByRow.get(sgPhyOutResultItemDto.getPsSkuId() + "_" + sgPhyOutResultItemDto.getRowNo());
                        if (CollectionUtils.isEmpty(sgSendEffectiveItems)) {
                            SgSendEffectiveItem sgSendEffectiveItem1 = sgSendEffectiveItemListByRow.get(0);
                            SgSendEffectiveItem sgSendEffectiveItem = new SgSendEffectiveItem();
                            BeanConvertUtil.copyProperties((Object)sgSendEffectiveItem1, (Object)sgSendEffectiveItem);
                            BeanConvertUtil.copyProperties((Object)sgPhyOutResultItemDto, (Object)sgSendEffectiveItem);
                            sgSendEffectiveItem.setId(null);
                            sgSendEffectiveItem.setSgSendId(null);
                            sgSendEffectiveItem.setSgSendItemId(null);
                            sgSendEffectiveItem.setPreoutBatchCode(sgPhyOutResultItemDto.getBatchCode());
                            sgSendEffectiveItem.setQtySend(sgPhyOutResultItemDto.getQty());
                            sgSendEffectiveItem.setQtyPreOut(BigDecimal.ZERO);
                            sgSendEffectiveItem.setProductDate(sgPhyOutResultItemDto.getProductDate());
                            sgSendEffectiveItem.setExpireDate(sgPhyOutResultItemDto.getExpireDate());
                            sgSendEffectiveItem.setSgStoreId(sgSendEffectiveItem1.getSgStoreId());
                            releaseSgSendEffectiveItemList.add(sgSendEffectiveItem);
                            SgSendEffectiveItem sgSendEffectiveItem1New = new SgSendEffectiveItem();
                            BeanConvertUtil.copyProperties((Object)sgSendEffectiveItem1, (Object)sgSendEffectiveItem1New);
                            sgSendEffectiveItem1New.setQtySend(BigDecimal.ZERO);
                            sgSendEffectiveItem1New.setQtyPreOut(sgPhyOutResultItemDto.getQty());
                            releaseSgSendEffectiveItemList.add(sgSendEffectiveItem1New);
                            continue;
                        }
                        ArrayList<SgSendEffectiveItem> updateSendItemList = new ArrayList<SgSendEffectiveItem>();
                        BigDecimal outQty = sgPhyOutResultItemDto.getQty();
                        this.processSendEffectiveItemByRowAndBatch(isLast, outQty, sgSendEffectiveItems.get(0), updateSendItemList, releaseSgSendEffectiveItemList, sgPhyOutResultItemDto);
                        if (!CollectionUtils.isNotEmpty(updateSendItemList)) continue;
                        this.sgSendEffectiveItemService.updateBatchById(updateSendItemList);
                    }
                    if (isLast) {
                        for (SgSendEffectiveItem sgSendEffectiveItem : sgSendEffectiveItemListDB) {
                            BigDecimal totalQtyPreOut = releaseSgSendEffectiveItemList.stream().filter(item -> item.getPsSkuId().equals(sgSendEffectiveItem.getPsSkuId()) && item.getRowNo().equals(sgSendEffectiveItem.getRowNo()) && item.getPreoutBatchCode().equals(sgSendEffectiveItem.getPreoutBatchCode())).map(SgSendEffectiveItem::getQtyPreOut).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal subtract = sgSendEffectiveItem.getQtyPreOut().subtract(totalQtyPreOut);
                            if (subtract.compareTo(BigDecimal.ZERO) <= 0) continue;
                            SgSendEffectiveItem sgSendEffectiveItemlast = new SgSendEffectiveItem();
                            BeanConvertUtil.copyProperties((Object)sgSendEffectiveItem, (Object)sgSendEffectiveItemlast);
                            sgSendEffectiveItemlast.setId(null);
                            sgSendEffectiveItemlast.setSgSendId(null);
                            sgSendEffectiveItemlast.setSgSendItemId(null);
                            sgSendEffectiveItemlast.setQtySend(BigDecimal.ZERO);
                            sgSendEffectiveItemlast.setQtyPreOut(subtract);
                            lastReleaseSgSendEffectiveItemList.add(sgSendEffectiveItemlast);
                        }
                        lastReleaseSgSendEffectiveItemList.addAll(releaseSgSendEffectiveItemList);
                        this.sgSendEffectiveItemService.batchVoidUpdateSendItems(sendId, Long.valueOf(userInfo.getUserId()), userInfo.getFullName(), new Date());
                    }
                }
            }
        } else {
            Map<String, SgPhyOutResultItemDto> skuIdAndPhyOutResultItemMap = this.aggregationOutResultItemBySkuIdAndBatchCode(phyOutResultEffectiveItems);
            Map<String, List<SgSendEffectiveItem>> skuIdAndSendItemDBMap = sgSendEffectiveItemListDB.stream().collect(Collectors.groupingBy(item -> item.getPsSkuId() + "_" + item.getPreoutBatchCode()));
            if (MapUtils.isNotEmpty(skuIdAndSendItemDBMap)) {
                for (Map.Entry<String, List<SgSendEffectiveItem>> sendEntry : skuIdAndSendItemDBMap.entrySet()) {
                    SgPhyOutResultItemDto phyOutResultItem;
                    String skuIdAndBatchCode = sendEntry.getKey();
                    List<Object> sendItemsDB = sendEntry.getValue();
                    List rankNotNulls = sendItemsDB.stream().filter(s -> s.getRank() != null).collect(Collectors.toList());
                    int skuIdSendItemLineCount = sendItemsDB.size();
                    if (skuIdSendItemLineCount > 1 && skuIdSendItemLineCount == rankNotNulls.size()) {
                        sendItemsDB = sendItemsDB.stream().sorted((p1, p2) -> p2.getRank() - p1.getRank()).collect(Collectors.toList());
                    }
                    if ((phyOutResultItem = skuIdAndPhyOutResultItemMap.get(skuIdAndBatchCode)) != null) {
                        ArrayList<SgSendEffectiveItem> updateSendItemList = new ArrayList<SgSendEffectiveItem>();
                        BigDecimal outQty = phyOutResultItem.getQty();
                        this.processSendEffectiveItem(isLast, outQty, sendItemsDB, skuIdSendItemLineCount, updateSendItemList, releaseSgSendEffectiveItemList);
                        if (CollectionUtils.isNotEmpty(updateSendItemList)) {
                            this.sgSendEffectiveItemService.updateBatchById(updateSendItemList);
                        }
                    } else {
                        sendItemsDB.forEach(o -> o.setQtySend(BigDecimal.ZERO));
                    }
                    if (!isLast) continue;
                    lastReleaseSgSendEffectiveItemList.addAll(sendItemsDB);
                }
                if (isLast) {
                    this.sgSendEffectiveItemService.batchVoidUpdateSendItems(sendId, Long.valueOf(userInfo.getUserId()), userInfo.getFullName(), new Date());
                }
            }
        }
    }

    private Map<String, SgPhyOutResultItemDto> aggregationOutResultItemBySkuIdAndBatchCode(List<SgPhyOutResultItemDto> phyOutResultItemList) {
        HashMap<String, SgPhyOutResultItemDto> skuIdAndPhyOutResultItemMap = new HashMap<String, SgPhyOutResultItemDto>();
        for (SgPhyOutResultItemDto phyOutResultItem : phyOutResultItemList) {
            String skuIdAndBatchCode = phyOutResultItem.getPsSkuId() + "_" + phyOutResultItem.getBatchCode();
            if (skuIdAndPhyOutResultItemMap.containsKey(skuIdAndBatchCode)) {
                SgPhyOutResultItemDto orgResultItem = (SgPhyOutResultItemDto)skuIdAndPhyOutResultItemMap.get(skuIdAndBatchCode);
                BigDecimal orgQty = Optional.ofNullable(orgResultItem.getQty()).orElse(BigDecimal.ZERO);
                BigDecimal qty = Optional.ofNullable(phyOutResultItem.getQty()).orElse(BigDecimal.ZERO);
                orgResultItem.setQty(qty.add(orgQty));
                continue;
            }
            skuIdAndPhyOutResultItemMap.put(skuIdAndBatchCode, phyOutResultItem);
        }
        return skuIdAndPhyOutResultItemMap;
    }

    private void processSendEffectiveItem(boolean isLast, BigDecimal outQty, List<SgSendEffectiveItem> sendItemsDB, int skuIdSendItemLineCount, List<SgSendEffectiveItem> updateSendItemList, List<SgSendEffectiveItem> releaseSgSendItemList) {
        for (SgSendEffectiveItem sendItemDB : sendItemsDB) {
            Long sendItemId = sendItemDB.getId();
            BigDecimal orgQtyPreOut = sendItemDB.getQtyPreOut();
            BigDecimal orgQtySend = sendItemDB.getQtySend() == null ? BigDecimal.ZERO : sendItemDB.getQtySend();
            BigDecimal subtract = outQty.abs().subtract(orgQtyPreOut.abs());
            SgSendEffectiveItem updateSendItem = new SgSendEffectiveItem();
            updateSendItem.setId(sendItemId);
            if (subtract.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal qtySend = skuIdSendItemLineCount > 1 ? orgQtyPreOut : outQty;
                sendItemDB.setQtySend(qtySend);
                sendItemDB.setQtyPreOut(qtySend);
                releaseSgSendItemList.add(sendItemDB);
                updateSendItem.setQtySend(orgQtySend.add(qtySend));
                updateSendItem.setQtyPreOut(BigDecimal.ZERO);
                this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSendItem);
                updateSendItemList.add(updateSendItem);
                outQty = subtract;
                --skuIdSendItemLineCount;
            }
            if (subtract.compareTo(BigDecimal.ZERO) == 0) {
                sendItemDB.setQtySend(outQty);
                sendItemDB.setQtyPreOut(outQty);
                releaseSgSendItemList.add(sendItemDB);
                updateSendItem.setQtySend(orgQtySend.add(outQty));
                updateSendItem.setQtyPreOut(BigDecimal.ZERO);
                this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSendItem);
                updateSendItemList.add(updateSendItem);
                break;
            }
            if (subtract.compareTo(BigDecimal.ZERO) >= 0) continue;
            sendItemDB.setQtySend(outQty);
            sendItemDB.setQtyPreOut(isLast ? orgQtyPreOut : outQty);
            releaseSgSendItemList.add(sendItemDB);
            updateSendItem.setQtySend(orgQtySend.add(outQty));
            updateSendItem.setQtyPreOut(isLast ? BigDecimal.ZERO : subtract.negate());
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSendItem);
            updateSendItemList.add(updateSendItem);
            break;
        }
    }

    private Map<String, SgPhyOutResultItemDto> aggregationOutResultItemBySkuIdAndRowNo(List<SgPhyOutResultItemDto> phyOutResultItemList) {
        HashMap<String, SgPhyOutResultItemDto> skuIdAndPhyOutResultItemMap = new HashMap<String, SgPhyOutResultItemDto>();
        for (SgPhyOutResultItemDto phyOutResultItem : phyOutResultItemList) {
            String rowInfoStr = phyOutResultItem.getRowNoInfo();
            JSONObject rowInfo = JSONObject.parseObject((String)rowInfoStr);
            for (Map.Entry entry : rowInfo.entrySet()) {
                int rowNo = Integer.parseInt((String)entry.getKey());
                BigDecimal outQty = (BigDecimal)entry.getValue();
                String skuIdAndBatchCode = phyOutResultItem.getPsSkuId() + "_" + rowNo;
                if (skuIdAndPhyOutResultItemMap.containsKey(skuIdAndBatchCode)) {
                    SgPhyOutResultItemDto orgResultItem = (SgPhyOutResultItemDto)skuIdAndPhyOutResultItemMap.get(skuIdAndBatchCode);
                    BigDecimal orgQty = Optional.ofNullable(orgResultItem.getQty()).orElse(BigDecimal.ZERO);
                    BigDecimal qty = outQty;
                    orgResultItem.setQty(qty.add(orgQty));
                    continue;
                }
                phyOutResultItem.setRowNo(rowNo);
                phyOutResultItem.setQty(outQty);
                skuIdAndPhyOutResultItemMap.put(skuIdAndBatchCode, phyOutResultItem);
            }
        }
        return skuIdAndPhyOutResultItemMap;
    }

    private void processSendEffectiveItemByRow(boolean isLast, BigDecimal outQty, List<SgSendEffectiveItem> sendItemsDB, int skuIdSendItemLineCount, List<SgSendEffectiveItem> updateSendItemList, List<SgSendEffectiveItem> releaseSgSendItemList) {
        for (SgSendEffectiveItem sendItemDB : sendItemsDB) {
            Long sendItemId = sendItemDB.getId();
            BigDecimal orgQtyPreOut = sendItemDB.getQtyPreOut();
            BigDecimal orgQtySend = sendItemDB.getQtySend() == null ? BigDecimal.ZERO : sendItemDB.getQtySend();
            BigDecimal subtract = outQty.abs().subtract(orgQtyPreOut.abs());
            SgSendEffectiveItem updateSendItem = new SgSendEffectiveItem();
            updateSendItem.setId(sendItemId);
            if (subtract.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal qtySend = skuIdSendItemLineCount > 1 ? orgQtyPreOut : outQty;
                sendItemDB.setQtySend(qtySend);
                sendItemDB.setQtyPreOut(qtySend);
                releaseSgSendItemList.add(sendItemDB);
                updateSendItem.setQtySend(orgQtySend.add(qtySend));
                updateSendItem.setQtyPreOut(BigDecimal.ZERO);
                this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSendItem);
                updateSendItemList.add(updateSendItem);
                outQty = subtract;
                --skuIdSendItemLineCount;
            }
            if (subtract.compareTo(BigDecimal.ZERO) == 0) {
                sendItemDB.setQtySend(outQty);
                sendItemDB.setQtyPreOut(outQty);
                releaseSgSendItemList.add(sendItemDB);
                updateSendItem.setQtySend(orgQtySend.add(outQty));
                updateSendItem.setQtyPreOut(BigDecimal.ZERO);
                this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSendItem);
                updateSendItemList.add(updateSendItem);
                break;
            }
            if (subtract.compareTo(BigDecimal.ZERO) >= 0) continue;
            sendItemDB.setQtySend(outQty);
            sendItemDB.setQtyPreOut(isLast ? orgQtyPreOut : outQty);
            releaseSgSendItemList.add(sendItemDB);
            updateSendItem.setQtySend(orgQtySend.add(outQty));
            updateSendItem.setQtyPreOut(isLast ? BigDecimal.ZERO : subtract.negate());
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSendItem);
            updateSendItemList.add(updateSendItem);
            break;
        }
    }

    private Map<String, SgPhyOutResultItemDto> aggregationOutResultItemBySkuIdAndRowNoAndBatchCode(List<SgPhyOutResultItemDto> phyOutResultItemList, List<SgSendEffectiveItem> sgSendEffectiveItemListDB) {
        HashMap<CallSite, SgPhyOutResultItemDto> skuIdAndPhyOutResultItemMap = new HashMap<CallSite, SgPhyOutResultItemDto>();
        for (SgPhyOutResultItemDto phyOutResultItem : phyOutResultItemList) {
            String rowInfoStr = phyOutResultItem.getRowNoInfo();
            JSONObject rowInfo = JSONObject.parseObject((String)rowInfoStr);
            for (Map.Entry entry2 : rowInfo.entrySet()) {
                SgPhyOutResultItemDto phyOutResultItemDtoNew = new SgPhyOutResultItemDto();
                BeanConvertUtil.copyProperties((Object)phyOutResultItem, (Object)phyOutResultItemDtoNew);
                int rowNo = Integer.parseInt((String)entry2.getKey());
                BigDecimal outQty = (BigDecimal)entry2.getValue();
                String skuIdAndBatchCode = phyOutResultItemDtoNew.getPsSkuId() + "_" + phyOutResultItemDtoNew.getBatchCode() + "_" + rowNo;
                if (skuIdAndPhyOutResultItemMap.containsKey(skuIdAndBatchCode)) {
                    SgPhyOutResultItemDto orgResultItem = (SgPhyOutResultItemDto)skuIdAndPhyOutResultItemMap.get(skuIdAndBatchCode);
                    BigDecimal orgQty = Optional.ofNullable(orgResultItem.getQty()).orElse(BigDecimal.ZERO);
                    BigDecimal qty = outQty;
                    orgResultItem.setQty(qty.add(orgQty));
                    continue;
                }
                phyOutResultItemDtoNew.setRowNo(rowNo);
                phyOutResultItemDtoNew.setQty(outQty);
                Map<String, List<SgSendEffectiveItem>> skuIdAndSendItemDBMap = sgSendEffectiveItemListDB.stream().collect(Collectors.groupingBy(item -> item.getPsSkuId() + "_" + item.getPreoutBatchCode() + "_" + item.getRowNo()));
                List<SgSendEffectiveItem> sgSendEffectiveItems = skuIdAndSendItemDBMap.get(skuIdAndBatchCode);
                if (CollectionUtils.isEmpty(sgSendEffectiveItems)) {
                    phyOutResultItemDtoNew.setId(Long.valueOf(0L));
                }
                skuIdAndPhyOutResultItemMap.put((CallSite)((Object)skuIdAndBatchCode), phyOutResultItemDtoNew);
            }
        }
        List<Map.Entry> sortedList = skuIdAndPhyOutResultItemMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparingLong(SgPhyOutResultItemDto::getId))).collect(Collectors.toList());
        LinkedHashMap<String, SgPhyOutResultItemDto> sortedMap = new LinkedHashMap<String, SgPhyOutResultItemDto>();
        sortedList.forEach(entry -> sortedMap.put((String)entry.getKey(), (SgPhyOutResultItemDto)entry.getValue()));
        return sortedMap;
    }

    private void processSendEffectiveItemByRowAndBatch(boolean isLast, BigDecimal outQty, SgSendEffectiveItem sendItemDB, List<SgSendEffectiveItem> updateSendItemList, List<SgSendEffectiveItem> releaseSgSendEffectiveItemList, SgPhyOutResultItemDto sgPhyOutResultItemDto) {
        BigDecimal totalQtyPreOut = releaseSgSendEffectiveItemList.stream().filter(item -> item.getPsSkuId().equals(sgPhyOutResultItemDto.getPsSkuId()) && item.getRowNo().equals(sgPhyOutResultItemDto.getRowNo())).map(SgSendEffectiveItem::getQtyPreOut).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        Long sendItemId = sendItemDB.getId();
        BigDecimal orgQtyPreOut = sendItemDB.getQtyPreOut().subtract(totalQtyPreOut);
        BigDecimal orgQtySend = sendItemDB.getQtySend() == null ? BigDecimal.ZERO : sendItemDB.getQtySend();
        BigDecimal subtract = outQty.abs().subtract(orgQtyPreOut.abs());
        SgSendEffectiveItem updateSendItem = new SgSendEffectiveItem();
        updateSendItem.setId(sendItemId);
        if (subtract.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal qtySend = orgQtyPreOut;
            sendItemDB.setQtySend(qtySend);
            sendItemDB.setQtyPreOut(qtySend);
            releaseSgSendEffectiveItemList.add(sendItemDB);
            updateSendItem.setQtySend(orgQtySend.add(qtySend));
            updateSendItem.setQtyPreOut(BigDecimal.ZERO);
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSendItem);
            updateSendItemList.add(updateSendItem);
            outQty = subtract;
            SgSendEffectiveItem sgSendEffectiveItem = new SgSendEffectiveItem();
            BeanConvertUtil.copyProperties((Object)sendItemDB, (Object)sgSendEffectiveItem);
            sgSendEffectiveItem.setId(null);
            sgSendEffectiveItem.setSgSendId(null);
            sgSendEffectiveItem.setSgSendItemId(null);
            sgSendEffectiveItem.setQtySend(outQty);
            sgSendEffectiveItem.setQtyPreOut(BigDecimal.ZERO);
            releaseSgSendEffectiveItemList.add(sgSendEffectiveItem);
        }
        if (subtract.compareTo(BigDecimal.ZERO) == 0) {
            sendItemDB.setQtySend(outQty);
            sendItemDB.setQtyPreOut(outQty);
            releaseSgSendEffectiveItemList.add(sendItemDB);
            updateSendItem.setQtySend(orgQtySend.add(outQty));
            updateSendItem.setQtyPreOut(BigDecimal.ZERO);
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSendItem);
            updateSendItemList.add(updateSendItem);
        }
        if (subtract.compareTo(BigDecimal.ZERO) < 0) {
            sendItemDB.setQtySend(outQty);
            sendItemDB.setQtyPreOut(isLast ? orgQtyPreOut : outQty);
            releaseSgSendEffectiveItemList.add(sendItemDB);
            updateSendItem.setQtySend(orgQtySend.add(outQty));
            updateSendItem.setQtyPreOut(isLast ? BigDecimal.ZERO : subtract.negate());
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSendItem);
            updateSendItemList.add(updateSendItem);
            if (isLast) {
                SgSendEffectiveItem sgSendEffectiveItem = new SgSendEffectiveItem();
                BeanConvertUtil.copyProperties((Object)sendItemDB, (Object)sgSendEffectiveItem);
                sgSendEffectiveItem.setId(null);
                sgSendEffectiveItem.setSgSendId(null);
                sgSendEffectiveItem.setSgSendItemId(null);
                sgSendEffectiveItem.setQtySend(BigDecimal.ZERO);
                sgSendEffectiveItem.setQtyPreOut(subtract.negate());
                releaseSgSendEffectiveItemList.add(sgSendEffectiveItem);
            }
        }
    }
}

