/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.send;

import com.alibaba.fastjson.JSON;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.bizlog.annotation.LogAnnotation;
import com.xinqiyi.framework.bizlog.entity.InnerLog;
import com.xinqiyi.framework.business.model.BizOperatorInfo;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.redis.lock.RedisReentrantLock;
import com.xinqiyi.sg.basic.api.model.vo.SgStorageBatchUpdateVo;
import com.xinqiyi.sg.basic.model.common.SgBizEnum;
import com.xinqiyi.sg.basic.model.common.SgErrorCodeEnum;
import com.xinqiyi.sg.basic.model.common.SourceBillTypeEnum;
import com.xinqiyi.sg.basic.model.entity.SgStore;
import com.xinqiyi.sg.basic.service.common.CommonStorageRollBackBiz;
import com.xinqiyi.sg.basic.service.config.SgStorageEffectiveConfig;
import com.xinqiyi.sg.basic.service.exception.BizException;
import com.xinqiyi.sg.basic.service.utils.AssertBiz;
import com.xinqiyi.sg.basic.service.utils.SgRedisKey;
import com.xinqiyi.sg.basic.service.utils.SgRedisLockUtils;
import com.xinqiyi.sg.store.api.model.vo.send.SgSendBillVoidVo;
import com.xinqiyi.sg.store.model.dto.send.SgSendBillVoidDto;
import com.xinqiyi.sg.store.model.entity.SgSend;
import com.xinqiyi.sg.store.service.SgSendEffectiveItemService;
import com.xinqiyi.sg.store.service.SgSendItemService;
import com.xinqiyi.sg.store.service.SgSendService;
import com.xinqiyi.sg.store.service.business.common.CommonService;
import com.xinqiyi.sg.store.service.business.common.SgStoreStorageBySendBiz;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class SgSendVoidBiz {
    private static final Logger log = LoggerFactory.getLogger(SgSendVoidBiz.class);
    @Resource
    private SgSendService sgSendService;
    @Resource
    private SgSendItemService sgSendItemService;
    @Resource
    private BaseDaoInitialService baseDaoInitialService;
    @Resource
    private SgStoreStorageBySendBiz sgStoreStorageBySendBiz;
    @Resource
    private CommonService commonService;
    @Resource
    private CommonStorageRollBackBiz commonStorageRollBackBiz;
    @Resource
    private SgStorageEffectiveConfig sgStorageEffectiveConfig;
    @Resource
    private SgSendEffectiveItemService sgSendEffectiveItemService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LogAnnotation
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<SgSendBillVoidVo> voidSend(SgSendBillVoidDto dto) {
        SgSendBillVoidVo returnVO;
        block19: {
            ArrayList redisBillFtpKeyListByBatchCode;
            if (log.isDebugEnabled()) {
                log.debug("SgSendVoidBiz.voidSend params:{}", (Object)JSON.toJSONString((Object)dto));
            }
            Boolean isOpenEffective = this.sgStorageEffectiveConfig.isOpenEffective != null && this.sgStorageEffectiveConfig.isOpenEffective != false;
            ArrayList redisBillFtpKeyList = dto.getRedisBillFtpKeyList();
            if (CollectionUtils.isEmpty((Collection)redisBillFtpKeyList)) {
                redisBillFtpKeyList = new ArrayList();
            }
            if (CollectionUtils.isEmpty((Collection)(redisBillFtpKeyListByBatchCode = dto.getRedisBillFtpKeyListByBatchCode()))) {
                redisBillFtpKeyListByBatchCode = new ArrayList();
            }
            returnVO = new SgSendBillVoidVo();
            ApiResponse<Void> checkRes = this.checkParams(dto);
            if (!checkRes.isSuccess()) {
                return ApiResponse.failed((String)checkRes.getDesc());
            }
            String lockRedisKey = SgRedisKey.getSendRedisKey((String)dto.getSourceBillNo(), (Integer)dto.getSourceBillType());
            RedisReentrantLock redisLock = SgRedisLockUtils.getReentrantLock((String)lockRedisKey);
            try {
                if (redisLock.tryLock(0L, TimeUnit.MINUTES)) {
                    ApiResponse<SgSend> res = this.getSendFormDBAndCheckData(dto);
                    if (!res.isSuccess()) {
                        ApiResponse apiResponse = ApiResponse.failed(null, (String)res.getCode(), (String)res.getDesc());
                        return apiResponse;
                    }
                    SgSend sgSendDB = (SgSend)res.getContent();
                    Long sendId = sgSendDB.getId();
                    List sgSendItemDBList = this.sgSendItemService.selectSendItemList(sendId);
                    List sgSendEffectiveItemDBList = this.sgSendEffectiveItemService.selectSendEffectiveItemBysendIdList(sendId);
                    if (CollectionUtils.isNotEmpty((Collection)sgSendItemDBList)) {
                        List<Long> storeIdList = sgSendItemDBList.stream().map(obj -> obj.getSgStoreId()).collect(Collectors.toList());
                        Map<Long, SgStore> negativeStock = this.commonService.getNegativeStockOfStore(storeIdList);
                        ApiResponse<SgStorageBatchUpdateVo> storageRes = this.sgStoreStorageBySendBiz.cleanOrVoidSendStoragePreOut(dto.getServiceNode(), sgSendDB, sgSendItemDBList, negativeStock, sgSendEffectiveItemDBList);
                        if (storageRes.isSuccess()) {
                            redisBillFtpKeyList.addAll(((SgStorageBatchUpdateVo)storageRes.getContent()).getRedisBillFtpKeyList());
                            returnVO.setRedisBillFtpKeyList(((SgStorageBatchUpdateVo)storageRes.getContent()).getRedisBillFtpKeyList());
                            if (isOpenEffective.booleanValue() && ObjectUtils.isNotEmpty((Object)((SgStorageBatchUpdateVo)storageRes.getContent()).getSgStorageEffectiveBatchUpdateVo())) {
                                redisBillFtpKeyListByBatchCode.addAll(((SgStorageBatchUpdateVo)storageRes.getContent()).getSgStorageEffectiveBatchUpdateVo().getRedisBillFtpKeyList());
                                returnVO.setRedisBillFtpKeyListByBatchCode(((SgStorageBatchUpdateVo)storageRes.getContent()).getSgStorageEffectiveBatchUpdateVo().getRedisBillFtpKeyList());
                            }
                        }
                    }
                    SgSend updateSgSend = new SgSend();
                    updateSgSend.setId(sendId);
                    updateSgSend.setTotQtyPreOut(BigDecimal.ZERO);
                    updateSgSend.setBillStatus(SgBizEnum.SendBillStatus.CANCELED.getValue());
                    updateSgSend.setServiceNode(dto.getServiceNode());
                    if (dto.getLoginUser() != null) {
                        BizOperatorInfo bizOperator = new BizOperatorInfo();
                        BeanUtils.copyProperties((Object)dto.getLoginUser(), (Object)bizOperator);
                        this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSgSend, bizOperator);
                    } else {
                        this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSgSend);
                    }
                    this.sgSendService.updateById((Object)updateSgSend);
                    this.sgSendItemService.updateBySendId(sendId, BigDecimal.ZERO);
                    if (isOpenEffective.booleanValue()) {
                        this.sgSendEffectiveItemService.updateBySendId(sendId, BigDecimal.ZERO);
                    }
                    InnerLog.addLog((Long)sendId, (String)"\u4f5c\u5e9f\u903b\u8f91\u53d1\u8d27\u5355", (String)"sg_send", null, (String)"\u4f5c\u5e9f");
                    break block19;
                }
                ApiResponse res = ApiResponse.failed(null, (String)SgErrorCodeEnum.IN_PROGRESS.getCode(), (String)"\u903b\u8f91\u53d1\u8d27\u5355\u6b63\u5728\u88ab\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                return res;
            }
            catch (Exception e) {
                log.error("SgSendBiz.voidSend \u5f02\u5e38:", (Throwable)e);
                this.commonStorageRollBackBiz.rollBackStorage(redisBillFtpKeyList);
                if (isOpenEffective.booleanValue()) {
                    this.commonStorageRollBackBiz.rollBackStorageEffective(redisBillFtpKeyListByBatchCode);
                }
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                ApiResponse apiResponse = ApiResponse.failed((String)e.getMessage());
                return apiResponse;
            }
            finally {
                redisLock.unlock();
            }
        }
        return ApiResponse.success((Object)returnVO, (String)"\u4f5c\u5e9f\u903b\u8f91\u53d1\u8d27\u5355\u6210\u529f");
    }

    private ApiResponse<Void> checkParams(SgSendBillVoidDto dto) {
        try {
            AssertBiz.notNull((Object)dto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getSourceBillNo(), (String)"\u6765\u6e90\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getSourceBillType(), (String)"\u6765\u6e90\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (BizException e) {
            e.printStackTrace();
            return ApiResponse.failed((String)e.getMessage());
        }
        return ApiResponse.success();
    }

    private ApiResponse<SgSend> getSendFormDBAndCheckData(SgSendBillVoidDto dto) {
        boolean flag;
        SgSend sgSend;
        String orderNo = null;
        if (SourceBillTypeEnum.RETAIL.getCode() == dto.getSourceBillType().intValue()) {
            orderNo = dto.getOrderNo();
        }
        if ((sgSend = this.sgSendService.selectEffectiveSend(dto.getSourceBillNo(), orderNo, dto.getSourceBillType())) == null) {
            return ApiResponse.failed(null, (String)SgErrorCodeEnum.NOT_FOUND.getCode(), (String)("\u903b\u8f91\u53d1\u8d27\u5355\u4e0d\u5b58\u5728\u3002\u6765\u6e90\u5355\u636e\u7f16\u53f7\uff1a" + dto.getSourceBillNo()));
        }
        String billStatus = sgSend.getBillStatus();
        boolean bl = flag = !SgBizEnum.SendBillStatus.CREATE.getValue().equals(billStatus) && !SgBizEnum.SendBillStatus.UPDATE.getValue().equals(billStatus);
        if (flag) {
            String msg = "\u5f53\u524d\u903b\u8f91\u53d1\u8d27\u5355\u636e\u72b6\u6001\u4e0d\u5141\u8bb8\u4f5c\u5e9f\u3002\u5355\u636e\u72b6\u6001\uff1a" + SgBizEnum.SendBillStatus.getDesc((String)billStatus);
            return ApiResponse.failed((String)msg);
        }
        return ApiResponse.success((Object)sgSend);
    }
}

