/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.send;

import com.alibaba.fastjson.JSON;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.bizlog.annotation.LogAnnotation;
import com.xinqiyi.framework.bizlog.entity.InnerLog;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.redis.lock.RedisReentrantLock;
import com.xinqiyi.sg.basic.api.model.vo.SgStorageBatchUpdateVo;
import com.xinqiyi.sg.basic.model.common.SgBizEnum;
import com.xinqiyi.sg.basic.model.common.SgErrorCodeEnum;
import com.xinqiyi.sg.basic.model.entity.SgStore;
import com.xinqiyi.sg.basic.service.common.CommonStorageRollBackBiz;
import com.xinqiyi.sg.basic.service.exception.BizException;
import com.xinqiyi.sg.basic.service.utils.AssertBiz;
import com.xinqiyi.sg.basic.service.utils.SgRedisKey;
import com.xinqiyi.sg.basic.service.utils.SgRedisLockUtils;
import com.xinqiyi.sg.store.api.model.vo.send.SgSendBillVoidVo;
import com.xinqiyi.sg.store.model.dto.send.SgSendBillVoidDto;
import com.xinqiyi.sg.store.model.entity.SgSend;
import com.xinqiyi.sg.store.model.entity.SgSendItem;
import com.xinqiyi.sg.store.service.SgSendItemService;
import com.xinqiyi.sg.store.service.SgSendService;
import com.xinqiyi.sg.store.service.business.common.CommonService;
import com.xinqiyi.sg.store.service.business.common.SgStoreStorageBySendBiz;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class SgSendVoidByOmsBiz {
    private static final Logger log = LoggerFactory.getLogger(SgSendVoidByOmsBiz.class);
    @Resource
    private SgSendService sgSendService;
    @Resource
    private SgSendItemService sgSendItemService;
    @Resource
    private BaseDaoInitialService baseDaoInitialService;
    @Resource
    private SgStoreStorageBySendBiz sgStoreStorageBySendBiz;
    @Resource
    private CommonService commonService;
    @Resource
    private CommonStorageRollBackBiz commonStorageRollBackBiz;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LogAnnotation
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<SgSendBillVoidVo> voidSend(SgSendBillVoidDto dto) {
        SgSendBillVoidVo returnVO;
        block17: {
            if (log.isDebugEnabled()) {
                log.debug("SgSendVoidBiz.voidSend params:{}", (Object)JSON.toJSONString((Object)dto));
            }
            List redisBillFtpKeyList = dto.getRedisBillFtpKeyList();
            returnVO = new SgSendBillVoidVo();
            ApiResponse<Void> checkRes = this.checkParams(dto);
            if (!checkRes.isSuccess()) {
                return ApiResponse.failed((String)checkRes.getDesc());
            }
            String lockRedisKey = SgRedisKey.getSendRedisKey((String)dto.getSourceBillNo(), (Integer)dto.getSourceBillType());
            RedisReentrantLock redisLock = SgRedisLockUtils.getReentrantLock((String)lockRedisKey);
            try {
                if (redisLock.tryLock(0L, TimeUnit.MINUTES)) {
                    ApiResponse<SgSend> res = this.getSendFormDBAndCheckData(dto);
                    if (!res.isSuccess()) {
                        ApiResponse apiResponse = ApiResponse.failed((String)res.getDesc());
                        return apiResponse;
                    }
                    SgSend orgSend = (SgSend)res.getContent();
                    Long sendId = orgSend.getId();
                    Map<String, List<SgSendItem>> sgSendItemMap = this.sgSendItemService.selectSendItemList(sendId).stream().collect(Collectors.groupingBy(o -> o.getSgStoreId() + ":" + o.getPsSkuCode()));
                    SgSend cancelSend = this.sgSendService.selectCancelSendBySourceBillNo(dto.getSourceBillNo(), dto.getSourceBillType());
                    ArrayList updateItemList = Lists.newArrayList();
                    ArrayList storageItemList = Lists.newArrayList();
                    List cancelSendItem = this.sgSendItemService.selectSendItemList(cancelSend.getId());
                    BigDecimal subtractQty = BigDecimal.ZERO;
                    BigDecimal subtractQtyPreOut = BigDecimal.ZERO;
                    ArrayList deleteItemIdList = Lists.newArrayList();
                    for (SgSendItem cancelItem : cancelSendItem) {
                        List<SgSendItem> skuItemList = sgSendItemMap.get(cancelItem.getSgStoreId() + ":" + cancelItem.getPsSkuCode());
                        SgSendItem item = skuItemList.get(0);
                        BigDecimal newQty = item.getQty().subtract(cancelItem.getQty());
                        subtractQty = subtractQty.add(cancelItem.getQty());
                        subtractQtyPreOut = subtractQtyPreOut.add(cancelItem.getQtyPreOut());
                        if (newQty.compareTo(BigDecimal.ZERO) > 0) {
                            SgSendItem updateItem = new SgSendItem();
                            updateItem.setId(item.getId());
                            updateItem.setQty(newQty);
                            updateItem.setQtyPreOut(item.getQtyPreOut().subtract(cancelItem.getQtyPreOut()));
                            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateItem, dto.getLoginUser());
                            updateItemList.add(updateItem);
                        } else {
                            deleteItemIdList.add(item.getId());
                        }
                        SgSendItem storageItem = new SgSendItem();
                        BeanUtils.copyProperties((Object)item, (Object)storageItem);
                        storageItem.setQtyPreOut(newQty);
                        storageItemList.add(item);
                    }
                    if (!CollectionUtils.isEmpty((Collection)updateItemList)) {
                        this.sgSendItemService.updateBatchById((Collection)updateItemList);
                    }
                    if (!CollectionUtils.isEmpty((Collection)deleteItemIdList)) {
                        this.sgSendItemService.removeByIds((Collection)deleteItemIdList);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)storageItemList)) {
                        List<Long> storeIdList = storageItemList.stream().map(obj -> obj.getSgStoreId()).collect(Collectors.toList());
                        Map<Long, SgStore> negativeStock = this.commonService.getNegativeStockOfStore(storeIdList);
                        ApiResponse<SgStorageBatchUpdateVo> storageRes = this.sgStoreStorageBySendBiz.cleanOrVoidSendStoragePreOut(dto.getServiceNode(), orgSend, storageItemList, negativeStock, null);
                        if (storageRes.isSuccess()) {
                            returnVO.setRedisBillFtpKeyList(((SgStorageBatchUpdateVo)storageRes.getContent()).getRedisBillFtpKeyList());
                        }
                    }
                    this.updateMain(orgSend, dto, subtractQtyPreOut, returnVO);
                    break block17;
                }
                ApiResponse res = ApiResponse.failed(null, (String)SgErrorCodeEnum.IN_PROGRESS.getCode(), (String)"\u903b\u8f91\u53d1\u8d27\u5355\u6b63\u5728\u88ab\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                return res;
            }
            catch (Exception e) {
                log.error("SgSendBiz.voidSend \u5f02\u5e38:", (Throwable)e);
                this.commonStorageRollBackBiz.rollBackStorage(redisBillFtpKeyList);
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                ApiResponse apiResponse = ApiResponse.failed((String)e.getMessage());
                return apiResponse;
            }
            finally {
                redisLock.unlock();
            }
        }
        return ApiResponse.success((Object)returnVO, (String)"\u4f5c\u5e9f\u903b\u8f91\u53d1\u8d27\u5355\u6210\u529f");
    }

    public void updateMain(SgSend send, SgSendBillVoidDto dto, BigDecimal subtracQtyPreOut, SgSendBillVoidVo returnVO) {
        SgSend updateSgSend = new SgSend();
        updateSgSend.setId(send.getId());
        updateSgSend.setTotQtyPreOut(send.getTotQtyPreOut().subtract(subtracQtyPreOut));
        if (updateSgSend.getTotQtyPreOut().compareTo(BigDecimal.ZERO) <= 0) {
            updateSgSend.setBillStatus(SgBizEnum.SendBillStatus.CANCELED.getValue());
            returnVO.setBillStatus(SgBizEnum.SendBillStatus.CANCELED.getValue());
            InnerLog.addLog((Long)send.getId(), (String)("\u4f5c\u5e9f\u903b\u8f91\u53d1\u8d27\u5355\uff08" + dto.getSourceBillNo() + "\uff09"), (String)"sg_send", null, (String)"\u4f5c\u5e9f");
        } else {
            updateSgSend.setBillStatus(SgBizEnum.SendBillStatus.UPDATE.getValue());
            returnVO.setBillStatus(SgBizEnum.SendBillStatus.UPDATE.getValue());
            InnerLog.addLog((Long)send.getId(), (String)("\u903b\u8f91\u53d1\u8d27\u5355\u90e8\u5206\u91ca\u653e\uff08" + dto.getSourceBillNo() + "\uff09"), (String)"sg_send", null, (String)"\u4f5c\u5e9f");
        }
        updateSgSend.setServiceNode(dto.getServiceNode());
        this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSgSend, dto.getLoginUser());
        this.sgSendService.updateById((Object)updateSgSend);
    }

    private ApiResponse<Void> checkParams(SgSendBillVoidDto dto) {
        try {
            AssertBiz.notNull((Object)dto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getSourceBillNo(), (String)"\u6765\u6e90\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getSourceBillType(), (String)"\u6765\u6e90\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (BizException e) {
            e.printStackTrace();
            return ApiResponse.failed((String)e.getMessage());
        }
        return ApiResponse.success();
    }

    private ApiResponse<SgSend> getSendFormDBAndCheckData(SgSendBillVoidDto dto) {
        boolean flag;
        SgSend sgSend = this.sgSendService.sendByOms(dto.getSourceBillNo(), dto.getSourceBillType());
        if (sgSend == null) {
            return ApiResponse.failed((String)("\u903b\u8f91\u53d1\u8d27\u5355\u4e0d\u5b58\u5728\u3002\u6765\u6e90\u5355\u636e\u7f16\u53f7\uff1a" + dto.getSourceBillNo()));
        }
        String billStatus = sgSend.getBillStatus();
        boolean bl = flag = !SgBizEnum.SendBillStatus.CREATE.getValue().equals(billStatus) && !SgBizEnum.SendBillStatus.UPDATE.getValue().equals(billStatus);
        if (flag) {
            String msg = "\u5f53\u524d\u903b\u8f91\u53d1\u8d27\u5355\u636e\u72b6\u6001\u4e0d\u5141\u8bb8\u4f5c\u5e9f\u3002\u5355\u636e\u72b6\u6001\uff1a" + SgBizEnum.SendBillStatus.getDesc((String)billStatus);
            return ApiResponse.failed((String)msg);
        }
        return ApiResponse.success((Object)sgSend);
    }
}

