/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.send;

import com.alibaba.fastjson.JSON;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.redis.RedisHelper;
import com.xinqiyi.ps.api.model.vo.spu.QueryInteriorSkuVO;
import com.xinqiyi.sg.basic.api.model.vo.SgStorageBatchUpdateVo;
import com.xinqiyi.sg.basic.model.common.SgErrorCodeEnum;
import com.xinqiyi.sg.basic.model.entity.SgBStorageEffective;
import com.xinqiyi.sg.basic.service.SgBStorageEffectiveService;
import com.xinqiyi.sg.basic.service.SgStorageEffectiveBiz;
import com.xinqiyi.sg.basic.service.adapter.common.PsAdapter;
import com.xinqiyi.sg.basic.service.adapter.mdm.MdmAdapter;
import com.xinqiyi.sg.basic.service.exception.BusinessException;
import com.xinqiyi.sg.store.api.model.vo.send.SgOutStockStorageVO;
import com.xinqiyi.sg.store.model.dto.send.SgSendOccupyDto;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SgStockQueryBiz {
    private static final Logger log = LoggerFactory.getLogger(SgStockQueryBiz.class);
    @Resource
    private PsAdapter psAdapter;
    @Resource
    private MdmAdapter mdmAdapter;
    @Resource
    private SgBStorageEffectiveService sgBStorageEffectiveService;

    public ApiResponse<SgOutStockStorageVO> accessToStock(SgSendOccupyDto dto) {
        ApiResponse checkResponse;
        if (log.isDebugEnabled()) {
            log.info("SgStoreQueryBiz.accessToStock \u5165\u53c2 {}", (Object)JSON.toJSONString((Object)dto));
        }
        if (!(checkResponse = this.checkParma(dto)).isSuccess()) {
            return checkResponse;
        }
        List itemList = dto.getItemList();
        List<SgSendOccupyDto.SgSendItemDto> mergeItemList = this.mergeSameSkuIdQty(itemList);
        if (log.isDebugEnabled()) {
            log.info("SgStorageQueryRedisBiz.accessToStock mergeItemList:{}", (Object)JSON.toJSONString(mergeItemList));
        }
        List<String> redisKeyList = this.buildRedisKeyList(mergeItemList);
        if (log.isDebugEnabled()) {
            log.info("SgStorageQueryRedisBiz.accessToStock redisKeyList:{}", (Object)JSON.toJSONString(redisKeyList));
        }
        List resultList = this.queryRedis(redisKeyList);
        if (log.isDebugEnabled()) {
            log.info("SgStorageQueryRedisBiz.accessToStock resultList:{}", (Object)JSON.toJSONString((Object)resultList));
        }
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)resultList)) {
            return ApiResponse.failed((String)"\u67e5\u8be2redis\u5e93\u5b58\u8fd4\u56de\u7a7a");
        }
        ArrayList storageResultList = (ArrayList)resultList.get(1);
        Map<String, RedisStorage> redisStorageMap = this.getRedsStorageMap(storageResultList);
        if (org.springframework.util.CollectionUtils.isEmpty(redisStorageMap)) {
            return ApiResponse.failed((String)"\u67e5\u8be2redis\u5e93\u5b58\u7ed3\u679c\u503c\u4e3a\u8fd4\u56de\u7a7a");
        }
        SgOutStockStorageVO sgOutStockStorageVO = new SgOutStockStorageVO();
        ArrayList<SgStorageBatchUpdateVo.OutStockItem> outStockItemList = new ArrayList<SgStorageBatchUpdateVo.OutStockItem>();
        this.getOutStockItemList(outStockItemList, redisStorageMap, mergeItemList, dto.getMain());
        String msg = this.processOutStockItemMsg(outStockItemList);
        sgOutStockStorageVO.setOutStockItemMsg(msg);
        sgOutStockStorageVO.setOutStockItemList(outStockItemList);
        return ApiResponse.success((Object)sgOutStockStorageVO);
    }

    private void getOutStockItemList(List<SgStorageBatchUpdateVo.OutStockItem> outStockItemList, Map<String, RedisStorage> redisStorageMap, List<SgSendOccupyDto.SgSendItemDto> mergeItemList, SgSendOccupyDto.SgSendDto main) {
        for (SgSendOccupyDto.SgSendItemDto item : mergeItemList) {
            BigDecimal available;
            BigDecimal qty = Optional.ofNullable(item.getQty()).orElse(BigDecimal.ZERO);
            BigDecimal diffQty = BigDecimal.ZERO;
            String key = "sg:storage:" + item.getSgStoreId() + ":" + item.getPsSkuId();
            RedisStorage redisStorage = redisStorageMap.get(key);
            if (redisStorage == null || (diffQty = (available = Optional.ofNullable(redisStorage.getAvailable()).orElse(BigDecimal.ZERO)).subtract(qty)).compareTo(BigDecimal.ZERO) >= 0) continue;
            SgStorageBatchUpdateVo.OutStockItem outStockItem = this.buildOutStockItem(item, diffQty, main, null);
            outStockItemList.add(outStockItem);
        }
        if (log.isDebugEnabled()) {
            log.info("SgStorageQueryRedisBiz.getOutStockItemList outStockItemList\uff1a{}", (Object)JSON.toJSONString(outStockItemList));
        }
    }

    private SgStorageBatchUpdateVo.OutStockItem buildOutStockItem(SgSendOccupyDto.SgSendItemDto item, BigDecimal diffQty, SgSendOccupyDto.SgSendDto main, String batchCode) {
        SgStorageBatchUpdateVo.OutStockItem outStockItem = new SgStorageBatchUpdateVo.OutStockItem();
        String skuName = item.getPsSpec1Name();
        outStockItem.setPsSkuId(item.getPsSkuId());
        outStockItem.setPsSkuCode(item.getPsSkuCode());
        outStockItem.setPsSkuName(skuName);
        outStockItem.setQty(diffQty.abs());
        outStockItem.setSgStoreId(item.getSgStoreId());
        outStockItem.setSgStoreCode(item.getSgStoreCode());
        outStockItem.setSgStoreName(item.getSgStoreName());
        outStockItem.setPhyWarehouseId(main.getSgWarehouseId());
        outStockItem.setPhyWarehouseCode(main.getSgWarehouseCode());
        outStockItem.setPhyWarehouseName(main.getSgWarehouseName());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)batchCode)) {
            outStockItem.setBatchCode(batchCode);
        }
        return outStockItem;
    }

    private String processOutStockItemMsg(List<SgStorageBatchUpdateVo.OutStockItem> outStockItemList) {
        if (!org.springframework.util.CollectionUtils.isEmpty(outStockItemList)) {
            StringBuilder sb = new StringBuilder();
            for (SgStorageBatchUpdateVo.OutStockItem outStockItem : outStockItemList) {
                sb.append("\u5546\u54c1\u3010" + outStockItem.getPsSkuName() + "\uff08" + outStockItem.getPsSkuCode() + "\uff09\u3011\u5728\u4ed3\u5e93\u3010" + outStockItem.getPhyWarehouseName() + "-" + outStockItem.getSgStoreName() + "\u3011\u5e93\u5b58\u4e0d\u8db3\uff1b");
                sb.append("\n");
            }
            return sb.toString();
        }
        return null;
    }

    private Map<String, RedisStorage> getRedsStorageMap(List<List> storageResultList) {
        HashMap<String, RedisStorage> redisStorageMap = null;
        if (log.isDebugEnabled()) {
            log.info("SgStorageQueryRedisBiz.getRedisStorageMap \u5165\u53c2 storageResultList:{}", (Object)JSON.toJSONString(storageResultList));
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(storageResultList)) {
            redisStorageMap = new HashMap<String, RedisStorage>();
            for (List storageResult : storageResultList) {
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)storageResult)) continue;
                BigDecimal preout = new BigDecimal((String)storageResult.get(0));
                BigDecimal prein = new BigDecimal((String)storageResult.get(1));
                BigDecimal storage = new BigDecimal((String)storageResult.get(2));
                BigDecimal available = new BigDecimal((String)storageResult.get(3));
                String key = (String)storageResult.get(4);
                RedisStorage redisStorage = new RedisStorage();
                redisStorage.setPreout(preout);
                redisStorage.setPrein(prein);
                redisStorage.setStorage(storage);
                redisStorage.setAvailable(available);
                redisStorageMap.put(key, redisStorage);
            }
        }
        if (log.isDebugEnabled()) {
            log.info("SgStorageQueryRedisBiz.getRedisStorageMap \u8fd4\u56de\u503c redisStorageMap:{}", (Object)JSON.toJSONString(redisStorageMap));
        }
        return redisStorageMap;
    }

    private List queryRedis(List<String> redisKeyList) {
        RedisTemplate redisMasterTemplate = RedisHelper.getRedisTemplate();
        DefaultRedisScript redisScript = new DefaultRedisScript();
        redisScript.setLocation((org.springframework.core.io.Resource)new ClassPathResource("lua/QueryRedisStorage.lua"));
        redisScript.setResultType(List.class);
        List result = (List)redisMasterTemplate.execute((RedisScript)redisScript, redisKeyList, new Object[0]);
        return result;
    }

    private List<String> buildRedisKeyList(List<SgSendOccupyDto.SgSendItemDto> mergeItemList) {
        ArrayList<String> redisKeyList = new ArrayList<String>();
        for (SgSendOccupyDto.SgSendItemDto item : mergeItemList) {
            String key = "sg:storage:" + item.getSgStoreId() + ":" + item.getPsSkuId();
            redisKeyList.add(key);
        }
        return redisKeyList;
    }

    private List<SgSendOccupyDto.SgSendItemDto> mergeSameSkuIdQty(List<SgSendOccupyDto.SgSendItemDto> itemList) {
        if (log.isDebugEnabled()) {
            log.info("SgStoreQueryBiz.mergeSameSkuIdQty \u5408\u5e76\u524d {}", (Object)JSON.toJSONString(itemList));
        }
        Map<Long, List<SgSendOccupyDto.SgSendItemDto>> newSendItemMap = itemList.stream().collect(Collectors.groupingBy(obj -> obj.getPsSkuId()));
        Iterator<Long> it = newSendItemMap.keySet().iterator();
        ArrayList<SgSendOccupyDto.SgSendItemDto> newItemList = new ArrayList<SgSendOccupyDto.SgSendItemDto>();
        while (it.hasNext()) {
            Long skuId = it.next();
            List<SgSendOccupyDto.SgSendItemDto> sameSkuList = newSendItemMap.get(skuId);
            BigDecimal newQty = sameSkuList.stream().map(SgSendOccupyDto.SgSendItemDto::getQty).reduce(BigDecimal.ZERO, BigDecimal::add);
            SgSendOccupyDto.SgSendItemDto sgSendItemDto = sameSkuList.get(0);
            SgSendOccupyDto.SgSendItemDto sgOutItemSaveDto = new SgSendOccupyDto.SgSendItemDto();
            BeanUtils.copyProperties((Object)sgSendItemDto, (Object)sgOutItemSaveDto);
            sgOutItemSaveDto.setQty(newQty);
            newItemList.add(sgOutItemSaveDto);
        }
        if (log.isDebugEnabled()) {
            log.info("SgStoreQueryBiz.mergeSameSkuIdQty \u5408\u5e76\u524d\u540e {}", (Object)JSON.toJSONString(newItemList));
        }
        return newItemList;
    }

    private ApiResponse checkParma(SgSendOccupyDto dto) {
        if (dto == null || dto.getMain() == null || dto.getItemList() == null) {
            return ApiResponse.failed(null, (String)SgErrorCodeEnum.CHECK_PARAM.getCode(), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List itemList = dto.getItemList();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)itemList)) {
            return ApiResponse.failed(null, (String)SgErrorCodeEnum.CHECK_PARAM.getCode(), (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (SgSendOccupyDto.SgSendItemDto item : itemList) {
            if (item.getPsSkuId() == null || StringUtils.isEmpty((Object)item.getPsSkuCode())) {
                return ApiResponse.failed(null, (String)SgErrorCodeEnum.CHECK_PARAM.getCode(), (String)"\u6761\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (item.getSgStoreId() != null && !StringUtils.isEmpty((Object)item.getSgStoreCode())) continue;
            return ApiResponse.failed(null, (String)SgErrorCodeEnum.CHECK_PARAM.getCode(), (String)("[" + item.getPsSkuCode() + "]\u903b\u8f91\u4ed3ID\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        return ApiResponse.success();
    }

    public ApiResponse<SgOutStockStorageVO> accessToEffectiveStock(SgSendOccupyDto dto) {
        if (log.isDebugEnabled()) {
            log.info("SgStoreQueryBiz.accessToEffectiveStock \u5165\u53c2 {}", (Object)JSON.toJSONString((Object)dto));
        }
        String effectiveLabel = dto.getEffectiveLabel();
        Integer redundantDays = dto.getRedundantDays() == null ? 0 : dto.getRedundantDays();
        ApiResponse checkResponse = this.checkParmaByEffective(dto);
        if (!checkResponse.isSuccess()) {
            return checkResponse;
        }
        List itemList = dto.getItemList();
        List<SgSendOccupyDto.SgSendItemDto> mergeItemList = this.mergeSameSkuIdAndBatchCodeQty(itemList);
        if (log.isDebugEnabled()) {
            log.info("SgStorageQueryRedisBiz.accessToEffectiveStock mergeItemList:{}", (Object)JSON.toJSONString(mergeItemList));
        }
        Map<String, List<String>> batchCodeMap = this.batchCodeMap(effectiveLabel, mergeItemList, redundantDays);
        List<String> redisKeyList = this.buildRedisKeyByBatchCodeList(mergeItemList, batchCodeMap);
        if (log.isDebugEnabled()) {
            log.info("SgStorageQueryRedisBiz.accessToEffectiveStock redisKeyList:{}", (Object)JSON.toJSONString(redisKeyList));
        }
        List resultList = this.queryRedis(redisKeyList);
        if (log.isDebugEnabled()) {
            log.info("SgStorageQueryRedisBiz.accessToEffectiveStock resultList:{}", (Object)JSON.toJSONString((Object)resultList));
        }
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)resultList)) {
            return ApiResponse.failed((String)"\u67e5\u8be2redis\u5e93\u5b58\u8fd4\u56de\u7a7a");
        }
        ArrayList storageResultList = (ArrayList)resultList.get(1);
        Map<String, RedisStorage> redisStorageMap = this.getRedsStorageMap(storageResultList);
        if (org.springframework.util.CollectionUtils.isEmpty(redisStorageMap)) {
            return ApiResponse.failed((String)"\u67e5\u8be2redis\u5e93\u5b58\u7ed3\u679c\u503c\u4e3a\u8fd4\u56de\u7a7a");
        }
        SgOutStockStorageVO sgOutStockStorageVO = new SgOutStockStorageVO();
        ArrayList<SgStorageBatchUpdateVo.OutStockItem> outStockItemList = new ArrayList<SgStorageBatchUpdateVo.OutStockItem>();
        this.getOutStockItemByBatchCodeList(outStockItemList, redisStorageMap, mergeItemList, dto.getMain(), batchCodeMap);
        String msg = this.processOutStockItemByBatchCodeMsg(outStockItemList);
        sgOutStockStorageVO.setOutStockItemMsg(msg);
        sgOutStockStorageVO.setOutStockItemList(outStockItemList);
        return ApiResponse.success((Object)sgOutStockStorageVO);
    }

    private ApiResponse checkParmaByEffective(SgSendOccupyDto dto) {
        if (dto == null || dto.getMain() == null || dto.getItemList() == null) {
            return ApiResponse.failed(null, (String)SgErrorCodeEnum.CHECK_PARAM.getCode(), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List itemList = dto.getItemList();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)itemList)) {
            return ApiResponse.failed(null, (String)SgErrorCodeEnum.CHECK_PARAM.getCode(), (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (SgSendOccupyDto.SgSendItemDto item : itemList) {
            if (item.getPsSkuId() == null || StringUtils.isEmpty((Object)item.getPsSkuCode())) {
                return ApiResponse.failed(null, (String)SgErrorCodeEnum.CHECK_PARAM.getCode(), (String)"\u6761\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (item.getSgStoreId() != null && !StringUtils.isEmpty((Object)item.getSgStoreCode())) continue;
            return ApiResponse.failed(null, (String)SgErrorCodeEnum.CHECK_PARAM.getCode(), (String)("[" + item.getPsSkuCode() + "]\u903b\u8f91\u4ed3ID\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        return ApiResponse.success();
    }

    private List<SgSendOccupyDto.SgSendItemDto> mergeSameSkuIdAndBatchCodeQty(List<SgSendOccupyDto.SgSendItemDto> itemList) {
        if (log.isDebugEnabled()) {
            log.info("SgStoreQueryBiz.mergeSameSkuIdAndBatchCodeQty \u5408\u5e76\u524d {}", (Object)JSON.toJSONString(itemList));
        }
        Map<String, List<SgSendOccupyDto.SgSendItemDto>> newSendItemMap = itemList.stream().collect(Collectors.groupingBy(obj -> obj.getPsSkuId() + 95L + obj.getBatchCode()));
        Iterator<String> it = newSendItemMap.keySet().iterator();
        ArrayList<SgSendOccupyDto.SgSendItemDto> newItemList = new ArrayList<SgSendOccupyDto.SgSendItemDto>();
        while (it.hasNext()) {
            String skuIdAndBatch = it.next();
            List<SgSendOccupyDto.SgSendItemDto> sameSkuList = newSendItemMap.get(skuIdAndBatch);
            BigDecimal newQty = sameSkuList.stream().map(SgSendOccupyDto.SgSendItemDto::getQty).reduce(BigDecimal.ZERO, BigDecimal::add);
            SgSendOccupyDto.SgSendItemDto sgSendItemDto = sameSkuList.get(0);
            SgSendOccupyDto.SgSendItemDto sgOutItemSaveDto = new SgSendOccupyDto.SgSendItemDto();
            BeanUtils.copyProperties((Object)sgSendItemDto, (Object)sgOutItemSaveDto);
            sgOutItemSaveDto.setQty(newQty);
            QueryInteriorSkuVO skuInfo = this.psAdapter.getSkuInfo(sgSendItemDto.getPsSkuId());
            if (ObjectUtils.isEmpty((Object)skuInfo)) {
                throw new BusinessException("\u83b7\u53d6\u5546\u54c1\u4fe1\u606f\u51fa\u9519");
            }
            Boolean isValidityPeriodControlled = org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)String.valueOf(skuInfo.getBatchManage()));
            sgOutItemSaveDto.setIsValidityPeriodControlled(isValidityPeriodControlled);
            newItemList.add(sgOutItemSaveDto);
        }
        if (log.isDebugEnabled()) {
            log.info("SgStoreQueryBiz.mergeSameSkuIdAndBatchCodeQty \u5408\u5e76\u524d\u540e {}", (Object)JSON.toJSONString(newItemList));
        }
        return newItemList;
    }

    private List<String> buildRedisKeyByBatchCodeList(List<SgSendOccupyDto.SgSendItemDto> mergeItemList, Map<String, List<String>> batchCodeMap) {
        ArrayList<String> redisKeyList = new ArrayList<String>();
        for (SgSendOccupyDto.SgSendItemDto item : mergeItemList) {
            List<String> batchCodeList = batchCodeMap.get(item.getPsSkuId() + "_" + item.getSgStoreId());
            for (String batchCode : batchCodeList) {
                String key = "sg:storage:effective:" + item.getSgStoreId() + ":" + item.getPsSkuId() + ":" + batchCode;
                redisKeyList.add(key);
            }
        }
        return redisKeyList;
    }

    private void getOutStockItemByBatchCodeList(List<SgStorageBatchUpdateVo.OutStockItem> outStockItemList, Map<String, RedisStorage> redisStorageMap, List<SgSendOccupyDto.SgSendItemDto> mergeItemList, SgSendOccupyDto.SgSendDto main, Map<String, List<String>> batchCodeMap) {
        for (SgSendOccupyDto.SgSendItemDto item : mergeItemList) {
            BigDecimal qty = Optional.ofNullable(item.getQty()).orElse(BigDecimal.ZERO);
            BigDecimal diffQty = BigDecimal.ZERO;
            boolean outStockFlag = true;
            List<String> batchCodeList = batchCodeMap.get(item.getPsSkuId() + "_" + item.getSgStoreId());
            BigDecimal remainQty = qty;
            BigDecimal packageUnitQty = BigDecimal.valueOf(1L);
            if (item.getPsPackageUnitQty() != null) {
                packageUnitQty = BigDecimal.valueOf(item.getPsPackageUnitQty().intValue());
            }
            for (String batchCode : batchCodeList) {
                String key = "sg:storage:effective:" + item.getSgStoreId() + ":" + item.getPsSkuId() + ":" + batchCode;
                RedisStorage redisStorage = redisStorageMap.get(key);
                if (redisStorage == null) continue;
                BigDecimal available = SgStockQueryBiz.isNullReturnZero(redisStorage.getAvailable());
                BigDecimal packageAvailableQty = available.divide(packageUnitQty, 0, RoundingMode.DOWN);
                diffQty = (packageAvailableQty = packageAvailableQty.multiply(packageUnitQty)).subtract(remainQty);
                if (diffQty.compareTo(BigDecimal.ZERO) >= 0) {
                    outStockFlag = false;
                    break;
                }
                remainQty = remainQty.subtract(packageAvailableQty).abs();
            }
            if (!outStockFlag) continue;
            BigDecimal diffQtyNew = diffQty.abs().divide(packageUnitQty, 0, RoundingMode.UP);
            SgStorageBatchUpdateVo.OutStockItem outStockItem = this.buildOutStockItem(item, diffQtyNew, main, batchCodeList.get(0));
            outStockItemList.add(outStockItem);
        }
        if (log.isDebugEnabled()) {
            log.info("SgStorageQueryRedisBiz.getOutStockItemByBatchCodeList outStockItemList\uff1a{}", (Object)JSON.toJSONString(outStockItemList));
        }
    }

    private String processOutStockItemByBatchCodeMsg(List<SgStorageBatchUpdateVo.OutStockItem> outStockItemList) {
        if (!org.springframework.util.CollectionUtils.isEmpty(outStockItemList)) {
            StringBuilder sb = new StringBuilder();
            for (SgStorageBatchUpdateVo.OutStockItem outStockItem : outStockItemList) {
                sb.append("\u5546\u54c1\u3010" + outStockItem.getPsSkuName() + "\uff08" + outStockItem.getPsSkuCode() + "\uff09\u3011\u5728\u4ed3\u5e93\u3010" + outStockItem.getPhyWarehouseName() + "-" + outStockItem.getSgStoreName() + "\u3011\u6548\u671f\u6279\u6b21\u3010" + outStockItem.getBatchCode() + "\u3011\u4e2d\u5e93\u5b58\u4e0d\u8db3\uff1b");
                sb.append("\n");
            }
            return sb.toString();
        }
        return null;
    }

    public Map<String, List<String>> batchCodeMap(String effectiveLabel, List<SgSendOccupyDto.SgSendItemDto> itemList, Integer redundantDays) {
        LinkedHashMap<String, List<String>> batchCodeMap = new LinkedHashMap<String, List<String>>();
        String defaultEffectiveBatchCode = this.mdmAdapter.selectMdmSystemConfig("DEFAULT_EFFECTIVE_BATCH_CODE");
        for (SgSendOccupyDto.SgSendItemDto item : itemList) {
            Boolean isValidityPeriodControlled;
            List<String> batchCodeList = new ArrayList<String>();
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)item.getBatchCode())) {
                batchCodeList.add(item.getBatchCode());
            }
            if (!(isValidityPeriodControlled = item.getIsValidityPeriodControlled()).booleanValue() && CollectionUtils.isEmpty(batchCodeList)) {
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)defaultEffectiveBatchCode)) {
                    batchCodeList.add(defaultEffectiveBatchCode);
                } else {
                    throw new BusinessException("\u672a\u914d\u7f6e\u6548\u671f\u5e93\u5b58\u9ed8\u8ba4\u6548\u671f\u6279\u6b21");
                }
            }
            if (CollectionUtils.isEmpty(batchCodeList)) {
                batchCodeList = this.getBatchCodeList(effectiveLabel, item.getPsSkuId(), item.getSgStoreId(), redundantDays);
            }
            if (org.springframework.util.CollectionUtils.isEmpty(batchCodeList)) {
                throw new BusinessException("\u67e5\u8be2\u6548\u671f\u6279\u6b21\u4fe1\u606f\u51fa\u9519\u6216\u8005\u672a\u67e5\u5230\u5546\u54c1\u6279\u6b21\u5e93\u5b58\u4fe1\u606f");
            }
            batchCodeMap.put(item.getPsSkuId() + "_" + item.getSgStoreId(), batchCodeList);
        }
        if (log.isDebugEnabled()) {
            log.info("SgStockQueryBiz.batchCodeMap \u8fd4\u56de\u503c {}", (Object)JSON.toJSONString(batchCodeMap));
        }
        return batchCodeMap;
    }

    public List<String> getBatchCodeList(String effectiveLabel, Long psSkuId, Long storeId, Integer redundantDays) {
        List<Object> batchCodeList = new ArrayList();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)effectiveLabel)) {
            List sgBStorageEffectiveList = this.sgBStorageEffectiveService.getListBatchCodeBySkuIdAndStoreId(psSkuId, storeId);
            batchCodeList = sgBStorageEffectiveList.stream().map(SgBStorageEffective::getBatchCode).collect(Collectors.toList());
        } else {
            BigDecimal effectiveLabelValue = SgStorageEffectiveBiz.getEffectiveLabelValue((String)effectiveLabel);
            List sgBStorageEffectiveList = this.sgBStorageEffectiveService.getListBySkuIdAndStoreIdAndEffectiveLabelAndRedundantDays(psSkuId, storeId, effectiveLabelValue, redundantDays);
            batchCodeList = sgBStorageEffectiveList.stream().map(SgBStorageEffective::getBatchCode).collect(Collectors.toList());
        }
        return batchCodeList;
    }

    public static BigDecimal isNullReturnZero(BigDecimal amt) {
        return amt == null ? BigDecimal.ZERO : amt;
    }

    public static class RedisStorage {
        private BigDecimal preout;
        private BigDecimal prein;
        private BigDecimal storage;
        private BigDecimal available;

        public BigDecimal getPreout() {
            return this.preout;
        }

        public BigDecimal getPrein() {
            return this.prein;
        }

        public BigDecimal getStorage() {
            return this.storage;
        }

        public BigDecimal getAvailable() {
            return this.available;
        }

        public void setPreout(BigDecimal preout) {
            this.preout = preout;
        }

        public void setPrein(BigDecimal prein) {
            this.prein = prein;
        }

        public void setStorage(BigDecimal storage) {
            this.storage = storage;
        }

        public void setAvailable(BigDecimal available) {
            this.available = available;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RedisStorage)) {
                return false;
            }
            RedisStorage other = (RedisStorage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigDecimal this$preout = this.getPreout();
            BigDecimal other$preout = other.getPreout();
            if (this$preout == null ? other$preout != null : !((Object)this$preout).equals(other$preout)) {
                return false;
            }
            BigDecimal this$prein = this.getPrein();
            BigDecimal other$prein = other.getPrein();
            if (this$prein == null ? other$prein != null : !((Object)this$prein).equals(other$prein)) {
                return false;
            }
            BigDecimal this$storage = this.getStorage();
            BigDecimal other$storage = other.getStorage();
            if (this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage)) {
                return false;
            }
            BigDecimal this$available = this.getAvailable();
            BigDecimal other$available = other.getAvailable();
            return !(this$available == null ? other$available != null : !((Object)this$available).equals(other$available));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RedisStorage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigDecimal $preout = this.getPreout();
            result = result * 59 + ($preout == null ? 43 : ((Object)$preout).hashCode());
            BigDecimal $prein = this.getPrein();
            result = result * 59 + ($prein == null ? 43 : ((Object)$prein).hashCode());
            BigDecimal $storage = this.getStorage();
            result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
            BigDecimal $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            return result;
        }

        public String toString() {
            return "SgStockQueryBiz.RedisStorage(preout=" + this.getPreout() + ", prein=" + this.getPrein() + ", storage=" + this.getStorage() + ", available=" + this.getAvailable() + ")";
        }
    }
}

