/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.send.restructure;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.redis.lock.RedisReentrantLock;
import com.xinqiyi.sg.basic.model.common.SgErrorCodeEnum;
import com.xinqiyi.sg.basic.model.dto.SgStorageRollBackDto;
import com.xinqiyi.sg.basic.service.business.SgStorageEffectiveRollBackBiz;
import com.xinqiyi.sg.basic.service.business.SgStorageRollBackBiz;
import com.xinqiyi.sg.basic.service.utils.SgRedisKey;
import com.xinqiyi.sg.basic.service.utils.SgRedisLockUtils;
import com.xinqiyi.sg.store.api.model.vo.send.SgSendBillSaveVo;
import com.xinqiyi.sg.store.model.dto.send.SgBatchSendOccupyDto;
import com.xinqiyi.sg.store.model.dto.send.SgSendOccupyDto;
import com.xinqiyi.sg.store.service.business.send.restructure.SgSendOccupyBiz;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class SgBatchSendOccupyBiz {
    private static final Logger log = LoggerFactory.getLogger(SgBatchSendOccupyBiz.class);
    @Resource
    private SgSendOccupyBiz sgSendOccupyBiz;
    @Autowired
    SgStorageRollBackBiz sgStorageRollBackBiz;
    @Autowired
    SgStorageEffectiveRollBackBiz sgStorageEffectiveRollBackBiz;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public ApiResponse<List<SgSendBillSaveVo>> batchSendOccupy(SgBatchSendOccupyDto sgBatchOutBillDto) {
        ArrayList successResultList;
        block15: {
            log.info("SgBatchSendOccupyBiz.batchSendOccupy.start");
            if (log.isDebugEnabled()) {
                log.debug("SgBatchSendOccupyBiz.batchSendOccupy.param:{}", (Object)JSON.toJSONString((Object)sgBatchOutBillDto));
            }
            Assert.isTrue((boolean)CharSequenceUtil.isNotBlank((CharSequence)sgBatchOutBillDto.getBatchNo()), (String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            ArrayList errorMsgList = Lists.newArrayList();
            ArrayList failResultList = Lists.newArrayList();
            successResultList = Lists.newArrayList();
            ArrayList redisBillFtpKeyList = Lists.newArrayList();
            ArrayList redisBillFtpKeyListByBatchCode = new ArrayList();
            String batchNo = sgBatchOutBillDto.getBatchNo();
            String lockRedisKey = SgRedisKey.getBatchNoRedisKey((String)batchNo);
            RedisReentrantLock redisLock = SgRedisLockUtils.getReentrantLock((String)lockRedisKey);
            List sgOutBillDtoList = sgBatchOutBillDto.getSgSendOccupyDtoList();
            try {
                if (redisLock.tryLock(0L, TimeUnit.MINUTES)) {
                    for (SgSendOccupyDto dto : sgOutBillDtoList) {
                        ApiResponse<SgSendBillSaveVo> response = this.sgSendOccupyBiz.sendOccupy(dto);
                        SgSendBillSaveVo content = (SgSendBillSaveVo)response.getContent();
                        if (content != null) {
                            content.setSourceBillNo(dto.getMain().getSourceBillNo());
                        }
                        if (response.isSuccess()) {
                            successResultList.add(content);
                            redisBillFtpKeyList.addAll(content.getRedisBillFtpKeyList());
                            if (!content.getIsOpenEffective().booleanValue() || !CollectionUtils.isNotEmpty((Collection)content.getRedisBillFtpKeyListByBatchCode())) continue;
                            redisBillFtpKeyListByBatchCode.addAll(content.getRedisBillFtpKeyListByBatchCode());
                            continue;
                        }
                        failResultList.add((SgSendBillSaveVo)response.getContent());
                        errorMsgList.add(response.getDesc());
                    }
                    if (CollUtil.isNotEmpty((Collection)failResultList)) {
                        SgStorageRollBackDto rollBackEffectiveDto;
                        log.info("SgBatchSendOccupyBiz.batchSendOccupy have failResult");
                        if (log.isDebugEnabled()) {
                            log.debug("SgBatchSendOccupyBiz.batchSendOccupy.failResultList:{}", (Object)JSON.toJSONString((Object)failResultList));
                        }
                        SgStorageRollBackDto rollBackDto = new SgStorageRollBackDto();
                        rollBackDto.setRollbackDBflag(true);
                        rollBackDto.setRedisBillFtpKeyList((List)redisBillFtpKeyList);
                        this.sgStorageRollBackBiz.rollbackStorageBill(rollBackDto);
                        if (CollectionUtils.isNotEmpty(redisBillFtpKeyListByBatchCode)) {
                            rollBackEffectiveDto = new SgStorageRollBackDto();
                            rollBackEffectiveDto.setRollbackDBflag(true);
                            rollBackEffectiveDto.setRedisBillFtpKeyList(redisBillFtpKeyListByBatchCode);
                            this.sgStorageEffectiveRollBackBiz.rollbackStorageBill(rollBackEffectiveDto);
                        }
                        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                        rollBackEffectiveDto = ApiResponse.failed((Object)failResultList, (String)CollUtil.join((Iterable)errorMsgList, (CharSequence)";"));
                        return rollBackEffectiveDto;
                    }
                    break block15;
                }
                ApiResponse rollBackDto = ApiResponse.failed((Object)failResultList, (String)SgErrorCodeEnum.IN_PROGRESS.getCode(), (String)"\u5f53\u524d\u6279\u6b21\u6b63\u5728\u88ab\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                return rollBackDto;
            }
            catch (Exception e) {
                log.error("SgBatchSendOccupyBiz.batchSendOccupy.error:", (Throwable)e);
                SgStorageRollBackDto rollBackDto = new SgStorageRollBackDto();
                rollBackDto.setRollbackDBflag(true);
                rollBackDto.setRedisBillFtpKeyList((List)redisBillFtpKeyList);
                this.sgStorageRollBackBiz.rollbackStorageBill(rollBackDto);
                if (CollectionUtils.isNotEmpty(redisBillFtpKeyListByBatchCode)) {
                    SgStorageRollBackDto rollBackEffectiveDto = new SgStorageRollBackDto();
                    rollBackEffectiveDto.setRollbackDBflag(true);
                    rollBackEffectiveDto.setRedisBillFtpKeyList(redisBillFtpKeyListByBatchCode);
                    this.sgStorageEffectiveRollBackBiz.rollbackStorageBill(rollBackEffectiveDto);
                }
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                ApiResponse apiResponse = ApiResponse.failed((Object)failResultList, (String)("\u6267\u884c\u6279\u91cf\u5360\u5355\u5f02\u5e38:" + e.getMessage()));
                return apiResponse;
            }
            finally {
                redisLock.unlock();
            }
        }
        return ApiResponse.success((Object)successResultList);
    }
}

