/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.send.restructure;

import com.alibaba.fastjson.JSON;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.business.model.BizOperatorInfo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.api.model.vo.spu.QueryInteriorSkuVO;
import com.xinqiyi.sg.basic.api.model.vo.SgStorageBatchUpdateVo;
import com.xinqiyi.sg.basic.api.model.vo.SgStorageUpdateBillItemVo;
import com.xinqiyi.sg.basic.model.common.SgBizEnum;
import com.xinqiyi.sg.basic.model.common.SgErrorCodeEnum;
import com.xinqiyi.sg.basic.model.common.SourceBillTypeEnum;
import com.xinqiyi.sg.basic.model.common.SupplyStrategyBusinessTypeEnum;
import com.xinqiyi.sg.basic.model.dto.SgStorageUpdateBillItemBaseDto;
import com.xinqiyi.sg.basic.model.dto.SgSupplyStrategyPriorityDTO;
import com.xinqiyi.sg.basic.model.entity.SgStore;
import com.xinqiyi.sg.basic.model.entity.SgWarehouse;
import com.xinqiyi.sg.basic.service.adapter.common.PsAdapter;
import com.xinqiyi.sg.basic.service.adapter.common.SgWarehouseAdapter;
import com.xinqiyi.sg.basic.service.business.SgStoreBiz;
import com.xinqiyi.sg.basic.service.exception.BizException;
import com.xinqiyi.sg.basic.service.exception.BusinessException;
import com.xinqiyi.sg.basic.service.utils.AssertBiz;
import com.xinqiyi.sg.basic.service.utils.StoreManager;
import com.xinqiyi.sg.store.model.dto.send.SgSendOccupyDto;
import com.xinqiyi.sg.store.model.entity.SgSend;
import com.xinqiyi.sg.store.model.entity.SgSendEffectiveItem;
import com.xinqiyi.sg.store.model.entity.SgSendItem;
import com.xinqiyi.sg.store.service.SgSendEffectiveItemService;
import com.xinqiyi.sg.store.service.SgSendItemService;
import com.xinqiyi.sg.store.service.SgSendService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class SgSendCommonBiz {
    private static final Logger log = LoggerFactory.getLogger(SgSendCommonBiz.class);
    @Resource
    private SgSendService sgSendService;
    @Resource
    private SgSendItemService sgSendItemService;
    @Resource
    private PsAdapter psAdapter;
    @Resource
    private SgStoreBiz sgStoreBiz;
    @Resource
    private IdSequenceGenerator idSequenceGenerator;
    @Resource
    private SgWarehouseAdapter sgWarehouseAdapter;
    @Resource
    private SgSendEffectiveItemService sgSendEffectiveItemService;

    public ApiResponse<SendCommonEntity> checkParams(SgSendOccupyDto dto) {
        Long startTime = System.currentTimeMillis();
        try {
            AssertBiz.notNull((Object)dto, (String)"\u903b\u8f91\u53d1\u8d27\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getMain(), (String)"\u903b\u8f91\u53d1\u8d27\u5355\u4e3b\u8868\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getUserInfo(), (String)"\u903b\u8f91\u53d1\u8d27\u5355UserInfo\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.isTrue((!org.springframework.util.CollectionUtils.isEmpty((Collection)dto.getItemList()) ? 1 : 0) != 0, (String)"\u903b\u8f91\u53d1\u8d27\u5355\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getMain().getSourceBillNo(), (String)"\u6765\u6e90\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getMain().getSourceBillType(), (String)"\u6765\u6e90\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            AssertBiz.notNull((Object)dto.getMain().getSgWarehouseId(), (String)"\u5b9e\u4f53\u4ed3ID\u4e0d\u80fd\u4e3a\u7a7a");
            if (StringUtils.isEmpty((Object)dto.getMain().getSgWarehouseCode())) {
                throw new BizException("\u5b9e\u4f53\u4ed3\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)dto.getMain().getSgWarehouseName())) {
                throw new BizException("\u5b9e\u4f53\u4ed3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List sendItemSaveDtoList = dto.getItemList();
            for (SgSendOccupyDto.SgSendItemDto item : sendItemSaveDtoList) {
                AssertBiz.notNull((Object)item, (String)"\u6765\u6e90\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                String psSkuCode = item.getPsSkuCode();
                AssertBiz.notNull((Object)item.getPsSkuId(), (String)("[" + psSkuCode + "]\u89c4\u683cID\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                AssertBiz.notNull((Object)psSkuCode, (String)"\u89c4\u683c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                AssertBiz.notNull((Object)item.getSourceBillItemId(), (String)("[" + psSkuCode + "]\u6765\u6e90\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                AssertBiz.notNull((Object)item.getSgStoreId(), (String)("[" + psSkuCode + "]\u903b\u8f91\u4ed3ID\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                if (StringUtils.isEmpty((Object)item.getSgStoreCode())) {
                    throw new BizException("[" + psSkuCode + "]\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isEmpty((Object)item.getSgStoreName())) {
                    throw new BizException("[" + psSkuCode + "]\u903b\u8f91\u4ed3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                AssertBiz.notNull((Object)item.getPsProId(), (String)("[" + psSkuCode + "]\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                AssertBiz.notNull((Object)item.getPsProCode(), (String)("[" + psSkuCode + "]\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                AssertBiz.notNull((Object)item.getPsProName(), (String)("[" + psSkuCode + "]\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                AssertBiz.notNull((Object)item.getPsSpec1Id(), (String)("[" + psSkuCode + "]\u89c4\u683cID\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                AssertBiz.notNull((Object)item.getPsSpec1Name(), (String)("[" + psSkuCode + "]\u89c4\u683c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                AssertBiz.notNull((Object)item.getPsSpec1Code(), (String)("[" + psSkuCode + "]\u89c4\u683c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                AssertBiz.notNull((Object)item.getPsProClassify(), (String)("[" + psSkuCode + "]\u5546\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                AssertBiz.notNull((Object)item.getPsBrandId(), (String)("[" + psSkuCode + "]\u54c1\u724cID\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                AssertBiz.notNull((Object)item.getPsBrandName(), (String)("[" + psSkuCode + "]\u54c1\u724c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                AssertBiz.notNull((Object)item.getWmsThirdCode(), (String)("[" + psSkuCode + "]\u6761\u7801\u7f16\u7801(WMS)\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                if (item.getQty() != null) continue;
                throw new BizException("[" + psSkuCode + "]\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u62160\uff01");
            }
            SgSendOccupyDto.SgSendDto main = dto.getMain();
            if (main.getBusinessType() == null) {
                Integer sourceBillType = main.getSourceBillType();
                if (SourceBillTypeEnum.SALE.getCode() == sourceBillType.intValue()) {
                    if (main.getSourceBillNo().startsWith("ODR")) {
                        main.setBusinessType(SupplyStrategyBusinessTypeEnum.DISTRIBUTION.getValue());
                    } else {
                        main.setBusinessType(SupplyStrategyBusinessTypeEnum.SALE.getValue());
                    }
                } else if (SourceBillTypeEnum.RETAIL.getCode() == sourceBillType.intValue() || SourceBillTypeEnum.VIP_SALE_ORDER.getCode() == sourceBillType.intValue()) {
                    main.setBusinessType(SupplyStrategyBusinessTypeEnum.RETAIL.getValue());
                } else {
                    main.setBusinessType(SupplyStrategyBusinessTypeEnum.OTHER.getValue());
                }
            }
            BizOperatorInfo bizOperator = new BizOperatorInfo();
            BeanUtils.copyProperties((Object)dto.getUserInfo(), (Object)bizOperator);
            SendCommonEntity sendCommonEntity = new SendCommonEntity();
            sendCommonEntity.setBizOperator(bizOperator);
            sendCommonEntity.setUserInfo(dto.getUserInfo());
            if (log.isDebugEnabled()) {
                log.debug("checkParams \u6821\u9a8c\u6210\u529f \u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - startTime));
            }
            return ApiResponse.success((Object)sendCommonEntity);
        }
        catch (BizException e) {
            e.printStackTrace();
            return ApiResponse.failed(null, (String)SgErrorCodeEnum.CHECK_PARAM.getCode(), (String)e.getMessage());
        }
    }

    public ApiResponse<Void> checkParamsSgWarehouseAndSgStore(SgSendOccupyDto dto) {
        try {
            ArrayList<Long> warehouseIds = new ArrayList<Long>();
            warehouseIds.add(dto.getMain().getSgWarehouseId());
            List sgStoreVOList = this.sgStoreBiz.queryStoreByWarehouseIds(warehouseIds);
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)sgStoreVOList)) {
                throw new BizException(dto.getMain().getSgWarehouseName() + "\u5b9e\u4f53\u4ed3\u4e0b\u4e0d\u5b58\u5728\u53ef\u7528\u7684\u903b\u8f91\u4ed3");
            }
            List sendItemSaveDtoList = dto.getItemList();
            List skuIdList = sendItemSaveDtoList.stream().map(SgSendOccupyDto.SgSendItemDto::getPsSkuId).distinct().collect(Collectors.toList());
            Map skuInfoMap = this.psAdapter.getSkuInfoMap(skuIdList);
            Assert.notNull((Object)skuInfoMap, (String)("\u672a\u67e5\u8be2\u5230SKU\u4fe1\u606f\u3002skuIdList:" + JSON.toJSONString(skuIdList)));
            String thirdPartyType = "2";
            SgWarehouse sgWarehouse = this.sgWarehouseAdapter.getWarehouse(dto.getMain().getSgWarehouseId());
            Assert.notNull((Object)sgWarehouse, (String)("\u672a\u67e5\u8be2\u5230\u5b9e\u4f53\u4ed3\u4fe1\u606f \u5b9e\u4f53\u4ed3ID" + dto.getMain().getSgWarehouseId()));
            if (sgWarehouse.getCallType() != null) {
                thirdPartyType = sgWarehouse.getCallType().toString();
            }
            for (SgSendOccupyDto.SgSendItemDto item : sendItemSaveDtoList) {
                List voList = sgStoreVOList.stream().filter(obj -> obj.getId().equals(item.getSgStoreId()) && obj.getSgWarehouseId().equals(dto.getMain().getSgWarehouseId())).collect(Collectors.toList());
                if (org.springframework.util.CollectionUtils.isEmpty(voList)) {
                    throw new BizException("\u903b\u8f91\u4ed3\u3010" + item.getSgStoreName() + "\u3011 \u5728\u5b9e\u4f53\u4ed3\u3010" + dto.getMain().getSgWarehouseName() + "\u3011\u4e0b\u4e0d\u5b58\u5728\u6216\u5df2\u505c\u7528\u3002");
                }
                QueryInteriorSkuVO skuVO = (QueryInteriorSkuVO)skuInfoMap.get(item.getPsSkuId());
                if (skuVO == null) continue;
                item.setWmsThirdCode(skuVO.getWmsThirdPlatformCode(thirdPartyType, sgWarehouse.getOwnerCode()));
            }
            if (dto.getIsOpenEffective().booleanValue()) {
                List sendEffectiveItemSaveDtoList = dto.getEffectiveItemList();
                for (SgSendOccupyDto.SgSendItemDto item : sendEffectiveItemSaveDtoList) {
                    List voList = sgStoreVOList.stream().filter(obj -> obj.getId().equals(item.getSgStoreId()) && obj.getSgWarehouseId().equals(dto.getMain().getSgWarehouseId())).collect(Collectors.toList());
                    if (org.springframework.util.CollectionUtils.isEmpty(voList)) {
                        throw new BizException("\u903b\u8f91\u4ed3\u3010" + item.getSgStoreName() + "\u3011 \u5728\u5b9e\u4f53\u4ed3\u3010" + dto.getMain().getSgWarehouseName() + "\u3011\u4e0b\u4e0d\u5b58\u5728\u6216\u5df2\u505c\u7528\u3002");
                    }
                    QueryInteriorSkuVO skuVO = (QueryInteriorSkuVO)skuInfoMap.get(item.getPsSkuId());
                    if (skuVO == null) continue;
                    item.setWmsThirdCode(skuVO.getWmsThirdPlatformCode(thirdPartyType, sgWarehouse.getOwnerCode()));
                }
            }
            return ApiResponse.success();
        }
        catch (BizException e) {
            return ApiResponse.failed(null, (String)SgErrorCodeEnum.CHECK_PARAM.getCode(), (String)e.getMessage());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateSendPreOut(Long sendId, SgBizEnum.SendItemOccupyType occupyType, SgStorageBatchUpdateVo resultData) {
        log.info("SgSendCommonBiz.updateSendPreOut.start");
        List actualUpdateBillItems = resultData.getActualUpdateBillItems();
        if (CollectionUtils.isEmpty((Collection)actualUpdateBillItems)) {
            return;
        }
        List sgSendItemListDB = this.sgSendItemService.selectSendItemList(sendId);
        if (log.isDebugEnabled()) {
            log.debug("SgSendCommonBiz.updateSendPreOut sgSendItemListDBcs:{}", (Object)JSON.toJSONString((Object)sgSendItemListDB));
        }
        Map sgSendItemIdMap = sgSendItemListDB.stream().collect(Collectors.toMap(SgSendItem::getId, Function.identity(), (key1, key2) -> key1));
        if (log.isDebugEnabled()) {
            log.debug("SgSendCommonBiz.updateSendPreOut sgSendItemIdMap:{}", (Object)JSON.toJSONString(sgSendItemIdMap));
        }
        Map<Long, List<SgStorageUpdateBillItemVo>> billItemIdMap = actualUpdateBillItems.stream().collect(Collectors.groupingBy(SgStorageUpdateBillItemBaseDto::getBillItemId));
        if (log.isDebugEnabled()) {
            log.debug("SgSendCommonBiz.updateSendPreOut billItemIdMap:{}", (Object)JSON.toJSONString(billItemIdMap));
        }
        ArrayList<SgSendItem> updateSendItemList = new ArrayList<SgSendItem>();
        ArrayList<SgSendItem> insertSendItemList = new ArrayList<SgSendItem>();
        for (Long billItemId : billItemIdMap.keySet()) {
            List<SgStorageUpdateBillItemVo> sgStorageUpdateBillItemVoList = billItemIdMap.get(billItemId);
            SgSendItem sgSendItemDb = (SgSendItem)sgSendItemIdMap.get(billItemId);
            if (log.isDebugEnabled()) {
                log.debug("SgSendCommonBiz.updateSendPreOut.sgSendItemDb\uff1a{}", (Object)JSON.toJSONString((Object)sgSendItemDb));
            }
            log.info("SgSendCommonBiz.updateSendPreOut.sgSendItemDb\uff1a{}", (Object)JSON.toJSONString((Object)sgSendItemDb));
            if (org.springframework.util.CollectionUtils.isEmpty(sgStorageUpdateBillItemVoList)) continue;
            for (SgStorageUpdateBillItemVo storageUpdateBillItemVo : sgStorageUpdateBillItemVoList) {
                log.info("SgSendCommonBiz.updateSendPreOut dbItemStoreId={},outStoreId={}", (Object)sgSendItemDb.getSgStoreId(), (Object)storageUpdateBillItemVo.getCpCStoreId());
                if (!storageUpdateBillItemVo.getCpCStoreId().equals(sgSendItemDb.getSgStoreId())) {
                    SgSendItem insertSendItem = new SgSendItem();
                    BeanUtils.copyProperties((Object)sgSendItemDb, (Object)insertSendItem);
                    insertSendItem.setId(this.idSequenceGenerator.generateId(SgSendItem.class));
                    insertSendItem.setQtyPreOut(storageUpdateBillItemVo.getQtyPreoutChange());
                    insertSendItem.setQty(storageUpdateBillItemVo.getQtyPreoutChange());
                    insertSendItem.setQtySend(BigDecimal.ZERO);
                    SgStore store = StoreManager.getBean().getStore(storageUpdateBillItemVo.getCpCStoreId().longValue());
                    insertSendItem.setSgStoreId(store.getId());
                    insertSendItem.setSgStoreCode(store.getCode());
                    insertSendItem.setSgStoreName(store.getName());
                    insertSendItemList.add(insertSendItem);
                    continue;
                }
                SgSendItem updateSendItem = new SgSendItem();
                BigDecimal qtySend = sgSendItemDb.getQtySend() == null ? BigDecimal.ZERO : sgSendItemDb.getQtySend();
                updateSendItem.setQtySend(qtySend);
                updateSendItem.setId(storageUpdateBillItemVo.getBillItemId());
                BigDecimal qtyPreOutDb = sgSendItemDb.getQtyPreOut() == null ? BigDecimal.ZERO : sgSendItemDb.getQtyPreOut();
                qtyPreOutDb = qtyPreOutDb.add(storageUpdateBillItemVo.getQtyPreoutChange());
                updateSendItem.setQtyPreOut(qtyPreOutDb);
                updateSendItemList.add(updateSendItem);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("SgSendCommonBiz.updateSendPreOut updateSendItemList:{} insertSendItemList:{}", (Object)JSON.toJSONString(updateSendItemList), (Object)JSON.toJSONString(insertSendItemList));
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(updateSendItemList)) {
            this.sgSendItemService.updateBatchById(updateSendItemList);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(insertSendItemList)) {
            this.sgSendItemService.saveBatch(insertSendItemList);
        }
        if (resultData.getIsOpenEffective().booleanValue()) {
            this.updateSendEffectivePreOut(sendId, occupyType, resultData, updateSendItemList, insertSendItemList);
        }
    }

    public void updateTotalQtyPreOut(Long sendId) {
        List allSgSendItemList = this.sgSendItemService.selectSendItemList(sendId);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)allSgSendItemList)) {
            BigDecimal totQtyPreOut = BigDecimal.ZERO;
            for (SgSendItem sgSendItem : allSgSendItemList) {
                totQtyPreOut = totQtyPreOut.add(sgSendItem.getQty());
            }
            SgSend updateSend = new SgSend();
            updateSend.setId(sendId);
            updateSend.setTotQtyPreOut(totQtyPreOut);
            this.sgSendService.updateById((Object)updateSend);
        }
    }

    public void updateSendEffectivePreOut(Long sendId, SgBizEnum.SendItemOccupyType occupyType, SgStorageBatchUpdateVo resultData, List<SgSendItem> updateSendItemList, List<SgSendItem> insertSendItemList) {
        List actualUpdateBillItemsEffective;
        log.info("SgSendCommonBiz.updateSendEffectivePreOut.start");
        ArrayList<SgSendItem> sendItemList = new ArrayList<SgSendItem>();
        sendItemList.addAll(updateSendItemList);
        sendItemList.addAll(insertSendItemList);
        if (log.isDebugEnabled()) {
            log.debug("SgSendCommonBiz.updateSendPreOut sendItemList:{}", (Object)JSON.toJSONString(sendItemList));
        }
        if (CollectionUtils.isEmpty((Collection)(actualUpdateBillItemsEffective = resultData.getSgStorageEffectiveBatchUpdateVo().getActualUpdateBillItems()))) {
            throw new BusinessException("\u5b9e\u9645\u66f4\u65b0\u6548\u671f\u5e93\u5b58\u7684\u660e\u7ec6\u4e3a\u7a7a");
        }
        List sgSendEffEctiveItemListDB = this.sgSendEffectiveItemService.selectSendEffectiveItemBysendIdList(sendId);
        if (log.isDebugEnabled()) {
            log.debug("SgSendCommonBiz.updateSendPreOut sgSendEffEctiveItemListDB:{}", (Object)JSON.toJSONString((Object)sgSendEffEctiveItemListDB));
        }
        Map sgSendEffectiveItemIdMap = sgSendEffEctiveItemListDB.stream().collect(Collectors.toMap(SgSendEffectiveItem::getId, Function.identity(), (key1, key2) -> key1));
        if (log.isDebugEnabled()) {
            log.debug("SgSendCommonBiz.updateSendPreOut sgSendEffectiveItemIdMap:{}", (Object)JSON.toJSONString(sgSendEffectiveItemIdMap));
        }
        Map<Long, List<SgStorageUpdateBillItemVo>> billEffectiveItemIdMap = actualUpdateBillItemsEffective.stream().collect(Collectors.groupingBy(SgStorageUpdateBillItemBaseDto::getBillItemId));
        if (log.isDebugEnabled()) {
            log.debug("SgSendCommonBiz.updateSendPreOut billEffectiveItemIdMap:{}", (Object)JSON.toJSONString(billEffectiveItemIdMap));
        }
        SgSend sgSend = (SgSend)this.sgSendService.getById((Serializable)sendId);
        ArrayList<SgSendEffectiveItem> updateSendEffectiveItemList = new ArrayList<SgSendEffectiveItem>();
        ArrayList<SgSendEffectiveItem> insertSendEffectiveItemList = new ArrayList<SgSendEffectiveItem>();
        for (Long billItemId : sgSendEffectiveItemIdMap.keySet()) {
            List<SgStorageUpdateBillItemVo> sgStorageUpdateBillItemVoList = billEffectiveItemIdMap.get(billItemId);
            SgSendEffectiveItem sgSendEffectiveItemDb = (SgSendEffectiveItem)sgSendEffectiveItemIdMap.get(billItemId);
            if (log.isDebugEnabled()) {
                log.debug("SgSendCommonBiz.updateSendPreOut.sgSendEffectiveItemDb\uff1a{}", (Object)JSON.toJSONString((Object)sgSendEffectiveItemDb));
            }
            if (org.springframework.util.CollectionUtils.isEmpty(sgStorageUpdateBillItemVoList)) continue;
            int rowNo = 1;
            for (SgStorageUpdateBillItemVo storageUpdateBillItemVo : sgStorageUpdateBillItemVoList) {
                log.info("SgSendCommonBiz.updateSendEffectivePreOut dbItemStoreId={},outStoreId={}, dbItembatchCode={}, outbatchCode={}", new Object[]{sgSendEffectiveItemDb.getSgStoreId(), storageUpdateBillItemVo.getCpCStoreId(), sgSendEffectiveItemDb.getPreoutBatchCode(), storageUpdateBillItemVo.getBatchCode()});
                if (!storageUpdateBillItemVo.getCpCStoreId().equals(sgSendEffectiveItemDb.getSgStoreId()) || !storageUpdateBillItemVo.getBatchCode().equals(sgSendEffectiveItemDb.getPreoutBatchCode())) {
                    SgSendEffectiveItem insertSendItem = new SgSendEffectiveItem();
                    BeanUtils.copyProperties((Object)sgSendEffectiveItemDb, (Object)insertSendItem);
                    insertSendItem.setId(this.idSequenceGenerator.generateId(SgSendEffectiveItem.class));
                    insertSendItem.setQtyPreOut(storageUpdateBillItemVo.getQtyPreoutChange());
                    insertSendItem.setQty(storageUpdateBillItemVo.getQtyPreoutChange());
                    insertSendItem.setQtySend(BigDecimal.ZERO);
                    SgStore store = StoreManager.getBean().getStore(storageUpdateBillItemVo.getCpCStoreId().longValue());
                    insertSendItem.setSgStoreId(store.getId());
                    insertSendItem.setSgStoreCode(store.getCode());
                    insertSendItem.setSgStoreName(store.getName());
                    insertSendItem.setPreoutBatchCode(storageUpdateBillItemVo.getBatchCode());
                    insertSendEffectiveItemList.add(insertSendItem);
                } else {
                    SgSendEffectiveItem updateSendItem = new SgSendEffectiveItem();
                    BigDecimal qtySend = sgSendEffectiveItemDb.getQtySend() == null ? BigDecimal.ZERO : sgSendEffectiveItemDb.getQtySend();
                    updateSendItem.setQtySend(qtySend);
                    updateSendItem.setId(storageUpdateBillItemVo.getBillItemId());
                    BigDecimal qtyPreOutDb = sgSendEffectiveItemDb.getQtyPreOut() == null ? BigDecimal.ZERO : sgSendEffectiveItemDb.getQtyPreOut();
                    qtyPreOutDb = qtyPreOutDb.add(storageUpdateBillItemVo.getQtyPreoutChange());
                    updateSendItem.setQtyPreOut(qtyPreOutDb);
                    updateSendItem.setQty(qtySend.add(qtyPreOutDb));
                    updateSendEffectiveItemList.add(updateSendItem);
                }
                ++rowNo;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("SgSendCommonBiz.updateSendEffectivePreOut updateSendItemList:{} insertSendItemList:{}", (Object)JSON.toJSONString(updateSendEffectiveItemList), (Object)JSON.toJSONString(insertSendEffectiveItemList));
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(updateSendEffectiveItemList)) {
            this.sgSendEffectiveItemService.updateBatchById(updateSendEffectiveItemList);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(insertSendEffectiveItemList)) {
            this.sgSendEffectiveItemService.saveBatch(insertSendEffectiveItemList);
        }
        this.sgSendEffectiveItemService.deleteSendEffectiveItemBySendIdAndZero(sendId);
    }

    class SendCommonEntity {
        private BizOperatorInfo bizOperator;
        private LoginUserInfo userInfo;
        private SendEntity origSendEntity;

        public BizOperatorInfo getBizOperator() {
            return this.bizOperator;
        }

        public LoginUserInfo getUserInfo() {
            return this.userInfo;
        }

        public SendEntity getOrigSendEntity() {
            return this.origSendEntity;
        }

        public void setBizOperator(BizOperatorInfo bizOperator) {
            this.bizOperator = bizOperator;
        }

        public void setUserInfo(LoginUserInfo userInfo) {
            this.userInfo = userInfo;
        }

        public void setOrigSendEntity(SendEntity origSendEntity) {
            this.origSendEntity = origSendEntity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SendCommonEntity)) {
                return false;
            }
            SendCommonEntity other = (SendCommonEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BizOperatorInfo this$bizOperator = this.getBizOperator();
            BizOperatorInfo other$bizOperator = other.getBizOperator();
            if (this$bizOperator == null ? other$bizOperator != null : !this$bizOperator.equals(other$bizOperator)) {
                return false;
            }
            LoginUserInfo this$userInfo = this.getUserInfo();
            LoginUserInfo other$userInfo = other.getUserInfo();
            if (this$userInfo == null ? other$userInfo != null : !this$userInfo.equals(other$userInfo)) {
                return false;
            }
            SendEntity this$origSendEntity = this.getOrigSendEntity();
            SendEntity other$origSendEntity = other.getOrigSendEntity();
            return !(this$origSendEntity == null ? other$origSendEntity != null : !((Object)this$origSendEntity).equals(other$origSendEntity));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SendCommonEntity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BizOperatorInfo $bizOperator = this.getBizOperator();
            result = result * 59 + ($bizOperator == null ? 43 : $bizOperator.hashCode());
            LoginUserInfo $userInfo = this.getUserInfo();
            result = result * 59 + ($userInfo == null ? 43 : $userInfo.hashCode());
            SendEntity $origSendEntity = this.getOrigSendEntity();
            result = result * 59 + ($origSendEntity == null ? 43 : ((Object)$origSendEntity).hashCode());
            return result;
        }

        public String toString() {
            return "SgSendCommonBiz.SendCommonEntity(bizOperator=" + this.getBizOperator() + ", userInfo=" + this.getUserInfo() + ", origSendEntity=" + this.getOrigSendEntity() + ")";
        }
    }

    public static class StoragePreOutEntity {
        private SendEntity origSendEntity;
        private SendEntity newSendEntity;
        private String occupyType;
        private List<SgSupplyStrategyPriorityDTO> strategyPriorityList;
        private Boolean isOpenEffective;
        private Map<String, List<String>> batchCodeMap;

        public SendEntity getOrigSendEntity() {
            return this.origSendEntity;
        }

        public SendEntity getNewSendEntity() {
            return this.newSendEntity;
        }

        public String getOccupyType() {
            return this.occupyType;
        }

        public List<SgSupplyStrategyPriorityDTO> getStrategyPriorityList() {
            return this.strategyPriorityList;
        }

        public Boolean getIsOpenEffective() {
            return this.isOpenEffective;
        }

        public Map<String, List<String>> getBatchCodeMap() {
            return this.batchCodeMap;
        }

        public void setOrigSendEntity(SendEntity origSendEntity) {
            this.origSendEntity = origSendEntity;
        }

        public void setNewSendEntity(SendEntity newSendEntity) {
            this.newSendEntity = newSendEntity;
        }

        public void setOccupyType(String occupyType) {
            this.occupyType = occupyType;
        }

        public void setStrategyPriorityList(List<SgSupplyStrategyPriorityDTO> strategyPriorityList) {
            this.strategyPriorityList = strategyPriorityList;
        }

        public void setIsOpenEffective(Boolean isOpenEffective) {
            this.isOpenEffective = isOpenEffective;
        }

        public void setBatchCodeMap(Map<String, List<String>> batchCodeMap) {
            this.batchCodeMap = batchCodeMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StoragePreOutEntity)) {
                return false;
            }
            StoragePreOutEntity other = (StoragePreOutEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$isOpenEffective = this.getIsOpenEffective();
            Boolean other$isOpenEffective = other.getIsOpenEffective();
            if (this$isOpenEffective == null ? other$isOpenEffective != null : !((Object)this$isOpenEffective).equals(other$isOpenEffective)) {
                return false;
            }
            SendEntity this$origSendEntity = this.getOrigSendEntity();
            SendEntity other$origSendEntity = other.getOrigSendEntity();
            if (this$origSendEntity == null ? other$origSendEntity != null : !((Object)this$origSendEntity).equals(other$origSendEntity)) {
                return false;
            }
            SendEntity this$newSendEntity = this.getNewSendEntity();
            SendEntity other$newSendEntity = other.getNewSendEntity();
            if (this$newSendEntity == null ? other$newSendEntity != null : !((Object)this$newSendEntity).equals(other$newSendEntity)) {
                return false;
            }
            String this$occupyType = this.getOccupyType();
            String other$occupyType = other.getOccupyType();
            if (this$occupyType == null ? other$occupyType != null : !this$occupyType.equals(other$occupyType)) {
                return false;
            }
            List<SgSupplyStrategyPriorityDTO> this$strategyPriorityList = this.getStrategyPriorityList();
            List<SgSupplyStrategyPriorityDTO> other$strategyPriorityList = other.getStrategyPriorityList();
            if (this$strategyPriorityList == null ? other$strategyPriorityList != null : !((Object)this$strategyPriorityList).equals(other$strategyPriorityList)) {
                return false;
            }
            Map<String, List<String>> this$batchCodeMap = this.getBatchCodeMap();
            Map<String, List<String>> other$batchCodeMap = other.getBatchCodeMap();
            return !(this$batchCodeMap == null ? other$batchCodeMap != null : !((Object)this$batchCodeMap).equals(other$batchCodeMap));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StoragePreOutEntity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isOpenEffective = this.getIsOpenEffective();
            result = result * 59 + ($isOpenEffective == null ? 43 : ((Object)$isOpenEffective).hashCode());
            SendEntity $origSendEntity = this.getOrigSendEntity();
            result = result * 59 + ($origSendEntity == null ? 43 : ((Object)$origSendEntity).hashCode());
            SendEntity $newSendEntity = this.getNewSendEntity();
            result = result * 59 + ($newSendEntity == null ? 43 : ((Object)$newSendEntity).hashCode());
            String $occupyType = this.getOccupyType();
            result = result * 59 + ($occupyType == null ? 43 : $occupyType.hashCode());
            List<SgSupplyStrategyPriorityDTO> $strategyPriorityList = this.getStrategyPriorityList();
            result = result * 59 + ($strategyPriorityList == null ? 43 : ((Object)$strategyPriorityList).hashCode());
            Map<String, List<String>> $batchCodeMap = this.getBatchCodeMap();
            result = result * 59 + ($batchCodeMap == null ? 43 : ((Object)$batchCodeMap).hashCode());
            return result;
        }

        public String toString() {
            return "SgSendCommonBiz.StoragePreOutEntity(origSendEntity=" + this.getOrigSendEntity() + ", newSendEntity=" + this.getNewSendEntity() + ", occupyType=" + this.getOccupyType() + ", strategyPriorityList=" + this.getStrategyPriorityList() + ", isOpenEffective=" + this.getIsOpenEffective() + ", batchCodeMap=" + this.getBatchCodeMap() + ")";
        }
    }

    public static class SendSaveVO {
        private SendEntity origSendEntity;
        private SendEntity newSendEntity;

        public SendEntity getOrigSendEntity() {
            return this.origSendEntity;
        }

        public SendEntity getNewSendEntity() {
            return this.newSendEntity;
        }

        public void setOrigSendEntity(SendEntity origSendEntity) {
            this.origSendEntity = origSendEntity;
        }

        public void setNewSendEntity(SendEntity newSendEntity) {
            this.newSendEntity = newSendEntity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SendSaveVO)) {
                return false;
            }
            SendSaveVO other = (SendSaveVO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SendEntity this$origSendEntity = this.getOrigSendEntity();
            SendEntity other$origSendEntity = other.getOrigSendEntity();
            if (this$origSendEntity == null ? other$origSendEntity != null : !((Object)this$origSendEntity).equals(other$origSendEntity)) {
                return false;
            }
            SendEntity this$newSendEntity = this.getNewSendEntity();
            SendEntity other$newSendEntity = other.getNewSendEntity();
            return !(this$newSendEntity == null ? other$newSendEntity != null : !((Object)this$newSendEntity).equals(other$newSendEntity));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SendSaveVO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SendEntity $origSendEntity = this.getOrigSendEntity();
            result = result * 59 + ($origSendEntity == null ? 43 : ((Object)$origSendEntity).hashCode());
            SendEntity $newSendEntity = this.getNewSendEntity();
            result = result * 59 + ($newSendEntity == null ? 43 : ((Object)$newSendEntity).hashCode());
            return result;
        }

        public String toString() {
            return "SgSendCommonBiz.SendSaveVO(origSendEntity=" + this.getOrigSendEntity() + ", newSendEntity=" + this.getNewSendEntity() + ")";
        }
    }

    public static class SendEntity {
        private SgSend send;
        private List<SgSendItem> sendItemList;
        private List<SgSendEffectiveItem> sendEffectiveItemList;

        public SgSend getSend() {
            return this.send;
        }

        public List<SgSendItem> getSendItemList() {
            return this.sendItemList;
        }

        public List<SgSendEffectiveItem> getSendEffectiveItemList() {
            return this.sendEffectiveItemList;
        }

        public void setSend(SgSend send) {
            this.send = send;
        }

        public void setSendItemList(List<SgSendItem> sendItemList) {
            this.sendItemList = sendItemList;
        }

        public void setSendEffectiveItemList(List<SgSendEffectiveItem> sendEffectiveItemList) {
            this.sendEffectiveItemList = sendEffectiveItemList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SendEntity)) {
                return false;
            }
            SendEntity other = (SendEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SgSend this$send = this.getSend();
            SgSend other$send = other.getSend();
            if (this$send == null ? other$send != null : !this$send.equals(other$send)) {
                return false;
            }
            List<SgSendItem> this$sendItemList = this.getSendItemList();
            List<SgSendItem> other$sendItemList = other.getSendItemList();
            if (this$sendItemList == null ? other$sendItemList != null : !((Object)this$sendItemList).equals(other$sendItemList)) {
                return false;
            }
            List<SgSendEffectiveItem> this$sendEffectiveItemList = this.getSendEffectiveItemList();
            List<SgSendEffectiveItem> other$sendEffectiveItemList = other.getSendEffectiveItemList();
            return !(this$sendEffectiveItemList == null ? other$sendEffectiveItemList != null : !((Object)this$sendEffectiveItemList).equals(other$sendEffectiveItemList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SendEntity;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SgSend $send = this.getSend();
            result = result * 59 + ($send == null ? 43 : $send.hashCode());
            List<SgSendItem> $sendItemList = this.getSendItemList();
            result = result * 59 + ($sendItemList == null ? 43 : ((Object)$sendItemList).hashCode());
            List<SgSendEffectiveItem> $sendEffectiveItemList = this.getSendEffectiveItemList();
            result = result * 59 + ($sendEffectiveItemList == null ? 43 : ((Object)$sendEffectiveItemList).hashCode());
            return result;
        }

        public String toString() {
            return "SgSendCommonBiz.SendEntity(send=" + this.getSend() + ", sendItemList=" + this.getSendItemList() + ", sendEffectiveItemList=" + this.getSendEffectiveItemList() + ")";
        }
    }
}

