/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.send.restructure;

import com.alibaba.fastjson.JSON;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.bizlog.annotation.LogAnnotation;
import com.xinqiyi.framework.bizlog.entity.InnerLog;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.sg.basic.model.common.SgBizEnum;
import com.xinqiyi.sg.basic.service.SgOrderNoBiz;
import com.xinqiyi.sg.basic.service.TableIdBatchGet;
import com.xinqiyi.sg.store.model.dto.send.SgSendOccupyDto;
import com.xinqiyi.sg.store.model.entity.SgSend;
import com.xinqiyi.sg.store.model.entity.SgSendEffectiveItem;
import com.xinqiyi.sg.store.model.entity.SgSendItem;
import com.xinqiyi.sg.store.service.SgSendEffectiveItemService;
import com.xinqiyi.sg.store.service.SgSendItemService;
import com.xinqiyi.sg.store.service.SgSendService;
import com.xinqiyi.sg.store.service.business.send.restructure.SgSendCommonBiz;
import com.xinqiyi.sg.store.service.business.utils.StoreUtils;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SgSendCreateBiz {
    private static final Logger log = LoggerFactory.getLogger(SgSendCreateBiz.class);
    @Resource
    private SgSendService sgSendService;
    @Resource
    private SgSendItemService sgSendItemService;
    @Resource
    private IdSequenceGenerator idSequenceGenerator;
    @Resource
    private BaseDaoInitialService baseDaoInitialService;
    @Resource
    private SgOrderNoBiz sgOrderNoBiz;
    @Resource
    private TableIdBatchGet tableIdBatchGet;
    @Resource
    private SgSendEffectiveItemService sgSendEffectiveItemService;

    @LogAnnotation
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NESTED)
    public ApiResponse<SgSendCommonBiz.SendEntity> sendCreate(SgSendOccupyDto dto, SgSendCommonBiz.SendCommonEntity sendCommonEntity) {
        Long startTime = System.currentTimeMillis();
        SgSend sgSend = this.buildSgSendForNew(dto, sendCommonEntity);
        List<SgSendItem> sendItemList = this.buildSgSendItemForNew(sgSend.getId(), dto, sendCommonEntity);
        ArrayList<SgSendEffectiveItem> sendEffectiveItemList = new ArrayList();
        if (dto.getIsOpenEffective().booleanValue()) {
            sendEffectiveItemList = this.buildSgSendEffectiveItemForNew(sgSend.getId(), dto, sendCommonEntity, sendItemList);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u65b0\u589e\u7684\u903b\u8f91\u53d1\u8d27\u5355 sgSend\uff1a{} sendItemList\uff1a{} sendEffectiveItemList: {}", new Object[]{JSON.toJSONString((Object)sgSend), JSON.toJSONString(sendItemList), JSON.toJSONString(sendEffectiveItemList)});
        }
        this.sgSendService.save((Object)sgSend);
        this.sgSendItemService.saveBatch(sendItemList);
        if (CollectionUtils.isNotEmpty(sendEffectiveItemList)) {
            this.sgSendEffectiveItemService.saveBatch(sendEffectiveItemList);
        }
        SgSendCommonBiz.SendEntity sendEntity = new SgSendCommonBiz.SendEntity();
        sendEntity.setSend(sgSend);
        sendEntity.setSendItemList(sendItemList);
        sendEntity.setSendEffectiveItemList(sendEffectiveItemList);
        InnerLog.addLog((Long)sgSend.getId(), (String)"\u65b0\u589e\u903b\u8f91\u53d1\u8d27\u5355", (String)"sg_send", null, (String)"\u65b0\u589e");
        if (log.isDebugEnabled()) {
            log.debug("\u65b0\u589e\u903b\u8f91\u903b\u8f91\u53d1\u8d27\u5355\u6210\u529f \u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - startTime));
        }
        return ApiResponse.success((Object)sendEntity);
    }

    private SgSend buildSgSendForNew(SgSendOccupyDto dto, SgSendCommonBiz.SendCommonEntity sendCommonEntity) {
        Long startTime = System.currentTimeMillis();
        SgSendOccupyDto.SgSendDto maim = dto.getMain();
        List itemList = dto.getItemList();
        SgSend send = new SgSend();
        BeanUtils.copyProperties((Object)maim, (Object)send);
        String billNo = this.sgOrderNoBiz.getSendOrderNo();
        Long id = this.idSequenceGenerator.generateId(SgSend.class);
        send.setId(id);
        send.setBillNo(billNo);
        send.setBillStatus(SgBizEnum.SendBillStatus.CREATE.getValue());
        send.setBillDate(new Date());
        BigDecimal totalQtyPreOut = BigDecimal.ZERO;
        for (SgSendOccupyDto.SgSendItemDto sgSendItemDto : itemList) {
            totalQtyPreOut = totalQtyPreOut.add(sgSendItemDto.getQty());
        }
        send.setTotQtyPreOut(totalQtyPreOut);
        send.setTotQtySend(BigDecimal.ZERO);
        this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)send, sendCommonEntity.getBizOperator());
        if (log.isDebugEnabled()) {
            log.debug("buildSgSendForNew \u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - startTime));
        }
        return send;
    }

    private List<SgSendItem> buildSgSendItemForNew(Long sgSendId, SgSendOccupyDto dto, SgSendCommonBiz.SendCommonEntity sendCommonEntity) {
        Long startTime = System.currentTimeMillis();
        List itemList = dto.getItemList();
        Boolean isPreOrderOccupy = dto.getIsPreOrderOccupy() != null && dto.getIsPreOrderOccupy() != false;
        ArrayList<SgSendItem> list = new ArrayList<SgSendItem>();
        Long[] sendItemIds = this.tableIdBatchGet.batchGenerateId(SgSendItem.class, itemList.size());
        Long i = sendItemIds[0];
        for (SgSendOccupyDto.SgSendItemDto sgSendItemDto : itemList) {
            SgSendItem sgSendItem = new SgSendItem();
            BeanUtils.copyProperties((Object)sgSendItemDto, (Object)sgSendItem);
            sgSendItem.setQtySend(BigDecimal.ZERO);
            if (isPreOrderOccupy.booleanValue()) {
                sgSendItem.setQtyPreOut(sgSendItemDto.getQty());
            } else {
                sgSendItem.setQtyPreOut(BigDecimal.ZERO);
            }
            sgSendItem.setId(i);
            sgSendItem.setSgSendId(sgSendId);
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)sgSendItem, sendCommonEntity.getBizOperator());
            list.add(sgSendItem);
            Long l = i;
            i = i + 1L;
        }
        if (log.isDebugEnabled()) {
            log.debug("buildSgSendItemForNew \u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - startTime));
        }
        return list;
    }

    private List<SgSendEffectiveItem> buildSgSendEffectiveItemForNew(Long sgSendId, SgSendOccupyDto dto, SgSendCommonBiz.SendCommonEntity sendCommonEntity, List<SgSendItem> sendItemList) {
        Long startTime = System.currentTimeMillis();
        Map<String, List<SgSendItem>> newSendItemMap = sendItemList.stream().collect(Collectors.groupingBy(obj -> StoreUtils.getSendItemMapForMapKey(obj.getPsSkuId(), obj.getSgStoreId())));
        List effectiveItemList = dto.getEffectiveItemList();
        Boolean isPreOrderOccupy = dto.getIsPreOrderOccupy() != null && dto.getIsPreOrderOccupy() != false;
        ArrayList<SgSendEffectiveItem> list = new ArrayList<SgSendEffectiveItem>();
        Long[] sendIEffectiveItemIds = this.tableIdBatchGet.batchGenerateId(SgSendEffectiveItem.class, effectiveItemList.size());
        Long i = sendIEffectiveItemIds[0];
        for (SgSendOccupyDto.SgSendItemDto sgSendItemDto : effectiveItemList) {
            SgSendEffectiveItem sgSendEffectiveItem = new SgSendEffectiveItem();
            BeanUtils.copyProperties((Object)sgSendItemDto, (Object)sgSendEffectiveItem);
            sgSendEffectiveItem.setQtySend(BigDecimal.ZERO);
            if (isPreOrderOccupy.booleanValue()) {
                sgSendEffectiveItem.setQtyPreOut(sgSendItemDto.getQty());
            } else {
                sgSendEffectiveItem.setQtyPreOut(BigDecimal.ZERO);
            }
            sgSendEffectiveItem.setId(i);
            sgSendEffectiveItem.setSgSendId(sgSendId);
            String skuId_StoreId = sgSendItemDto.getPsSkuId() + "_" + sgSendItemDto.getSgStoreId();
            Long sendItemId = newSendItemMap.get(skuId_StoreId).get(0).getId();
            sgSendEffectiveItem.setSgSendItemId(sendItemId);
            sgSendEffectiveItem.setPreoutBatchCode(sgSendItemDto.getBatchCode());
            sgSendEffectiveItem.setPsPackageUnitQty(sgSendItemDto.getPsPackageUnitQty());
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)sgSendEffectiveItem, sendCommonEntity.getBizOperator());
            list.add(sgSendEffectiveItem);
            Long l = i;
            i = i + 1L;
        }
        if (log.isDebugEnabled()) {
            log.debug("buildSgSendEffectiveItemForNew \u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - startTime));
        }
        return list;
    }
}

