/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.send.restructure;

import com.alibaba.fastjson.JSON;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.redis.lock.RedisReentrantLock;
import com.xinqiyi.framework.util.ApplicationContextHelper;
import com.xinqiyi.ps.api.model.vo.spu.QueryInteriorSkuVO;
import com.xinqiyi.sg.basic.api.model.vo.SgStorageBatchUpdateVo;
import com.xinqiyi.sg.basic.model.common.SgBizEnum;
import com.xinqiyi.sg.basic.model.common.SgErrorCodeEnum;
import com.xinqiyi.sg.basic.service.adapter.common.PsAdapter;
import com.xinqiyi.sg.basic.service.adapter.mdm.MdmAdapter;
import com.xinqiyi.sg.basic.service.common.CommonStorageRollBackBiz;
import com.xinqiyi.sg.basic.service.config.SgStorageEffectiveConfig;
import com.xinqiyi.sg.basic.service.exception.BusinessException;
import com.xinqiyi.sg.basic.service.utils.SgRedisKey;
import com.xinqiyi.sg.basic.service.utils.SgRedisLockUtils;
import com.xinqiyi.sg.store.api.model.vo.send.SgOutStockStorageVO;
import com.xinqiyi.sg.store.api.model.vo.send.SgSendBillSaveVo;
import com.xinqiyi.sg.store.model.dto.send.SgSendOccupyDto;
import com.xinqiyi.sg.store.model.entity.SgSend;
import com.xinqiyi.sg.store.service.SgSendEffectiveItemService;
import com.xinqiyi.sg.store.service.SgSendItemService;
import com.xinqiyi.sg.store.service.SgSendService;
import com.xinqiyi.sg.store.service.business.send.SgStockQueryBiz;
import com.xinqiyi.sg.store.service.business.send.restructure.SgSendCommonBiz;
import com.xinqiyi.sg.store.service.business.send.restructure.SgSendCreateBiz;
import com.xinqiyi.sg.store.service.business.send.restructure.SgSendUpdateBiz;
import com.xinqiyi.sg.store.service.business.send.restructure.SgStoreOccupyBiz;
import com.xinqiyi.sg.store.service.business.utils.StoreUtils;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.ObjectUtils;

@Service
public class SgSendOccupyBiz {
    private static final Logger log = LoggerFactory.getLogger(SgSendOccupyBiz.class);
    @Resource
    private SgSendService sgSendService;
    @Resource
    private SgSendItemService sgSendItemService;
    @Resource
    private SgSendCreateBiz sendCreateBiz;
    @Resource
    private SgSendUpdateBiz sendUpdateBiz;
    @Resource
    private SgSendCommonBiz sendCommonBiz;
    @Resource
    private SgStoreOccupyBiz storeOccupyBiz;
    @Resource
    private CommonStorageRollBackBiz commonStorageRollBackBiz;
    @Resource
    private SgSendUpdateBiz sgSendUpdateBiz;
    @Resource
    private SgStockQueryBiz sgStoreQueryBiz;
    @Resource
    public SgStorageEffectiveConfig sgStorageEffectiveConfig;
    @Resource
    private SgSendEffectiveItemService sgSendEffectiveItemService;
    @Resource
    private PsAdapter psAdapter;
    @Autowired
    private MdmAdapter mdmAdapter;
    @Resource
    private SgStockQueryBiz sgStockQueryBiz;

    public boolean isExistSend(String sourceBillNo, String orderNo, Integer sourceBillType) {
        SgSend sgSend = this.sgSendService.selectEffectiveSend(sourceBillNo, orderNo, sourceBillType);
        return sgSend != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NESTED)
    public ApiResponse<SgSendBillSaveVo> sendOccupy(SgSendOccupyDto dto) {
        ApiResponse apiResponse;
        Long startTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("\u903b\u8f91\u53d1\u8d27\u5355\u5360\u7528\u5165\u53c2 {}", (Object)JSON.toJSONString((Object)dto));
        }
        String sourceBillNo = dto.getMain().getSourceBillNo();
        if (StringUtils.isNotEmpty((CharSequence)dto.getMain().getOrderNo())) {
            sourceBillNo = dto.getMain().getOrderNo();
        }
        String lockRedisKey = SgRedisKey.getSendRedisKey((String)sourceBillNo, (Integer)dto.getMain().getSourceBillType());
        RedisReentrantLock redisLock = dto.getRedisReentrantLock();
        if (redisLock == null) {
            redisLock = SgRedisLockUtils.getReentrantLock((String)lockRedisKey);
        }
        ArrayList redisBillFtpKeyList = new ArrayList();
        ArrayList redisBillFtpKeyListByBatchCode = new ArrayList();
        SgSendBillSaveVo returnVO = new SgSendBillSaveVo();
        Boolean isOpenEffective = this.sgStorageEffectiveConfig.isOpenEffective != null && this.sgStorageEffectiveConfig.isOpenEffective != false;
        dto.setIsOpenEffective(isOpenEffective);
        try {
            SgSendOccupyBiz bean;
            ApiResponse<SgSendCommonBiz.SendSaveVO> sendSaveRes;
            if (!redisLock.tryLock(0L, TimeUnit.MINUTES)) {
                ApiResponse apiResponse2 = ApiResponse.failed(null, (String)SgErrorCodeEnum.IN_PROGRESS.getCode(), (String)"\u903b\u8f91\u53d1\u8d27\u5355\u6b63\u5728\u88ab\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                return apiResponse2;
            }
            if (CollectionUtils.isEmpty((Collection)dto.getStrategyPriorityList()) && (dto.getIsRelease() == null || !dto.getIsRelease().booleanValue())) {
                ApiResponse<SgOutStockStorageVO> stockResponse = this.sgStoreQueryBiz.accessToStock(dto);
                if (!stockResponse.isSuccess()) {
                    ApiResponse apiResponse3 = ApiResponse.failed((String)stockResponse.getDesc());
                    return apiResponse3;
                }
                SgOutStockStorageVO stockStorageVO = (SgOutStockStorageVO)stockResponse.getContent();
                if (stockStorageVO != null && CollectionUtils.isNotEmpty((Collection)stockStorageVO.getOutStockItemList())) {
                    returnVO.setOutStockItemList(stockStorageVO.getOutStockItemList());
                    ApiResponse apiResponse4 = ApiResponse.failed((Object)returnVO, (String)stockStorageVO.getOutStockItemMsg());
                    return apiResponse4;
                }
                if (isOpenEffective != null && isOpenEffective.booleanValue()) {
                    ApiResponse<SgOutStockStorageVO> effectiveStockResponse = this.sgStoreQueryBiz.accessToEffectiveStock(dto);
                    if (!effectiveStockResponse.isSuccess()) {
                        ApiResponse apiResponse5 = ApiResponse.failed((String)effectiveStockResponse.getDesc());
                        return apiResponse5;
                    }
                    SgOutStockStorageVO effectiveStockStorageVO = (SgOutStockStorageVO)effectiveStockResponse.getContent();
                    if (effectiveStockStorageVO != null && CollectionUtils.isNotEmpty((Collection)effectiveStockStorageVO.getOutStockItemList())) {
                        returnVO.setOutStockItemList(effectiveStockStorageVO.getOutStockItemList());
                        ApiResponse apiResponse6 = ApiResponse.failed((Object)returnVO, (String)effectiveStockStorageVO.getOutStockItemMsg());
                        return apiResponse6;
                    }
                }
            }
            String effectiveLabel = dto.getEffectiveLabel();
            Integer redundantDays = dto.getRedundantDays() == null ? 0 : dto.getRedundantDays();
            String defaultEffectiveBatchCode = this.mdmAdapter.selectMdmSystemConfig("DEFAULT_EFFECTIVE_BATCH_CODE");
            LinkedHashMap<String, List<String>> batchCodeMap = new LinkedHashMap<String, List<String>>();
            if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)dto.getBatchCodeMap())) {
                List sgSendItemDtos = dto.getItemList();
                for (SgSendOccupyDto.SgSendItemDto sgSendItemDto : sgSendItemDtos) {
                    if (!isOpenEffective.booleanValue()) continue;
                    QueryInteriorSkuVO skuInfo = this.psAdapter.getSkuInfo(sgSendItemDto.getPsSkuId());
                    if (ObjectUtils.isEmpty((Object)skuInfo)) {
                        throw new BusinessException("\u67e5\u8be2\u5546\u54c1\u662f\u5426\u6548\u671f\u7ba1\u63a7\u4fe1\u606f\u5931\u8d25");
                    }
                    Boolean isValidityPeriodControlled = StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)String.valueOf(skuInfo.getBatchManage()));
                    sgSendItemDto.setIsValidityPeriodControlled(isValidityPeriodControlled);
                    List<String> batchCodeList = new ArrayList<String>();
                    if (StringUtils.isNotEmpty((CharSequence)sgSendItemDto.getBatchCode())) {
                        batchCodeList.add(sgSendItemDto.getBatchCode());
                    }
                    if (!isValidityPeriodControlled.booleanValue() && CollectionUtils.isEmpty(batchCodeList)) {
                        if (StringUtils.isNotEmpty((CharSequence)defaultEffectiveBatchCode)) {
                            batchCodeList.add(defaultEffectiveBatchCode);
                        } else {
                            throw new BusinessException("\u672a\u914d\u7f6e\u6548\u671f\u5e93\u5b58\u9ed8\u8ba4\u6548\u671f\u6279\u6b21");
                        }
                    }
                    if (CollectionUtils.isEmpty(batchCodeList)) {
                        batchCodeList = this.sgStockQueryBiz.getBatchCodeList(effectiveLabel, sgSendItemDto.getPsSkuId(), sgSendItemDto.getSgStoreId(), redundantDays);
                    }
                    if (org.springframework.util.CollectionUtils.isEmpty(batchCodeList)) {
                        throw new BusinessException("\u67e5\u8be2\u6548\u671f\u6279\u6b21\u4fe1\u606f\u51fa\u9519\u6216\u8005\u672a\u67e5\u5230\u5546\u54c1\u6279\u6b21\u5e93\u5b58\u4fe1\u606f");
                    }
                    sgSendItemDto.setBatchCode((String)batchCodeList.get(0));
                    batchCodeMap.put(sgSendItemDto.getSgStoreId() + "_" + sgSendItemDto.getPsSkuId(), batchCodeList);
                }
            }
            if (!(sendSaveRes = (bean = (SgSendOccupyBiz)ApplicationContextHelper.getBean(SgSendOccupyBiz.class)).sendSave(dto)).isSuccess()) {
                throw new BusinessException("\u65b0\u589e\u6216\u66f4\u65b0\u903b\u8f91\u53d1\u8d27\u5355\u5931\u8d25\uff1a" + sendSaveRes.getDesc());
            }
            SgSendCommonBiz.SendSaveVO sendSaveVO = (SgSendCommonBiz.SendSaveVO)sendSaveRes.getContent();
            Long updateStoragePreOutStartTime = System.currentTimeMillis();
            SgSendCommonBiz.StoragePreOutEntity storagePreOutEntity = new SgSendCommonBiz.StoragePreOutEntity();
            storagePreOutEntity.setOccupyType(dto.getOccupyType());
            storagePreOutEntity.setOrigSendEntity(sendSaveVO.getOrigSendEntity());
            storagePreOutEntity.setNewSendEntity(sendSaveVO.getNewSendEntity());
            storagePreOutEntity.setStrategyPriorityList(dto.getStrategyPriorityList());
            storagePreOutEntity.setIsOpenEffective(isOpenEffective);
            if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)dto.getBatchCodeMap())) {
                storagePreOutEntity.setBatchCodeMap(dto.getBatchCodeMap());
            } else {
                storagePreOutEntity.setBatchCodeMap(batchCodeMap);
            }
            ApiResponse<SgStorageBatchUpdateVo> updateStoragePreOutRes = this.storeOccupyBiz.updateStoragePreOut(storagePreOutEntity);
            if (log.isDebugEnabled()) {
                log.debug("\u903b\u8f91\u53d1\u8d27\u5355\u5360\u7528 \u66f4\u65b0\u903b\u8f91\u5e93\u5b58\u8fd4\u56de\u503c {} \u8017\u65f6:{}ms", (Object)JSON.toJSONString(updateStoragePreOutRes), (Object)(System.currentTimeMillis() - updateStoragePreOutStartTime));
            }
            if (updateStoragePreOutRes.getContent() != null && ((SgStorageBatchUpdateVo)updateStoragePreOutRes.getContent()).getOutStockItem() != null) {
                ArrayList<SgStorageBatchUpdateVo.OutStockItem> outStockItemList = new ArrayList<SgStorageBatchUpdateVo.OutStockItem>();
                SgStorageBatchUpdateVo.OutStockItem outStockItem = new SgStorageBatchUpdateVo.OutStockItem();
                BeanUtils.copyProperties((Object)((SgStorageBatchUpdateVo)updateStoragePreOutRes.getContent()).getOutStockItem(), (Object)outStockItem);
                outStockItemList.add(outStockItem);
                returnVO.setOutStockItemList(outStockItemList);
            }
            if (log.isDebugEnabled()) {
                log.debug("\u903b\u8f91\u53d1\u8d27\u5355\u5360\u7528 \u8fd4\u56de\u503c\uff1a{}", (Object)JSON.toJSONString((Object)returnVO));
            }
            if (!updateStoragePreOutRes.isSuccess()) {
                throw new BusinessException(updateStoragePreOutRes.getDesc());
            }
            SgStorageBatchUpdateVo resultData = (SgStorageBatchUpdateVo)updateStoragePreOutRes.getContent();
            Long updateSendPreOutStartTime = System.currentTimeMillis();
            resultData.setIsOpenEffective(isOpenEffective);
            this.sendCommonBiz.updateSendPreOut(sendSaveVO.getNewSendEntity().getSend().getId(), SgBizEnum.SendItemOccupyType.getEnum((String)dto.getOccupyType()), resultData);
            if (log.isDebugEnabled()) {
                log.debug("\u66f4\u65b0\u903b\u8f91\u53d1\u8d27\u5355\u5360\u7528 \u8017\u65f6:{}ms", (Object)(System.currentTimeMillis() - updateSendPreOutStartTime));
            }
            returnVO.setId(sendSaveVO.getNewSendEntity().getSend().getId());
            returnVO.setRedisSynchMqItemList(resultData.getRedisSynchMqItemList());
            returnVO.setRedisBillFtpKeyList(resultData.getRedisBillFtpKeyList());
            returnVO.setUpdateResult(resultData);
            returnVO.setStrategyPriorityList(storagePreOutEntity.getStrategyPriorityList());
            redisBillFtpKeyList.addAll(resultData.getRedisBillFtpKeyList());
            if (dto.getIsOpenEffective().booleanValue()) {
                returnVO.setIsOpenEffective(isOpenEffective);
                redisBillFtpKeyListByBatchCode.addAll(resultData.getSgStorageEffectiveBatchUpdateVo().getRedisBillFtpKeyList());
                returnVO.setRedisBillFtpKeyListByBatchCode(redisBillFtpKeyListByBatchCode);
            }
            if (log.isDebugEnabled()) {
                log.debug("\u903b\u8f91\u53d1\u8d27\u5355\u5360\u7528\u7ed3\u675f \u8017\u65f6{}ms", (Object)(System.currentTimeMillis() - startTime));
            }
            ApiResponse apiResponse7 = ApiResponse.success((Object)returnVO);
            return apiResponse7;
        }
        catch (BusinessException e) {
            log.error("\u903b\u8f91\u53d1\u8d27\u5355\u5360\u7528\u4e1a\u52a1\u5f02\u5e38:{}", (Object)e.getMessage());
            this.commonStorageRollBackBiz.rollBackStorage(redisBillFtpKeyList);
            if (CollectionUtils.isNotEmpty(redisBillFtpKeyListByBatchCode)) {
                this.commonStorageRollBackBiz.rollBackStorageEffective(redisBillFtpKeyListByBatchCode);
            }
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            apiResponse = ApiResponse.failed((Object)returnVO, (String)e.getMessage());
            return apiResponse;
        }
        catch (Exception e) {
            log.error("\u903b\u8f91\u53d1\u8d27\u5355\u5360\u7528\u5f02\u5e38:", (Throwable)e);
            this.commonStorageRollBackBiz.rollBackStorage(redisBillFtpKeyList);
            if (CollectionUtils.isNotEmpty(redisBillFtpKeyListByBatchCode)) {
                this.commonStorageRollBackBiz.rollBackStorageEffective(redisBillFtpKeyListByBatchCode);
            }
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            apiResponse = ApiResponse.failed((Object)returnVO, (String)e.getMessage());
            return apiResponse;
        }
        finally {
            redisLock.unlock();
        }
    }

    public static void main(String[] args) {
        SgStorageBatchUpdateVo.OutStockItem outStockItem = new SgStorageBatchUpdateVo.OutStockItem();
        outStockItem.setSgSupplyStrategyCode("123123");
        SgStorageBatchUpdateVo.OutStockItem outStockItemNew = new SgStorageBatchUpdateVo.OutStockItem();
        BeanUtils.copyProperties((Object)outStockItem, (Object)outStockItemNew);
        System.out.println(JSON.toJSONString((Object)outStockItem));
        System.out.println(JSON.toJSONString((Object)outStockItemNew));
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NESTED)
    public ApiResponse<SgSendCommonBiz.SendSaveVO> sendSave(SgSendOccupyDto dto) {
        ApiResponse<SgSendCommonBiz.SendCommonEntity> res;
        Long startTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("\u903b\u8f91\u53d1\u8d27\u5355\u4fdd\u5b58\u5165\u53c2 {}", (Object)JSON.toJSONString((Object)dto));
        }
        if (!(res = this.sendCommonBiz.checkParams(dto)).isSuccess()) {
            return ApiResponse.failed((String)res.getDesc());
        }
        SgSendCommonBiz.SendCommonEntity sendCommonEntity = (SgSendCommonBiz.SendCommonEntity)res.getContent();
        try {
            ApiResponse<SgSendCommonBiz.SendEntity> apiRes;
            List itemList = dto.getItemList();
            List<SgSendOccupyDto.SgSendItemDto> newItemList = this.mergeSameSkuIdAndSgStoreId(itemList);
            dto.setItemList(newItemList);
            if (dto.getIsOpenEffective().booleanValue()) {
                List itemEffectiveList = dto.getEffectiveItemList();
                List<Object> effectiveItemList = new ArrayList();
                effectiveItemList = CollectionUtils.isNotEmpty((Collection)itemEffectiveList) ? this.mergeSameSkuIdAndSgStoreIdAndBatchCode(itemEffectiveList) : this.mergeSameSkuIdAndSgStoreIdAndBatchCode(itemList);
                dto.setEffectiveItemList(effectiveItemList);
            }
            if (log.isDebugEnabled()) {
                log.debug("\u5408\u5e76\u540e\u7684\u903b\u8f91\u53d1\u8d27\u5355\u5165\u53c2 {}", (Object)JSON.toJSONString((Object)dto));
            }
            boolean isCreate = true;
            SgSendCommonBiz.SendEntity origSendEntity = this.getOrigSendEntity(dto.getMain().getSourceBillNo(), dto.getMain().getOrderNo(), dto.getMain().getSourceBillType());
            if (origSendEntity != null) {
                isCreate = false;
            }
            if (isCreate) {
                ApiResponse<Void> apiResponse = this.sendCommonBiz.checkParamsSgWarehouseAndSgStore(dto);
                if (!apiResponse.isSuccess()) {
                    return ApiResponse.failed((String)apiResponse.getDesc());
                }
                apiRes = this.sendCreateBiz.sendCreate(dto, sendCommonEntity);
            } else {
                sendCommonEntity.setOrigSendEntity(origSendEntity);
                apiRes = this.sendUpdateBiz.sendUpdate(dto, sendCommonEntity);
            }
            if (!apiRes.isSuccess()) {
                return ApiResponse.failed((String)apiRes.getDesc());
            }
            SgSendCommonBiz.SendSaveVO sendSaveVO = new SgSendCommonBiz.SendSaveVO();
            sendSaveVO.setOrigSendEntity(origSendEntity);
            sendSaveVO.setNewSendEntity((SgSendCommonBiz.SendEntity)apiRes.getContent());
            if (log.isDebugEnabled()) {
                log.debug("\u903b\u8f91\u53d1\u8d27\u5355\u4fdd\u5b58\u8fd4\u56de\u503c {} \u8017\u65f6:{}ms", (Object)JSON.toJSONString((Object)sendSaveVO), (Object)(System.currentTimeMillis() - startTime));
            }
            return ApiResponse.success((Object)sendSaveVO);
        }
        catch (Exception e) {
            log.error("\u903b\u8f91\u53d1\u8d27\u5355\u4fdd\u5b58\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException("\u903b\u8f91\u53d1\u8d27\u5355\u4fdd\u5b58\u5f02\u5e38" + e.getMessage());
        }
    }

    public List<SgSendOccupyDto.SgSendItemDto> mergeSameSkuIdAndSgStoreId(List<SgSendOccupyDto.SgSendItemDto> itemList) {
        Map<String, List<SgSendOccupyDto.SgSendItemDto>> newSendItemMap = itemList.stream().collect(Collectors.groupingBy(obj -> StoreUtils.getSendItemMapForMapKey(obj.getPsSkuId(), obj.getSgStoreId())));
        ArrayList<SgSendOccupyDto.SgSendItemDto> list = new ArrayList<SgSendOccupyDto.SgSendItemDto>();
        for (String PsSkuId_SgStoreId : newSendItemMap.keySet()) {
            List<SgSendOccupyDto.SgSendItemDto> newSendItemList = newSendItemMap.get(PsSkuId_SgStoreId);
            SgSendOccupyDto.SgSendItemDto newSendItem = this.sgSendUpdateBiz.getNewSgSendItemDto(newSendItemList);
            list.add(newSendItem);
        }
        return list;
    }

    public SgSendCommonBiz.SendEntity getOrigSendEntity(String sourceBillNo, String orderNo, Integer sourceBillType) {
        SgSendCommonBiz.SendEntity origSendEntity = null;
        SgSend sgSend = this.sgSendService.selectEffectiveSend(sourceBillNo, orderNo, sourceBillType);
        if (sgSend != null) {
            List sgSendItemList = this.sgSendItemService.selectSendItemList(sgSend.getId());
            if (CollectionUtils.isEmpty((Collection)sgSendItemList)) {
                throw new BusinessException("\u903b\u8f91\u53d1\u8d27\u5355\u660e\u7ec6\u4e0d\u5b58\u5728\u3002\u5355\u636e\u7f16\u53f7\uff1a" + sgSend.getSourceBillNo());
            }
            List sgSendEffectiveItemList = this.sgSendEffectiveItemService.selectSendEffectiveItemBysendIdList(sgSend.getId());
            origSendEntity = new SgSendCommonBiz.SendEntity();
            origSendEntity.setSend(sgSend);
            origSendEntity.setSendItemList(sgSendItemList);
            if (CollectionUtils.isNotEmpty((Collection)sgSendEffectiveItemList)) {
                origSendEntity.setSendEffectiveItemList(sgSendEffectiveItemList);
            }
        }
        return origSendEntity;
    }

    public List<SgSendOccupyDto.SgSendItemDto> mergeSameSkuIdAndSgStoreIdAndBatchCode(List<SgSendOccupyDto.SgSendItemDto> itemList) {
        Map<String, List<SgSendOccupyDto.SgSendItemDto>> newSendItemMap = itemList.stream().collect(Collectors.groupingBy(obj -> StoreUtils.getSendItemByBatchCodeMapForMapKey(obj.getPsSkuId(), obj.getSgStoreId(), obj.getBatchCode())));
        ArrayList<SgSendOccupyDto.SgSendItemDto> list = new ArrayList<SgSendOccupyDto.SgSendItemDto>();
        for (String PsSkuId_SgStoreId_BatchCode : newSendItemMap.keySet()) {
            List<SgSendOccupyDto.SgSendItemDto> newSendItemList = newSendItemMap.get(PsSkuId_SgStoreId_BatchCode);
            SgSendOccupyDto.SgSendItemDto newSendItem = this.sgSendUpdateBiz.getNewSgSendItemDto(newSendItemList);
            list.add(newSendItem);
        }
        return list;
    }
}

