/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.send.restructure;

import com.alibaba.fastjson.JSON;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.bizlog.annotation.LogAnnotation;
import com.xinqiyi.framework.bizlog.entity.InnerLog;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.sg.basic.model.common.SgBizEnum;
import com.xinqiyi.sg.store.model.dto.send.SgSendOccupyDto;
import com.xinqiyi.sg.store.model.entity.SgSend;
import com.xinqiyi.sg.store.model.entity.SgSendEffectiveItem;
import com.xinqiyi.sg.store.model.entity.SgSendItem;
import com.xinqiyi.sg.store.service.SgSendEffectiveItemService;
import com.xinqiyi.sg.store.service.SgSendItemService;
import com.xinqiyi.sg.store.service.SgSendService;
import com.xinqiyi.sg.store.service.business.send.restructure.SgSendCommonBiz;
import com.xinqiyi.sg.store.service.business.utils.StoreUtils;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SgSendUpdateBiz {
    private static final Logger log = LoggerFactory.getLogger(SgSendUpdateBiz.class);
    @Resource
    private SgSendService sgSendService;
    @Resource
    private SgSendItemService sgSendItemService;
    @Resource
    private IdSequenceGenerator idSequenceGenerator;
    @Resource
    private BaseDaoInitialService baseDaoInitialService;
    @Resource
    private SgSendCommonBiz sgSendCommonBiz;
    @Resource
    private SgSendEffectiveItemService sgSendEffectiveItemService;

    @LogAnnotation
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NESTED)
    public ApiResponse<SgSendCommonBiz.SendEntity> sendUpdate(SgSendOccupyDto dto, SgSendCommonBiz.SendCommonEntity sendCommonEntity) {
        SgSend sgSend = this.buildSgSendForUpdate(dto, sendCommonEntity);
        List<SgSendItem> sendItemList = this.buildSgSendItemForUpdate(sgSend.getId(), dto, sendCommonEntity);
        List<Object> sendEffectiveItemList = new ArrayList();
        if (dto.getIsOpenEffective().booleanValue()) {
            sendEffectiveItemList = this.buildSgSendEffectiveItemForUpdate(sgSend.getId(), dto, sendCommonEntity, sendItemList);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u66f4\u65b0\u7684\u903b\u8f91\u53d1\u8d27\u5355 sgSend\uff1a{} sendItemList\uff1a{} sendEffectiveItemList: {}", new Object[]{JSON.toJSONString((Object)sgSend), JSON.toJSONString(sendItemList), JSON.toJSONString(sendEffectiveItemList)});
        }
        this.sgSendService.updateById((Object)sgSend);
        this.sgSendItemService.saveOrUpdateBatch(sendItemList);
        if (CollectionUtils.isNotEmpty(sendEffectiveItemList)) {
            this.sgSendEffectiveItemService.saveOrUpdateBatch(sendEffectiveItemList);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u66f4\u65b0\u903b\u8f91\u53d1\u8d27\u5355\u6210\u529f");
        }
        this.sgSendCommonBiz.updateTotalQtyPreOut(sgSend.getId());
        SgSendCommonBiz.SendEntity sendEntity = new SgSendCommonBiz.SendEntity();
        sendEntity.setSend((SgSend)this.sgSendService.getById((Serializable)sgSend.getId()));
        sendEntity.setSendItemList(this.sgSendItemService.selectSendItemList(sgSend.getId()));
        sendEntity.setSendEffectiveItemList(this.sgSendEffectiveItemService.selectSendEffectiveItemBysendIdList(sgSend.getId()));
        InnerLog.addLog((Long)sgSend.getId(), (String)"\u66f4\u65b0\u903b\u8f91\u53d1\u8d27\u5355", (String)"sg_send", null, (String)"\u66f4\u65b0");
        return ApiResponse.success((Object)sendEntity);
    }

    private SgSend buildSgSendForUpdate(SgSendOccupyDto dto, SgSendCommonBiz.SendCommonEntity sendCommonEntity) {
        List itemList = dto.getItemList();
        SgSend sendDb = sendCommonEntity.getOrigSendEntity().getSend();
        String occupyType = dto.getOccupyType();
        SgSend send = new SgSend();
        send.setId(sendDb.getId());
        send.setBillStatus(SgBizEnum.SendBillStatus.UPDATE.getValue());
        BigDecimal totalQtyPreOut = BigDecimal.ZERO;
        for (SgSendOccupyDto.SgSendItemDto sendItemDto : itemList) {
            totalQtyPreOut = totalQtyPreOut.add(sendItemDto.getQty());
        }
        if (SgBizEnum.SendItemOccupyType.INCREMENT.getValue().equals(occupyType)) {
            BigDecimal totQtyPreOutDb = Optional.ofNullable(sendDb.getTotQtyPreOut()).orElse(BigDecimal.ZERO);
            totalQtyPreOut = totalQtyPreOut.add(totQtyPreOutDb);
        }
        if (dto.getMain() != null) {
            send.setServiceNode(dto.getMain().getServiceNode());
        }
        send.setTotQtyPreOut(totalQtyPreOut);
        send.setBillNo(sendDb.getBillNo());
        send.setSourceBillId(sendDb.getSourceBillId());
        send.setSourceBillNo(sendDb.getSourceBillNo());
        send.setSourceBillType(sendDb.getSourceBillType());
        send.setOrderId(sendDb.getOrderId());
        send.setOrderNo(sendDb.getOrderNo());
        send.setBillDate(sendDb.getBillDate());
        this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)send, sendCommonEntity.getBizOperator());
        return send;
    }

    private List<SgSendItem> buildSgSendItemForUpdate(Long sendId, SgSendOccupyDto dto, SgSendCommonBiz.SendCommonEntity sendCommonEntity) {
        List itemList = dto.getItemList();
        List<SgSendItem> sendItemDdList = sendCommonEntity.getOrigSendEntity().getSendItemList();
        String occupyType = dto.getOccupyType();
        Boolean isPreOrderOccupy = dto.getIsPreOrderOccupy() != null && dto.getIsPreOrderOccupy() != false;
        Map origSendItemMap = sendItemDdList.stream().collect(Collectors.toMap(obj -> StoreUtils.getSendItemMapForMapKey(obj.getPsSkuId(), obj.getSgStoreId()), Function.identity()));
        Map<String, List<SgSendOccupyDto.SgSendItemDto>> newSendItemMap = itemList.stream().collect(Collectors.groupingBy(obj -> StoreUtils.getSendItemMapForMapKey(obj.getPsSkuId(), obj.getSgStoreId())));
        ArrayList<SgSendItem> list = new ArrayList<SgSendItem>();
        for (String PsSkuId_SgStoreId : newSendItemMap.keySet()) {
            List<SgSendOccupyDto.SgSendItemDto> newSendItemList = newSendItemMap.get(PsSkuId_SgStoreId);
            SgSendOccupyDto.SgSendItemDto newSendItem = this.getNewSgSendItemDto(newSendItemList);
            SgSendItem origSendItem = (SgSendItem)origSendItemMap.get(PsSkuId_SgStoreId);
            SgSendItem sgSendItem = new SgSendItem();
            if (origSendItem != null) {
                BigDecimal origQty;
                BigDecimal newQty = newSendItem.getQty() == null ? BigDecimal.ZERO : newSendItem.getQty();
                BigDecimal bigDecimal = origQty = origSendItem.getQty() == null ? BigDecimal.ZERO : origSendItem.getQty();
                if (SgBizEnum.SendItemOccupyType.INCREMENT.getValue().equals(occupyType)) {
                    newQty = origQty.add(newQty);
                }
                sgSendItem.setId(origSendItem.getId());
                sgSendItem.setQty(newQty);
                if (isPreOrderOccupy.booleanValue()) {
                    sgSendItem.setQtyPreOut(newQty);
                }
                sgSendItem.setPsSkuId(origSendItem.getPsSkuId());
                sgSendItem.setSgStoreId(origSendItem.getSgStoreId());
                this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)sgSendItem, sendCommonEntity.getBizOperator());
                list.add(sgSendItem);
                continue;
            }
            Long id = this.idSequenceGenerator.generateId(SgSendItem.class);
            BeanUtils.copyProperties((Object)newSendItem, (Object)sgSendItem);
            sgSendItem.setId(id);
            sgSendItem.setSgSendId(sendId);
            if (isPreOrderOccupy.booleanValue()) {
                sgSendItem.setQtySend(BigDecimal.ZERO);
                sgSendItem.setQtyPreOut(sgSendItem.getQty());
            }
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)sgSendItem);
            list.add(sgSendItem);
        }
        return list;
    }

    public SgSendOccupyDto.SgSendItemDto getNewSgSendItemDto(List<SgSendOccupyDto.SgSendItemDto> newSendItemList) {
        BigDecimal newQty = newSendItemList.stream().map(SgSendOccupyDto.SgSendItemDto::getQty).reduce(BigDecimal.ZERO, BigDecimal::add);
        SgSendOccupyDto.SgSendItemDto sgSendItemDto = newSendItemList.get(0);
        sgSendItemDto.setQty(newQty);
        return sgSendItemDto;
    }

    private List<SgSendEffectiveItem> buildSgSendEffectiveItemForUpdate(Long sendId, SgSendOccupyDto dto, SgSendCommonBiz.SendCommonEntity sendCommonEntity, List<SgSendItem> sendItemList) {
        Map<String, List<SgSendItem>> newSendItemMap = sendItemList.stream().collect(Collectors.groupingBy(obj -> StoreUtils.getSendItemMapForMapKey(obj.getPsSkuId(), obj.getSgStoreId())));
        List itemList = dto.getEffectiveItemList();
        List<SgSendEffectiveItem> sendEffectiveItemList = sendCommonEntity.getOrigSendEntity().getSendEffectiveItemList();
        String occupyType = dto.getOccupyType();
        Boolean isPreOrderOccupy = dto.getIsPreOrderOccupy() != null && dto.getIsPreOrderOccupy() != false;
        Map origSendEffectiveItemMap = sendEffectiveItemList.stream().collect(Collectors.toMap(obj -> StoreUtils.getSendItemByBatchCodeMapForMapKey(obj.getPsSkuId(), obj.getSgStoreId(), obj.getPreoutBatchCode()), Function.identity()));
        Map<String, List<SgSendOccupyDto.SgSendItemDto>> newSendEffectvieItemMap = itemList.stream().collect(Collectors.groupingBy(obj -> StoreUtils.getSendItemByBatchCodeMapForMapKey(obj.getPsSkuId(), obj.getSgStoreId(), obj.getBatchCode())));
        ArrayList<SgSendEffectiveItem> list = new ArrayList<SgSendEffectiveItem>();
        for (String PsSkuId_SgStoreId_BatchCode : newSendEffectvieItemMap.keySet()) {
            List<SgSendOccupyDto.SgSendItemDto> newSendItemList = newSendEffectvieItemMap.get(PsSkuId_SgStoreId_BatchCode);
            SgSendOccupyDto.SgSendItemDto newSendItem = this.getNewSgSendItemDto(newSendItemList);
            SgSendEffectiveItem origSendEffectiveItem = (SgSendEffectiveItem)origSendEffectiveItemMap.get(PsSkuId_SgStoreId_BatchCode);
            SgSendEffectiveItem sgSendEffectiveItem = new SgSendEffectiveItem();
            if (origSendEffectiveItem != null) {
                BigDecimal origQty;
                BigDecimal newQty = newSendItem.getQty() == null ? BigDecimal.ZERO : newSendItem.getQty();
                BigDecimal bigDecimal = origQty = origSendEffectiveItem.getQty() == null ? BigDecimal.ZERO : origSendEffectiveItem.getQty();
                if (SgBizEnum.SendItemOccupyType.INCREMENT.getValue().equals(occupyType)) {
                    newQty = origQty.add(newQty);
                }
                sgSendEffectiveItem.setId(origSendEffectiveItem.getId());
                sgSendEffectiveItem.setQty(newQty);
                if (isPreOrderOccupy.booleanValue()) {
                    sgSendEffectiveItem.setQtyPreOut(newQty);
                }
                this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)sgSendEffectiveItem, sendCommonEntity.getBizOperator());
                list.add(sgSendEffectiveItem);
                continue;
            }
            Long id = this.idSequenceGenerator.generateId(SgSendEffectiveItem.class);
            BeanUtils.copyProperties((Object)newSendItem, (Object)sgSendEffectiveItem);
            sgSendEffectiveItem.setId(id);
            sgSendEffectiveItem.setSgSendId(sendId);
            if (isPreOrderOccupy.booleanValue()) {
                sgSendEffectiveItem.setQtySend(BigDecimal.ZERO);
                sgSendEffectiveItem.setQtyPreOut(sgSendEffectiveItem.getQty());
            }
            String skuId_StoreId = newSendItem.getPsSkuId() + "_" + newSendItem.getSgStoreId();
            Long sendItemId = newSendItemMap.get(skuId_StoreId).get(0).getId();
            sgSendEffectiveItem.setSgSendItemId(sendItemId);
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)sgSendEffectiveItem);
            list.add(sgSendEffectiveItem);
        }
        return list;
    }
}

