/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.sg.store.service.business.send.restructure;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.sg.basic.api.model.vo.SgStorageBatchUpdateVo;
import com.xinqiyi.sg.basic.model.dto.SgStorageSingleUpdateDto;
import com.xinqiyi.sg.basic.model.dto.SgStorageUpdateBillDto;
import com.xinqiyi.sg.basic.model.dto.SgStorageUpdateBillItemDto;
import com.xinqiyi.sg.basic.model.dto.SgStorageUpdateControlDto;
import com.xinqiyi.sg.basic.service.business.SgStorageRedisBillUpdateBiz;
import com.xinqiyi.sg.basic.service.config.SgResultMqConfig;
import com.xinqiyi.sg.basic.service.exception.BusinessException;
import com.xinqiyi.sg.store.model.entity.SgSend;
import com.xinqiyi.sg.store.model.entity.SgSendEffectiveItem;
import com.xinqiyi.sg.store.model.entity.SgSendItem;
import com.xinqiyi.sg.store.service.business.common.PropertyCopyByStoreBiz;
import com.xinqiyi.sg.store.service.business.common.PropertyCopyByStoreEffectiveBiz;
import com.xinqiyi.sg.store.service.business.send.restructure.SgSendCommonBiz;
import com.xinqiyi.sg.store.service.business.utils.StoreUtils;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SgStoreOccupyBiz {
    private static final Logger log = LoggerFactory.getLogger(SgStoreOccupyBiz.class);
    @Resource
    private SgStorageRedisBillUpdateBiz sgStorageRedisBillUpdateBiz;
    @Resource
    private PropertyCopyByStoreBiz propertyCopyByStoreBiz;
    @Resource
    SgResultMqConfig sgResultMqConfig;
    @Resource
    private PropertyCopyByStoreEffectiveBiz propertyCopyByStoreEffectiveBiz;

    public ApiResponse<SgStorageBatchUpdateVo> updateStoragePreOut(SgSendCommonBiz.StoragePreOutEntity storagePreOutEntity) {
        ApiResponse response;
        SgStorageSingleUpdateDto storageSingleUpdateDto = new SgStorageSingleUpdateDto();
        try {
            SgSend newSend = storagePreOutEntity.getNewSendEntity().getSend();
            String billNo = newSend.getBillNo();
            SgStorageUpdateBillDto sgStorageUpdateBillDto = this.buildBillInfo(storagePreOutEntity);
            String messageKey = this.sgResultMqConfig.MSG_TAG_SEND + ":" + newSend.getBillNo();
            storageSingleUpdateDto.setControlModel(new SgStorageUpdateControlDto());
            storageSingleUpdateDto.setMessageKey(messageKey);
            storageSingleUpdateDto.setBill(sgStorageUpdateBillDto);
            storageSingleUpdateDto.setIsOpenEffective(storagePreOutEntity.getIsOpenEffective());
            log.info("\u6765\u6e90\u5355\u636e\u7f16\u53f7[" + billNo + "],\u5e93\u5b58\u5360\u7528\u5165\u53c2" + JSONObject.toJSONString((Object)storageSingleUpdateDto));
            response = this.sgStorageRedisBillUpdateBiz.updateStorageBill(storageSingleUpdateDto);
            log.info("\u6765\u6e90\u5355\u636e\u7f16\u53f7[" + billNo + "],\u5e93\u5b58\u5360\u7528\u51fa\u53c2" + JSON.toJSONString((Object)response));
        }
        catch (Exception e) {
            log.error("\u5e93\u5b58\u5360\u7528\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("\u5e93\u5b58\u5360\u7528\u670d\u52a1\u5f02\u5e38:" + e);
        }
        return response;
    }

    public SgStorageUpdateBillDto buildBillInfo(SgSendCommonBiz.StoragePreOutEntity storagePreOutEntity) {
        SgStorageUpdateBillDto billRequest = new SgStorageUpdateBillDto();
        this.propertyCopyByStoreBiz.initBillInfo(storagePreOutEntity.getNewSendEntity().getSend(), billRequest);
        if (storagePreOutEntity.getStrategyPriorityList() != null) {
            billRequest.setStrategyPriorityList(storagePreOutEntity.getStrategyPriorityList());
        }
        List<SgStorageUpdateBillItemDto> itemList = this.buildSendStorageItems(storagePreOutEntity);
        billRequest.setItemList(itemList);
        if (storagePreOutEntity.getIsOpenEffective().booleanValue()) {
            List<SgStorageUpdateBillItemDto> effectiveItemList = this.buildSendEffectiveStorageItems(storagePreOutEntity);
            billRequest.setEffectiveItemList(effectiveItemList);
            billRequest.setBatchCodeMap(storagePreOutEntity.getBatchCodeMap());
        }
        return billRequest;
    }

    public List<SgStorageUpdateBillItemDto> buildSendStorageItems(SgSendCommonBiz.StoragePreOutEntity storagePreOutEntity) {
        ArrayList<SgStorageUpdateBillItemDto> storageUpdateBillItemList = new ArrayList<SgStorageUpdateBillItemDto>();
        String occupyType = storagePreOutEntity.getOccupyType();
        SgSendCommonBiz.SendEntity origSendEntity = storagePreOutEntity.getOrigSendEntity();
        SgSendCommonBiz.SendEntity newSendEntity = storagePreOutEntity.getNewSendEntity();
        if (origSendEntity == null) {
            List<SgStorageUpdateBillItemDto> billItemList = this.buildStorageUpdateBillItem(newSendEntity);
            storageUpdateBillItemList.addAll(billItemList);
        } else {
            List<SgSendItem> origSendItemList = origSendEntity.getSendItemList();
            List<SgSendItem> newSendItemList = newSendEntity.getSendItemList();
            Map origSendItemMap = origSendItemList.stream().collect(Collectors.toMap(obj -> StoreUtils.getSendItemMapForMapKey(obj.getPsSkuId(), obj.getSgStoreId()), Function.identity()));
            Map newSendItemMap = newSendItemList.stream().collect(Collectors.toMap(obj -> StoreUtils.getSendItemMapForMapKey(obj.getPsSkuId(), obj.getSgStoreId()), Function.identity()));
            ArrayList<SgSendItem> newOccupySendItemList = new ArrayList<SgSendItem>();
            for (String key : newSendItemMap.keySet()) {
                SgSendItem newSendItem = (SgSendItem)newSendItemMap.get(key);
                SgSendItem origSendItem = (SgSendItem)origSendItemMap.get(key);
                if (origSendItem != null) {
                    BigDecimal origQty;
                    BigDecimal newQty = newSendItem.getQty();
                    BigDecimal diffQty = newQty.subtract(origQty = origSendItem.getQty());
                    if (BigDecimal.ZERO.compareTo(diffQty) == 0) continue;
                    newSendItem.setQty(diffQty);
                    newOccupySendItemList.add(newSendItem);
                    continue;
                }
                newOccupySendItemList.add(newSendItem);
            }
            SgSendCommonBiz.SendEntity newOccupySend = new SgSendCommonBiz.SendEntity();
            newOccupySend.setSend(newSendEntity.getSend());
            newOccupySend.setSendItemList(newOccupySendItemList);
            List<SgStorageUpdateBillItemDto> billItemList = this.buildStorageUpdateBillItem(newOccupySend);
            storageUpdateBillItemList.addAll(billItemList);
        }
        return storageUpdateBillItemList;
    }

    private List<SgStorageUpdateBillItemDto> buildReverseStorageUpdateBillItem(SgSendCommonBiz.SendEntity origSendEntity) {
        ArrayList<SgStorageUpdateBillItemDto> storageUpdateBillItemList = new ArrayList<SgStorageUpdateBillItemDto>();
        SgSend origSend = origSendEntity.getSend();
        List<SgSendItem> origSendItemList = origSendEntity.getSendItemList();
        for (SgSendItem origSendItem : origSendItemList) {
            if (origSendItem == null || 0 == BigDecimal.ZERO.compareTo(origSendItem.getQtyPreOut().negate())) continue;
            BigDecimal qtyPreOutChange = origSendItem.getQtyPreOut().negate();
            SgStorageUpdateBillItemDto storageUpdateBillItem = new SgStorageUpdateBillItemDto();
            BeanUtils.copyProperties((Object)origSendItem, (Object)storageUpdateBillItem);
            this.propertyCopyByStoreBiz.copyProperties(origSend, origSendItem, storageUpdateBillItem);
            storageUpdateBillItem.setBillItemId(origSendItem.getId());
            storageUpdateBillItem.setSourceItemId(origSendItem.getSourceBillItemId());
            storageUpdateBillItem.setQtyPreoutChange(qtyPreOutChange);
            storageUpdateBillItem.setControlmodel(new SgStorageUpdateControlDto());
            storageUpdateBillItemList.add(storageUpdateBillItem);
        }
        return storageUpdateBillItemList;
    }

    private List<SgStorageUpdateBillItemDto> buildStorageUpdateBillItem(SgSendCommonBiz.SendEntity newSendEntity) {
        SgSend newSend = newSendEntity.getSend();
        List<SgSendItem> newSendItemList = newSendEntity.getSendItemList();
        ArrayList<SgStorageUpdateBillItemDto> storageUpdateBillItemList = new ArrayList<SgStorageUpdateBillItemDto>();
        for (SgSendItem newSendItem : newSendItemList) {
            SgStorageUpdateBillItemDto storageUpdateBillItem = new SgStorageUpdateBillItemDto();
            BeanUtils.copyProperties((Object)newSendItem, (Object)storageUpdateBillItem);
            this.propertyCopyByStoreBiz.copyProperties(newSend, newSendItem, storageUpdateBillItem);
            storageUpdateBillItem.setBillItemId(newSendItem.getId());
            storageUpdateBillItem.setSourceItemId(newSendItem.getSourceBillItemId());
            storageUpdateBillItem.setQtyPreoutChange(newSendItem.getQty());
            storageUpdateBillItem.setControlmodel(new SgStorageUpdateControlDto());
            storageUpdateBillItemList.add(storageUpdateBillItem);
        }
        return storageUpdateBillItemList;
    }

    public List<SgStorageUpdateBillItemDto> buildSendEffectiveStorageItems(SgSendCommonBiz.StoragePreOutEntity storagePreOutEntity) {
        ArrayList<SgStorageUpdateBillItemDto> storageUpdateBillItemList = new ArrayList<SgStorageUpdateBillItemDto>();
        String occupyType = storagePreOutEntity.getOccupyType();
        SgSendCommonBiz.SendEntity origSendEntity = storagePreOutEntity.getOrigSendEntity();
        SgSendCommonBiz.SendEntity newSendEntity = storagePreOutEntity.getNewSendEntity();
        if (origSendEntity == null) {
            List<SgStorageUpdateBillItemDto> billItemList = this.buildStorageUpdateBillEffectiveItem(newSendEntity);
            storageUpdateBillItemList.addAll(billItemList);
        } else {
            List<SgSendEffectiveItem> origSendEffectiveItemList = origSendEntity.getSendEffectiveItemList();
            List<SgSendEffectiveItem> newSendEffectiveItemList = newSendEntity.getSendEffectiveItemList();
            Map origSendEffectiveItemMap = origSendEffectiveItemList.stream().collect(Collectors.toMap(obj -> StoreUtils.getSendItemByBatchCodeMapForMapKey(obj.getPsSkuId(), obj.getSgStoreId(), obj.getPreoutBatchCode()), Function.identity()));
            Map newSendEffectiveItemMap = newSendEffectiveItemList.stream().collect(Collectors.toMap(obj -> StoreUtils.getSendItemByBatchCodeMapForMapKey(obj.getPsSkuId(), obj.getSgStoreId(), obj.getPreoutBatchCode()), Function.identity()));
            ArrayList<SgSendEffectiveItem> newOccupySendEffectiveItemList = new ArrayList<SgSendEffectiveItem>();
            for (String key : newSendEffectiveItemMap.keySet()) {
                SgSendEffectiveItem newSendEffectiveItem = (SgSendEffectiveItem)newSendEffectiveItemMap.get(key);
                SgSendEffectiveItem origSendEffectiveItem = (SgSendEffectiveItem)origSendEffectiveItemMap.get(key);
                if (origSendEffectiveItem != null) {
                    BigDecimal origQty;
                    BigDecimal newQty = newSendEffectiveItem.getQty();
                    BigDecimal diffQty = newQty.subtract(origQty = origSendEffectiveItem.getQty());
                    if (BigDecimal.ZERO.compareTo(diffQty) == 0) continue;
                    newSendEffectiveItem.setQty(diffQty);
                    newOccupySendEffectiveItemList.add(newSendEffectiveItem);
                    continue;
                }
                newOccupySendEffectiveItemList.add(newSendEffectiveItem);
            }
            SgSendCommonBiz.SendEntity newOccupySend = new SgSendCommonBiz.SendEntity();
            newOccupySend.setSend(newSendEntity.getSend());
            newOccupySend.setSendEffectiveItemList(newOccupySendEffectiveItemList);
            List<SgStorageUpdateBillItemDto> billItemList = this.buildStorageUpdateBillEffectiveItem(newOccupySend);
            storageUpdateBillItemList.addAll(billItemList);
        }
        return storageUpdateBillItemList;
    }

    private List<SgStorageUpdateBillItemDto> buildStorageUpdateBillEffectiveItem(SgSendCommonBiz.SendEntity newSendEntity) {
        SgSend newSend = newSendEntity.getSend();
        List<SgSendEffectiveItem> sendEffectiveItemList = newSendEntity.getSendEffectiveItemList();
        ArrayList<SgStorageUpdateBillItemDto> storageUpdateBillItemList = new ArrayList<SgStorageUpdateBillItemDto>();
        for (SgSendEffectiveItem newSendItem : sendEffectiveItemList) {
            SgStorageUpdateBillItemDto storageUpdateBillItem = new SgStorageUpdateBillItemDto();
            BeanUtils.copyProperties((Object)newSendItem, (Object)storageUpdateBillItem);
            this.propertyCopyByStoreEffectiveBiz.copyProperties(newSend, newSendItem, storageUpdateBillItem);
            storageUpdateBillItem.setBillItemId(newSendItem.getId());
            storageUpdateBillItem.setSourceItemId(newSendItem.getSourceBillItemId());
            storageUpdateBillItem.setQtyPreoutChange(newSendItem.getQty());
            storageUpdateBillItem.setControlmodel(new SgStorageUpdateControlDto());
            storageUpdateBillItemList.add(storageUpdateBillItem);
        }
        return storageUpdateBillItemList;
    }
}

