/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.liquibase;

import io.choerodon.liquibase.ChoerodonLiquibaseChangeLogParser;
import io.choerodon.liquibase.CusFileSystemResourceAccessor;
import io.choerodon.liquibase.addition.AdditionDataSource;
import io.choerodon.liquibase.addition.ProfileMap;
import io.choerodon.liquibase.excel.ExcelDataLoader;
import io.choerodon.liquibase.exception.LiquibaseException;
import io.choerodon.liquibase.helper.LiquibaseHelper;
import io.choerodon.liquibase.iam.PermissionLoader;
import io.choerodon.liquibase.seed.SeedDataLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.parser.ext.GroovyLiquibaseChangeLogParser;
import liquibase.resource.InputStreamList;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;

public class LiquibaseExecutor {
    private static final Logger logger = LoggerFactory.getLogger(LiquibaseExecutor.class);
    private static final String TEMP_DIR_NAME = "temp/";
    private static final String SUFFIX_XLSX = ".xlsx";
    private static final String SUFFIX_XML = ".xml";
    private static final String SUFFIX_GROOVY = ".groovy";
    private static final String FINAL_SUFFIX_GROOVY = "-final.groovy";
    private static final String SUFFIX_SQL = ".sql";
    private static final String SUFFIX_JAR = ".jar";
    private static final String PERMISSION_FILE_PATH = "CHOERODON-META/permission.json";
    private static final String BOOTSTRAP_FILE_PATH = "bootstrap.yml";
    private static final String PREFIX_SCRIPT_DB = "script/db/";
    private static final String PREFIX_DATA = "data/";
    private static final String PREFIX_SPRING_BOOT_CLASSES = "BOOT-INF/classes/";
    private static final String POM_XML = "pom.xml";
    @Value(value="${data.dir:#{null}}")
    private String defaultDir;
    @Value(value="${data.jar:#{null}}")
    private String defaultJar;
    @Value(value="${data.mode:normal}")
    private String defaultMode;
    @Value(value="${data.drop:false}")
    private boolean defaultDrop;
    @Value(value="${data.normal:true}")
    private boolean defaultNormal;
    @Value(value="${data.init:false}")
    private boolean defaultInit;
    @Value(value="${data.process.type:database}")
    private String dataProcessType;
    @Value(value="${data.update.exclusion:#{null}}")
    private String updateExclusion;
    @Value(value="${addition.datasource.names:#{null}}")
    private String additionDataSourceNameProfile;
    @Value(value="${spring.datasource.url}")
    private String dsUrl;
    @Value(value="${spring.datasource.username}")
    private String dsUserName;
    @Value(value="${spring.datasource.password}")
    private String dsPassword;
    private DataSource defaultDataSource;
    @Autowired
    private ProfileMap profileMap;

    public LiquibaseExecutor(DataSource defaultDataSource) {
        this.defaultDataSource = defaultDataSource;
    }

    public boolean execute(String ... args) {
        boolean successful = false;
        try {
            this.runToDb(this.prepareDataSources());
            logger.info("\u6570\u636e\u5e93\u521d\u59cb\u5316\u4efb\u52a1\u5b8c\u6210");
            successful = true;
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u5e93\u521d\u59cb\u5316\u4efb\u52a1\u5931\u8d25, message: {}, exception: ", (Object)e.getMessage(), (Object)e);
        }
        return successful;
    }

    private List<File> getDirRecursive(File file) {
        File[] files;
        ArrayList<File> dirList = new ArrayList<File>();
        if (file.isDirectory() && (files = file.listFiles()) != null && files.length > 0) {
            dirList.addAll(Arrays.asList(files));
            List tmpList = dirList.stream().map(this::getDirRecursive).flatMap(Collection::stream).collect(Collectors.toList());
            dirList.addAll(tmpList);
        }
        return dirList;
    }

    private String getDirInJar(List<File> fileList, String searchDir) {
        if (searchDir == null) {
            throw new IllegalArgumentException("\u5fc5\u987b\u6307\u5b9a\u8981\u8fdb\u884c\u641c\u7d22\u7684\u6839\u76ee\u5f55");
        }
        String res = null;
        for (File file : fileList) {
            String normalPath = file.getPath().replace("\\", "/");
            int index = normalPath.indexOf(searchDir);
            if (index == -1 || index + searchDir.length() != normalPath.length()) continue;
            res = normalPath;
            break;
        }
        if (res == null) {
            throw new LiquibaseException(searchDir + " not exist.");
        }
        return res;
    }

    private List<AdditionDataSource> prepareDataSources() {
        ArrayList<AdditionDataSource> additionDataSources = new ArrayList<AdditionDataSource>();
        AdditionDataSource defaultAddition = new AdditionDataSource(this.dsUrl, this.dsUserName, this.dsPassword, this.defaultDir, this.defaultDrop, this.defaultDataSource);
        defaultAddition.setJar(this.defaultJar);
        defaultAddition.setMode(this.defaultMode);
        defaultAddition.setName("default");
        additionDataSources.add(defaultAddition);
        if (this.additionDataSourceNameProfile != null) {
            String[] additionDataSourceNames;
            for (String dataSourceName : additionDataSourceNames = this.additionDataSourceNameProfile.split(",")) {
                String url = this.profileMap.getAdditionValue(dataSourceName + ".url");
                String username = this.profileMap.getAdditionValue(dataSourceName + ".username");
                String password = this.profileMap.getAdditionValue(dataSourceName + ".password");
                String dir = this.profileMap.getAdditionValue(dataSourceName + ".dir");
                String jar = this.profileMap.getAdditionValue(dataSourceName + SUFFIX_JAR);
                String mode = this.profileMap.getAdditionValue(dataSourceName + ".mode");
                boolean drop = Boolean.parseBoolean(this.profileMap.getAdditionValue(dataSourceName + ".drop"));
                Set tables = null;
                if (this.profileMap.getAdditionValue(dataSourceName + ".tables") != null) {
                    tables = Arrays.stream(this.profileMap.getAdditionValue(dataSourceName + ".tables").split(",")).collect(Collectors.toSet());
                }
                AdditionDataSource ads = new AdditionDataSource(url, username, password, dir, drop, null, tables);
                ads.setJar(jar);
                ads.setMode(mode == null ? "normal" : mode);
                ads.setName(dataSourceName);
                additionDataSources.add(ads);
            }
        }
        return additionDataSources;
    }

    private void runToDb(List<AdditionDataSource> additionDataSourceList) throws IOException, CustomChangeException, SQLException, liquibase.exception.LiquibaseException {
        for (AdditionDataSource addition : additionDataSourceList) {
            logger.info("Init data source, name : {}", (Object)addition.getName());
            String dir = addition.getDir();
            if (StringUtils.isEmpty((Object)dir)) {
                logger.info("Data source name : {} dir is empty, extra jar {}", (Object)addition.getName(), (Object)addition.getJar());
                this.extra(addition.getJar(), TEMP_DIR_NAME);
                dir = TEMP_DIR_NAME;
            }
            logger.info("Load data source, name : {}, dir : {}", (Object)addition.getName(), (Object)dir);
            this.load(dir, addition);
        }
    }

    private void prepareGroovyParser(LiquibaseHelper liquibaseHelper) {
        List<ChangeLogParser> changeLogParsers = ChangeLogParserFactory.getInstance().getParsers().stream().filter(parser -> parser instanceof GroovyLiquibaseChangeLogParser || parser instanceof ChoerodonLiquibaseChangeLogParser).collect(Collectors.toList());
        changeLogParsers.forEach(changeLogParser -> ChangeLogParserFactory.getInstance().unregister(changeLogParser));
        ChangeLogParserFactory.getInstance().register((ChangeLogParser)new ChoerodonLiquibaseChangeLogParser(liquibaseHelper));
    }

    private void extraJarStream(InputStream inputStream, String dir, boolean dep) throws IOException {
        JarEntry entry = null;
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        while ((entry = jarInputStream.getNextJarEntry()) != null) {
            String name = entry.getName();
            if ((name.endsWith(SUFFIX_GROOVY) || name.endsWith(SUFFIX_XLSX) || name.endsWith(SUFFIX_SQL)) && name.contains(PREFIX_SCRIPT_DB) || name.endsWith(SUFFIX_XML) && name.contains(PREFIX_DATA) || name.endsWith(PERMISSION_FILE_PATH) && !dep || name.endsWith(BOOTSTRAP_FILE_PATH) && !dep) {
                File file;
                if (name.startsWith(PREFIX_SPRING_BOOT_CLASSES)) {
                    name = name.substring(PREFIX_SPRING_BOOT_CLASSES.length());
                }
                if (!(file = new File(dir + name)).getParentFile().exists() && !file.getParentFile().mkdirs()) {
                    throw new IOException("create dir fail: " + file.getParentFile().getAbsolutePath());
                }
                FileOutputStream outputStream = new FileOutputStream(file);
                try {
                    StreamUtils.copy((InputStream)jarInputStream, (OutputStream)outputStream);
                    continue;
                }
                finally {
                    outputStream.close();
                    continue;
                }
            }
            if (!name.endsWith(SUFFIX_JAR)) continue;
            this.extraJarStream(jarInputStream, dir, true);
        }
    }

    private void extra(String jar, String dir) throws IOException {
        boolean isUrl = jar.startsWith("https://") || jar.startsWith("http://") || jar.startsWith("file://");
        try (InputStream inputStream = isUrl ? new URL(jar).openStream() : new FileInputStream(jar);){
            File temp = new File(dir);
            FileUtils.deleteDirectory((File)temp);
            if (!temp.mkdir()) {
                throw new IOException("create dir fail.");
            }
            this.extraJarStream(inputStream, dir, false);
        }
        logger.info("Jar extra {} done", (Object)jar);
    }

    private void load(String dir, AdditionDataSource additionDataSource) throws IOException, CustomChangeException, SQLException, liquibase.exception.LiquibaseException {
        this.prepareGroovyParser(additionDataSource.getLiquibaseHelper());
        Map<String, Set<String>> updateExclusionMap = this.processExclusion();
        CusFileSystemResourceAccessor accessor = new CusFileSystemResourceAccessor(dir);
        InputStreamList bootstrapInputStreams = accessor.openStreams(dir, BOOTSTRAP_FILE_PATH);
        String serviceCode = null;
        if (bootstrapInputStreams == null || bootstrapInputStreams.isEmpty()) {
            logger.info("Data source {} bootstrap.yml file not found.", (Object)additionDataSource.getName());
        } else {
            Yaml yaml = new Yaml();
            Map result = (Map)yaml.load((InputStream)bootstrapInputStreams.iterator().next());
            serviceCode = (String)((Map)((Map)result.get("spring")).get("application")).get("name");
            if (serviceCode == null || serviceCode.isEmpty()) {
                logger.warn("Data source {} key spring.application.name not found in bootstrap.yml.", (Object)additionDataSource.getName());
                serviceCode = null;
            }
        }
        if ("all".equals(additionDataSource.getMode()) || "normal".equals(additionDataSource.getMode())) {
            Liquibase liquibase;
            SortedSet fileNameSet = accessor.list(null, File.separator, true, false, true);
            ArrayList nameList = new ArrayList(fileNameSet);
            Collections.sort(nameList);
            JdbcConnection jdbcConnection = new JdbcConnection(additionDataSource.getDataSource().getConnection());
            if (additionDataSource.isDrop()) {
                liquibase = new Liquibase("drop", (ResourceAccessor)accessor, (DatabaseConnection)jdbcConnection);
                liquibase.dropAll();
            }
            liquibase = new Liquibase("clearCheckSums", (ResourceAccessor)accessor, (DatabaseConnection)jdbcConnection);
            liquibase.clearCheckSums();
            for (Object file : nameList) {
                if (!((String)file).endsWith(SUFFIX_GROOVY) || ((String)file).endsWith(FINAL_SUFFIX_GROOVY) || !((String)file).contains(PREFIX_SCRIPT_DB)) continue;
                liquibase = new Liquibase((String)file, (ResourceAccessor)accessor, (DatabaseConnection)jdbcConnection);
                liquibase.update(new Contexts());
            }
            if (this.defaultInit) {
                InputStreamList inputStream;
                for (Object file : nameList) {
                    if (!((String)file).endsWith(SUFFIX_XLSX) || !((String)file).contains(PREFIX_SCRIPT_DB)) continue;
                    ExcelDataLoader loader = ExcelDataLoader.DATABASE.equals(this.dataProcessType) ? new ExcelDataLoader() : new ExcelDataLoader(this.dataProcessType, this.defaultDir + (String)file);
                    inputStream = accessor.openStreams(dir, (String)file);
                    loader.setUpdateExclusionMap(updateExclusionMap);
                    logger.info("begin to process excel : {}", file);
                    loader.execute((InputStream)inputStream.iterator().next(), additionDataSource);
                }
                SeedDataLoader loader = new SeedDataLoader(serviceCode);
                for (String file : nameList) {
                    if (!file.endsWith(SUFFIX_XML) || !file.contains(PREFIX_DATA) || file.endsWith(POM_XML)) continue;
                    inputStream = accessor.openStreams(dir, file);
                    logger.info("begin to process xml : {}", (Object)file);
                    loader.execute((InputStream)inputStream.iterator().next(), additionDataSource);
                }
            }
            for (Object file : nameList) {
                if (!((String)file).endsWith(FINAL_SUFFIX_GROOVY) || !((String)file).contains(PREFIX_SCRIPT_DB)) continue;
                liquibase = new Liquibase((String)file, (ResourceAccessor)accessor, (DatabaseConnection)jdbcConnection);
                liquibase.update(new Contexts());
            }
        }
        if ("all".equals(additionDataSource.getMode()) || "iam".equals(additionDataSource.getMode())) {
            InputStreamList permissionInputStreams = accessor.openStreams(dir, PERMISSION_FILE_PATH);
            if (permissionInputStreams == null || permissionInputStreams.isEmpty()) {
                logger.warn("Data source {} is iam mode but permission file not found.", (Object)additionDataSource.getName());
            } else {
                InputStream permissionInputStream = (InputStream)permissionInputStreams.iterator().next();
                PermissionLoader permissionLoader = new PermissionLoader(new LiquibaseHelper(this.dsUrl));
                permissionLoader.setServiceCode(serviceCode);
                try (Connection connection = additionDataSource.getDataSource().getConnection();){
                    connection.setAutoCommit(false);
                    try {
                        permissionLoader.execute(permissionInputStream, connection);
                        connection.commit();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        connection.rollback();
                    }
                }
            }
        }
    }

    private Map<String, Set<String>> processExclusion() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        if (this.updateExclusion != null) {
            String[] array;
            for (String str : array = this.updateExclusion.split(",")) {
                if (str != null && str.contains(".")) {
                    String[] strArray = str.split("\\.");
                    String tableName = strArray[0] == null ? null : strArray[0].toLowerCase();
                    String columnName = strArray[1] == null ? null : strArray[1].toLowerCase();
                    Set columns = (Set)map.get(tableName);
                    if (columns == null) {
                        HashSet<String> set = new HashSet<String>();
                        set.add(columnName);
                        map.put(tableName, set);
                        continue;
                    }
                    columns.add(columnName);
                    continue;
                }
                if (map.get(str) != null) continue;
                map.put(str, null);
            }
        }
        return map;
    }
}

