/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.liquibase.addition;

import io.choerodon.liquibase.helper.LiquibaseHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class AdditionDataSource {
    private String name;
    private String url;
    private String username;
    private String password;
    private String dir;
    private String jar;
    private String mode;
    private boolean drop;
    private DataSource dataSource;
    private LiquibaseHelper liquibaseHelper;
    private Set<String> tables;
    private static Map<String, AdditionDataSource> tablesMap = new HashMap<String, AdditionDataSource>();

    public AdditionDataSource() {
    }

    public AdditionDataSource(String url, String username, String password, String dir, boolean drop) {
        this(url, username, password, dir, drop, null);
    }

    public AdditionDataSource(String url, String username, String password, String dir, boolean drop, DataSource dataSource) {
        this(url, username, password, dir, drop, dataSource, null);
    }

    public AdditionDataSource(String url, String username, String password, String dir, boolean drop, DataSource dataSource, Set<String> tables) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.dir = dir;
        this.drop = drop;
        this.dataSource = dataSource;
        this.liquibaseHelper = new LiquibaseHelper(this.url);
        this.tables = tables;
        if (tables != null) {
            tables.forEach(t -> tablesMap.put((String)t, this));
        }
    }

    public String getJar() {
        return this.jar;
    }

    public void setJar(String jar) {
        this.jar = jar;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static Map<String, AdditionDataSource> getTablesMap() {
        return tablesMap;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public boolean isDrop() {
        return this.drop;
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public DataSource getDataSource() {
        if (this.dataSource == null) {
            this.dataSource = new DriverManagerDataSource(this.url, this.username, this.password);
        }
        return this.dataSource;
    }

    public Set<String> getTables() {
        return this.tables;
    }

    public void setTables(Set<String> tables) {
        this.tables = tables;
    }

    public LiquibaseHelper getLiquibaseHelper() {
        return this.liquibaseHelper;
    }
}

