/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.liquibase.addition;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class ProfileMap {
    private static final Logger logger = LoggerFactory.getLogger(ProfileMap.class);
    private Environment env;

    @Autowired
    public void setEnvironment(Environment env) {
        this.env = env;
    }

    public String getValue(String key) {
        try {
            return this.env.getProperty(key);
        }
        catch (Exception e) {
            logger.warn("can not get value of key: {} from environment, return false", (Object)key);
            return "false";
        }
    }

    public String getAdditionValue(String key) {
        return this.getValue("addition.datasource." + key);
    }

    public String getSpringValue(String key) {
        return this.getValue("spring.datasource." + key);
    }

    public String getDataValue(String key) {
        return this.getValue("data." + key);
    }
}

