/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.liquibase.excel;

import io.choerodon.liquibase.addition.AdditionDataSource;
import io.choerodon.liquibase.excel.ExcelDataLoader;
import io.choerodon.liquibase.excel.TableData;
import io.choerodon.liquibase.exception.LiquibaseException;
import io.choerodon.liquibase.helper.LiquibaseHelper;
import io.choerodon.liquibase.utils.CellDataConverter;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import liquibase.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbAdaptor {
    static final Map<String, Integer> SQL_TYPE_MAP = new HashMap<String, Integer>();
    public static final String ZH_CN = "zh_CN";
    public static final String SQL_UPDATE = "update ";
    public static final String SQL_WHERE = " where  ";
    public static final String SQL_SET = " set ";
    Map<String, String> tableInsertSqlMap = new HashMap<String, String>();
    Map<String, String> tableUpdateSqlMap = new HashMap<String, String>();
    Map<String, String> tableUpdateTlSqlMap = new HashMap<String, String>();
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private DataSource dataSource;
    private Connection connection;
    private Map<String, Connection> connectionMap = new HashMap<String, Connection>();
    protected ExcelDataLoader dataProcessor;
    private boolean useSeq = false;
    private boolean override = true;
    private LiquibaseHelper helper;

    public DbAdaptor(ExcelDataLoader dataProcessor, AdditionDataSource ad) {
        this.dataProcessor = dataProcessor;
        this.helper = ad.getLiquibaseHelper();
        this.useSeq = this.helper.isSupportSequence();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public void initConnection() throws SQLException {
        this.connection = this.dataSource.getConnection();
        this.connection.setAutoCommit(false);
        for (String table : AdditionDataSource.getTablesMap().keySet()) {
            Connection conn = AdditionDataSource.getTablesMap().get(table).getDataSource().getConnection();
            conn.setAutoCommit(false);
            this.connectionMap.put(table, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(boolean commit) {
        if (this.connection != null) {
            try (Connection c = this.connection;){
                if (commit) {
                    c.commit();
                } else {
                    c.rollback();
                }
            }
            catch (SQLException e) {
                this.logger.error("commit or rollback exception: {}", (Throwable)e);
            }
            finally {
                try {
                    this.connection.close();
                }
                catch (SQLException e) {
                    this.logger.error("close connect exception: {}", (Throwable)e);
                }
            }
        }
        for (Connection connection : this.connectionMap.values()) {
            if (connection == null) continue;
            try {
                Connection c = connection;
                try {
                    if (commit) {
                        c.commit();
                        continue;
                    }
                    c.rollback();
                }
                finally {
                    if (c == null) continue;
                    c.close();
                }
            }
            catch (SQLException e) {
                this.logger.error("commit or rollback exception: {}", (Throwable)e);
            }
            finally {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    this.logger.error("close connect exception: {}", (Throwable)e);
                }
            }
        }
    }

    protected Connection getConnection() {
        return this.connection;
    }

    public int processTableRow(TableData.TableRow tableRow) throws SQLException {
        Long cu;
        if (tableRow.isProcessFlag()) {
            return 0;
        }
        if (tableRow.isDeleteFlag()) {
            tableRow.setProcessFlag(true);
        }
        if ((cu = this.checkExists(tableRow)) == null && tableRow.canInsert() && !tableRow.isDeleteFlag()) {
            if (this.doInsert(tableRow) > 0L) {
                this.doInsertTl(tableRow);
            }
            return 1;
        }
        if (cu != null && cu >= 0L) {
            tableRow.setProcessFlag(true);
            if (tableRow.isDeleteFlag()) {
                this.doDelete(tableRow);
                this.doDeleteTL(tableRow);
            } else {
                this.doInsertTl(tableRow);
            }
            return 1;
        }
        return 0;
    }

    protected int doDelete(TableData.TableRow tableRow) throws SQLException {
        TableData.TableCellValue genTableCellValue = null;
        for (TableData.TableCellValue tableCellValue : tableRow.getTableCellValues()) {
            if (!tableCellValue.getColumn().isGen() && !tableCellValue.getColumn().isUnique()) continue;
            genTableCellValue = tableCellValue;
            break;
        }
        if (genTableCellValue == null) {
            return 0;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ");
        sql.append(tableRow.getTable().getName());
        sql.append(" WHERE ");
        sql.append(genTableCellValue.getColumn().getName());
        sql.append("=?");
        try (PreparedStatement statement = this.connection.prepareStatement(sql.toString());){
            this.setParam(statement, genTableCellValue, 1);
            int n = statement.executeUpdate();
            return n;
        }
    }

    protected int doDeleteTL(TableData.TableRow tableRow) throws SQLException {
        if (tableRow.getTable().getLangs().isEmpty()) {
            return 0;
        }
        TableData.TableCellValue genTableCellValue = null;
        for (TableData.TableCellValue tableCellValue : tableRow.getTableCellValues()) {
            if (!tableCellValue.getColumn().isGen() && !tableCellValue.getColumn().isUnique()) continue;
            genTableCellValue = tableCellValue;
            break;
        }
        if (genTableCellValue == null) {
            return 0;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ");
        sql.append(this.tlTableName(tableRow.getTable().getName()));
        sql.append(" WHERE ");
        sql.append(genTableCellValue.getColumn().getName());
        sql.append("=?");
        try (PreparedStatement statement = this.connection.prepareStatement(sql.toString());){
            this.setParam(statement, genTableCellValue, 1);
            int n = statement.executeUpdate();
            return n;
        }
    }

    /*
     * Loose catch block
     */
    protected Long checkExists(TableData.TableRow tableRow) throws SQLException {
        boolean uniquePresent = true;
        TableData.TableCellValue genTableCellValue = null;
        for (TableData.TableCellValue tableCellValue : tableRow.getTableCellValues()) {
            if (tableCellValue.getColumn().isGen()) {
                genTableCellValue = tableCellValue;
            }
            if (tableCellValue.isFormula() && !tableCellValue.isValuePresent()) {
                this.dataProcessor.tryUpdateCell(tableCellValue);
            }
            if (!tableCellValue.getColumn().isUnique()) continue;
            uniquePresent = uniquePresent && tableCellValue.isValuePresent();
        }
        if (!uniquePresent) {
            this.logger.info("[{}] check exists: ?? row:{} ,result :(-1)not ready", (Object)tableRow.getTable().getName(), (Object)tableRow);
            return -1L;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select ").append(genTableCellValue == null ? "0" : genTableCellValue.getColumn().getName()).append(" from ").append(tableRow.getTable().getName());
        sb.append(" where ");
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        ArrayList<TableData.TableCellValue> params = new ArrayList<TableData.TableCellValue>();
        for (TableData.TableCellValue tableCellValue : tableRow.getTableCellValues()) {
            if (!tableCellValue.getColumn().isUnique()) continue;
            String value = tableCellValue.getValue();
            String tableName = tableCellValue.getColumn().getName();
            if (StringUtil.isEmpty((String)value)) {
                list.add((CallSite)((Object)((String)tableName + " IS NULL")));
                continue;
            }
            list.add((CallSite)((Object)((String)tableName + " = ?")));
            params.add(tableCellValue);
        }
        sb.append(StringUtil.join(list, (String)" AND "));
        Connection connection = this.connection;
        this.logger.warn("connection map : {}", this.connectionMap);
        if (this.connectionMap.containsKey(tableRow.getTable().getName())) {
            connection = this.connectionMap.get(tableRow.getTable().getName());
        }
        try (PreparedStatement ps = connection.prepareStatement(sb.toString());){
            Long l;
            block29: {
                ResultSet rs;
                block27: {
                    TableData.TableCellValue tableCellValue2222;
                    block28: {
                        int index = 1;
                        for (TableData.TableCellValue tableCellValue2222 : params) {
                            this.setParam(ps, tableCellValue2222, index++);
                        }
                        rs = ps.executeQuery();
                        if (rs != null && rs.next()) break block27;
                        this.logger.info("[{}] check exists: <> row:{} ,result :not exists", (Object)tableRow.getTable().getName(), (Object)tableRow);
                        tableCellValue2222 = null;
                        if (rs == null) break block28;
                        rs.close();
                    }
                    return tableCellValue2222;
                }
                Long pk = rs.getLong(1);
                if (rs.next()) {
                    throw new LiquibaseException("check unique found more than one, row:" + tableRow);
                }
                this.logger.info("[{}] check exists: == row:{} ,result :{}", new Object[]{tableRow.getTable().getName(), tableRow, pk});
                if (genTableCellValue != null) {
                    genTableCellValue.updateValue("" + pk);
                }
                tableRow.setExistsFlag(true);
                l = pk;
                if (rs == null) break block29;
                {
                    catch (Throwable throwable) {
                        try {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            this.logger.error("[{}]error check unique, row:{}, sql:{}", new Object[]{tableRow.getTable().getName(), tableRow, sb});
                            throw e;
                        }
                    }
                }
                rs.close();
            }
            return l;
        }
    }

    protected int doUpdate(TableData.TableRow tableRow, Set<String> excludedColumns, Set<String> logInfo) throws SQLException {
        int updateCount = 0;
        TableData.TableCellValue genTableCellValue = null;
        ArrayList<TableData.TableCellValue> uniques = new ArrayList<TableData.TableCellValue>();
        ArrayList<TableData.TableCellValue> normals = new ArrayList<TableData.TableCellValue>();
        for (TableData.TableCellValue tableCellValue : tableRow.getTableCellValues()) {
            if (tableCellValue.getColumn().isDeleteFlag()) continue;
            if (tableCellValue.isFormula() && !tableCellValue.isValuePresent()) {
                this.dataProcessor.tryUpdateCell(tableCellValue);
            }
            if (tableCellValue.getColumn().isGen()) {
                genTableCellValue = tableCellValue;
                continue;
            }
            if (tableCellValue.getColumn().isUnique()) {
                if (tableCellValue.getColumn().isOnlyInsert() || this.excluded(tableCellValue.getColumn().getName(), excludedColumns)) {
                    logInfo.add(this.processLog(tableRow, tableCellValue));
                    continue;
                }
                uniques.add(tableCellValue);
                continue;
            }
            if (tableCellValue.getColumn().isOnlyInsert() || this.excluded(tableCellValue.getColumn().getName(), excludedColumns)) {
                logInfo.add(this.processLog(tableRow, tableCellValue));
                continue;
            }
            normals.add(tableCellValue);
        }
        if (genTableCellValue != null) {
            uniques.clear();
            uniques.add(genTableCellValue);
        }
        if (normals.isEmpty()) {
            return updateCount;
        }
        String sql = this.prepareTableUpdateSql(tableRow, uniques, normals);
        Connection connection = this.connection;
        if (this.connectionMap.containsKey(tableRow.getTable().getName())) {
            connection = this.connectionMap.get(tableRow.getTable().getName());
        }
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            int index = 1;
            for (TableData.TableCellValue tableCellValue : normals) {
                if (tableCellValue.getColumn().getLang() != null && !ZH_CN.equalsIgnoreCase(tableCellValue.getColumn().getLang())) continue;
                this.setParam(ps, tableCellValue, index++);
            }
            for (TableData.TableCellValue tableCellValue : uniques) {
                this.setParam(ps, tableCellValue, index++);
            }
            updateCount += ps.executeUpdate();
            tableRow.setUpdateFlag(true);
        }
        catch (SQLException e) {
            this.logger.error("[{}]update error, row:{} ,sql:{}", new Object[]{tableRow.getTable().getName(), tableRow, sql});
            throw e;
        }
        if (genTableCellValue == null || tableRow.getTable().getLangs().isEmpty()) {
            return updateCount;
        }
        sql = this.prepareTableUpdateTlSql(tableRow, genTableCellValue, normals);
        for (String lang : tableRow.getTable().getLangs()) {
            try {
                PreparedStatement ps = connection.prepareStatement(sql);
                try {
                    int index = 1;
                    for (TableData.TableCellValue tableCellValue : normals) {
                        if (!lang.equals(tableCellValue.getColumn().getLang())) continue;
                        this.setParam(ps, tableCellValue, index++);
                    }
                    this.setParam(ps, genTableCellValue, index++);
                    ps.setString(index, lang);
                    updateCount += ps.executeUpdate();
                }
                finally {
                    if (ps == null) continue;
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.logger.error("[{}]error update tl ,row:{},sql:{}", new Object[]{tableRow.getTable().getName(), tableRow, sql});
                throw e;
            }
        }
        return updateCount;
    }

    protected String processLog(TableData.TableRow tableRow, TableData.TableCellValue tableCellValue) {
        StringBuilder sb = new StringBuilder();
        sb.append("skip update table : ");
        sb.append(tableRow.getTable().getName());
        sb.append(" column: ");
        sb.append(tableCellValue.getColumn().getName());
        return sb.toString();
    }

    protected boolean excluded(String column, Set<String> excludedColumns) {
        if (excludedColumns != null) {
            for (String excludedColumn : excludedColumns) {
                if (excludedColumn == null || !excludedColumn.equalsIgnoreCase(column)) continue;
                return true;
            }
        }
        return false;
    }

    protected String prepareTableUpdateSql(TableData.TableRow tableRow, List<TableData.TableCellValue> uniques, List<TableData.TableCellValue> normals) {
        String sql = this.tableUpdateSqlMap.get(tableRow.getTable().getName());
        if (sql == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(SQL_UPDATE).append(tableRow.getTable().getName()).append(SQL_SET);
            for (TableData.TableCellValue tableCellValue : normals) {
                if (tableCellValue.getColumn().getLang() != null && !ZH_CN.equalsIgnoreCase(tableCellValue.getColumn().getLang())) continue;
                sb.append(tableCellValue.getColumn().getName());
                sb.append("=?,");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(SQL_WHERE);
            for (TableData.TableCellValue tableCellValue : uniques) {
                sb.append(tableCellValue.getColumn().getName());
                sb.append("=? AND ");
            }
            sb.delete(sb.length() - 4, sb.length());
            sql = sb.toString();
            this.tableUpdateSqlMap.put(tableRow.getTable().getName(), sql);
        }
        return sql;
    }

    private String prepareTableUpdateTlSql(TableData.TableRow tableRow, TableData.TableCellValue genTableCellValue, List<TableData.TableCellValue> normals) {
        String sql = this.tableUpdateTlSqlMap.get(tableRow.getTable().getName());
        if (sql == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(SQL_UPDATE).append(this.tlTableName(tableRow.getTable().getName())).append(SQL_SET);
            for (TableData.TableCellValue tableCellValue : normals) {
                if (!ZH_CN.equalsIgnoreCase(tableCellValue.getColumn().getLang())) continue;
                sb.append(tableCellValue.getColumn().getName()).append("=?,");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(SQL_WHERE).append(genTableCellValue.getColumn().getName()).append("=? and lang=?");
            sql = sb.toString();
            this.tableUpdateTlSqlMap.put(tableRow.getTable().getName(), sql);
        }
        return sql;
    }

    protected Long doInsert(TableData.TableRow tableRow) throws SQLException {
        TableData.TableCellValue genTableCellValue;
        long genVal;
        block25: {
            String sql = this.prepareInsertSql(tableRow);
            if (sql == null) {
                tableRow.setProcessFlag(true);
                return 1L;
            }
            genVal = 0L;
            genTableCellValue = null;
            boolean isGeneratedColumnInserted = tableRow.isGeneratedColumnInserted();
            TableData table = tableRow.getTable();
            String tableName = table.getName();
            long maxId = table.getMaxId();
            Connection connection = this.connection;
            if (this.connectionMap.containsKey(tableRow.getTable().getName())) {
                connection = this.connectionMap.get(tableRow.getTable().getName());
            }
            try (PreparedStatement ps = connection.prepareStatement(sql, 1);){
                int count = 1;
                for (TableData.TableCellValue tableCellValue : tableRow.getTableCellValues()) {
                    if (tableCellValue.getColumn().isGen()) {
                        genTableCellValue = tableCellValue;
                        if (isGeneratedColumnInserted) {
                            genVal = Long.valueOf(genTableCellValue.getValue());
                            ps.setLong(count++, genVal);
                            table.setMaxId(genVal > maxId ? genVal : maxId);
                            continue;
                        }
                        if (!this.sequencePk()) continue;
                        genVal = this.getSeqNextVal(tableName);
                        if (genVal < maxId) {
                            long step = maxId - genVal;
                            this.updateSequence(tableName, step);
                            genVal = this.getSeqNextVal(tableName);
                        }
                        if (genVal == maxId) {
                            genVal = this.getSeqNextVal(tableName);
                        }
                        ps.setLong(count++, genVal);
                        continue;
                    }
                    if (tableCellValue.getColumn().getLang() != null && !ZH_CN.equals(tableCellValue.getColumn().getLang()) || tableCellValue.getColumn().isDeleteFlag()) continue;
                    if (!tableCellValue.isValuePresent() && tableCellValue.isFormula()) {
                        ps.setLong(count++, -1L);
                        continue;
                    }
                    this.setParam(ps, tableCellValue, count++);
                }
                try {
                    ps.executeUpdate();
                    tableRow.setInsertFlag(true);
                }
                catch (SQLException sqle) {
                    this.logger.error("[{}]error insert row:{}  sql:{}", new Object[]{tableName, tableRow, sql});
                    throw sqle;
                }
                this.logger.info("insert row:{}", (Object)tableRow);
                tableRow.getTable().setInsert(tableRow.getTable().getInsert() + 1);
                if (this.sequencePk() || genTableCellValue == null) break block25;
                try (ResultSet rs = ps.getGeneratedKeys();){
                    if (rs != null && rs.next()) {
                        genVal = rs.getLong(1);
                    } else {
                        this.logger.warn("no gen pk,row:{}", (Object)tableRow);
                    }
                }
            }
        }
        if (genTableCellValue != null) {
            genTableCellValue.updateValue(String.valueOf(genVal));
        }
        tableRow.setProcessFlag(true);
        return genVal;
    }

    private List<TableData.TableCellValue> getUnpresentFormulaTds(TableData.TableRow tableRow) {
        ArrayList<TableData.TableCellValue> formulaTableCellValues = new ArrayList<TableData.TableCellValue>();
        for (TableData.TableCellValue tableCellValue : tableRow.getTableCellValues()) {
            if (!tableCellValue.isFormula() || tableCellValue.isValuePresent()) continue;
            formulaTableCellValues.add(tableCellValue);
        }
        return formulaTableCellValues;
    }

    public int weakInsert(List<TableData> tables) throws SQLException {
        ArrayList<TableData.TableRow> tempList = new ArrayList<TableData.TableRow>();
        for (TableData tableData : tables) {
            for (TableData.TableRow tableRow : tableData.getTableRows()) {
                if (tableRow.isProcessFlag()) continue;
                Long cu = this.checkExists(tableRow);
                if (cu == null) {
                    this.doInsert(tableRow);
                    tableRow.setProcessFlag(false);
                    this.logger.info("weak insert row:{}", (Object)tableRow);
                    this.doInsertTl(tableRow);
                    tempList.add(tableRow);
                    continue;
                }
                if (cu <= 0L) continue;
                this.doInsertTl(tableRow);
                tempList.add(tableRow);
            }
        }
        int count = 0;
        do {
            count = 0;
            for (TableData.TableRow tableRow : tempList) {
                if (tableRow.isProcessFlag()) continue;
                List<TableData.TableCellValue> formulaTableCellValues = this.getUnpresentFormulaTds(tableRow);
                int cc = 0;
                for (TableData.TableCellValue tableCellValue : formulaTableCellValues) {
                    if (!this.dataProcessor.tryUpdateCell(tableCellValue)) continue;
                    ++cc;
                    this.doPostUpdate(tableRow, tableCellValue, Long.parseLong(tableCellValue.getValue()));
                    ++count;
                }
                if (cc != formulaTableCellValues.size()) continue;
                tableRow.setProcessFlag(true);
                tableRow.setInsertFlag(true);
            }
        } while (count > 0);
        for (TableData.TableRow tableRow : tempList) {
            if (tableRow.isProcessFlag()) continue;
            throw new LiquibaseException("can not insert :" + tableRow);
        }
        return tempList.size();
    }

    protected void doPostUpdate(TableData.TableRow tableRow, TableData.TableCellValue tableCellValue, Long value) throws SQLException {
        TableData.TableCellValue genTableCellValue = null;
        for (TableData.TableCellValue d : tableRow.getTableCellValues()) {
            if (!d.getColumn().isGen()) continue;
            genTableCellValue = d;
            break;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(SQL_UPDATE).append(tableRow.getTable().getName()).append(SQL_SET).append(tableCellValue.getColumn().getName()).append("=? where ");
        if (genTableCellValue != null) {
            sb.append(genTableCellValue.getColumn().getName()).append("=?");
        }
        Connection connection = this.connection;
        if (this.connectionMap.containsKey(tableRow.getTable().getName())) {
            connection = this.connectionMap.get(tableRow.getTable().getName());
        }
        try (PreparedStatement ps = connection.prepareStatement(sb.toString());){
            ps.setLong(1, value);
            if (genTableCellValue != null) {
                this.setParam(ps, genTableCellValue, 2);
            }
            ps.executeUpdate();
            this.logger.debug("update getColumn():{} value:{}  row:{}", new Object[]{tableCellValue.getColumn().getName(), value, tableRow});
        }
        catch (SQLException ee) {
            this.logger.error("[{}]error post update getColumn():{},row:{} ,sql:{}", new Object[]{tableRow.getTable().getName(), tableCellValue.getColumn().getName(), tableRow, sb});
            throw ee;
        }
    }

    private void setParam(PreparedStatement ps, TableData.TableCellValue tableCellValue, int nn) throws SQLException {
        String type;
        String value = tableCellValue.getValue();
        Object object = CellDataConverter.covert(value, type = tableCellValue.getColumn().getType());
        if (object == null) {
            ps.setNull(nn, SQL_TYPE_MAP.get(tableCellValue.getColumn().getType()));
        } else if (object instanceof String) {
            ps.setString(nn, (String)object);
        } else if (object instanceof Long) {
            ps.setLong(nn, (Long)object);
        } else if (object instanceof java.util.Date) {
            ps.setDate(nn, new Date(((java.util.Date)object).getTime()));
        } else if (object instanceof LocalDate) {
            ps.setDate(nn, Date.valueOf((LocalDate)object));
        } else if (object instanceof LocalDateTime) {
            ps.setDate(nn, Date.valueOf(((LocalDateTime)object).toLocalDate()));
        } else if (object instanceof Double) {
            ps.setDouble(nn, (Double)object);
        } else {
            ps.setObject(nn, object);
        }
    }

    protected boolean checkTlExists(TableData.TableRow tableRow, String lang) throws SQLException {
        StringBuilder sb = new StringBuilder();
        TableData.TableCellValue genTableCellValue = null;
        for (TableData.TableCellValue tableCellValue : tableRow.getTableCellValues()) {
            if (!tableCellValue.getColumn().isGen() && !tableCellValue.getColumn().isUnique()) continue;
            genTableCellValue = tableCellValue;
            break;
        }
        if (genTableCellValue == null) {
            return true;
        }
        sb.append("select 1 from ").append(this.tlTableName(tableRow.getTable().getName()));
        sb.append(" where ").append(genTableCellValue.getColumn().getName()).append("=?");
        sb.append(" AND LANG=?");
        String sql = sb.toString();
        Connection connection = this.connection;
        if (this.connectionMap.containsKey(tableRow.getTable().getName())) {
            connection = this.connectionMap.get(tableRow.getTable().getName());
        }
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            boolean bl;
            block18: {
                ps.setObject(1, genTableCellValue.getValue());
                ps.setObject(2, lang);
                ResultSet rs = ps.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        this.logger.error("[{}]error check tl exists, row:{} ,sql:{}", new Object[]{tableRow.getTable().getName(), tableRow, sql});
                        throw e;
                    }
                }
                rs.close();
            }
            return bl;
        }
    }

    private String tlTableName(String tableName) {
        String s = tableName.replaceAll("_", "");
        boolean allIsUpperCase = true;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isLowerCase(c)) continue;
            allIsUpperCase = false;
            break;
        }
        if (allIsUpperCase) {
            if (tableName.endsWith("_B")) {
                tableName = tableName.substring(0, tableName.length() - 2);
            }
            return tableName + "_TL";
        }
        if (tableName.endsWith("_b")) {
            tableName = tableName.substring(0, tableName.length() - 2);
        }
        return tableName + "_tl";
    }

    protected int doInsertTl(TableData.TableRow tableRow) throws SQLException {
        int cc = 0;
        for (String lang : tableRow.getTable().getLangs()) {
            cc += this.doInsertTl(tableRow, lang);
        }
        return cc;
    }

    protected int doInsertTl(TableData.TableRow tableRow, String lang) throws SQLException {
        if (this.checkTlExists(tableRow, lang)) {
            return 0;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(this.tlTableName(tableRow.getTable().getName())).append("(");
        LinkedList<String> keys = new LinkedList<String>();
        LinkedList<TableData.TableCellValue> values = new LinkedList<TableData.TableCellValue>();
        TableData.TableCellValue unique = null;
        boolean isGen = false;
        for (TableData.TableCellValue tableCellValue : tableRow.getTableCellValues()) {
            if (tableCellValue.getColumn().isUnique()) {
                unique = tableCellValue;
            }
            if (tableCellValue.getColumn().isGen()) {
                isGen = true;
                keys.add(tableCellValue.getColumn().getName());
                values.add(tableCellValue);
                continue;
            }
            if (!lang.equals(tableCellValue.getColumn().getLang())) continue;
            keys.add(tableCellValue.getColumn().getName());
            values.add(tableCellValue);
        }
        if (!isGen && unique != null) {
            keys.add(unique.getColumn().getName());
            values.add(unique);
        }
        keys.add("lang");
        sb.append(StringUtil.join(keys, (String)","));
        sb.append(")VALUES(");
        for (int i = 0; i < values.size(); ++i) {
            sb.append("?").append(",");
        }
        sb.append("?)");
        String sql = sb.toString();
        Connection connection = this.connection;
        if (this.connectionMap.containsKey(tableRow.getTable().getName())) {
            connection = this.connectionMap.get(tableRow.getTable().getName());
        }
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            int nn = 1;
            for (TableData.TableCellValue tableCellValue : values) {
                this.setParam(ps, tableCellValue, nn++);
            }
            ps.setString(nn, lang);
            try {
                ps.executeUpdate();
            }
            catch (SQLException sqle) {
                this.logger.error("[{}]error insert tl row:{}  sql:{}", new Object[]{tableRow.getTable().getName(), tableRow, sql});
                throw sqle;
            }
        }
        this.logger.info("insert tl for row : {}  lang:{}", (Object)tableRow, (Object)lang);
        return 1;
    }

    protected String prepareInsertSql(TableData.TableRow tableRow) {
        boolean isGeneratedColumnInserted = tableRow.isGeneratedColumnInserted();
        String tableName = tableRow.getTable().getName();
        String sqlKey = tableName + "#" + isGeneratedColumnInserted;
        String sql = this.tableInsertSqlMap.get(sqlKey);
        if (sql == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO ").append(tableName).append("(");
            int count = 0;
            for (TableData.TableCellValue tableCellValue : tableRow.getTableCellValues()) {
                boolean isGen;
                if (tableCellValue.getColumn().isDeleteFlag() || (isGen = tableCellValue.getColumn().isGen()) && !isGeneratedColumnInserted && !this.sequencePk() || tableCellValue.getColumn().getLang() != null && !ZH_CN.equals(tableCellValue.getColumn().getLang())) continue;
                ++count;
                sb.append(tableCellValue.getColumn().getName());
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(") VALUES (");
            for (int i = 0; i < count; ++i) {
                sb.append("?,");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
            sql = sb.toString();
            if (this.helper.isSqlServer() && isGeneratedColumnInserted) {
                StringBuilder builder = new StringBuilder();
                builder.append("set IDENTITY_INSERT ").append(tableName).append(" ").append("on;");
                builder.append(sql).append(";");
                builder.append("set IDENTITY_INSERT ").append(tableName).append(" ").append("off");
                sql = builder.toString();
            }
            this.tableInsertSqlMap.put(sqlKey, sql);
        }
        return sql;
    }

    protected Long getSeqNextVal(String tableName) throws SQLException {
        StringBuilder builder = new StringBuilder();
        builder.append("select ").append(tableName).append("_s.nextval from dual");
        Connection connection = this.connection;
        if (this.connectionMap.containsKey(tableName)) {
            connection = this.connectionMap.get(tableName);
        }
        try (PreparedStatement ps = connection.prepareStatement(builder.toString());){
            Long l;
            block15: {
                ResultSet rs = ps.executeQuery();
                try {
                    rs.next();
                    l = rs.getLong(1);
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        this.logger.error("error get sequence nextVal, tableName:{}", (Object)tableName);
                        throw e;
                    }
                }
                rs.close();
            }
            return l;
        }
    }

    private void updateSequence(String tableName, long step) throws SQLException {
        long defaultStep = 1L;
        StringBuilder builder = new StringBuilder();
        String alterSql = builder.append("alter sequence ").append(tableName).append("_s increment by ").toString();
        String sql = alterSql + step;
        this.execUpdateSequence(sql, tableName);
        this.getSeqNextVal(tableName);
        sql = alterSql + defaultStep;
        this.execUpdateSequence(sql, tableName);
    }

    private void execUpdateSequence(String sql, String table) throws SQLException {
        try (Statement statement = null;){
            Connection connection = this.connection;
            if (this.connectionMap.containsKey(table)) {
                connection = this.connectionMap.get(table);
            }
            statement = connection.prepareStatement(sql);
            statement.executeUpdate();
        }
    }

    protected boolean sequencePk() {
        return this.useSeq;
    }

    static {
        SQL_TYPE_MAP.put("VARCHAR", 12);
        SQL_TYPE_MAP.put("DATE", 91);
        SQL_TYPE_MAP.put("CLOB", 2005);
        SQL_TYPE_MAP.put("BLOB", 2004);
        SQL_TYPE_MAP.put("DECIMAL", 3);
        SQL_TYPE_MAP.put("BIGINT", -5);
        SQL_TYPE_MAP.put("INT", -5);
    }
}

