/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.liquibase.excel;

import io.choerodon.liquibase.addition.AdditionDataSource;
import io.choerodon.liquibase.excel.DbAdaptor;
import io.choerodon.liquibase.excel.ExcelSeedDataReader;
import io.choerodon.liquibase.excel.TableData;
import io.choerodon.liquibase.excel.XmlFileAdaptor;
import io.choerodon.liquibase.exception.LiquibaseException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.exception.CustomChangeException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelDataLoader {
    List<TableData> tables = null;
    DbAdaptor dbAdaptor;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String filePath;
    private Map<String, Set<String>> updateExclusionMap = new HashMap<String, Set<String>>();
    private String dataProcessType = "database";
    private String dataProcessXmlFile;
    public static String XML = "xml";
    public static String DATABASE = "database";

    public ExcelDataLoader() {
    }

    public ExcelDataLoader(String dataProcessType, String dataProcessXmlFile) {
        this.dataProcessType = dataProcessType;
        this.dataProcessXmlFile = dataProcessXmlFile;
    }

    static int toColIndex(String str) {
        int value = 0;
        int pp = 1;
        for (int i = str.length() - 1; i >= 0; --i) {
            char cc = str.charAt(i);
            value += (cc - 65 + 1) * pp;
            pp *= 26;
        }
        return value;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public Map<String, Set<String>> getUpdateExclusionMap() {
        return this.updateExclusionMap;
    }

    public void setUpdateExclusionMap(Map<String, Set<String>> updateExclusionMap) {
        this.updateExclusionMap = updateExclusionMap;
    }

    public void processData() {
        try {
            this.dbAdaptor.initConnection();
        }
        catch (SQLException e) {
            throw new LiquibaseException(e);
        }
        long begin = System.currentTimeMillis();
        try {
            this.processTableCopy();
            if (this.dbAdaptor.isOverride()) {
                this.processUpdate();
            }
            this.logger.info("SUCCESS");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new LiquibaseException(e);
        }
        finally {
            this.logger.info("data process finish, time: {} ms", (Object)(System.currentTimeMillis() - begin));
        }
    }

    private void processTableCopy() throws SQLException {
        block2: {
            int roundProcessCount;
            ArrayList<TableData> tablesCopy = new ArrayList<TableData>(this.tables);
            int round = 0;
            do {
                this.logger.info("---- begin round {} ----", (Object)(++round));
                long begin = System.currentTimeMillis();
                roundProcessCount = 0;
                for (TableData tableData : tablesCopy) {
                    roundProcessCount += this.processTable(tableData);
                }
                this.logger.info("---- round {} summary ----", (Object)round);
                this.roundSummary(tablesCopy);
                this.logger.info("---- total process {},time:{}ms ----", (Object)roundProcessCount, (Object)(System.currentTimeMillis() - begin));
                if (tablesCopy.isEmpty()) break block2;
            } while (roundProcessCount != 0 || this.dbAdaptor.weakInsert(tablesCopy) != 0);
            throw new LiquibaseException(this.errorLog(tablesCopy) + " rows can not process.");
        }
    }

    private void processUpdate() throws SQLException {
        this.logger.info("begin update exists datas...");
        int uc = 0;
        for (TableData tableData : this.tables) {
            boolean skipWholeTable = false;
            for (Map.Entry<String, Set<String>> entry : this.updateExclusionMap.entrySet()) {
                String tableName = entry.getKey();
                Set<String> columnSet = entry.getValue();
                if (columnSet != null && !columnSet.isEmpty() || !tableName.equalsIgnoreCase(tableData.getName())) continue;
                this.updateExclusionMap.remove(tableName);
                this.logger.info("skip update table : {}", (Object)tableData.getName());
                skipWholeTable = true;
                break;
            }
            if (skipWholeTable) continue;
            Set<String> exclusionColumns = this.updateExclusionMap.get(tableData.getName().toLowerCase());
            HashSet<String> logInfo = new HashSet<String>();
            for (TableData.TableRow tableRow : tableData.getTableRows()) {
                if (!tableRow.isExistsFlag()) continue;
                uc += this.dbAdaptor.doUpdate(tableRow, exclusionColumns, logInfo);
            }
            for (String log : logInfo) {
                this.logger.info(log);
            }
        }
        this.logger.info("update complete, update row:{} (include tl)", (Object)uc);
    }

    private int getMaxTableNameLength(List<TableData> list) {
        int max = 10;
        for (TableData tableData : list) {
            max = Math.max(max, tableData.getName().length());
        }
        return max;
    }

    private void roundSummary(List<TableData> tablesCopy) {
        int mtnl = this.getMaxTableNameLength(tablesCopy);
        for (int i = 0; i < tablesCopy.size(); ++i) {
            String summary = String.format("%-" + mtnl + "s   %s", tablesCopy.get(i).getName(), tablesCopy.get(i).processSummary());
            this.logger.info(summary);
            if (!tablesCopy.get(i).complete()) continue;
            tablesCopy.remove(i);
            --i;
        }
    }

    private int errorLog(List<TableData> tablesCopy) {
        this.logger.error("**** can not process rows below ****");
        int count = 0;
        for (TableData tableData : tablesCopy) {
            this.logger.error("{} :", (Object)tableData.getName());
            for (TableData.TableRow tableRow : tableData.getTableRows()) {
                if (!tableRow.isProcessFlag()) continue;
                this.logger.error("    {}", (Object)tableRow);
                ++count;
            }
        }
        return count;
    }

    public int processTable(TableData tableData) throws SQLException {
        int cc = 0;
        for (TableData.TableRow tableRow : tableData.getTableRows()) {
            cc += this.dbAdaptor.processTableRow(tableRow);
        }
        return cc;
    }

    void updateCellFormula(TableData.TableCellValue tableCellValue) {
        tableCellValue.getTableRow().getTable().getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator().evaluateFormulaCell(tableCellValue.getCell());
    }

    public boolean tryUpdateCell(TableData.TableCellValue tableCellValue) {
        List<String> relatedCells = tableCellValue.getRelatedCell();
        int ready = 0;
        for (String cellNum : relatedCells) {
            TableData.TableCellValue relatedTableCellValue = this.findCell(cellNum, tableCellValue);
            if (relatedTableCellValue == null) {
                throw new LiquibaseException("invalid reference:" + cellNum);
            }
            if (!relatedTableCellValue.isValuePresent()) continue;
            ++ready;
        }
        if (ready != relatedCells.size()) {
            return false;
        }
        this.updateCellFormula(tableCellValue);
        tableCellValue.updateValue(tableCellValue.getCell().getRichStringCellValue().getString());
        return true;
    }

    TableData.TableCellValue findCell(String cellNum, TableData.TableCellValue tableCellValue) {
        String sheetName = null;
        int ii = cellNum.indexOf(33);
        if (ii > 0) {
            sheetName = cellNum.substring(0, ii);
            cellNum = cellNum.substring(ii + 1);
        }
        int idx = 0;
        for (int i = 0; i < cellNum.length(); ++i) {
            if (!Character.isDigit(cellNum.charAt(i))) continue;
            idx = i;
            break;
        }
        if (idx == 0 || idx >= cellNum.length()) {
            throw new LiquibaseException(cellNum + " is not a value CellNum.");
        }
        int col = ExcelDataLoader.toColIndex(cellNum.substring(0, idx));
        int row = Integer.parseInt(cellNum.substring(idx));
        for (TableData tableData : this.tables) {
            if (sheetName == null && tableCellValue.getTableRow().getTable().getSheet() != tableData.getSheet() || sheetName != null && !sheetName.equals(tableData.getSheet().getSheetName())) continue;
            int sl = tableData.getStartLine();
            int sc = tableData.getStartCol();
            if (sl >= row || sl + tableData.getTableRows().size() < row) continue;
            TableData.TableRow tableRow = tableData.getTableRows().get(row - tableData.getStartLine() - 1);
            return tableRow.getTableCellValues().get(col - sc - 1);
        }
        return null;
    }

    public void execute(InputStream inputStream, AdditionDataSource ad) throws CustomChangeException {
        try {
            ExcelSeedDataReader dataReader = new ExcelSeedDataReader(inputStream);
            this.tables = dataReader.load();
            this.dbAdaptor = XML.equals(this.dataProcessType) ? new XmlFileAdaptor(this, ad, this.dataProcessXmlFile) : new DbAdaptor(this, ad);
            this.dbAdaptor.setDataSource(ad.getDataSource());
            this.processData();
            this.dbAdaptor.closeConnection(true);
            if (this.dbAdaptor instanceof XmlFileAdaptor) {
                ((XmlFileAdaptor)this.dbAdaptor).writeToFile(this.dataProcessXmlFile);
            }
        }
        catch (Exception e) {
            if (this.dbAdaptor != null) {
                this.dbAdaptor.closeConnection(false);
                this.dbAdaptor.closeConnection(false);
            }
            if (e.getCause() instanceof InvalidFormatException) {
                this.logger.warn("invalid input stream, maybe your excel is not save and close");
            }
            throw new CustomChangeException((Throwable)e);
        }
    }
}

