/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.liquibase.excel;

import io.choerodon.liquibase.excel.TableData;
import io.choerodon.liquibase.exception.LiquibaseException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import liquibase.util.StringUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelSeedDataReader {
    private static final int SKIP_LINE = 6;
    private static final int SKIP_COL = 3;
    private static final int SHEET_BEGIN_NUMBER = 1;
    private InputStream inputStream;
    private Workbook workBook;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public ExcelSeedDataReader(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public List<TableData> load() {
        try {
            this.workBook = WorkbookFactory.create((InputStream)this.inputStream);
            ArrayList<TableData> tablesAll = new ArrayList<TableData>();
            for (int i = 1; i < this.workBook.getNumberOfSheets(); ++i) {
                tablesAll.addAll(this.getSheetData(i));
            }
            return tablesAll;
        }
        catch (Exception e) {
            throw new LiquibaseException(e);
        }
    }

    private String getCellValue(Cell cell) {
        return cell == null ? "" : this.getCellValueByType(cell);
    }

    private String getCellValueByType(Cell cell) {
        String cellValue = "";
        DataFormatter formatter = new DataFormatter();
        switch (cell.getCellTypeEnum()) {
            case NUMERIC: {
                int intValue;
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    cellValue = formatter.formatCellValue(cell);
                    break;
                }
                if (cell instanceof XSSFCell) {
                    cellValue = ((XSSFCell)cell).getRawValue();
                    break;
                }
                double value = cell.getNumericCellValue();
                if (value == (double)(intValue = (int)value)) {
                    cellValue = String.valueOf(intValue);
                    break;
                }
                cellValue = String.valueOf(value);
                break;
            }
            case STRING: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                cellValue = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case FORMULA: {
                cellValue = String.valueOf(cell.getCellFormula());
                break;
            }
            case BLANK: {
                cellValue = "";
                break;
            }
            case ERROR: {
                cellValue = "";
                break;
            }
            default: {
                cellValue = cell.toString().trim();
            }
        }
        return cellValue.trim();
    }

    private List<TableData> getSheetData(int sheetIdx) {
        Sheet sheet = this.workBook.getSheetAt(sheetIdx);
        ArrayList<TableData> tables = new ArrayList<TableData>();
        int numOfRows = sheet.getLastRowNum() + 1;
        TableData currentTable = null;
        for (int rowNum = 6; rowNum < numOfRows; ++rowNum) {
            Row row = sheet.getRow(rowNum);
            if (row == null) {
                if (!this.addCurrentTable(tables, currentTable)) continue;
                currentTable = null;
                continue;
            }
            if (row.getLastCellNum() < 3) continue;
            if (StringUtil.isNotEmpty((String)this.getCellValue(row.getCell(3)))) {
                this.addCurrentTable(tables, currentTable);
                currentTable = this.getCurrentTable(sheet, row);
                continue;
            }
            if (this.isAllEmpty(row, 4)) continue;
            if (currentTable != null) {
                this.processTableRow(currentTable, row);
                continue;
            }
            this.logger.warn("\u8df3\u8fc7\u65e0\u6cd5\u627e\u5230\u8868\u540d\u7684\u6570\u636e:{}", (Object)row);
        }
        this.addCurrentTable(tables, currentTable);
        return tables;
    }

    private boolean addCurrentTable(List<TableData> tables, TableData currentTable) {
        if (currentTable != null) {
            currentTable.validate();
            tables.add(currentTable);
            return true;
        }
        return false;
    }

    private TableData getCurrentTable(Sheet sheet, Row row) {
        Cell cell;
        String colName;
        int cellNum = row.getLastCellNum();
        Cell tableNameCell = row.getCell(3);
        String tableName = this.getCellValue(tableNameCell);
        TableData currentTable = new TableData();
        currentTable.setSheet(sheet);
        currentTable.setStartLine(row.getRowNum() + 1);
        if (tableNameCell != null) {
            currentTable.setStartCol(tableNameCell.getColumnIndex() + 1);
        }
        currentTable.setName(tableName);
        this.logger.info("found table:{} ,sheet:{}, begin row:{}", new Object[]{tableName, sheet.getSheetName(), currentTable.getStartLine()});
        for (int c = 4; c < cellNum && !StringUtil.isEmpty((String)(colName = this.getCellValue(cell = row.getCell(c)))); ++c) {
            currentTable.addCol(new TableData.Column(colName));
        }
        return currentTable;
    }

    private void processTableRow(TableData currentTable, Row row) {
        boolean allBlank;
        TableData.TableRow tableRow = new TableData.TableRow();
        tableRow.setTable(currentTable);
        tableRow.setLineNumber(row.getRowNum() + 1);
        for (int j = 4; j < row.getLastCellNum(); ++j) {
            Cell cell = row.getCell(j);
            this.addTableCellValue(cell, tableRow, currentTable);
            if (tableRow.getTableCellValues().size() == currentTable.getColumns().size()) break;
        }
        if (!(allBlank = this.tableRowIsEmpty(tableRow))) {
            int delt = currentTable.getColumns().size() - tableRow.getTableCellValues().size();
            for (int j = 0; j < delt; ++j) {
                this.addTableCellValue(null, tableRow, currentTable);
            }
            currentTable.getTableRows().add(tableRow);
        }
    }

    private boolean tableRowIsEmpty(TableData.TableRow tableRow) {
        return Optional.ofNullable(tableRow).map(row -> {
            List<TableData.TableCellValue> tableCellValues = row.getTableCellValues();
            boolean allBlank = true;
            for (TableData.TableCellValue cell : tableCellValues) {
                if (!StringUtil.isNotEmpty((String)cell.getValue())) continue;
                allBlank = false;
                break;
            }
            return allBlank;
        }).orElse(true);
    }

    private void addTableCellValue(Cell cell, TableData.TableRow tableRow, TableData currentTable) {
        int indexOfTitleColumn = tableRow.getTableCellValues().size();
        TableData.Column currentTitleColumn = currentTable.getColumns().get(indexOfTitleColumn);
        String value = this.getCellValue(cell);
        if (currentTitleColumn.isGen()) {
            try {
                Long.parseLong(value);
                tableRow.setGeneratedColumnInserted(true);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ("$DEL".equals(currentTitleColumn.getName()) && "1".equals(value)) {
            tableRow.setDeleteFlag(true);
        }
        TableData.TableCellValue tableCellValue = new TableData.TableCellValue(cell, tableRow, currentTitleColumn);
        tableCellValue.setValue(value);
        tableRow.getTableCellValues().add(tableCellValue);
    }

    private boolean isAllEmpty(Row row, int startCol) {
        for (int i = startCol; i < row.getLastCellNum(); ++i) {
            Cell cell = row.getCell(i);
            if (cell == null || !StringUtil.isNotEmpty((String)this.getCellValue(cell))) continue;
            return false;
        }
        return true;
    }
}

