/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.liquibase.excel;

import io.choerodon.liquibase.exception.LiquibaseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.util.StringUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;

public class TableData {
    private Sheet sheet;
    private int insert = 0;
    private Set<String> langs = new HashSet<String>();
    private int startLine;
    private int startCol;
    private long maxId;
    private String name;
    private List<Column> columns = new ArrayList<Column>();
    private List<Column> uniqueColumns = new ArrayList<Column>();
    private List<TableRow> tableRows = new ArrayList<TableRow>();

    public long getMaxId() {
        return this.maxId;
    }

    public void setMaxId(long maxId) {
        this.maxId = maxId;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int startLine) {
        this.startLine = startLine;
    }

    public int getStartCol() {
        return this.startCol;
    }

    public void setStartCol(int startCol) {
        this.startCol = startCol;
    }

    public List<TableRow> getTableRows() {
        return this.tableRows;
    }

    public void setTableRows(List<TableRow> tableRows) {
        this.tableRows = tableRows;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Column> getUniqueColumns() {
        return this.uniqueColumns;
    }

    public void setUniqueColumns(List<Column> uniqueColumns) {
        this.uniqueColumns = uniqueColumns;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public int getInsert() {
        return this.insert;
    }

    public void setInsert(int insert) {
        this.insert = insert;
    }

    public Set<String> getLangs() {
        return this.langs;
    }

    public void setLangs(Set<String> langs) {
        this.langs = langs;
    }

    public boolean complete() {
        for (TableRow tableRow : this.tableRows) {
            if (tableRow.processFlag) continue;
            return false;
        }
        return true;
    }

    public String processSummary() {
        int complete = 0;
        for (TableRow tableRow : this.tableRows) {
            if (!tableRow.processFlag) continue;
            ++complete;
        }
        Object str = String.format("total:%-4d  process:%-4d  insert:%-4d", this.tableRows.size(), complete, this.insert);
        if (complete == this.tableRows.size()) {
            str = (String)str + "  complete";
        }
        return str;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public Column addCol(Column column) {
        this.columns.add(column);
        if (column.unique) {
            this.uniqueColumns.add(column);
        }
        if (column.lang != null) {
            this.langs.add(column.lang);
        }
        return column;
    }

    public void validate() {
        int genCount = 0;
        int uniqueCount = 0;
        for (Column column : this.columns) {
            if (column.gen) {
                ++genCount;
                continue;
            }
            if (!column.unique) continue;
            ++uniqueCount;
        }
        if (genCount > 1) {
            throw new LiquibaseException("table has more than one generated column :" + this.getName());
        }
        if (uniqueCount == 0) {
            throw new LiquibaseException("table has no unique check column :" + this.getName());
        }
    }

    public String getSummaryInfo() {
        return String.format("%s[sheet:%s;startLine:%d]", this.name, this.sheet.getSheetName(), this.startLine);
    }

    public static class TableCellValue {
        private static Pattern pattern = Pattern.compile("[A-Z]+[0-9]+");
        private String value;
        private String formula;
        private boolean valuePresent = true;
        private boolean isFormula = false;
        private Cell cell;
        private TableRow tableRow;
        private Column column;

        public TableCellValue() {
        }

        public TableCellValue(Cell cell, TableRow tableRow, Column column) {
            this.tableRow = tableRow;
            this.column = column;
            this.cell = cell;
            if (cell != null && cell.getCellType() == 2) {
                this.isFormula = true;
                this.formula = cell.getCellFormula().replace("$", "");
                this.valuePresent = false;
            }
            if (column.gen) {
                this.valuePresent = false;
            }
        }

        public static Pattern getPattern() {
            return pattern;
        }

        public List<String> getRelatedCell() {
            if (!this.isFormula) {
                return Collections.emptyList();
            }
            if (this.formula.contains("!")) {
                return Collections.singletonList(this.formula);
            }
            ArrayList<String> list = new ArrayList<String>();
            Matcher matcher = pattern.matcher(this.formula);
            while (matcher.find()) {
                list.add(matcher.group());
            }
            return list;
        }

        public void updateValue(String value) {
            this.cell.setCellValue(value);
            this.value = value;
            this.valuePresent = true;
        }

        public String toString() {
            if (this.cell == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            if (this.isFormula) {
                sb.append('[').append("F:").append(this.formula).append(']');
            }
            sb.append(this.value);
            return sb.toString();
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getFormula() {
            return this.formula;
        }

        public boolean isValuePresent() {
            return this.valuePresent;
        }

        public boolean isFormula() {
            return this.isFormula;
        }

        public Cell getCell() {
            return this.cell;
        }

        public TableRow getTableRow() {
            return this.tableRow;
        }

        public Column getColumn() {
            return this.column;
        }
    }

    public static class TableRow {
        private TableData table;
        private int lineNumber;
        private List<TableCellValue> tableCellValues = new ArrayList<TableCellValue>();
        private boolean processFlag = false;
        private boolean existsFlag = false;
        private boolean insertFlag = false;
        private boolean updateFlag = false;
        private boolean deleteFlag = false;
        private boolean generatedColumnInserted = false;

        public boolean present() {
            for (TableCellValue tableCellValue : this.tableCellValues) {
                if (tableCellValue.valuePresent) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return Arrays.toString(this.tableCellValues.toArray());
        }

        public boolean needGen() {
            for (TableCellValue tableCellValue : this.tableCellValues) {
                if (!tableCellValue.column.gen || tableCellValue.valuePresent) continue;
                return true;
            }
            return false;
        }

        public boolean canInsert() {
            for (TableCellValue tableCellValue : this.tableCellValues) {
                if (tableCellValue.column.gen || tableCellValue.valuePresent) continue;
                return false;
            }
            return true;
        }

        public TableData getTable() {
            return this.table;
        }

        public void setTable(TableData table) {
            this.table = table;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        public List<TableCellValue> getTableCellValues() {
            return this.tableCellValues;
        }

        public void setTableCellValues(List<TableCellValue> tableCellValues) {
            this.tableCellValues = tableCellValues;
        }

        public boolean isProcessFlag() {
            return this.processFlag;
        }

        public void setProcessFlag(boolean processFlag) {
            this.processFlag = processFlag;
        }

        public boolean isExistsFlag() {
            return this.existsFlag;
        }

        public void setExistsFlag(boolean existsFlag) {
            this.existsFlag = existsFlag;
        }

        public boolean isInsertFlag() {
            return this.insertFlag;
        }

        public void setInsertFlag(boolean insertFlag) {
            this.insertFlag = insertFlag;
        }

        public boolean isUpdateFlag() {
            return this.updateFlag;
        }

        public void setUpdateFlag(boolean updateFlag) {
            this.updateFlag = updateFlag;
        }

        public boolean isGeneratedColumnInserted() {
            return this.generatedColumnInserted;
        }

        public void setGeneratedColumnInserted(boolean generatedColumnInserted) {
            this.generatedColumnInserted = generatedColumnInserted;
        }

        public boolean isDeleteFlag() {
            return this.deleteFlag;
        }

        public void setDeleteFlag(boolean deleteFlag) {
            this.deleteFlag = deleteFlag;
        }
    }

    public static class Column {
        public static final String DEL_FLAG_COLUMN_NAME = "$DEL";
        private boolean gen = false;
        private String type = "VARCHAR";
        private String name;
        private boolean unique = false;
        private boolean onlyInsert = false;
        private boolean deleteFlag = false;
        private String lang = null;

        public Column(String name) {
            this.setName(name);
        }

        public boolean isGen() {
            return this.gen;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        private void setName(String originName) {
            int lb;
            this.name = originName;
            if (DEL_FLAG_COLUMN_NAME.equals(originName)) {
                this.deleteFlag = true;
                return;
            }
            if (originName.startsWith("*")) {
                this.name = originName.substring(1);
                this.gen = true;
            } else if (originName.startsWith("#")) {
                this.unique = true;
                this.name = originName.substring(1);
            } else if (originName.startsWith("$") || originName.startsWith("@")) {
                this.onlyInsert = true;
                this.name = originName.substring(1);
            }
            int sem = this.name.indexOf(58);
            if (sem > 0) {
                String localLang = this.name.substring(sem + 1);
                this.name = this.name.substring(0, sem);
                if (StringUtil.isEmpty((String)localLang)) {
                    throw new LiquibaseException("invalid tl language :" + this.name);
                }
                this.lang = localLang;
            }
            if (this.name.endsWith("_DATE")) {
                this.type = "DATE";
            }
            if ((lb = this.name.indexOf(40)) > 0) {
                this.type = this.name.substring(lb + 1, this.name.indexOf(41)).trim().toUpperCase();
                this.name = this.name.substring(0, lb).trim();
            }
        }

        public boolean isUnique() {
            return this.unique;
        }

        public String getLang() {
            return this.lang;
        }

        public boolean isOnlyInsert() {
            return this.onlyInsert;
        }

        public boolean isDeleteFlag() {
            return this.deleteFlag;
        }

        public String toString() {
            return (this.gen ? "*" : "") + this.name + ":" + this.type;
        }
    }
}

