/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.liquibase.excel;

import io.choerodon.liquibase.addition.AdditionDataSource;
import io.choerodon.liquibase.excel.DbAdaptor;
import io.choerodon.liquibase.excel.ExcelDataLoader;
import io.choerodon.liquibase.excel.TableData;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class XmlFileAdaptor
extends DbAdaptor {
    private Map<String, Set<String>> tableXmlMap = new HashMap<String, Set<String>>();
    private String dataProcessXmlFile;

    public XmlFileAdaptor(ExcelDataLoader dataProcessor, AdditionDataSource ad, String dataProcessXmlFile) {
        super(dataProcessor, ad);
    }

    @Override
    public int processTableRow(TableData.TableRow tableRow) throws SQLException {
        if (tableRow.isProcessFlag()) {
            return 0;
        }
        if (tableRow.isDeleteFlag()) {
            tableRow.setProcessFlag(true);
        }
        this.doInsert(tableRow);
        return 1;
    }

    @Override
    protected Long doInsert(TableData.TableRow tableRow) throws SQLException {
        String sql = this.prepareInsertSql(tableRow);
        TableData.TableCellValue genTableCellValue = null;
        StringBuilder genKeysb = new StringBuilder();
        for (TableData.TableCellValue tableCellValue : tableRow.getTableCellValues()) {
            if (tableCellValue.getColumn().isUnique()) {
                if (genKeysb.length() > 0) {
                    genKeysb.append("_");
                }
                genKeysb.append(tableCellValue.getValue());
            }
            if (!tableCellValue.getColumn().isGen()) continue;
            genTableCellValue = tableCellValue;
        }
        tableRow.setInsertFlag(true);
        tableRow.getTable().setInsert(tableRow.getTable().getInsert() + 1);
        if (genTableCellValue != null && genTableCellValue.getCell() != null) {
            genKeysb.insert(0, genTableCellValue.getTableRow().getTable().getName().toLowerCase() + ".");
            genKeysb.append(":" + genTableCellValue.getColumn().getName().toLowerCase());
            genTableCellValue.updateValue(genKeysb.toString());
        }
        tableRow.setProcessFlag(true);
        tableRow.setExistsFlag(true);
        return 1L;
    }

    @Override
    protected int doUpdate(TableData.TableRow tableRow, Set<String> excludedColumns, Set<String> logInfo) throws SQLException {
        int updateCount = 0;
        StringBuilder sb = new StringBuilder();
        StringBuilder genKeysb = new StringBuilder();
        for (TableData.TableCellValue tableCellValue : tableRow.getTableCellValues()) {
            if (tableCellValue.getColumn().isDeleteFlag()) continue;
            if (tableCellValue.isFormula() && !tableCellValue.isValuePresent()) {
                this.dataProcessor.tryUpdateCell(tableCellValue);
            }
            if (tableCellValue.getColumn().isUnique()) {
                if (genKeysb.length() > 0) {
                    genKeysb.append("_");
                    genKeysb.append(tableCellValue.getValue());
                } else {
                    genKeysb.append(tableCellValue.getValue());
                }
            }
            sb.append("<field name=\"");
            sb.append(tableCellValue.getColumn().getName().toLowerCase());
            sb.append("\"");
            if (tableCellValue.getColumn().getLang() != null) {
                sb.append(" language=\"");
                sb.append(tableCellValue.getColumn().getLang());
                sb.append("\"");
            }
            if (tableCellValue.getColumn().isGen()) {
                sb.append(" primary=\"");
                sb.append("true");
                sb.append("\"");
            }
            if (tableCellValue.getColumn().isUnique()) {
                sb.append(" unique=\"");
                sb.append("true");
                sb.append("\"");
            }
            if (tableCellValue.isFormula()) {
                sb.append(" ref=\"");
                sb.append(tableCellValue.getValue());
                sb.append("\"");
            }
            sb.append(">");
            if (!tableCellValue.isFormula() && !tableCellValue.getColumn().isGen()) {
                sb.append(tableCellValue.getValue());
            }
            sb.append("</field>");
        }
        sb.append("</record>");
        if (genKeysb.length() > 0) {
            sb.insert(0, "<record externalId=\"" + genKeysb.toString() + "\">");
        } else {
            sb.insert(0, "<record>");
        }
        Set<String> tableXmlSet = this.tableXmlMap.get(tableRow.getTable().getName());
        if (tableXmlSet != null) {
            tableXmlSet.add(sb.toString());
        } else {
            tableXmlSet = new HashSet<String>();
            tableXmlSet.add(sb.toString());
            this.tableXmlMap.put(tableRow.getTable().getName(), tableXmlSet);
        }
        return updateCount;
    }

    public void writeToFile(String fileName) {
        StringBuilder sb = new StringBuilder();
        sb.append("<seed>");
        for (Map.Entry<String, Set<String>> entry : this.tableXmlMap.entrySet()) {
            sb.append("<table name=\"");
            sb.append(entry.getKey().toLowerCase());
            sb.append("\">");
            for (String xml : entry.getValue()) {
                sb.append(xml);
            }
            sb.append("</table>");
        }
        sb.append("</seed>");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(fileName + ".xml"));){
            writer.write(sb.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

