/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.liquibase.iam;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.choerodon.annotation.entity.PermissionDescription;
import io.choerodon.annotation.entity.PermissionEntity;
import io.choerodon.core.enums.ResourceType;
import io.choerodon.liquibase.helper.LiquibaseHelper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PermissionLoader {
    private String serviceCode;
    private static final char UNDERLINE = '-';
    private Connection connection;
    private Map<String, Long> roleMap;
    private LiquibaseHelper liquibaseHelper;

    public PermissionLoader(LiquibaseHelper liquibaseHelper) {
        this.liquibaseHelper = liquibaseHelper;
    }

    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    public void execute(InputStream inputStream, Connection connection) throws IOException, SQLException {
        this.connection = connection;
        this.roleMap = this.queryRoleMap();
        ObjectMapper objectMapper = new ObjectMapper();
        Map descriptions = (Map)objectMapper.readValue(inputStream, (JavaType)objectMapper.getTypeFactory().constructMapType(HashMap.class, String.class, PermissionDescription.class));
        for (Map.Entry entry : descriptions.entrySet()) {
            ((PermissionDescription)entry.getValue()).setService(this.serviceCode);
            this.processDescription((String)entry.getKey(), (PermissionDescription)entry.getValue());
        }
    }

    private void processDescription(String key, PermissionDescription description) throws SQLException {
        Long permissionKey;
        String[] names = key.split("\\.");
        String controllerClassName = names[names.length - 2];
        String action = names[names.length - 1];
        String resource = PermissionLoader.camelToUnderline(controllerClassName).replace("-controller", "");
        if (description.getPermission() == null) {
            PermissionEntity permissionEntity = new PermissionEntity();
            permissionEntity.setType(ResourceType.SITE.value());
            permissionEntity.setPermissionWithin(true);
            description.setPermission(permissionEntity);
        }
        if ((permissionKey = this.queryPermission(this.makeCode(description.getService(), resource, action))) != null) {
            this.update(description.getPermission(), description.getPath(), description.getMethod(), description.getService(), resource, action);
        } else {
            this.insert(description.getPermission(), description.getPath(), description.getMethod(), description.getService(), resource, action);
            permissionKey = this.queryPermission(this.makeCode(description.getService(), resource, action));
            this.insertRolePermission(permissionKey, new HashSet<String>(Arrays.asList(description.getPermission().getRoles())));
        }
    }

    private Map<String, Long> queryRoleMap() throws SQLException {
        HashMap<String, Long> result = new HashMap<String, Long>();
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT ID, CODE FROM iam_role");
             ResultSet resultSet = ps.executeQuery();){
            while (resultSet.next()) {
                result.put(resultSet.getString("CODE"), resultSet.getLong("ID"));
            }
        }
        return result;
    }

    private void insertRolePermission(Long permissionKey, Set<String> roles) throws SQLException {
        roles.add("ADMIN");
        for (String roleCode : roles) {
            Long roleId = this.roleMap.get(roleCode);
            if (roleId == null) {
                System.out.println(this.roleMap);
                throw new IllegalArgumentException(String.format("role code [%s] not found.", roleCode));
            }
            PreparedStatement ps = this.connection.prepareStatement(this.getRolePermissionInsertSql());
            try {
                ps.setLong(1, roleId);
                ps.setLong(2, permissionKey);
                if (ps.executeUpdate() == 1) continue;
                throw new IllegalStateException("update permission result not one.");
            }
            finally {
                if (ps == null) continue;
                ps.close();
            }
        }
    }

    private String makeCode(String service, String resource, String action) {
        String code = resource + "." + action;
        if (service != null) {
            code = service + "." + code;
        }
        return code;
    }

    private void update(PermissionEntity permission, String path, String method, String service, String resource, String action) throws SQLException {
        try (PreparedStatement ps = this.connection.prepareStatement("UPDATE iam_permission SET PATH=?, SERVICE_CODE=?, CONTROLLER=?, ACTION=?, METHOD=?, RESOURCE_LEVEL=?, IS_PUBLIC_ACCESS=?, IS_LOGIN_ACCESS=?, IS_WITHIN=?, EXTERNAL_ACCESS=? WHERE CODE=?");){
            ps.setString(1, path);
            ps.setString(2, service);
            ps.setString(3, resource);
            ps.setString(4, action);
            ps.setString(5, method);
            ps.setString(6, permission.getType());
            ps.setBoolean(7, permission.isPermissionPublic());
            ps.setBoolean(8, permission.isPermissionLogin());
            ps.setBoolean(9, permission.isPermissionWithin());
            ps.setBoolean(10, permission.isExternalAccess());
            ps.setString(11, this.makeCode(service, resource, action));
            if (ps.executeUpdate() != 1) {
                throw new IllegalStateException("update permission result not one.");
            }
        }
    }

    private void insert(PermissionEntity permission, String path, String method, String service, String resource, String action) throws SQLException {
        try (PreparedStatement ps = this.connection.prepareStatement(this.getPermissionInsertSql());){
            ps.setString(1, this.makeCode(service, resource, action));
            ps.setString(2, path);
            ps.setString(3, service);
            ps.setString(4, resource);
            ps.setString(5, action);
            ps.setString(6, method);
            ps.setString(7, permission.getType());
            ps.setBoolean(8, permission.isPermissionPublic());
            ps.setBoolean(9, permission.isPermissionLogin());
            ps.setBoolean(10, permission.isPermissionWithin());
            ps.setBoolean(11, permission.isExternalAccess());
            if (ps.executeUpdate() != 1) {
                throw new IllegalStateException("update permission result not one.");
            }
        }
    }

    private String getRolePermissionInsertSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO iam_role_permission (");
        if (this.liquibaseHelper.isSupportSequence()) {
            sb.append("ID, ");
        }
        sb.append("ROLE_ID, PERMISSION_ID) VALUES (");
        if (this.liquibaseHelper.isOracle() || this.liquibaseHelper.isHana()) {
            sb.append("IAM_ROLE_PERMISSION_S.nextval, ");
        }
        if (this.liquibaseHelper.isPostgresql()) {
            sb.append("nextval('IAM_ROLE_PERMISSION_S'), ");
        }
        sb.append("?, ?)");
        return sb.toString();
    }

    private String getPermissionInsertSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO iam_permission (");
        if (this.liquibaseHelper.isSupportSequence()) {
            sb.append("ID, ");
        }
        sb.append("CODE, PATH, SERVICE_CODE, CONTROLLER, ACTION, METHOD,RESOURCE_LEVEL, IS_PUBLIC_ACCESS, IS_LOGIN_ACCESS, IS_WITHIN, EXTERNAL_ACCESS) VALUES (");
        if (this.liquibaseHelper.isOracle() || this.liquibaseHelper.isHana()) {
            sb.append("IAM_PERMISSION_S.nextval, ");
        }
        if (this.liquibaseHelper.isPostgresql()) {
            sb.append("nextval('IAM_PERMISSION_S'), ");
        }
        sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        return sb.toString();
    }

    private Long queryPermission(String code) throws SQLException {
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT ID FROM iam_permission WHERE CODE=?");){
            Long l;
            block16: {
                ResultSet resultSet;
                block14: {
                    Long l2;
                    block15: {
                        ps.setString(1, code);
                        resultSet = ps.executeQuery();
                        try {
                            if (!resultSet.next()) break block14;
                            l2 = resultSet.getLong("ID");
                            if (resultSet == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return l2;
                }
                l = null;
                if (resultSet == null) break block16;
                resultSet.close();
            }
            return l;
        }
    }

    public static String camelToUnderline(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    sb.append('-');
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

